/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.sql.lang;

import com.metamatrix.core.util.EquivalenceUtil;
import com.metamatrix.query.sql.LanguageVisitor;
import com.metamatrix.query.sql.lang.Insert;
import com.metamatrix.query.sql.symbol.ElementSymbol;
import com.metamatrix.query.sql.symbol.Expression;
import com.metamatrix.query.sql.symbol.GroupSymbol;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class BulkInsert
extends Insert {
    private List rowValues = null;

    public BulkInsert(GroupSymbol group, List variables, List rows) {
        super(group, variables, null);
        this.rowValues = rows;
    }

    public BulkInsert(GroupSymbol group, List variables) {
        super(group, variables, null);
    }

    public List getRows() {
        if (this.rowValues == null) {
            return Collections.EMPTY_LIST;
        }
        return this.rowValues;
    }

    public void setRows(List rows) {
        this.rowValues = rows;
    }

    public void addValue(Expression value) {
        throw new UnsupportedOperationException("This operation not allowed in BulkInsert");
    }

    public List getValues() {
        throw new UnsupportedOperationException("This operation not allowed in BulkInsert");
    }

    public void setValues(List values) {
        throw new UnsupportedOperationException("This operation not allowed in BulkInsert");
    }

    public Object clone() {
        GroupSymbol group = this.getGroup();
        GroupSymbol copyGroup = null;
        if (group != null) {
            copyGroup = (GroupSymbol)group.clone();
        }
        ArrayList<Object> copyVars = null;
        if (this.getVariables() != null) {
            copyVars = new ArrayList<Object>(this.getVariables().size());
            Iterator iter = this.getVariables().iterator();
            while (iter.hasNext()) {
                ElementSymbol element = (ElementSymbol)iter.next();
                copyVars.add(element.clone());
            }
        }
        BulkInsert copy = new BulkInsert(copyGroup, copyVars);
        copy.rowValues = this.getRows();
        this.copyMetadataState(copy);
        return copy;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        BulkInsert other = (BulkInsert)obj;
        return EquivalenceUtil.areEqual(this.getGroup(), other.getGroup()) && EquivalenceUtil.areEqual(this.getVariables(), other.getVariables()) && EquivalenceUtil.areEqual(this.getRows(), other.getRows());
    }

    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }
}

