/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.xml.jms;

import com.metamatrix.connector.xml.CachingConnector;
import com.metamatrix.connector.xml.DocumentProducer;
import com.metamatrix.connector.xml.XMLExecution;
import com.metamatrix.connector.xml.base.SecureConnectorStateImpl;
import com.metamatrix.connector.xml.jms.JMSConnection;
import com.metamatrix.connector.xml.jms.JMSConnectorState;
import com.metamatrix.connector.xml.jms.JMSExecution;
import com.metamatrix.connector.xml.jms.JMSRequestExecutor;
import com.metamatrix.connector.xml.jms.Messages;
import com.metamatrix.data.api.Connection;
import com.metamatrix.data.api.ConnectorEnvironment;
import com.metamatrix.data.api.SecurityContext;
import com.metamatrix.data.exception.ConnectorException;
import java.util.Properties;

public class JMSXMLConnectorState
extends SecureConnectorStateImpl
implements JMSConnectorState {
    private String initialContextFactoryName;
    private String primaryProviderUrl;
    private String connectionFactoryName;
    private String outboundJMSDestination;
    private String inboundJMSDestination;
    private String userName;
    private String password;
    private int acknowledgementMode;
    private int receiveTimeout;
    private String correlationIdPrefix;
    private int messsagePriority;
    private int messageDuration;
    private int messageDeliveryMode;
    private String replyToDestination;
    private int connectionRetryCount;

    public void setState(Properties properties) throws ConnectorException {
        super.setState(properties);
        String provisionalContextFactory = properties.getProperty("INITIAL_CONTEXT_FACTORY");
        if (!this.isNotNullOrEmpty(provisionalContextFactory)) {
            throw new ConnectorException(Messages.getString("JMSConnectorState.invalid.INITIAL_CONTEXT_FACTORY"));
        }
        this.setInitialContextFactoryName(provisionalContextFactory);
        String provisionalPrimaryProviderURL = properties.getProperty("PROVIDER_URL");
        if (!this.isNotNullOrEmpty(provisionalPrimaryProviderURL)) {
            throw new ConnectorException(Messages.getString("JMSConnectorState.invalid.PROVIDER_URL"));
        }
        this.setPrimaryProviderUrl(provisionalPrimaryProviderURL);
        String provisionalConnectionFactoryName = properties.getProperty("CONNECTION_FACTORY");
        if (!this.isNotNullOrEmpty(provisionalConnectionFactoryName)) {
            throw new ConnectorException(Messages.getString("JMSConnectorState.invalid.CONNECTION_FACTORY"));
        }
        this.setConnectionFactoryName(provisionalConnectionFactoryName);
        String provisionalInboundJMSDestination = properties.getProperty("INBOUND_JMS_DESTINATION");
        if (this.isNotNullOrEmpty(provisionalInboundJMSDestination)) {
            this.setInboundJMSDestination(provisionalInboundJMSDestination);
        } else {
            this.logger.logInfo(Messages.getString("JMSConnectorState.empty.INBOUND_JMS_DESTINATION"));
        }
        String provisionalOutboundJMSDestination = properties.getProperty("OUTBOUND_JMS_DESTINATION");
        if (this.isNotNullOrEmpty(provisionalOutboundJMSDestination)) {
            this.setOutboundJMSDestination(provisionalOutboundJMSDestination);
        } else {
            this.logger.logInfo(Messages.getString("JMSConnectorState.empty.OUTBOUND_JMS_DESTINATION"));
        }
        if (this.getOutboundJMSDestination() == null && this.getInboundJMSDestination() == null) {
            throw new ConnectorException(Messages.getString("JMSConnectorState.empty.destinations"));
        }
        String provisionalUserName = properties.getProperty("USERNAME");
        if (this.isNotNullOrEmpty(provisionalUserName)) {
            this.setUserName(provisionalUserName);
        } else {
            this.logger.logInfo(Messages.getString("JMSConnectorState.invalid.USERNAME"));
        }
        String provisionalPassword = properties.getProperty("PASSWORD");
        if (this.isNotNullOrEmpty(provisionalPassword)) {
            this.setPassword(provisionalPassword);
        } else {
            this.logger.logInfo(Messages.getString("JMSConnectorState.invalid.PASSWORD"));
        }
        String provisionalAcknowledgementMode = properties.getProperty("ACKNOWLEDGEMENT_MODE");
        if (!this.isNotNullOrEmpty(provisionalAcknowledgementMode)) {
            throw new ConnectorException(Messages.getString("JMSConnectorState.empty.ack.mode"));
        }
        int mode = this.encodeAcknowledgementMode(provisionalAcknowledgementMode);
        this.setAcknowledgementMode(mode);
        try {
            int provisionalReceiveTimeout = Integer.parseInt(properties.getProperty("RECEIVE_TIMEOUT"));
            this.setReceiveTimeout(provisionalReceiveTimeout);
        }
        catch (NumberFormatException e) {
            throw new ConnectorException(Messages.getString("JMSConnectorState.invalid.receive.timeout"));
        }
        String provisionalCorrelationIdPrefix = properties.getProperty("CORRELATION_ID");
        if (this.isNotNullOrEmpty(provisionalCorrelationIdPrefix)) {
            this.setCorrelationIdPrefix(provisionalCorrelationIdPrefix);
        } else {
            this.logger.logInfo(Messages.getString("JMSConnectorState.empty.correlation.id"));
        }
        try {
            int provisionalMessagePriority = Integer.parseInt(properties.getProperty("MESSAGE_PRIORITY"));
            if (provisionalMessagePriority < 1 || provisionalMessagePriority > 9) {
                throw new ConnectorException(Messages.getString("JMSConnectorState.invalid.message.priority"));
            }
            this.setMesssagePriority(provisionalMessagePriority);
        }
        catch (NumberFormatException e) {
            throw new ConnectorException(Messages.getString("JMSConnectorState.message.priority.format"));
        }
        try {
            int provisionalMessageDuration = Integer.parseInt(properties.getProperty("MESSAGE_DURATION"));
            this.setMessageDuration(provisionalMessageDuration);
        }
        catch (NumberFormatException e) {
            throw new ConnectorException(Messages.getString("JMSConnectorState.message.duration.format"));
        }
        String provisionalDeliveryMode = properties.getProperty("MESSAGE_DELIVERY_MODE");
        if (!this.isNotNullOrEmpty(provisionalDeliveryMode)) {
            throw new ConnectorException(Messages.getString("JMSConnectorState.empty.delivery.mode"));
        }
        int mode2 = this.encodeMessageDeliveryMode(provisionalDeliveryMode);
        this.setMessageDeliveryMode(mode2);
        String provisionalReplyToDestination = properties.getProperty("REPLY_TO_DESTINATION");
        if (this.isNotNullOrEmpty(provisionalReplyToDestination)) {
            this.setReplyToDestination(provisionalReplyToDestination);
        } else {
            this.logger.logInfo(Messages.getString("JMSConnectorState.empty.reply.to"));
        }
        try {
            int provisionalConnectionRetryCount = Integer.parseInt(properties.getProperty("CONNECTION_RETRY_COUNT"));
            this.setConnectionRetryCount(provisionalConnectionRetryCount);
        }
        catch (NumberFormatException e) {
            throw new ConnectorException(Messages.getString("JMSConnectorState.connection.retry.format"));
        }
    }

    public DocumentProducer makeExecutor(XMLExecution execution) throws ConnectorException {
        return new JMSRequestExecutor(this, (JMSExecution)execution);
    }

    public String getInitialContextFactoryName() {
        return this.initialContextFactoryName;
    }

    private void setInitialContextFactoryName(String initialContextFactoryName) {
        this.initialContextFactoryName = initialContextFactoryName;
    }

    public String getPrimaryProviderUrl() {
        return this.primaryProviderUrl;
    }

    private void setPrimaryProviderUrl(String primaryProviderUrl) {
        this.primaryProviderUrl = primaryProviderUrl;
    }

    public String getConnectionFactoryName() {
        return this.connectionFactoryName;
    }

    private void setConnectionFactoryName(String connectionFactoryName) {
        this.connectionFactoryName = connectionFactoryName;
    }

    public String getUserName() {
        return this.userName;
    }

    private void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    private void setPassword(String password) {
        this.password = password;
    }

    public String getInboundJMSDestination() {
        return this.inboundJMSDestination;
    }

    private void setInboundJMSDestination(String inboundJMSDestination) {
        this.inboundJMSDestination = inboundJMSDestination;
    }

    public String getOutboundJMSDestination() {
        return this.outboundJMSDestination;
    }

    private void setOutboundJMSDestination(String outboundJMSDestination) {
        this.outboundJMSDestination = outboundJMSDestination;
    }

    private int encodeAcknowledgementMode(String mode) throws ConnectorException {
        int result;
        if (mode.toLowerCase().equals("CLIENT_ACKNOWLEDGE".toLowerCase())) {
            result = 2;
        } else if (mode.toLowerCase().equals("AUTO_ACKNOWLEDGE".toLowerCase())) {
            result = 2;
        } else if (mode.toLowerCase().equals("DUPS_OK_ACKNOWLEDGE".toLowerCase())) {
            result = 3;
        } else {
            throw new ConnectorException(Messages.getString("JMSConnectorState.invalid.ack.mode"));
        }
        return result;
    }

    private int encodeMessageDeliveryMode(String mode) throws ConnectorException {
        int result;
        if (mode.toLowerCase().equals("DELIVERY_MODE_NON_PERISTENT".toLowerCase())) {
            result = 1;
        } else if (mode.toLowerCase().equals("DELIVERY_MODE_PERISTENT".toLowerCase())) {
            result = 2;
        } else {
            throw new ConnectorException(Messages.getString("JMSConnectorState.invalid.delivery.mode"));
        }
        return result;
    }

    public int getAcknowledgementMode() {
        return this.acknowledgementMode;
    }

    private void setAcknowledgementMode(int acknowledgementMode) {
        this.acknowledgementMode = acknowledgementMode;
    }

    public int getReceiveTimeout() {
        return this.receiveTimeout;
    }

    private void setReceiveTimeout(int receiveTimeout) {
        this.receiveTimeout = receiveTimeout;
    }

    public String getCorrelationIdPrefix() {
        return this.correlationIdPrefix;
    }

    private void setCorrelationIdPrefix(String correlationIdPrefix) {
        this.correlationIdPrefix = correlationIdPrefix;
    }

    public int getMesssagePriority() {
        return this.messsagePriority;
    }

    private void setMesssagePriority(int messsagePriority) {
        this.messsagePriority = messsagePriority;
    }

    public int getMessageDuration() {
        return this.messageDuration;
    }

    private void setMessageDuration(int messageDuration) {
        this.messageDuration = messageDuration;
    }

    public int getMessageDeliveryMode() {
        return this.messageDeliveryMode;
    }

    private void setMessageDeliveryMode(int messageDeliveryMode) {
        this.messageDeliveryMode = messageDeliveryMode;
    }

    public String getReplyToDestination() {
        return this.replyToDestination;
    }

    private void setReplyToDestination(String replyToDestination) {
        this.replyToDestination = replyToDestination;
    }

    public int getConnectionRetryCount() {
        return this.connectionRetryCount;
    }

    private void setConnectionRetryCount(int connectionRetryCount) {
        this.connectionRetryCount = connectionRetryCount;
    }

    public Connection getConnection(CachingConnector connector, SecurityContext context, ConnectorEnvironment environment) throws ConnectorException {
        return new JMSConnection(connector, context, environment);
    }

    public Properties getState() {
        Properties props = super.getState();
        return props;
    }
}

