/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.xml.base;

import com.metamatrix.common.types.ClobType;
import com.metamatrix.connector.xml.base.LargeTextValueReference;
import com.metamatrix.connector.xml.base.StringBackedValueReference;
import com.metamatrix.data.exception.ConnectorException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;

public class LargeOrSmallString {
    private String smallString;
    private LargeTextValueReference valueReference;

    public static LargeOrSmallString createSmallString(String smallString) {
        return new LargeOrSmallString(smallString);
    }

    public static LargeOrSmallString createLargeString(LargeTextValueReference largeString) {
        return new LargeOrSmallString(largeString);
    }

    private LargeOrSmallString(String smallString) {
        this.smallString = smallString;
        this.valueReference = null;
    }

    private LargeOrSmallString(LargeTextValueReference largeString) {
        this.smallString = null;
        this.valueReference = largeString;
    }

    public boolean isSmall() {
        return this.valueReference == null;
    }

    public String getAsString() throws ConnectorException {
        if (this.valueReference == null) {
            return this.smallString;
        }
        return this.valueReference.getContentAsString();
    }

    public LargeTextValueReference getAsValueReference() {
        if (this.valueReference != null) {
            return this.valueReference;
        }
        return new StringBackedValueReference(this.smallString);
    }

    public ClobType getAsClobValue() throws ConnectorException {
        if (this.valueReference != null) {
            String largeString = new String(this.valueReference.getContentAsString());
            return new ClobType((Clob)new LocalClobImpl(largeString));
        }
        return new ClobType((Clob)new LocalClobImpl(this.smallString));
    }

    public String toString() {
        if (this.isSmall()) {
            return this.smallString;
        }
        return super.toString();
    }

    private static class LocalClobImpl
    implements Clob {
        String src;

        public LocalClobImpl(char[] src) {
            if (src != null) {
                this.src = new String(src);
            }
        }

        public LocalClobImpl(String src) {
            if (src != null) {
                this.src = src;
            }
        }

        public long length() throws SQLException {
            if (this.src != null) {
                return this.src.length();
            }
            return 0L;
        }

        public void truncate(long newLength) throws SQLException {
            throw new SQLException("not implemented");
        }

        public InputStream getAsciiStream() throws SQLException {
            if (this.src == null) {
                return null;
            }
            return new ByteArrayInputStream(this.src.getBytes());
        }

        public OutputStream setAsciiStream(long pos) throws SQLException {
            throw new SQLException("not implemented");
        }

        public Reader getCharacterStream() throws SQLException {
            return new StringReader(this.src);
        }

        public Writer setCharacterStream(long pos) throws SQLException {
            throw new SQLException("not implemented");
        }

        public String getSubString(long pos, int length) throws SQLException {
            throw new SQLException("not implemented");
        }

        public int setString(long pos, String str) throws SQLException {
            throw new SQLException("not implemented");
        }

        public int setString(long pos, String str, int offset, int len) throws SQLException {
            throw new SQLException("not implemented");
        }

        public long position(String searchstr, long start) throws SQLException {
            throw new SQLException("not implemented");
        }

        public long position(Clob searchstr, long start) throws SQLException {
            throw new SQLException("not implemented");
        }
    }
}

