/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.internal.adaptor;

import java.util.Enumeration;
import java.util.Properties;
import org.eclipse.core.runtime.adaptor.EclipseAdaptorMsg;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.eclipse.osgi.framework.console.CommandProvider;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.PlatformAdmin;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.VersionConstraint;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class EclipseCommandProvider
implements CommandProvider {
    private BundleContext context;
    static /* synthetic */ Class class$org$eclipse$osgi$service$resolver$PlatformAdmin;

    public EclipseCommandProvider(BundleContext context) {
        this.context = context;
    }

    public String getHelp() {
        StringBuffer help = new StringBuffer(512);
        help.append(EclipseAdaptorMsg.NEW_LINE);
        help.append("---");
        help.append(EclipseAdaptorMsg.ECLIPSE_CONSOLE_COMMANDS_HEADER);
        help.append("---");
        help.append(EclipseAdaptorMsg.NEW_LINE);
        help.append("\tdiag - " + EclipseAdaptorMsg.ECLIPSE_CONSOLE_HELP_DIAG_COMMAND_DESCRIPTION);
        help.append(EclipseAdaptorMsg.NEW_LINE);
        help.append("\tactive - " + EclipseAdaptorMsg.ECLIPSE_CONSOLE_HELP_ACTIVE_COMMAND_DESCRIPTION);
        help.append(EclipseAdaptorMsg.NEW_LINE);
        help.append("\tgetprop " + EclipseAdaptorMsg.ECLIPSE_CONSOLE_HELP_GETPROP_COMMAND_DESCRIPTION);
        return help.toString();
    }

    private BundleDescription getBundleDescriptionFromToken(State state, String token) {
        try {
            long id = Long.parseLong(token);
            return state.getBundle(id);
        }
        catch (NumberFormatException nfe) {
            BundleDescription[] allBundles = state.getBundles(token);
            if (allBundles.length > 0) {
                return allBundles[0];
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _diag(CommandInterpreter ci) throws Exception {
        String nextArg = ci.nextArgument();
        if (nextArg == null) {
            ci.println(EclipseAdaptorMsg.ECLIPSE_CONSOLE_NO_BUNDLE_SPECIFIED_ERROR);
            return;
        }
        ServiceReference platformAdminRef = this.context.getServiceReference((class$org$eclipse$osgi$service$resolver$PlatformAdmin == null ? (class$org$eclipse$osgi$service$resolver$PlatformAdmin = EclipseCommandProvider.class$("org.eclipse.osgi.service.resolver.PlatformAdmin")) : class$org$eclipse$osgi$service$resolver$PlatformAdmin).getName());
        if (platformAdminRef == null) {
            ci.print("  ");
            ci.println(EclipseAdaptorMsg.ECLIPSE_CONSOLE_NO_CONSTRAINTS_NO_PLATFORM_ADMIN_MESSAGE);
            return;
        }
        try {
            PlatformAdmin platformAdmin = (PlatformAdmin)this.context.getService(platformAdminRef);
            if (platformAdmin == null) {
                return;
            }
            State systemState = platformAdmin.getState(false);
            while (nextArg != null) {
                BundleDescription bundle = this.getBundleDescriptionFromToken(systemState, nextArg);
                if (bundle == null) {
                    ci.println(NLS.bind(EclipseAdaptorMsg.ECLIPSE_CONSOLE_CANNOT_FIND_BUNDLE_ERROR, nextArg));
                    nextArg = ci.nextArgument();
                    continue;
                }
                ci.println(bundle.getLocation() + " [" + bundle.getBundleId() + "]");
                VersionConstraint[] unsatisfied = platformAdmin.getStateHelper().getUnsatisfiedConstraints(bundle);
                if (unsatisfied.length == 0) {
                    String message = EclipseAdaptorMsg.ECLIPSE_CONSOLE_NO_CONSTRAINTS;
                    if (!bundle.isResolved()) {
                        BundleDescription resolved;
                        String symbolicName = bundle.getSymbolicName();
                        BundleDescription bundleDescription = resolved = symbolicName == null ? null : this.getResolvedBundle(systemState, symbolicName);
                        if (resolved != null) {
                            message = NLS.bind(EclipseAdaptorMsg.ECLIPSE_CONSOLE_OTHER_VERSION, resolved.getLocation());
                        }
                    }
                    ci.print("  ");
                    ci.println(message);
                }
                for (int i = 0; i < unsatisfied.length; ++i) {
                    ci.print("  ");
                    ci.println(EclipseAdaptorMsg.getResolutionFailureMessage(unsatisfied[i]));
                }
                nextArg = ci.nextArgument();
            }
        }
        finally {
            this.context.ungetService(platformAdminRef);
        }
    }

    private BundleDescription getResolvedBundle(State state, String symbolicName) {
        BundleDescription[] homonyms = state.getBundles(symbolicName);
        for (int i = 0; i < homonyms.length; ++i) {
            if (!homonyms[i].isResolved()) continue;
            return homonyms[i];
        }
        return null;
    }

    public void _active(CommandInterpreter ci) throws Exception {
        Bundle[] allBundles = this.context.getBundles();
        int activeCount = 0;
        for (int i = 0; i < allBundles.length; ++i) {
            if (allBundles[i].getState() != 32) continue;
            ci.println(allBundles[i]);
            ++activeCount;
        }
        ci.print("  ");
        ci.println(NLS.bind(EclipseAdaptorMsg.ECLIPSE_CONSOLE_BUNDLES_ACTIVE, String.valueOf(activeCount)));
    }

    public void _getprop(CommandInterpreter ci) throws Exception {
        Properties allProperties = System.getProperties();
        String filter = ci.nextArgument();
        Enumeration<Object> propertyNames = allProperties.keys();
        while (propertyNames.hasMoreElements()) {
            String prop = (String)propertyNames.nextElement();
            if (filter != null && !prop.startsWith(filter)) continue;
            ci.println(prop + '=' + allProperties.getProperty(prop));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

