/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.util;

import com.metamatrix.api.exception.MetaMatrixRuntimeException;
import com.metamatrix.common.comm.api.Message;
import com.metamatrix.common.comm.api.MessageHolder;
import com.metamatrix.common.comm.api.ServerConnection;
import com.metamatrix.common.comm.api.ServerInstance;
import com.metamatrix.common.comm.exception.ApplicationException;
import com.metamatrix.common.comm.exception.CommunicationException;
import com.metamatrix.common.comm.service.ExceptionHolder;
import com.metamatrix.dqp.message.TransactionMessage;
import com.metamatrix.jdbc.JDBCPlugin;
import com.metamatrix.jdbc.util.ThreadIdentifier;
import com.metamatrix.jdbc.util.UserTransactionProxyInterface;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;

public class UserTransactionProxy
implements UserTransaction,
UserTransactionProxyInterface {
    private String threadId;
    private String xId;
    private ServerInstance instance;
    private ServerConnection connection;
    private int defaultTxnTimeout;
    private int txnTimeout;

    public UserTransactionProxy(ServerConnection connection, ServerInstance instance) {
        this.connection = connection;
        this.instance = instance;
        this.threadId = ThreadIdentifier.get();
    }

    public UserTransactionProxy(ServerConnection connection, ServerInstance instance, String xId, int seconds) {
        this(connection, instance);
        this.xId = xId;
        this.defaultTxnTimeout = seconds;
        this.txnTimeout = seconds;
    }

    public void begin() throws NotSupportedException, SystemException {
        TransactionMessage returnMsg;
        TransactionMessage msg = new TransactionMessage();
        msg.setRequestType(2);
        msg.setThreadIdentifier(this.threadId);
        if (this.txnTimeout != this.defaultTxnTimeout) {
            msg.setTransactionTimeout(this.txnTimeout);
        }
        if ((returnMsg = UserTransactionProxy.sendMessage(msg, this.connection, this.instance)).hasException()) {
            Throwable error = returnMsg.getException();
            if (error instanceof NotSupportedException) {
                throw (NotSupportedException)error;
            }
            if (error instanceof SystemException) {
                throw (SystemException)error;
            }
            throw new MetaMatrixRuntimeException(error, JDBCPlugin.Util.getString("UserTransactionProxy.Received_exception_when_begining_transaction"));
        }
        this.xId = returnMsg.getMMXid();
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        if (this.xId == null || this.xId.trim().length() == 0) {
            throw new SystemException(JDBCPlugin.Util.getString("UserTransactionProxy.Not_involved_in_transaction"));
        }
        TransactionMessage msg = new TransactionMessage();
        msg.setRequestType(3);
        msg.setThreadIdentifier(this.threadId);
        msg.setMMXid(this.xId);
        TransactionMessage returnMsg = UserTransactionProxy.sendMessage(msg, this.connection, this.instance);
        if (returnMsg.hasException()) {
            Throwable error = returnMsg.getException();
            if (error instanceof RollbackException) {
                throw (RollbackException)error;
            }
            if (error instanceof HeuristicMixedException) {
                throw (HeuristicMixedException)error;
            }
            if (error instanceof HeuristicRollbackException) {
                throw (HeuristicRollbackException)error;
            }
            if (error instanceof SecurityException) {
                throw (SecurityException)error;
            }
            if (error instanceof IllegalStateException) {
                throw (IllegalStateException)error;
            }
            if (error instanceof SystemException) {
                throw (SystemException)error;
            }
            throw new MetaMatrixRuntimeException(error, JDBCPlugin.Util.getString("UserTransactionProxy.Received_exception_when_committing_transaction"));
        }
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        if (this.xId == null || this.xId.trim().length() == 0) {
            throw new SystemException(JDBCPlugin.Util.getString("UserTransactionProxy.Not_involved_in_transaction"));
        }
        TransactionMessage msg = new TransactionMessage();
        msg.setRequestType(4);
        msg.setThreadIdentifier(this.threadId);
        msg.setMMXid(this.xId);
        TransactionMessage returnMsg = UserTransactionProxy.sendMessage(msg, this.connection, this.instance);
        if (returnMsg.hasException()) {
            Throwable error = returnMsg.getException();
            if (error instanceof SecurityException) {
                throw (SecurityException)error;
            }
            if (error instanceof IllegalStateException) {
                throw (IllegalStateException)error;
            }
            if (error instanceof SystemException) {
                throw (SystemException)error;
            }
            throw new MetaMatrixRuntimeException(error, JDBCPlugin.Util.getString("UserTransactionProxy.Received_exception_when_rolling_back_transaction"));
        }
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        if (this.xId == null || this.xId.trim().length() == 0) {
            throw new SystemException(JDBCPlugin.Util.getString("UserTransactionProxy.Not_involved_in_transaction"));
        }
        TransactionMessage msg = new TransactionMessage();
        msg.setRequestType(5);
        msg.setThreadIdentifier(this.threadId);
        msg.setMMXid(this.xId);
        TransactionMessage returnMsg = UserTransactionProxy.sendMessage(msg, this.connection, this.instance);
        if (returnMsg.hasException()) {
            Throwable error = returnMsg.getException();
            if (error instanceof SecurityException) {
                throw (SecurityException)error;
            }
            if (error instanceof IllegalStateException) {
                throw (IllegalStateException)error;
            }
            if (error instanceof SystemException) {
                throw (SystemException)error;
            }
            throw new MetaMatrixRuntimeException(error, JDBCPlugin.Util.getString("UserTransactionProxy.Received_exception_when_setting_transaction_to_rollback_only"));
        }
    }

    public int getStatus() throws SystemException {
        if (this.xId == null || this.xId.trim().length() == 0) {
            throw new SystemException(JDBCPlugin.Util.getString("UserTransactionProxy.Not_involved_in_transaction"));
        }
        TransactionMessage msg = new TransactionMessage();
        msg.setRequestType(6);
        msg.setThreadIdentifier(this.threadId);
        msg.setMMXid(this.xId);
        TransactionMessage returnMsg = UserTransactionProxy.sendMessage(msg, this.connection, this.instance);
        if (returnMsg.hasException()) {
            Throwable error = returnMsg.getException();
            if (error instanceof SystemException) {
                throw (SystemException)error;
            }
            throw new MetaMatrixRuntimeException(error, JDBCPlugin.Util.getString("UserTransactionProxy.Received_exception_when_getting_transaction_status"));
        }
        return returnMsg.getTxnStatus();
    }

    public void setTransactionTimeout(int seconds) throws SystemException {
        if (seconds > 0) {
            this.txnTimeout = seconds;
        } else if (seconds == 0) {
            this.txnTimeout = this.defaultTxnTimeout;
        }
    }

    public String getThreadIdentifier() {
        return this.threadId;
    }

    public String getMMXid() {
        return this.xId;
    }

    public void setMMXid(String xid) {
        this.xId = xid;
    }

    public void setServerConnection(ServerConnection connection) {
        this.connection = connection;
    }

    public void setServerInstance(ServerInstance instance) {
        this.instance = instance;
    }

    private static TransactionMessage sendMessage(TransactionMessage msg, ServerConnection serverConnection, ServerInstance serverInstance) throws MetaMatrixRuntimeException {
        try {
            Message returnedMsg = serverConnection.send(msg, serverInstance);
            if (returnedMsg instanceof TransactionMessage) {
                msg = (TransactionMessage)returnedMsg;
            } else if (returnedMsg instanceof MessageHolder) {
                ExceptionHolder contents = (ExceptionHolder)((MessageHolder)returnedMsg).contents;
                msg.setException(contents.exception);
            } else {
                Object[] params = new Object[]{returnedMsg};
                msg.setException(new MetaMatrixRuntimeException(JDBCPlugin.Util.getString("UserTransactionProxy.Unknown_msg_type", params)));
            }
        }
        catch (CommunicationException e) {
            throw new MetaMatrixRuntimeException(e);
        }
        catch (ApplicationException e) {
            throw new MetaMatrixRuntimeException(e);
        }
        return msg;
    }

    public String toString() {
        return "ThreadID [" + this.threadId + "] XID [" + this.xId + "]";
    }
}

