/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.core.log;

import com.metamatrix.core.CorePlugin;
import com.metamatrix.core.log.LogListener;
import com.metamatrix.internal.core.log.PlatformLogWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.eclipse.core.runtime.IStatus;

public class FileLogWriter
implements LogListener {
    private PlatformLogWriter writer;

    public FileLogWriter(File file) {
        if (file == null) {
            String msg = CorePlugin.Util.getString("FileLogWriter.The_File_reference_may_not_be_null");
            throw new IllegalArgumentException(msg);
        }
        try {
            FileOutputStream destination = new FileOutputStream(file.getAbsolutePath(), true);
            this.writer = new PlatformLogWriter(destination, destination);
        }
        catch (IOException e) {
            this.writer = new PlatformLogWriter(System.err, System.err);
        }
    }

    public void logMessage(IStatus msg, long timestamp, String pluginID, String threadName) {
        this.writer.logMessage(msg, timestamp, pluginID, threadName);
    }

    public void shutdown() {
        this.writer.shutdown();
    }
}

