/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.core.io;

import java.io.IOException;
import java.io.Reader;

public abstract class CharArrayStreamReader
extends Reader {
    boolean closed = false;
    char[] charData = null;
    int currentCounter = 0;
    boolean lastChunk = false;
    int availableCounter = 0;
    boolean illegalState = false;

    public void close() throws IOException {
        this.closed = true;
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        if (this.closed) {
            throw new IllegalStateException("reader already closed");
        }
        if (this.lastChunk && this.availableCounter == 0) {
            return -1;
        }
        if (!this.lastChunk && this.availableCounter < len) {
            char[] chunk = this.getChars(this.getChunkSize());
            if (chunk == null) {
                this.lastChunk = true;
            } else {
                char[] nbuf = chunk;
                if (this.availableCounter > 0) {
                    nbuf = new char[this.availableCounter + chunk.length];
                    System.arraycopy(this.charData, this.currentCounter, nbuf, 0, this.availableCounter);
                    System.arraycopy(chunk, 0, nbuf, this.availableCounter, chunk.length);
                }
                this.charData = nbuf;
                this.availableCounter = nbuf.length;
                this.currentCounter = 0;
                boolean bl = this.lastChunk = chunk.length < this.getChunkSize();
            }
        }
        if (this.availableCounter > 0) {
            int copy = len;
            if (len > this.availableCounter) {
                copy = this.availableCounter;
            }
            this.availableCounter -= copy;
            System.arraycopy(this.charData, this.currentCounter, cbuf, off, copy);
            this.currentCounter += copy;
            return copy;
        }
        return -1;
    }

    public abstract char[] getChars(int var1) throws IOException;

    public abstract int getChunkSize();
}

