/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.util.crypto.cipher;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.util.crypto.CryptoException;
import com.metamatrix.common.util.crypto.CryptoFactory;
import com.metamatrix.common.util.crypto.Cryptor;
import com.metamatrix.common.util.crypto.cipher.SerializableEncryptor;
import java.io.Serializable;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SealedObject;

public class BasicCryptor
extends SerializableEncryptor
implements Cryptor {
    protected Key decryptKey = null;
    private Cipher decryptCipher = null;

    public BasicCryptor(Key encryptKey, Key decryptKey) throws CryptoException {
        this(encryptKey, decryptKey, "RSA/ECB/PKCS1Padding");
    }

    public BasicCryptor(Key encryptKey, Key decryptKey, String algorithm) throws CryptoException {
        super(encryptKey, algorithm);
        this.decryptKey = decryptKey;
        this.initCiphers();
    }

    public synchronized byte[] decrypt(byte[] ciphertext) throws CryptoException {
        try {
            return this.decryptCipher.doFinal(ciphertext);
        }
        catch (Exception e) {
            try {
                this.initCiphers();
            }
            catch (CryptoException cryptoException) {
                // empty catch block
            }
            throw new CryptoException("ERR.003.030.0071", CommonPlugin.Util.getString("ERR.003.030.0071", e.getClass().getName(), e.getMessage()));
        }
    }

    public char[] decrypt(char[] ciphertext) throws CryptoException {
        int i;
        if (ciphertext == null) {
            throw new CryptoException("ERR.003.030.0074", CommonPlugin.Util.getString("ERR.003.030.0074"));
        }
        for (i = 0; i < ENCRYPTED_PREFIX.length && i < ciphertext.length && ciphertext[i] == ENCRYPTED_PREFIX[i]; ++i) {
        }
        if (i == ENCRYPTED_PREFIX.length) {
            char[] actualText = new char[ciphertext.length - ENCRYPTED_PREFIX.length];
            System.arraycopy(ciphertext, ENCRYPTED_PREFIX.length, actualText, 0, actualText.length);
            ciphertext = actualText;
        }
        byte[] cipherBytes = null;
        try {
            cipherBytes = CryptoFactory.decodeBytes(ciphertext);
        }
        catch (IllegalArgumentException e) {
            throw new CryptoException("ERR.003.030.0075", CommonPlugin.Util.getString("ERR.003.030.0075", e.getMessage()));
        }
        byte[] cleartext = this.decrypt(cipherBytes);
        return new String(cleartext).toCharArray();
    }

    protected void initCiphers() throws CryptoException {
        super.initCipher();
        try {
            this.decryptCipher = Cipher.getInstance(this.cipherAlgorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException((Throwable)e, "ERR.003.030.0076", CommonPlugin.Util.getString("ERR.003.030.0076", this.cipherAlgorithm));
        }
        catch (NoSuchPaddingException e) {
            throw new CryptoException("ERR.003.030.0077", CommonPlugin.Util.getString("ERR.003.030.0077", this.cipherAlgorithm, e.getClass().getName(), e.getMessage()));
        }
        AlgorithmParameters algParams = this.encryptCipher.getParameters();
        if (algParams != null) {
            try {
                this.decryptCipher.init(2, this.decryptKey, algParams);
            }
            catch (InvalidKeyException e) {
                throw new CryptoException((Throwable)e, "ERR.003.030.0078", CommonPlugin.Util.getString("ERR.003.030.0078", e.getClass().getName(), e.getMessage()));
            }
            catch (InvalidAlgorithmParameterException e) {
                throw new CryptoException((Throwable)e, "ERR.003.030.0080", CommonPlugin.Util.getString("ERR.003.030.0080", this.cipherAlgorithm));
            }
        }
        try {
            this.decryptCipher.init(2, this.decryptKey);
        }
        catch (InvalidKeyException e) {
            throw new CryptoException((Throwable)e, "ERR.003.030.0079", CommonPlugin.Util.getString("ERR.003.030.0079", e.getClass().getName(), e.getMessage()));
        }
    }

    public synchronized Serializable unsealObject(Serializable object) throws CryptoException {
        if (!(object instanceof SealedObject)) {
            return object;
        }
        SealedObject so = (SealedObject)object;
        try {
            return (Serializable)so.getObject(this.decryptCipher);
        }
        catch (Exception e) {
            try {
                this.initCiphers();
            }
            catch (CryptoException err) {
                // empty catch block
            }
            throw new CryptoException("ERR.003.030.0071", CommonPlugin.Util.getString("ERR.003.030.0071", e.getClass().getName(), e.getMessage()));
        }
    }
}

