/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.log;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.log.DbLogWriter;
import com.metamatrix.common.log.DbWriterException;
import com.metamatrix.common.util.PropertiesUtils;
import com.metamatrix.core.log.LogListener;
import java.util.Properties;
import org.eclipse.core.runtime.IStatus;

public class DbLogListener
implements LogListener {
    public static final String LOG_DB_ENABLED = "metamatrix.log.jdbcDatabase.enabled";
    private DbLogWriter writer = null;
    private boolean enabled = true;

    public DbLogListener(Properties prop) throws DbWriterException {
        if (prop == null) {
            String msg = CommonPlugin.Util.getString("DbLogListener.The_Properties_reference_may_not_be_null");
            throw new IllegalArgumentException(msg);
        }
        this.writer = new DbLogWriter(prop);
        this.writer.initialize();
        this.enabled = PropertiesUtils.getBooleanProperty(prop, LOG_DB_ENABLED, true);
    }

    protected void init(Properties props) throws DbWriterException {
    }

    public void logMessage(IStatus status, long timestamp, String pluginID, String threadName) {
        if (this.enabled) {
            this.writer.logMessage(status, timestamp, pluginID, threadName);
        }
    }

    public void shutdown() {
        this.writer.shutdown();
    }

    public void determineIfEnabled(Properties props) {
        boolean isenabled = PropertiesUtils.getBooleanProperty(props, LOG_DB_ENABLED, true);
        this.enableDBLogging(isenabled);
    }

    public void enableDBLogging(boolean enable) {
        this.enabled = enable;
    }
}

