/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.comm.platform.server;

import com.metamatrix.admin.api.exception.AdminException;
import com.metamatrix.admin.util.IAdminMethodRoleResolver;
import com.metamatrix.api.exception.ComponentNotFoundException;
import com.metamatrix.api.exception.MetaMatrixProcessingException;
import com.metamatrix.api.exception.MetaMatrixRuntimeException;
import com.metamatrix.api.exception.security.AuthorizationException;
import com.metamatrix.api.exception.security.InvalidSessionException;
import com.metamatrix.common.comm.platform.CommPlatformPlugin;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.core.proxy.SecurityContext;
import com.metamatrix.core.proxy.SecurityContextFactory;
import com.metamatrix.core.proxy.ServiceInterceptor;
import com.metamatrix.core.proxy.ServiceInvocation;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.platform.admin.apiimpl.IAdminHelper;
import com.metamatrix.platform.security.api.MetaMatrixSessionID;
import com.metamatrix.platform.security.api.SessionToken;
import com.metamatrix.platform.service.api.exception.ServiceException;

public class AdminAuthorizationInterceptor
implements ServiceInterceptor {
    private static final String READ_ROLE = "Admin.ReadOnlyAdmin";
    private final SecurityContextFactory securityContextFactory;
    private final IAdminHelper authorizationService;
    private final IAdminMethodRoleResolver methodNames;

    public AdminAuthorizationInterceptor(SecurityContextFactory securityContextFactory, IAdminHelper authorizationService, IAdminMethodRoleResolver methodNames) {
        ArgCheck.isNotNull(securityContextFactory);
        ArgCheck.isNotNull(authorizationService);
        ArgCheck.isNotNull(methodNames);
        this.securityContextFactory = securityContextFactory;
        this.authorizationService = authorizationService;
        this.methodNames = methodNames;
    }

    public Object invoke(ServiceInvocation invocation) throws Throwable {
        SecurityContext securityContext = this.securityContextFactory.create();
        this.checkAdminAuthorization(invocation, securityContext);
        Object result = invocation.invokeNext();
        return result;
    }

    private void checkAdminAuthorization(ServiceInvocation invocation, SecurityContext securityContext) throws AuthorizationException, MetaMatrixProcessingException, AdminException {
        SessionToken adminToken = null;
        try {
            adminToken = this.authorizationService.validateSession(this.getSessionID(securityContext));
        }
        catch (InvalidSessionException err) {
            Object[] params = new Object[]{securityContext.getUserName(), invocation.getMethodName()};
            throw new AuthorizationException((Throwable)err, CommPlatformPlugin.Util.getString("AdminAuthorizationInterceptor.Admin_Session_not_valid", params));
        }
        catch (ComponentNotFoundException err) {
            Object[] params = new Object[]{securityContext.getUserName(), invocation.getMethodName()};
            throw new AuthorizationException((Throwable)err, CommPlatformPlugin.Util.getString("AdminAuthorizationInterceptor.Admin_Session_not_valid", params));
        }
        catch (ServiceException err) {
            Object[] params = new Object[]{securityContext.getUserName(), invocation.getMethodName()};
            throw new AuthorizationException((Throwable)err, CommPlatformPlugin.Util.getString("AdminAuthorizationInterceptor.Admin_Session_not_valid", params));
        }
        if (adminToken == null) {
            Object[] params = new Object[]{securityContext.getUserName(), invocation.getMethodName()};
            throw new AuthorizationException(CommPlatformPlugin.Util.getString("AdminAuthorizationInterceptor.Admin_Session_not_valid", params));
        }
        String methodName = invocation.getMethodName();
        if (!this.skipAuthorization(methodName)) {
            boolean isAuthorized = false;
            String requiredRoleName = this.methodNames.getRoleNameForMethod(methodName);
            Object[] msgParts = null;
            boolean msgWillBeRecorded = LogManager.isMessageToBeRecorded("AUDIT_ADMIN", 1);
            if (msgWillBeRecorded) {
                msgParts = this.buildAuditMessage(securityContext, adminToken, requiredRoleName, invocation);
                LogManager.logCritical("AUDIT_ADMIN", CommPlatformPlugin.Util.getString("AdminAuthorizationInterceptor.Admin_Audit_request", msgParts));
            }
            try {
                this.authorizationService.checkForRequiredRole(adminToken, requiredRoleName);
                isAuthorized = true;
                LogManager.logCritical("AUDIT_ADMIN", CommPlatformPlugin.Util.getString("AdminAuthorizationInterceptor.Admin_granted", msgParts));
            }
            catch (AuthorizationException err) {
                if (msgParts == null) {
                    msgParts = this.buildAuditMessage(securityContext, adminToken, requiredRoleName, invocation);
                }
                String errMsg = CommPlatformPlugin.Util.getString("AdminAuthorizationInterceptor.Admin_not_authorized", msgParts);
                LogManager.logCritical("AUDIT_ADMIN", errMsg);
                throw new AuthorizationException((Throwable)err, errMsg);
            }
            catch (ComponentNotFoundException err) {
                if (msgParts == null) {
                    msgParts = this.buildAuditMessage(securityContext, adminToken, requiredRoleName, invocation);
                }
                String errMsg = CommPlatformPlugin.Util.getString("AdminAuthorizationInterceptor.Admin_not_authorized", msgParts);
                LogManager.logCritical("AUDIT_ADMIN", errMsg);
                throw new AuthorizationException((Throwable)err, errMsg);
            }
            if (!isAuthorized && msgWillBeRecorded) {
                String errMsg = CommPlatformPlugin.Util.getString("AdminAuthorizationInterceptor.Admin_not_authorized", msgParts);
                LogManager.logCritical("AUDIT_ADMIN", errMsg);
                throw new AuthorizationException(errMsg);
            }
        }
    }

    private boolean skipAuthorization(String methodName) throws AdminException {
        String roleName = this.methodNames.getRoleNameForMethod(methodName);
        return roleName == null && roleName.equals(READ_ROLE);
    }

    private MetaMatrixSessionID getSessionID(SecurityContext securityContext) throws InvalidSessionException, ServiceException, ComponentNotFoundException {
        try {
            String sessionId = securityContext.getConnectionId();
            MetaMatrixSessionID mmSessionId = new MetaMatrixSessionID(Long.valueOf(sessionId), securityContext.getUserName());
            return mmSessionId;
        }
        catch (NumberFormatException e) {
            throw new MetaMatrixRuntimeException(e);
        }
    }

    private Object[] buildAuditMessage(SecurityContext securityContext, SessionToken adminToken, String requiredRoleName, ServiceInvocation invocation) {
        String COMMA_SPACE = ", ";
        StringBuffer methodSignature = new StringBuffer(invocation.getMethodName());
        methodSignature.append('(');
        Object[] args = invocation.getArguments();
        for (int i = 0; i < args.length; ++i) {
            Object anArg = args[i];
            if (anArg == null) continue;
            methodSignature.append(anArg.toString());
            methodSignature.append(", ");
        }
        if (args.length > 0) {
            methodSignature.setLength(methodSignature.length() - ", ".length());
        }
        methodSignature.append(')');
        Object[] msgParts = new Object[]{securityContext.getUserName(), adminToken.getSessionID().toString(), requiredRoleName, methodSignature.toString()};
        return msgParts;
    }
}

