/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.xml.cache;

import com.metamatrix.connector.xml.base.XMLDocument;
import com.metamatrix.connector.xml.cache.DocumentCache;
import com.metamatrix.connector.xml.cache.IDocumentCache;
import com.metamatrix.data.api.ConnectorLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;

/*
 * Exception performing whole class analysis ignored.
 */
public class DocumentCache
implements IDocumentCache {
    private int m_maxTimeToLive;
    private int m_maxMemoryCacheSize;
    private int m_maxFileCacheSize;
    private int m_currentMemoryCacheSize;
    private int m_currentFileCacheSize;
    private Hashtable m_cacheImpl;
    private List deleteList;
    private CachedObject m_mostRecentUsed;
    private CachedObject m_leastRecentUsed;
    private CacheCleaner m_cleaner;
    private String m_fileCacheLocation;
    private ConnectorLogger m_log;
    private String m_cacheIdentifier;
    private int m_memoryCacheCount = 0;
    private int m_fileCacheCount = 0;
    private boolean m_performanceCache = false;
    CachedObjectRemover cachedObjectRemover;
    private static final int UNLIMITED_CACHE_THRESHOLD = -1;

    public DocumentCache(int maxMemoryCacheSize, int maxFileCacheSize, String fileCacheLocation, int maxTimeToLive, ConnectorLogger log, String identifier, boolean useCleanerThread) {
        this.m_log = log;
        if (maxTimeToLive != 0) {
            this.m_performanceCache = true;
            this.m_cleaner = new CacheCleaner(this, useCleanerThread);
            this.m_log.logTrace("Performance File cache is enabled");
        } else {
            this.m_log.logTrace("Performance File cache is disabled");
        }
        this.m_maxMemoryCacheSize = maxMemoryCacheSize;
        this.m_log.logTrace("File cache Max Memory Cache Size " + maxMemoryCacheSize);
        this.m_maxTimeToLive = maxTimeToLive;
        this.m_log.logTrace("File cache Max Time to Live " + this.m_maxTimeToLive);
        this.m_maxFileCacheSize = maxFileCacheSize;
        this.m_log.logTrace("File cache location is " + this.m_fileCacheLocation);
        this.m_fileCacheLocation = fileCacheLocation;
        this.m_currentMemoryCacheSize = 0;
        this.m_currentFileCacheSize = 0;
        this.m_cacheImpl = new Hashtable();
        this.m_leastRecentUsed = this.m_mostRecentUsed = null;
        this.m_cacheIdentifier = identifier;
        this.deleteList = new ArrayList();
        this.cachedObjectRemover = new CachedObjectRemover(this, null);
        this.cachedObjectRemover.start();
    }

    public DocumentCache(int maxMemoryCacheSize, int maxFileCacheSize, String fileCacheLocation, int maxTimeToLive, ConnectorLogger log, String identifier) {
        this(maxMemoryCacheSize, maxFileCacheSize, fileCacheLocation, maxTimeToLive, log, identifier, true);
    }

    public static XMLDocument cacheLookup(IDocumentCache cache, String cacheKey, String requestID, String partID) {
        XMLDocument doc = null;
        Object tmpObject = cache.fetchObject(cacheKey, requestID, partID);
        if (tmpObject != null) {
            doc = (XMLDocument)tmpObject;
        }
        return doc;
    }

    public synchronized void addToCache(String id, Object obj, int size, String requestID, String partID) {
        this.m_log.logTrace("Attempting to cache item identified by " + id + "; estimated memory size is " + size + " bytes.");
        if (this.m_maxMemoryCacheSize > -1 && size > this.m_maxMemoryCacheSize && this.m_maxFileCacheSize > -1 && size > this.m_maxFileCacheSize) {
            this.m_log.logTrace(this.m_cacheIdentifier + ": unable to cache item identified by " + id);
            return;
        }
        CachedObject newItem = new CachedObject(this, null);
        if (this.m_performanceCache) {
            CachedObject.access$200((CachedObject)newItem, (long)(System.currentTimeMillis() + (long)this.m_maxTimeToLive));
        }
        CachedObject.access$300((CachedObject)newItem, (String)id);
        CachedObject.access$400((CachedObject)newItem, (Object)obj);
        CachedObject.access$500((CachedObject)newItem, (int)size);
        newItem.addReference(requestID, partID);
        if (obj instanceof EventSinkFactory) {
            EventSink eventSink = ((EventSinkFactory)obj).getEventSink();
            CachedObject.access$600((CachedObject)newItem, (EventSink)eventSink);
        }
        if (this.m_currentMemoryCacheSize == 0 && this.m_currentFileCacheSize == 0) {
            this.m_leastRecentUsed = newItem;
        } else if (this.m_cacheImpl.get(id) != null) {
            this.remove((CachedObject)this.m_cacheImpl.get(id));
        }
        if (size <= this.m_maxMemoryCacheSize || this.m_maxMemoryCacheSize <= -1) {
            this.addItemToMemoryCache(newItem);
        } else {
            this.addItemToFileCache(newItem);
        }
        if (this.m_mostRecentUsed != null) {
            CachedObject.access$700((CachedObject)this.m_mostRecentUsed, (CachedObject)newItem);
        }
        this.m_mostRecentUsed = newItem;
        this.m_cacheImpl.put(CachedObject.access$800((CachedObject)newItem), newItem);
        this.m_log.logTrace(this.m_cacheIdentifier + ": adding item to cache as " + CachedObject.access$800((CachedObject)newItem));
        this.logCacheReport();
        if (this.m_performanceCache) {
            this.m_cleaner.scheduleRemoval(newItem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void release(String cacheKey, String requestID, String partID) {
        CachedObject cacheObject = (CachedObject)this.m_cacheImpl.get(cacheKey);
        if (null != cacheObject) {
            cacheObject.removeReference(requestID, partID);
            this.m_log.logTrace("Removing reference to Request Identification " + requestID + " and Part Identification " + partID + " from cache item " + cacheKey);
            if (!this.m_performanceCache && !cacheObject.isLocked()) {
                this.m_log.logTrace("Moving cache item " + cacheKey + " to the delete list");
                this.removeLink(cacheObject);
                this.m_cacheImpl.remove(cacheKey);
                cacheObject.setListed(false);
                List list = this.deleteList;
                synchronized (list) {
                    this.deleteList.add(cacheObject);
                }
            }
        }
    }

    private void remove(CachedObject ref) {
        this.removeLink(ref);
        this.m_cacheImpl.remove(CachedObject.access$800((CachedObject)ref));
        this.m_log.logTrace(this.m_cacheIdentifier + ": removing item from cache identified by : " + CachedObject.access$800((CachedObject)ref));
        if (CachedObject.access$900((CachedObject)ref) instanceof FileCacheItem) {
            FileCacheItem item = (FileCacheItem)CachedObject.access$900((CachedObject)ref);
            File itemFile = new File(FileCacheItem.access$1000((FileCacheItem)item));
            boolean success = itemFile.delete();
            if (success) {
                this.m_log.logTrace(this.m_cacheIdentifier + ": removed file " + itemFile.getAbsolutePath() + " from file cache");
            } else {
                this.m_log.logError(this.m_cacheIdentifier + ": failed to remove file " + itemFile.getAbsolutePath() + " from the cache");
            }
            this.decrementFileCacheCount();
            this.updateFileCacheSize(-CachedObject.access$1100((CachedObject)ref));
        } else {
            this.decrementMemoryCacheCount();
            this.updateMemoryCacheSize(-CachedObject.access$1100((CachedObject)ref));
        }
        if (CachedObject.access$1200((CachedObject)ref) != null) {
            CachedObject.access$1200((CachedObject)ref).onDelete();
        }
        this.m_log.logTrace(this.m_cacheIdentifier + ": removed item " + CachedObject.access$800((CachedObject)ref) + " from cache");
        this.logCacheReport();
    }

    private void removeLink(CachedObject remove) {
        if (this.m_mostRecentUsed == remove) {
            this.m_mostRecentUsed = CachedObject.access$1300((CachedObject)remove);
        }
        if (this.m_leastRecentUsed == remove) {
            this.m_leastRecentUsed = CachedObject.access$1400((CachedObject)remove);
        }
        if (CachedObject.access$1300((CachedObject)remove) != null) {
            CachedObject.access$700((CachedObject)CachedObject.access$1300((CachedObject)remove), (CachedObject)CachedObject.access$1400((CachedObject)remove));
        }
        if (CachedObject.access$1400((CachedObject)remove) != null) {
            CachedObject.access$1500((CachedObject)CachedObject.access$1400((CachedObject)remove), (CachedObject)CachedObject.access$1300((CachedObject)remove));
        }
    }

    public synchronized Object fetchObject(String id, String requestID, String partID) {
        this.m_log.logTrace("Looking up " + id + " | " + requestID + " | " + partID);
        CachedObject foundLink = (CachedObject)this.m_cacheImpl.get(id);
        if (foundLink == null) {
            this.m_log.logTrace(this.m_cacheIdentifier + ": could not find item in cache with id " + id);
            return null;
        }
        String message = this.m_cacheIdentifier + ": found item in cache with id " + id;
        if (foundLink.isExpired()) {
            if (foundLink.hasReference(requestID)) {
                foundLink.addReference(requestID, partID);
            } else {
                message = message + ", Item is expired, returning null";
                this.m_log.logTrace(message);
                return null;
            }
        }
        this.m_log.logTrace(message);
        Object o = null;
        if (CachedObject.access$900((CachedObject)foundLink) instanceof FileCacheItem) {
            o = this.deserializeFileCacheItem((FileCacheItem)CachedObject.access$900((CachedObject)foundLink));
            if (CachedObject.access$1200((CachedObject)foundLink) != null) {
                CachedObject.access$1200((CachedObject)foundLink).onRestoreFromFile(o);
            }
            this.updateFileCacheSize(-CachedObject.access$1100((CachedObject)foundLink));
            if (o == null) {
                this.m_cacheImpl.remove(CachedObject.access$800((CachedObject)foundLink));
            }
        } else {
            o = CachedObject.access$900((CachedObject)foundLink);
        }
        foundLink.addReference(requestID, partID);
        return o;
    }

    public synchronized void clearCache() {
        this.m_cleaner.interrupt();
        CacheCleaner.access$1600((CacheCleaner)this.m_cleaner);
        this.cachedObjectRemover.interrupt();
    }

    private void addItemToFileCache(CachedObject item) {
        if (this.m_maxFileCacheSize > -1 && CachedObject.access$1100((CachedObject)item) > this.m_maxFileCacheSize) {
            this.m_log.logTrace(CachedObject.access$800((CachedObject)item) + " cannot be cached to file.  Cache size would be exceeded");
            return;
        }
        String extension = ".ser";
        if (CachedObject.access$900((CachedObject)item) instanceof Serializable) {
            File serialized = new File(this.m_fileCacheLocation + File.separator + item.hashCode() + ".ser");
            try {
                ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(serialized));
                oos.writeObject(CachedObject.access$900((CachedObject)item));
                oos.flush();
                oos.close();
            }
            catch (IOException e) {
                this.m_log.logTrace("IOException serializing " + CachedObject.access$800((CachedObject)item) + " Exception Message = " + e.getMessage());
                this.remove(item);
                return;
            }
            while (this.m_maxFileCacheSize > -1 && this.m_currentFileCacheSize + CachedObject.access$1100((CachedObject)item) >= this.m_maxFileCacheSize) {
                CachedObject obj = CachedObjectQueueItem.access$1800((CachedObjectQueueItem)CacheCleaner.access$1700((CacheCleaner)this.m_cleaner));
                CacheCleaner.access$1702((CacheCleaner)this.m_cleaner, (CachedObjectQueueItem)CachedObjectQueueItem.access$1900((CachedObjectQueueItem)CacheCleaner.access$1700((CacheCleaner)this.m_cleaner)));
                this.m_log.logTrace("Removing file cache item " + CachedObject.access$800((CachedObject)obj) + " to make room for " + CachedObject.access$800((CachedObject)item));
                this.m_log.logTrace("Consider increasing the memory cache size");
                this.remove(obj);
            }
            FileCacheItem cacheItem = new FileCacheItem(this, null);
            FileCacheItem.access$2100((FileCacheItem)cacheItem, (String)(this.m_fileCacheLocation + File.separator + item.hashCode() + ".ser"));
            CachedObject.access$400((CachedObject)item, (Object)cacheItem);
            this.incrementFileCacheCount();
            this.updateFileCacheSize(CachedObject.access$1100((CachedObject)item));
            this.m_log.logTrace(this.m_cacheIdentifier + ": added item " + CachedObject.access$800((CachedObject)item) + " to file cache with name " + FileCacheItem.access$1000((FileCacheItem)cacheItem));
        } else {
            this.m_log.logTrace(CachedObject.access$800((CachedObject)item) + " cannot be cached to file.  It does not implement Serializable");
            this.remove(item);
        }
    }

    private void incrementFileCacheCount() {
        ++this.m_fileCacheCount;
    }

    private void decrementFileCacheCount() {
        --this.m_fileCacheCount;
    }

    private void incrementMemoryCacheCount() {
        ++this.m_memoryCacheCount;
    }

    private void decrementMemoryCacheCount() {
        --this.m_memoryCacheCount;
    }

    private void addItemToMemoryCache(CachedObject newItem) {
        int writeTimeBuffer = 5000;
        while (this.m_maxMemoryCacheSize > -1 && this.m_currentMemoryCacheSize + CachedObject.access$1100((CachedObject)newItem) > this.m_maxMemoryCacheSize) {
            if (this.m_leastRecentUsed != null && this.m_performanceCache && CachedObject.access$2200((CachedObject)this.m_leastRecentUsed) <= 5000L + System.currentTimeMillis()) {
                this.m_cacheImpl.remove(CachedObject.access$800((CachedObject)this.m_leastRecentUsed));
                this.updateMemoryCacheSize(-CachedObject.access$1100((CachedObject)this.m_leastRecentUsed));
                this.m_leastRecentUsed = CachedObject.access$1300((CachedObject)this.m_leastRecentUsed);
                continue;
            }
            CachedObject removeCandidate = this.m_leastRecentUsed;
            while (removeCandidate != null && CachedObject.access$2300((CachedObject)removeCandidate) instanceof FileCacheItem) {
                removeCandidate = CachedObject.access$1400((CachedObject)removeCandidate);
            }
            if (removeCandidate == null) continue;
            this.m_log.logTrace("Moving item " + CachedObject.access$800((CachedObject)removeCandidate) + " from memory to file cache");
            this.addItemToFileCache(removeCandidate);
            this.updateMemoryCacheSize(-CachedObject.access$1100((CachedObject)removeCandidate));
            this.decrementMemoryCacheCount();
        }
        CachedObject.access$1500((CachedObject)newItem, (CachedObject)this.m_mostRecentUsed);
        CachedObject.access$700((CachedObject)newItem, null);
        this.incrementMemoryCacheCount();
        this.updateMemoryCacheSize(CachedObject.access$1100((CachedObject)newItem));
    }

    private void updateMemoryCacheSize(int amount) {
        this.m_currentMemoryCacheSize += amount;
        if (this.m_currentMemoryCacheSize < 0) {
            this.m_currentMemoryCacheSize = 0;
        }
    }

    private void updateFileCacheSize(int amount) {
        this.m_currentFileCacheSize += amount;
        if (this.m_currentFileCacheSize < 0) {
            this.m_currentFileCacheSize = 0;
        }
    }

    private void logCacheReport() {
        if (this.m_maxMemoryCacheSize <= -1) {
            this.m_log.logTrace(this.m_cacheIdentifier + " in-memory cache is unlimited. current usage: " + this.getCurrentMemoryCacheSize());
        } else {
            this.m_log.logTrace(this.m_cacheIdentifier + ": remaining in-memory cache: " + (this.m_maxMemoryCacheSize - this.getCurrentMemoryCacheSize()));
        }
        if (this.m_maxFileCacheSize <= -1) {
            this.m_log.logTrace(this.m_cacheIdentifier + " file cache is unlimited. current usage: " + this.getCurrentFileCacheSize());
        } else {
            this.m_log.logTrace(this.m_cacheIdentifier + ": remianing file memory cache: " + (this.m_maxFileCacheSize - this.getCurrentFileCacheSize()));
        }
        this.m_log.logTrace("Count of items in memory cache: " + this.m_memoryCacheCount);
        this.m_log.logTrace("Count of items in file cache: " + this.m_fileCacheCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object deserializeFileCacheItem(FileCacheItem item) {
        Object obj;
        File cacheFile = new File(FileCacheItem.access$1000((FileCacheItem)item));
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(new FileInputStream(cacheFile));
            obj = ois.readObject();
            ois.close();
            ois = null;
        }
        catch (Exception e) {
            obj = null;
        }
        finally {
            if (null != ois) {
                try {
                    ois.close();
                }
                catch (IOException e) {}
            }
        }
        return obj;
    }

    public void shutdownCleaner() {
        this.m_log.logTrace(this.m_cacheIdentifier + ": shutting down");
        if (this.m_performanceCache) {
            this.m_cleaner.interrupt();
        }
    }

    protected int getCurrentMemoryCacheSize() {
        return this.m_currentMemoryCacheSize;
    }

    protected int getCurrentFileCacheSize() {
        return this.m_currentFileCacheSize;
    }

    protected int getCacheCount() {
        return this.m_cacheImpl.size();
    }

    protected Enumeration getCacheContents() {
        return this.m_cacheImpl.elements();
    }

    protected void dumpCache() {
        CachedObject obj;
        int i;
        Enumeration enumer = this.getCacheContents();
        Vector<CachedObject> memory = new Vector<CachedObject>();
        Vector<CachedObject> files = new Vector<CachedObject>();
        while (enumer.hasMoreElements()) {
            CachedObject next = (CachedObject)enumer.nextElement();
            if (CachedObject.access$2300((CachedObject)next) instanceof FileCacheItem) {
                files.add(next);
                continue;
            }
            memory.add(next);
        }
        this.m_log.logTrace(this.m_cacheIdentifier + ": memory cache items:");
        for (i = 0; i < memory.size(); ++i) {
            obj = (CachedObject)memory.get(i);
            this.m_log.logTrace(obj.toString());
        }
        this.m_log.logTrace(this.m_cacheIdentifier + ": file cache items:");
        for (i = 0; i < files.size(); ++i) {
            obj = (CachedObject)files.get(i);
            this.m_log.logTrace(obj.toString());
        }
        this.m_log.logTrace("most recent used item: " + (this.m_mostRecentUsed == null ? "null" : CachedObject.access$2400((CachedObject)this.m_mostRecentUsed)));
        this.m_log.logTrace("least recent used item: " + (this.m_leastRecentUsed == null ? "null" : CachedObject.access$2400((CachedObject)this.m_leastRecentUsed)));
    }

    static /* synthetic */ ConnectorLogger access$2800(DocumentCache x0) {
        return x0.m_log;
    }

    static /* synthetic */ void access$2900(DocumentCache x0, CachedObject x1) {
        x0.removeLink(x1);
    }

    static /* synthetic */ List access$3000(DocumentCache x0) {
        return x0.deleteList;
    }

    static /* synthetic */ Hashtable access$3100(DocumentCache x0) {
        return x0.m_cacheImpl;
    }

    static /* synthetic */ void access$3200(DocumentCache x0, CachedObject x1) {
        x0.remove(x1);
    }

    static /* synthetic */ int access$3300(DocumentCache x0) {
        return x0.m_maxTimeToLive;
    }

    static /* synthetic */ List access$3002(DocumentCache x0, List x1) {
        x0.deleteList = x1;
        return x0.deleteList;
    }
}

