/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.api.tools;

import com.metamatrix.jdbc.api.DisplayHelper;
import com.metamatrix.jdbc.api.PlanNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class QueryPlanDisplayHelper
implements DisplayHelper {
    private Map nodeNameMap = new TreeMap();
    private Map childTypeMap = new TreeMap();
    private Map descriptionMap = new TreeMap();
    private Map propertyOrderMap = new TreeMap();
    private Map propertyNameMap = new TreeMap();

    public QueryPlanDisplayHelper() {
        this.init();
    }

    private void init() {
        this.nodeNameMap.put("Child Relational Plan", "Relational Plan");
        this.nodeNameMap.put("Child XML Plan", "XML Plan");
        this.nodeNameMap.put("COMMENT", "ADD COMMENT");
        this.childTypeMap.put("Relational Plan", "Child Relational Plan");
        this.childTypeMap.put("XML Plan", "Child XML Plan");
        this.descriptionMap.put("Join", "${joinType} ON ${joinCriteria}");
        this.descriptionMap.put("Project", "${selectCols}");
        this.descriptionMap.put("Select", "${criteria}");
        this.descriptionMap.put("Access", "${sql}");
        this.descriptionMap.put("EXECUTE SQL", "${sql}");
        this.descriptionMap.put("LOOP", "${joinType} ON ${joinCriteria}");
        this.descriptionMap.put("Join", "${joinType} ON ${joinCriteria}");
        this.descriptionMap.put("Limit", "${rowLimit}");
        this.descriptionMap.put("Offset", "${rowOffset}");
        this.putPropertySortOrder("default", new String[]{"outputCols"});
        this.putPropertySortOrder("Access", new String[]{"outputCols", "sql", "modelName"});
        this.putPropertySortOrder("Group", new String[]{"outputCols", "groupCols"});
        this.putPropertySortOrder("Join", new String[]{"outputCols", "joinType", "joinCriteria"});
        this.putPropertySortOrder("Merge Join", new String[]{"outputCols", "joinType", "joinCriteria"});
        this.putPropertySortOrder("Plan Execution", new String[]{"outputCols", "execPlan"});
        this.putPropertySortOrder("Project Into", new String[]{"outputCols", "intoGrp", "selectCols"});
        this.putPropertySortOrder("Project", new String[]{"outputCols", "selectCols"});
        this.putPropertySortOrder("Dependent Project", new String[]{"outputCols", "selectCols"});
        this.putPropertySortOrder("Select", new String[]{"outputCols", "criteria"});
        this.putPropertySortOrder("Dependent Select", new String[]{"outputCols", "criteria"});
        this.putPropertySortOrder("Sort", new String[]{"outputCols", "sortCols", "removeDups"});
        this.putPropertySortOrder("Limit", new String[]{"outputCols", "rowLimit"});
        this.putPropertySortOrder("Offset", new String[]{"outputCols", "rowOffset"});
        this.putPropertySortOrder("ABORT", new String[]{"message"});
        this.putPropertySortOrder("ADD COMMENT", new String[]{"message"});
        this.putPropertySortOrder("ADD ELEMENT", new String[]{"tag", "optional", "dataCol", "namespace", "namespaceDeclarations", "default"});
        this.putPropertySortOrder("ADD ATTRIBUTE", new String[]{"tag", "dataCol", "namespace", "default"});
        this.putPropertySortOrder("CACHE", new String[0]);
        this.putPropertySortOrder("UNCACHE", new String[0]);
        this.putPropertySortOrder("CLOSE RESULTSET", new String[]{"resultSet"});
        this.putPropertySortOrder("END DOCUMENT", new String[0]);
        this.putPropertySortOrder("EXECUTE SQL", new String[]{"resultSet", "sql", "isStaging", "inMemory", "group", "program"});
        this.putPropertySortOrder("CHOICE", new String[]{"conditions", "programs", "defaultProgram"});
        this.putPropertySortOrder("START DOCUMENT", new String[]{"encoding", "formatted"});
        this.putPropertySortOrder("NEXT ROW", new String[]{"resultSet"});
        this.putPropertySortOrder("DOCUMENT UP", new String[0]);
        this.putPropertySortOrder("DOCUMENT DOWN", new String[0]);
        this.putPropertySortOrder("NO OP", new String[0]);
        this.putPropertySortOrder("ASSIGN REFERENCE", new String[]{"expression"});
        this.putPropertySortOrder("LOOP", new String[]{"resultSet", "program"});
        this.putPropertySortOrder("ASSIGNMENT", new String[]{"variable", "expression", "program"});
        this.putPropertySortOrder("BREAK", new String[0]);
        this.putPropertySortOrder("CONTINUE", new String[0]);
        this.putPropertySortOrder("CREATE CURSOR", new String[]{"resultSet", "sql"});
        this.putPropertySortOrder("DECLARE VARIABLE", new String[]{"variable"});
        this.putPropertySortOrder("IF", new String[]{"criteria", "then", "else"});
        this.putPropertySortOrder("RAISE ERROR", new String[]{"message"});
        this.putPropertySortOrder("WHILE", new String[]{"criteria", "program"});
        this.propertyNameMap.put("outputCols", "Output Columns");
        this.propertyNameMap.put("criteria", "Criteria");
        this.propertyNameMap.put("selectCols", "Select Columns");
        this.propertyNameMap.put("groupCols", "Grouping Columns");
        this.propertyNameMap.put("sql", "Source Query");
        this.propertyNameMap.put("modelName", "Model Name");
        this.propertyNameMap.put("joinType", "Join Type");
        this.propertyNameMap.put("joinCriteria", "Join Criteria");
        this.propertyNameMap.put("joinStrategy", "Join Strategy");
        this.propertyNameMap.put("execPlan", "Execution Plan");
        this.propertyNameMap.put("intoGrp", "Select Into Group");
        this.propertyNameMap.put("sortCols", "Sort Columns");
        this.propertyNameMap.put("removeDups", "Remove Duplicates");
        this.propertyNameMap.put("message", "Message");
        this.propertyNameMap.put("tag", "XML Node Name");
        this.propertyNameMap.put("namespace", "Namespace");
        this.propertyNameMap.put("dataCol", "Data Column");
        this.propertyNameMap.put("namespaceDeclarations", "Namespace Declarations");
        this.propertyNameMap.put("optional", "Optional Flag");
        this.propertyNameMap.put("default", "Default Value");
        this.propertyNameMap.put("program", "Sub Program");
        this.propertyNameMap.put("recurseDir", "Recursion Direction");
        this.propertyNameMap.put("resultSet", "Result Set");
        this.propertyNameMap.put("bindings", "Bindings");
        this.propertyNameMap.put("isStaging", "Is Staging Flag");
        this.propertyNameMap.put("inMemory", "Source In Memory Flag");
        this.propertyNameMap.put("conditions", "Conditions");
        this.propertyNameMap.put("programs", "Sub Programs");
        this.propertyNameMap.put("defaultProgram", "Default Programs");
        this.propertyNameMap.put("encoding", "Encoding");
        this.propertyNameMap.put("formatted", "Formatting Flag");
        this.propertyNameMap.put("expression", "Expression");
        this.propertyNameMap.put("variable", "Variable");
        this.propertyNameMap.put("group", "Group");
        this.propertyNameMap.put("then", "Then");
        this.propertyNameMap.put("else", "Else");
        this.propertyNameMap.put("nodeStatistics", "Statistics");
        this.propertyNameMap.put("nodeCostEstimates", "Cost Estimates");
        this.propertyNameMap.put("rowLimit", "Row Limit");
        this.propertyNameMap.put("rowOffset", "Row Offset");
    }

    private void putPropertySortOrder(String type, String[] propOrder) {
        NodeProperty[] nodeProps = new NodeProperty[propOrder.length];
        for (int i = 0; i < propOrder.length; ++i) {
            nodeProps[i] = new NodeProperty(new Integer(i), type, propOrder[i]);
        }
        this.propertyOrderMap.put(type, nodeProps);
    }

    public String getName(PlanNode node) {
        String name = (String)node.getProperties().get("type");
        if (name != null) {
            if (this.nodeNameMap.containsKey(name)) {
                name = (String)this.nodeNameMap.get(name);
            }
        } else {
            name = "Node";
        }
        name = name + this.getDescription(node);
        return name;
    }

    public String getDescription(PlanNode node) {
        Map nodeProps = node.getProperties();
        String description = "";
        String type = (String)nodeProps.get("type");
        if (type != null && ((description = (String)nodeProps.get("desc")) == null || description.equals(""))) {
            description = (String)this.descriptionMap.get(type);
        }
        if (description == null || description.trim().length() == 0) {
            description = "";
        } else if ((description = this.replaceProperties(description.trim(), nodeProps).trim()).length() > 0) {
            description = " [" + description + "]";
        }
        return description;
    }

    private String replaceProperties(String descriptionExpression, Map nodeProps) {
        int startIndex = descriptionExpression.indexOf(36);
        if (startIndex < 0) {
            return descriptionExpression;
        }
        int endIndex = descriptionExpression.indexOf(125);
        if (endIndex < 0) {
            return descriptionExpression;
        }
        String propertyName = descriptionExpression.substring(startIndex + 2, endIndex).trim();
        Object descriptionObject = nodeProps.get(propertyName);
        String replacement = "";
        if (descriptionObject != null) {
            replacement = descriptionObject instanceof Collection ? this.stringifyCollection((Collection)descriptionObject) : descriptionObject.toString();
        }
        descriptionExpression = descriptionExpression.substring(0, startIndex) + replacement + (endIndex < descriptionExpression.length() - 1 ? descriptionExpression.substring(endIndex + 1) : "");
        return this.replaceProperties(descriptionExpression, nodeProps);
    }

    private String stringifyCollection(Collection collection) {
        Iterator iterator = collection.iterator();
        if (iterator.hasNext()) {
            StringBuffer buffer = new StringBuffer(iterator.next().toString());
            while (iterator.hasNext()) {
                buffer.append(", ").append(iterator.next().toString());
            }
            return buffer.toString();
        }
        return "";
    }

    public String getType(PlanNode node) {
        Map nodeProps = node.getProperties();
        String type = (String)nodeProps.get("type");
        if (type == null) {
            type = "";
        }
        if (node.getParent() != null && this.childTypeMap.get(type) != null) {
            return (String)this.childTypeMap.get(type);
        }
        return type;
    }

    public Map getOrderedPropertiesMap(PlanNode node) {
        Object[] nodeTypeKeySetArray = node.getProperties().keySet().toArray();
        Map nodeProperties = node.getProperties();
        String nodeType = (String)node.getProperties().get("type");
        Object[] orderedPropArray = this.propertyOrderMap.keySet().toArray();
        Iterator orderedPropIterator = this.propertyOrderMap.values().iterator();
        TreeMap propertiesOrdered = new TreeMap();
        NodeProperty[] nodeProps = null;
        int count = 0;
        if (nodeType != null) {
            for (int i = 0; i < orderedPropArray.length; ++i) {
                String orderedPropKey = (String)orderedPropArray[i];
                nodeProps = (NodeProperty[])orderedPropIterator.next();
                if (!nodeType.equalsIgnoreCase(orderedPropKey)) continue;
                for (int j = 0; j < nodeProps.length; ++j) {
                    String nodeProp = nodeProps[j].getValue();
                    if (nodeProperties.get(nodeProp) == null) continue;
                    HashMap prop = new HashMap();
                    prop.put(nodeProp, nodeProperties.get(nodeProp));
                    propertiesOrdered.put(new Integer(j), prop);
                    count = j;
                }
            }
            if (propertiesOrdered.size() < node.getProperties().size()) {
                int i;
                ArrayList<Object> addKeys = new ArrayList<Object>();
                for (i = 0; i < node.getProperties().size(); ++i) {
                    Iterator propIter = null;
                    propIter = propertiesOrdered.values().iterator();
                    boolean containsKey = false;
                    for (int k = 0; k < propertiesOrdered.size(); ++k) {
                        Map propEntry = (Map)propIter.next();
                        if (!propEntry.containsKey(nodeTypeKeySetArray[i])) continue;
                        containsKey = true;
                        break;
                    }
                    if (containsKey) continue;
                    addKeys.add(nodeTypeKeySetArray[i]);
                }
                for (i = 0; i < addKeys.size(); ++i) {
                    HashMap prop = new HashMap();
                    prop.put(addKeys.get(i), node.getProperties().get(addKeys.get(i)));
                    propertiesOrdered.put(new Integer(++count), prop);
                }
            }
        }
        return propertiesOrdered;
    }

    public List getOrderedProperties(PlanNode node) {
        Map orderPropMap = this.getOrderedPropertiesMap(node);
        Iterator mapIter = orderPropMap.keySet().iterator();
        ArrayList<String> orderPropList = new ArrayList<String>();
        while (mapIter.hasNext()) {
            Object key = mapIter.next();
            Map valueMap = (Map)orderPropMap.get(key);
            String propName = (String)valueMap.keySet().iterator().next();
            if (propName.equals("type") || propName.equals("desc")) continue;
            orderPropList.add(propName);
        }
        return orderPropList;
    }

    public void setMaxDescriptionLength(int maxLength) {
    }

    public String getProperty(String property) {
        String propertyDisplay = (String)this.propertyNameMap.get(property);
        if (propertyDisplay == null) {
            propertyDisplay = property;
        }
        return propertyDisplay;
    }

    public String getPropertyName(String property) {
        String propertyDisplay = (String)this.propertyNameMap.get(property);
        if (propertyDisplay == null) {
            propertyDisplay = property;
        }
        return propertyDisplay;
    }

    private class NodeProperty {
        Integer seqNo = null;
        String name = "";
        String value = "";

        public NodeProperty(Integer seqNo, String name, String value) {
            this.seqNo = seqNo;
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public Integer getSeqNo() {
            return this.seqNo;
        }

        public String getValue() {
            return this.value;
        }

        public void setName(String string) {
            this.name = string;
        }

        public void setSeqNo(Integer integer) {
            this.seqNo = integer;
        }

        public void setValue(String string) {
            this.value = string;
        }
    }
}

