/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc;

import com.metamatrix.common.aop.AOP;
import com.metamatrix.common.aop.ProxyFactory;
import com.metamatrix.common.comm.api.Message;
import com.metamatrix.common.comm.api.MessageListener;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.types.BlobType;
import com.metamatrix.common.types.ClobType;
import com.metamatrix.common.types.XMLType;
import com.metamatrix.common.util.TimestampWithTimezone;
import com.metamatrix.core.jdbc.SQLXML;
import com.metamatrix.dqp.message.CloseMessage;
import com.metamatrix.dqp.message.CursorRequestMessage;
import com.metamatrix.dqp.message.RequestID;
import com.metamatrix.dqp.message.ResultsMessage;
import com.metamatrix.jdbc.BatchFetcher;
import com.metamatrix.jdbc.BatchResults;
import com.metamatrix.jdbc.DataTypeTransformer;
import com.metamatrix.jdbc.JDBCPlugin;
import com.metamatrix.jdbc.MMBlob;
import com.metamatrix.jdbc.MMClob;
import com.metamatrix.jdbc.MMSQLException;
import com.metamatrix.jdbc.MMSQLXML;
import com.metamatrix.jdbc.MMStatement;
import com.metamatrix.jdbc.ResultsImpl;
import com.metamatrix.jdbc.api.ResultSetMetaData;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

public class CursorResultsImpl
extends ResultsImpl
implements BatchFetcher {
    private int cursorType;
    private RequestID requestID = null;
    private String msgKey = null;
    private BatchResults batchResults;
    private int columnCount;
    private ResultsMessage currentResultMsg;
    private TimeZone serverTimeZone;
    static /* synthetic */ Class class$com$metamatrix$jdbc$CursorResultsImpl;
    static /* synthetic */ Class class$com$metamatrix$dqp$message$ResultsMessage;
    static /* synthetic */ Class class$com$metamatrix$jdbc$MMStatement;
    static /* synthetic */ Class class$com$metamatrix$jdbc$api$ResultSetMetaData;

    static CursorResultsImpl newInstance(ResultsMessage resultsMsg, MMStatement statement) {
        if (AOP.useproxy()) {
            return (CursorResultsImpl)ProxyFactory.extend(class$com$metamatrix$jdbc$CursorResultsImpl == null ? (class$com$metamatrix$jdbc$CursorResultsImpl = CursorResultsImpl.class$("com.metamatrix.jdbc.CursorResultsImpl")) : class$com$metamatrix$jdbc$CursorResultsImpl, new Class[]{class$com$metamatrix$dqp$message$ResultsMessage == null ? (class$com$metamatrix$dqp$message$ResultsMessage = CursorResultsImpl.class$("com.metamatrix.dqp.message.ResultsMessage")) : class$com$metamatrix$dqp$message$ResultsMessage, class$com$metamatrix$jdbc$MMStatement == null ? (class$com$metamatrix$jdbc$MMStatement = CursorResultsImpl.class$("com.metamatrix.jdbc.MMStatement")) : class$com$metamatrix$jdbc$MMStatement}, new Object[]{resultsMsg, statement});
        }
        return new CursorResultsImpl(resultsMsg, statement);
    }

    static CursorResultsImpl newInstance(ResultsMessage resultsMsg, MMStatement statement, ResultSetMetaData rsmd) {
        if (AOP.useproxy()) {
            CursorResultsImpl obj = (CursorResultsImpl)ProxyFactory.extend(class$com$metamatrix$jdbc$CursorResultsImpl == null ? (class$com$metamatrix$jdbc$CursorResultsImpl = CursorResultsImpl.class$("com.metamatrix.jdbc.CursorResultsImpl")) : class$com$metamatrix$jdbc$CursorResultsImpl, new Class[]{class$com$metamatrix$dqp$message$ResultsMessage == null ? (class$com$metamatrix$dqp$message$ResultsMessage = CursorResultsImpl.class$("com.metamatrix.dqp.message.ResultsMessage")) : class$com$metamatrix$dqp$message$ResultsMessage, class$com$metamatrix$jdbc$MMStatement == null ? (class$com$metamatrix$jdbc$MMStatement = CursorResultsImpl.class$("com.metamatrix.jdbc.MMStatement")) : class$com$metamatrix$jdbc$MMStatement, class$com$metamatrix$jdbc$api$ResultSetMetaData == null ? (class$com$metamatrix$jdbc$api$ResultSetMetaData = CursorResultsImpl.class$("com.metamatrix.jdbc.api.ResultSetMetaData")) : class$com$metamatrix$jdbc$api$ResultSetMetaData}, new Object[]{resultsMsg, statement, rsmd});
            return obj;
        }
        return new CursorResultsImpl(resultsMsg, statement, rsmd);
    }

    CursorResultsImpl(ResultsMessage resultsMsg, MMStatement statement) {
        this(resultsMsg, statement, null);
    }

    CursorResultsImpl(ResultsMessage resultsMsg, MMStatement statement, ResultSetMetaData rsmd) {
        super(resultsMsg, statement, rsmd);
        this.cursorType = statement.getResultSetType();
        this.requestID = resultsMsg.getRequestID();
        this.msgKey = resultsMsg.getMessageKey();
        try {
            this.columnCount = this.getMetaData().getColumnCount();
            this.setResultsData(resultsMsg);
            this.batchResults.setBatchFetcher(this);
            TimeZone timezone = statement.driverConnection.getConnection().getTimeZone();
            if (timezone != null && !timezone.getID().equals(TimestampWithTimezone.DEFAULT_TIME_ZONE.getID()) && !timezone.equals(TimestampWithTimezone.DEFAULT_TIME_ZONE)) {
                this.setServerTimeZone(timezone);
            }
        }
        catch (SQLException e) {
            // empty catch block
        }
    }

    private void setResultsData(ResultsMessage resultsMsg) {
        if (LogManager.isMessageToBeRecorded("DQP", 5)) {
            LogManager.logDetail("DQP", "CursorResultsImpl.setResultsData] thread name: " + Thread.currentThread().getName() + " resultsMsg: " + resultsMsg);
        }
        if (resultsMsg.getException() != null) {
            this.setException(resultsMsg.getException());
            this.batchResults.setException(MMSQLException.create(resultsMsg.getException()));
            return;
        }
        List[] firstBatch = resultsMsg.getResults();
        if (resultsMsg.getFinalRow() >= 0) {
            this.finalRow = resultsMsg.getFinalRow();
        }
        boolean isLast = false;
        if (firstBatch.length == 0 || resultsMsg.getFinalRow() == resultsMsg.getLastRow()) {
            isLast = true;
        }
        if (this.batchResults == null) {
            this.batchResults = BatchResults.newInstance(firstBatch, resultsMsg.getFirstRow(), resultsMsg.getLastRow(), isLast, resultsMsg.getFetchSize());
            this.batchResults.setLogger(this.getLogger());
        } else {
            this.batchResults.setBatch(resultsMsg.getFirstRow(), resultsMsg.getLastRow(), firstBatch, isLast);
        }
    }

    public void close() throws SQLException {
        if (!this.isClosed) {
            if (this.requestID != null && !this.statement.isClosed()) {
                CloseMessage closeMsg = new CloseMessage();
                closeMsg.setRequestID(this.requestID);
                this.statement.executeAsynch(closeMsg, false);
            }
            this.isClosed = true;
        }
    }

    public int getFetchSize() throws SQLException {
        return this.batchResults.getFetchSize();
    }

    public boolean isFirst() throws SQLException {
        this.check("isFirst");
        return this.batchResults.isFirst();
    }

    private void check(String methodName) throws MMSQLException, SQLException {
        if (this.getException() != null) {
            throw new MMSQLException(JDBCPlugin.Util.getString("ResultsImpl.Cant_check_method", new Object[]{methodName}));
        }
        this.checkClosed();
    }

    public boolean hasNext() throws SQLException {
        this.check("hasNext");
        return this.batchResults.hasNext();
    }

    public boolean isLast() throws SQLException {
        this.check("isLast");
        return this.batchResults.isLast();
    }

    public boolean next() throws SQLException {
        this.check("next");
        return this.batchResults.next();
    }

    public boolean hasPrevious() throws SQLException {
        this.check("hasPrevious");
        if (this.cursorType != 1004) {
            throw new MMSQLException(JDBCPlugin.Util.getString("CursorResultsImpl.Moving_back_on_fwd_only"));
        }
        return this.batchResults.hasPrevious();
    }

    public boolean previous() throws SQLException {
        this.check("previous");
        if (this.cursorType != 1004) {
            throw new MMSQLException(JDBCPlugin.Util.getString("CursorResultsImpl.Moving_back_on_fwd_only"));
        }
        return this.batchResults.previous();
    }

    public int getRow() throws SQLException {
        this.check("getRow");
        return this.batchResults.getCurrentRowNumber();
    }

    public Object getObject(int column) throws SQLException {
        return this.getObject(column, true);
    }

    private Object getObject(int column, boolean convertClobToString) throws SQLException {
        if (column < 1 || column > this.columnCount) {
            throw new IllegalArgumentException(JDBCPlugin.Util.getString("ResultsImpl.Invalid_col_index", column));
        }
        List cursorRow = this.batchResults.getCurrentRow();
        if (cursorRow == null) {
            throw new MMSQLException(JDBCPlugin.Util.getString("ResultsImpl.The_cursor_is_not_on_a_valid_row._1"));
        }
        this.currentValue = cursorRow.get(column - 1);
        if (this.currentValue != null && this.currentValue instanceof ClobType) {
            this.currentValue = MMClob.newInstance((MMStatement)this.getStatement(), (ClobType)this.currentValue);
        } else if (this.currentValue != null && this.currentValue instanceof BlobType) {
            this.currentValue = MMBlob.newInstance((MMStatement)this.getStatement(), (BlobType)this.currentValue);
        } else if (this.currentValue != null && this.currentValue instanceof XMLType) {
            this.currentValue = MMSQLXML.newInstance((MMStatement)this.getStatement(), (XMLType)this.currentValue);
        }
        if (this.serverTimeZone != null && this.currentValue instanceof Date) {
            return TimestampWithTimezone.create((Date)this.currentValue, this.serverTimeZone, this.getDefaultCalendar(), this.currentValue.getClass());
        }
        return this.currentValue;
    }

    public Object getObject(String columnName) throws SQLException {
        this.check("getObject");
        int index = this.findColumnIndex(columnName);
        return this.getObject(index);
    }

    public Clob getClob(int columnIndex) throws SQLException {
        this.currentValue = this.getObject(columnIndex, false);
        if (this.currentValue == null) {
            return null;
        }
        return DataTypeTransformer.getClob(this.currentValue);
    }

    public Clob getClob(String columnName) throws SQLException {
        return this.getClob(this.findColumn(columnName));
    }

    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        this.currentValue = this.getObject(columnIndex, false);
        if (this.currentValue == null) {
            return null;
        }
        return DataTypeTransformer.getSQLXML(this.currentValue);
    }

    public SQLXML getSQLXML(String columnName) throws SQLException {
        return this.getSQLXML(this.findColumn(columnName));
    }

    public List getCurrentRecord() throws SQLException {
        this.check("getCurrentRecord");
        return this.batchResults.getCurrentRow();
    }

    public int getType() throws SQLException {
        return this.cursorType;
    }

    public boolean absolute(int row) throws SQLException {
        this.check("absolute");
        if (this.getType() == 1003) {
            String msg = JDBCPlugin.Util.getString("ResultsImpl.Fwd_only");
            throw new MMSQLException(msg);
        }
        return this.batchResults.absolute(row);
    }

    protected Map getUpdatedPlanDescription() {
        if (this.currentResultMsg != null) {
            return this.currentResultMsg.getPlanDescription();
        }
        return null;
    }

    public void requestBatch(int beginRow, int endRow) throws SQLException {
        if (LogManager.isMessageToBeRecorded("DQP", 5)) {
            LogManager.logDetail("DQP", "CursorResultsImpl.requestBatch] thread name: " + Thread.currentThread().getName() + " requestID: " + this.requestID + " beginRow: " + beginRow + " endinRow: " + endRow);
        }
        try {
            CursorRequestMessage requestMsg = new CursorRequestMessage();
            requestMsg.setBatchFirst(beginRow);
            requestMsg.setBatchLast(endRow);
            requestMsg.setRequestID(this.requestID);
            requestMsg.setMessageKey(this.msgKey);
            MessageListener listener = new MessageListener(){

                public void deliverMessage(Message msg, String messageKey) {
                    CursorResultsImpl.this.currentResultMsg = (ResultsMessage)msg;
                    CursorResultsImpl.this.setResultsData(CursorResultsImpl.this.currentResultMsg);
                }
            };
            this.statement.executeAsynch(requestMsg, listener, false);
        }
        catch (Throwable ex) {
            this.isClosed = true;
            throw MMSQLException.create(ex);
        }
    }

    public void beforeFirst() throws SQLException {
        this.check("beforeFirst");
        if (this.getType() == 1003) {
            String msg = JDBCPlugin.Util.getString("ResultsImpl.Fwd_only");
            throw new MMSQLException(msg);
        }
        if (this.absolute(1)) {
            this.previous();
        }
    }

    void setServerTimeZone(TimeZone serverTimeZone) {
        this.serverTimeZone = serverTimeZone;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

