/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.client.impl;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.MetaMatrixProcessingException;
import com.metamatrix.common.comm.api.ServerConnection;
import com.metamatrix.common.comm.api.ServerConnectionFactory;
import com.metamatrix.common.comm.api.ServerInstance;
import com.metamatrix.common.comm.exception.CommunicationException;
import com.metamatrix.common.comm.exception.ConnectionException;
import com.metamatrix.common.util.SqlUtil;
import com.metamatrix.core.MetaMatrixCoreException;
import com.metamatrix.dqp.DQPPlugin;
import com.metamatrix.dqp.client.ConnectionInfo;
import com.metamatrix.dqp.client.PortableContext;
import com.metamatrix.dqp.client.RequestInfo;
import com.metamatrix.dqp.client.Results;
import com.metamatrix.dqp.client.ResultsMetadata;
import com.metamatrix.dqp.client.ServerFacade;
import com.metamatrix.dqp.client.impl.RequestContext;
import com.metamatrix.dqp.client.impl.ResponseReceiver;
import com.metamatrix.dqp.client.impl.ResultBatch;
import com.metamatrix.dqp.client.impl.ResultsMetadataImpl;
import com.metamatrix.dqp.client.impl.ServerConnectionInfo;
import com.metamatrix.dqp.client.impl.ServerRequest;
import com.metamatrix.dqp.client.impl.ServerSessionContext;
import com.metamatrix.dqp.message.CancelMessage;
import com.metamatrix.dqp.message.CloseMessage;
import com.metamatrix.dqp.message.CursorRequestMessage;
import com.metamatrix.dqp.message.MetaDataMessage;
import com.metamatrix.dqp.message.RequestID;
import com.metamatrix.dqp.message.RequestMessage;
import com.metamatrix.dqp.message.ResultsMessage;
import com.metamatrix.query.sql.lang.Command;
import com.metamatrix.query.sql.lang.SQLQuery;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class ServerFacadeImpl
implements ServerFacade {
    private long requestIDGenerator;
    private ServerConnectionFactory connectionFactory;
    private Map connections = new HashMap(10, 0.8f);
    private Object connectionLock = new Object();

    public ServerFacadeImpl(ServerConnectionFactory connFactory) {
        this.connectionFactory = connFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PortableContext createSession(ConnectionInfo connectionInfo) throws MetaMatrixComponentException, MetaMatrixProcessingException {
        ServerConnectionInfo connInfo = this.validateConnectionInfo(connectionInfo);
        try {
            ServerConnection conn = this.connectionFactory.establishConnection(null, connInfo.getConnectionProperties());
            ServerSessionContext context = new ServerSessionContext(connInfo, conn.getContext().getPortableString());
            Map map = this.connections;
            synchronized (map) {
                this.connections.put(context, new ConnectionHolder(conn));
            }
            return context;
        }
        catch (MetaMatrixCoreException e) {
            throw new MetaMatrixComponentException((Throwable)e);
        }
    }

    public PortableContext executeRequest(PortableContext connectionContext, RequestInfo requestInfo) throws MetaMatrixComponentException, MetaMatrixProcessingException {
        ServerSessionContext context = ServerSessionContext.createSessionContextFromPortableContext(connectionContext);
        ServerRequest request = this.validateRequestInfo(requestInfo);
        RequestID requestID = new RequestID(this.nextRequestID());
        ResponseReceiver receiver = new ResponseReceiver();
        try {
            ConnectionHolder holder = this.getConnection(context);
            RequestMessage message = this.createRequestMessage(context, request, requestID);
            holder.connection.send(message, receiver, Long.toString(requestID.getExecutionID()), holder.instance);
        }
        catch (MetaMatrixCoreException e) {
            throw new MetaMatrixComponentException((Throwable)e);
        }
        ResultsMessage response = ResponseReceiver.waitForResponseMessage(receiver, 0L);
        if (response != null && response.getException() != null) {
            throw new MetaMatrixComponentException((Throwable)response.getException());
        }
        return new RequestContext(requestID, SqlUtil.isUpdateSql(request.getSql()));
    }

    public Results getBatch(PortableContext connectionContext, PortableContext requestContext, int beginRow, int maxEndRow, int waitTime) throws MetaMatrixComponentException, MetaMatrixProcessingException {
        if (beginRow <= 0) {
            throw new MetaMatrixProcessingException(DQPPlugin.Util.getString("ServerFacadeImpl.invalid_beginRow", beginRow));
        }
        if (maxEndRow < beginRow) {
            throw new MetaMatrixProcessingException(DQPPlugin.Util.getString("ServerFacadeImpl.invalid_endRow", maxEndRow));
        }
        if (waitTime < 0) {
            throw new MetaMatrixProcessingException(DQPPlugin.Util.getString("ServerFacadeImpl.invalid_waitTime", waitTime));
        }
        ServerSessionContext context = ServerSessionContext.createSessionContextFromPortableContext(connectionContext);
        RequestContext reqContext = RequestContext.createRequestContextFromPortableContext(requestContext);
        ResponseReceiver receiver = new ResponseReceiver();
        ConnectionHolder holder = null;
        try {
            holder = this.getConnection(context);
            CursorRequestMessage message = this.createCursorRequestMessage(context, reqContext, beginRow, maxEndRow);
            holder.connection.send(message, receiver, Long.toString(reqContext.getRequestID().getExecutionID()), holder.instance);
        }
        catch (MetaMatrixCoreException e) {
            throw new MetaMatrixComponentException((Throwable)e);
        }
        ResultsMessage results = ResponseReceiver.waitForResponseMessage(receiver, waitTime);
        if (results != null) {
            return new ResultBatch(results, reqContext.isUpdate(), reqContext.getRequestID().getExecutionID(), holder);
        }
        return null;
    }

    public ResultsMetadata getMetadata(PortableContext connectionContext, PortableContext requestContext) throws MetaMatrixComponentException, MetaMatrixProcessingException {
        ServerSessionContext context = ServerSessionContext.createSessionContextFromPortableContext(connectionContext);
        RequestContext reqContext = RequestContext.createRequestContextFromPortableContext(requestContext);
        if (reqContext.isUpdate()) {
            throw new MetaMatrixProcessingException(DQPPlugin.Util.getString("ServerFacadeImpl.updates_not_supported"));
        }
        MetaDataMessage metadataResults = null;
        try {
            ConnectionHolder holder = this.getConnection(context);
            MetaDataMessage message = new MetaDataMessage();
            message.setRequestID(reqContext.getRequestID());
            metadataResults = (MetaDataMessage)holder.connection.send(message, holder.instance);
        }
        catch (MetaMatrixCoreException e) {
            throw new MetaMatrixComponentException((Throwable)e);
        }
        if (metadataResults != null && metadataResults.getException() != null) {
            throw new MetaMatrixComponentException(metadataResults.getException());
        }
        return new ResultsMetadataImpl(metadataResults);
    }

    public void cancelRequest(PortableContext connectionContext, PortableContext requestContext) throws MetaMatrixComponentException, MetaMatrixProcessingException {
        ServerSessionContext context = ServerSessionContext.createSessionContextFromPortableContext(connectionContext);
        RequestContext reqContext = RequestContext.createRequestContextFromPortableContext(requestContext);
        try {
            ConnectionHolder holder = this.getConnection(context);
            CancelMessage cancelMessage = new CancelMessage();
            cancelMessage.setRequestID(reqContext.getRequestID());
            holder.connection.send(cancelMessage, holder.instance);
        }
        catch (MetaMatrixCoreException e) {
            throw new MetaMatrixComponentException((Throwable)e);
        }
    }

    public void closeRequest(PortableContext connectionContext, PortableContext requestContext) throws MetaMatrixComponentException, MetaMatrixProcessingException {
        ServerSessionContext context = ServerSessionContext.createSessionContextFromPortableContext(connectionContext);
        RequestContext reqContext = RequestContext.createRequestContextFromPortableContext(requestContext);
        try {
            ConnectionHolder holder = this.getConnection(context);
            CloseMessage closeMessage = new CloseMessage();
            closeMessage.setRequestID(reqContext.getRequestID());
            holder.connection.send(closeMessage, holder.instance);
        }
        catch (MetaMatrixCoreException e) {
            throw new MetaMatrixComponentException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeSession(PortableContext connectionContext) throws MetaMatrixComponentException, MetaMatrixProcessingException {
        ServerSessionContext context = ServerSessionContext.createSessionContextFromPortableContext(connectionContext);
        try {
            ConnectionHolder holder = this.getConnection(context);
            Map map = this.connections;
            synchronized (map) {
                this.connections.remove(context);
            }
            holder.connection.shutdown();
        }
        catch (MetaMatrixCoreException e) {
            throw new MetaMatrixComponentException((Throwable)e);
        }
    }

    private ServerConnectionInfo validateConnectionInfo(ConnectionInfo connectionInfo) throws MetaMatrixProcessingException {
        if (connectionInfo == null) {
            throw new MetaMatrixProcessingException(DQPPlugin.Util.getString("ServerFacadeImpl.null_connInfo"));
        }
        if (!(connectionInfo instanceof ServerConnectionInfo)) {
            throw new MetaMatrixProcessingException(DQPPlugin.Util.getString("ServerFacadeImpl.invalid_connInfo"));
        }
        ServerConnectionInfo info = (ServerConnectionInfo)connectionInfo;
        if (info.getServerUrl() == null || info.getServerUrl().length() == 0) {
            throw new MetaMatrixProcessingException(DQPPlugin.Util.getString("ServerFacadeImpl.null_URL"));
        }
        if (info.getUser() == null || info.getUser().length() == 0) {
            throw new MetaMatrixProcessingException(DQPPlugin.Util.getString("ServerFacadeImpl.null_user"));
        }
        if (info.getPassword() == null || info.getPassword().length() == 0) {
            throw new MetaMatrixProcessingException(DQPPlugin.Util.getString("ServerFacadeImpl.null_pwd"));
        }
        if (info.getVDBName() == null || info.getVDBName().length() == 0) {
            throw new MetaMatrixProcessingException(DQPPlugin.Util.getString("ServerFacadeImpl.null_vdb"));
        }
        return info;
    }

    private ServerRequest validateRequestInfo(RequestInfo requestInfo) throws MetaMatrixProcessingException {
        if (requestInfo == null) {
            throw new MetaMatrixProcessingException(DQPPlugin.Util.getString("ServerFacadeImpl.null_requestInfo"));
        }
        if (!(requestInfo instanceof ServerRequest)) {
            throw new MetaMatrixProcessingException(DQPPlugin.Util.getString("ServerFacadeImpl.invalid_requestInfo"));
        }
        ServerRequest request = (ServerRequest)requestInfo;
        if (request.getCursorType() != 1003 && request.getCursorType() != 1004) {
            throw new MetaMatrixProcessingException(DQPPlugin.Util.getString("ServerFacadeImpl.invalid_cursorType"));
        }
        if (request.getFetchSize() <= 0) {
            throw new MetaMatrixProcessingException(DQPPlugin.Util.getString("ServerFacadeImpl.invalid_fetchSize"));
        }
        if (request.getRequestType() != 0 && request.getRequestType() != 1 && request.getRequestType() != 2) {
            throw new MetaMatrixProcessingException(DQPPlugin.Util.getString("ServerFacadeImpl.invalid_requestType"));
        }
        if (request.getSql() == null || request.getSql().length() == 0) {
            throw new MetaMatrixProcessingException(DQPPlugin.Util.getString("ServerFacadeImpl.invalid_sql"));
        }
        if (request.getTransactionAutoWrapMode() != 0 && request.getTransactionAutoWrapMode() != 1 && request.getTransactionAutoWrapMode() != 2 && request.getTransactionAutoWrapMode() != 3) {
            throw new MetaMatrixProcessingException(DQPPlugin.Util.getString("ServerFacadeImpl.invalid_txnAutowrap"));
        }
        return request;
    }

    private RequestMessage createRequestMessage(ServerSessionContext context, ServerRequest info, RequestID requestID) throws MetaMatrixProcessingException {
        Object[] params;
        SQLQuery command = new SQLQuery(info.getSql());
        RequestMessage request = new RequestMessage(command);
        request.markSubmissionStart();
        request.setOriginalCommand((Command)((Command)command).clone());
        request.setUserName(context.getUserName());
        request.setExecutionPayload(info.getCommandPayload());
        request.setQueryPlanAllowed(false);
        if (info.getRequestType() == 1) {
            request.setPreparedStatement(true);
            params = info.getBindParameters();
            if (params != null) {
                request.setParameterValues(Arrays.asList(params));
            }
        } else if (info.getRequestType() == 2) {
            request.setCallableStatement(true);
            params = info.getBindParameters();
            if (params != null) {
                request.setParameterValues(Arrays.asList(params));
            }
        }
        request.setRequestID(requestID);
        request.setFetchSize(info.getFetchSize());
        request.setStyleSheet(info.getXMLStyleSheet());
        request.setPartialResults(info.getPartialResults());
        request.setFetchSize(info.getFetchSize());
        request.setCursorType(info.getCursorType());
        request.setValidationMode(info.getXMLValidationMode());
        request.setXMLFormat(info.getXMLFormat());
        int transactionAutowrap = info.getTransactionAutoWrapMode();
        String autowrap = null;
        switch (transactionAutowrap) {
            case 0: {
                autowrap = "OFF";
                break;
            }
            case 1: {
                autowrap = "ON";
                break;
            }
            case 2: {
                autowrap = "OPTIMISTIC";
                break;
            }
            case 3: {
                autowrap = "PESSIMISTIC";
                break;
            }
            default: {
                throw new MetaMatrixProcessingException(DQPPlugin.Util.getString("ServerFacadeImpl.invalid_txnautowrap", transactionAutowrap));
            }
        }
        request.setTxnAutoWrapMode(autowrap);
        request.setUseResultSetCache(info.getUseResultSetCache());
        request.setSynchronousRequest(true);
        return request;
    }

    private CursorRequestMessage createCursorRequestMessage(ServerSessionContext sessionContext, RequestContext requestContext, int startRow, int endRow) {
        CursorRequestMessage request = new CursorRequestMessage();
        request.setBatchFirst(startRow);
        request.setBatchLast(endRow);
        request.setRequestID(requestContext.getRequestID());
        return request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConnectionHolder getConnection(ServerSessionContext context) throws CommunicationException, ConnectionException {
        ConnectionHolder holder = null;
        Object object = this.connectionLock;
        synchronized (object) {
            Map map = this.connections;
            synchronized (map) {
                if (this.connections.containsKey(context)) {
                    holder = (ConnectionHolder)this.connections.get(context);
                }
            }
            if (holder == null) {
                ServerConnection conn = this.connectionFactory.reestablishConnection(context.getConnectionContext(), context.getConnectionProperties());
                holder = new ConnectionHolder(conn);
                Map map2 = this.connections;
                synchronized (map2) {
                    this.connections.put(context, holder);
                }
            }
        }
        if (holder.instance == null) {
            if (context.getInstanceContext() == null) {
                holder.instance = holder.connection.selectServerInstance(null);
                context.setInstanceContext(holder.instance.getContext().getPortableString());
            } else {
                holder.instance = holder.connection.reselectServerInstance(context.getInstanceContext());
            }
        }
        return holder;
    }

    private synchronized long nextRequestID() {
        return this.requestIDGenerator++;
    }

    static final class ConnectionHolder {
        private ServerConnection connection;
        private ServerInstance instance;

        private ConnectionHolder(ServerConnection connection) {
            this.connection = connection;
        }

        ServerConnection getConnection() {
            return this.connection;
        }

        ServerInstance getInstance() {
            return this.instance;
        }
    }
}

