/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.sql.visitor;

import com.metamatrix.query.QueryPlugin;
import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.LanguageVisitor;
import com.metamatrix.query.sql.navigator.PreOrderNavigator;
import com.metamatrix.query.sql.symbol.AllInGroupSymbol;
import com.metamatrix.query.sql.symbol.AllSymbol;
import com.metamatrix.query.sql.symbol.ElementSymbol;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;

public class GroupsUsedByElementsVisitor
extends LanguageVisitor {
    private Collection groups;

    public GroupsUsedByElementsVisitor() {
        this.groups = new HashSet();
    }

    public GroupsUsedByElementsVisitor(Collection groups) {
        if (groups == null) {
            throw new IllegalArgumentException(QueryPlugin.Util.getString("ERR.015.010.0023"));
        }
        this.groups = groups;
    }

    public Collection getGroups() {
        return this.groups;
    }

    public void visit(ElementSymbol obj) {
        this.groups.add(obj.getGroupSymbol());
    }

    public void visit(AllInGroupSymbol obj) {
        if (obj.getElementSymbols() != null) {
            Iterator elementIter = obj.getElementSymbols().iterator();
            while (elementIter.hasNext()) {
                ElementSymbol es = (ElementSymbol)elementIter.next();
                this.groups.add(es.getGroupSymbol());
            }
        }
    }

    public void visit(AllSymbol obj) {
        if (obj.getElementSymbols() != null) {
            Iterator elementIter = obj.getElementSymbols().iterator();
            while (elementIter.hasNext()) {
                ElementSymbol es = (ElementSymbol)elementIter.next();
                this.groups.add(es.getGroupSymbol());
            }
        }
    }

    public static final void getGroups(LanguageObject obj, Collection groups) {
        GroupsUsedByElementsVisitor visitor = new GroupsUsedByElementsVisitor(groups);
        PreOrderNavigator.doVisit(obj, visitor);
    }

    public static final Collection getGroups(LanguageObject obj) {
        GroupsUsedByElementsVisitor visitor = new GroupsUsedByElementsVisitor();
        PreOrderNavigator.doVisit(obj, visitor);
        return visitor.getGroups();
    }
}

