/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.sql.lang;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.QueryMetadataException;
import com.metamatrix.core.util.EquivalenceUtil;
import com.metamatrix.core.util.HashCodeUtil;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.sql.LanguageVisitor;
import com.metamatrix.query.sql.lang.Command;
import com.metamatrix.query.sql.symbol.ElementSymbol;
import com.metamatrix.query.sql.symbol.Expression;
import com.metamatrix.query.sql.symbol.GroupSymbol;
import com.metamatrix.query.sql.visitor.SQLStringVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class Insert
extends Command {
    private GroupSymbol group;
    private List variables;
    private List values;

    public Insert() {
        this.values = new ArrayList();
    }

    public int getType() {
        return 2;
    }

    public Insert(GroupSymbol group, List variables, List values) {
        this.group = group;
        this.variables = variables;
        this.values = values;
    }

    public GroupSymbol getGroup() {
        return this.group;
    }

    public void setGroup(GroupSymbol group) {
        this.group = group;
    }

    public List getVariables() {
        return this.variables;
    }

    public void addVariable(ElementSymbol var) {
        if (this.variables == null) {
            this.variables = new ArrayList();
        }
        this.variables.add(var);
    }

    public void addVariables(Collection vars) {
        if (this.variables == null) {
            this.variables = new ArrayList();
        }
        this.variables.addAll(vars);
    }

    public List getValues() {
        return this.values;
    }

    public void setValues(List values) {
        this.values.clear();
        this.values.addAll(values);
    }

    public void setVariables(Collection vars) {
        if (this.variables == null) {
            this.variables = new ArrayList(vars.size());
        } else {
            this.variables.clear();
        }
        this.variables.addAll(vars);
    }

    public void addValue(Expression value) {
        this.values.add(value);
    }

    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    public int hashCode() {
        int myHash = 0;
        myHash = HashCodeUtil.hashCode(myHash, this.group);
        if (this.variables != null) {
            myHash = HashCodeUtil.hashCode(myHash, this.variables);
        }
        return myHash;
    }

    public String toString() {
        return SQLStringVisitor.getSQLString(this);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        Insert other = (Insert)obj;
        return EquivalenceUtil.areEqual(this.getGroup(), other.getGroup()) && EquivalenceUtil.areEqual(this.getValues(), other.getValues()) && EquivalenceUtil.areEqual(this.getVariables(), other.getVariables());
    }

    public Object clone() {
        GroupSymbol copyGroup = null;
        if (this.group != null) {
            copyGroup = (GroupSymbol)this.group.clone();
        }
        ArrayList<Object> copyVars = null;
        if (this.getVariables() != null) {
            copyVars = new ArrayList<Object>(this.getVariables().size());
            Iterator iter = this.getVariables().iterator();
            while (iter.hasNext()) {
                ElementSymbol element = (ElementSymbol)iter.next();
                copyVars.add(element.clone());
            }
        }
        ArrayList<Object> copyVals = null;
        if (this.getValues() != null) {
            copyVals = new ArrayList<Object>(this.getValues().size());
            Iterator iter = this.getValues().iterator();
            while (iter.hasNext()) {
                Expression expression = (Expression)iter.next();
                copyVals.add(expression.clone());
            }
        }
        Insert copy = new Insert(copyGroup, copyVars, copyVals);
        copy.setIsResolved(this.isResolved());
        return copy;
    }

    public List getProjectedSymbols() {
        return Command.getUpdateCommandSymbol();
    }

    public boolean areResultsCachable() {
        return false;
    }

    public int updatingModelCount(QueryMetadataInterface metadata) throws MetaMatrixComponentException {
        if (this.group.isTempGroupSymbol()) {
            return 0;
        }
        int updateModelCount = 1;
        try {
            if (metadata.isVirtualGroup(this.group.getMetadataID())) {
                updateModelCount = 0;
            }
        }
        catch (QueryMetadataException e) {
            throw new MetaMatrixComponentException((Throwable)e);
        }
        return updateModelCount + this.getSubCommandsUpdatingModelCount(metadata);
    }
}

