/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.core.id;

import com.metamatrix.core.CorePlugin;
import com.metamatrix.core.id.InvalidIDException;
import com.metamatrix.core.id.ObjectID;
import com.metamatrix.core.id.ObjectIDFactory;
import com.metamatrix.core.id.ParsedObjectID;
import com.metamatrix.core.id.StringID;

public class StringIDFactory
implements ObjectIDFactory {
    private long lastID = 0L;

    public String getDescription() {
        return CorePlugin.Util.getString("StringIDFactory.Description");
    }

    protected long getNextValue() {
        return ++this.lastID;
    }

    public ObjectID create() {
        return new StringID(this.getNextValue());
    }

    public boolean validate(ObjectID id) {
        return id instanceof StringID;
    }

    public ObjectID stringWithoutProtocolToObject(String value) throws InvalidIDException {
        try {
            return new StringID(value);
        }
        catch (NumberFormatException e) {
            throw new InvalidIDException(CorePlugin.Util.getString("StringIDFactory.The_specified_ID_value_is_invalid", value, this.getProtocol()));
        }
    }

    public ObjectID stringToObject(String value) throws InvalidIDException {
        ParsedObjectID parsedID = ParsedObjectID.parsedStringifiedObjectID(value, "mmlong");
        try {
            return new StringID(parsedID.getRemainder());
        }
        catch (NumberFormatException e) {
            throw new InvalidIDException(CorePlugin.Util.getString("StringIDFactory.The_specified_ID_value_is_invalid", value, this.getProtocol()));
        }
    }

    public String getProtocol() {
        return "strid";
    }
}

