/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.xa.atomikos;

import com.atomikos.icatch.Propagation;
import com.metamatrix.common.xa.TransactionContext;
import com.metamatrix.common.xa.TransactionID;
import com.metamatrix.common.xa.TransactionResult;
import com.metamatrix.common.xa.atomikos.TransactionResultImpl;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.transaction.xa.XAResource;

public class TransactionContextImpl
implements TransactionContext,
Serializable {
    private TransactionID topLevelTxnID;
    private String exportingVMID;
    private Map importedVMID_to_TID;
    private Map resource_to_TID = new HashMap();
    private Propagation propagation;
    private TransactionResultImpl transactionResult;

    public TransactionContextImpl(TransactionID topLevelID) {
        this.topLevelTxnID = topLevelID;
    }

    public TransactionID getTopLevelTxnID() {
        return this.topLevelTxnID;
    }

    public boolean hasTransaction() {
        return this.topLevelTxnID != null;
    }

    public boolean hasPropagation() {
        return this.propagation != null;
    }

    public TransactionResult getTransactionResult() {
        return this.transactionResult;
    }

    void setPropagation(Propagation propagation) {
        this.propagation = propagation;
    }

    Propagation getPropagation() {
        return this.propagation;
    }

    void setTransactionResult(TransactionResultImpl transactionResult) {
        this.transactionResult = transactionResult;
    }

    public boolean hasResult() {
        return this.transactionResult != null && this.transactionResult.getExtent() != null;
    }

    public TransactionContext prepareForClientShipment() {
        TransactionContextImpl tc = new TransactionContextImpl(this.topLevelTxnID);
        if (this.transactionResult != null) {
            this.transactionResult.removeExtent();
        }
        return tc;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TransactionContextImpl)) {
            return false;
        }
        TransactionContextImpl transactionContext = (TransactionContextImpl)o;
        return !(this.topLevelTxnID != null ? !this.topLevelTxnID.equals(transactionContext.topLevelTxnID) : transactionContext.topLevelTxnID != null);
    }

    public int hashCode() {
        return this.topLevelTxnID != null ? this.topLevelTxnID.hashCode() : 0;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        buff.append(" Top-level_txnID: [" + this.topLevelTxnID);
        buff.append("] Exporting_VMID: [" + this.exportingVMID);
        buff.append("] Sub-Txn_IDs: [" + this.resource_to_TID);
        buff.append("] Propagation: [" + this.propagation);
        buff.append("] Imported_VMID -> TID: [" + this.importedVMID_to_TID);
        buff.append("] Extent: [" + this.transactionResult);
        buff.append(']');
        return buff.toString();
    }

    protected String getExportingVmID() {
        return this.exportingVMID;
    }

    protected void setExportingVmID(String id) {
        this.exportingVMID = id;
    }

    protected synchronized void setVMTxnID(String vmid, String id) {
        if (this.importedVMID_to_TID == null) {
            this.importedVMID_to_TID = Collections.synchronizedMap(new HashMap());
        }
        this.importedVMID_to_TID.put(vmid, id);
    }

    protected String getTransactionID(String vmID, XAResource res) {
        String tid = null;
        if (this.importedVMID_to_TID != null) {
            tid = (String)this.importedVMID_to_TID.get(vmID);
        }
        if (tid == null && res != null) {
            tid = (String)this.resource_to_TID.get(res);
        }
        if (tid == null) {
            tid = this.topLevelTxnID.asString();
        }
        return tid;
    }

    protected synchronized void addSubTxnID(String txnID, XAResource res) {
        this.resource_to_TID.put(res, txnID);
    }
}

