/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.admin.util;

import com.metamatrix.admin.api.exception.AdminComponentException;
import com.metamatrix.admin.api.exception.AdminException;
import com.metamatrix.admin.util.IAdminMethodEncryptResolver;
import com.metamatrix.common.util.PropertiesUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class AdminMethodEncryptResolver
implements IAdminMethodEncryptResolver {
    private static final String SEPARATOR = ",";
    private static final String DEFAUT_METHOD_ROLES_FILE = "methodencrypt.properties";
    String METHOD_ROLES_FILE = null;
    private Map argumentsMap = new HashMap();

    public int[] getArgumentsToEncrypt(String methodName) {
        if (!this.argumentsMap.containsKey(methodName)) {
            return new int[0];
        }
        return (int[])this.argumentsMap.get(methodName);
    }

    public void init() throws AdminException {
        String propFilePath = this.METHOD_ROLES_FILE == null ? DEFAUT_METHOD_ROLES_FILE : this.METHOD_ROLES_FILE;
        Properties properties = null;
        try {
            properties = PropertiesUtils.loadAsResource(this.getClass(), propFilePath);
        }
        catch (Exception err) {
            AdminComponentException e = new AdminComponentException("Unable to load " + propFilePath + " file: " + err.getMessage());
            e.setStackTrace(err.getStackTrace());
            throw e;
        }
        try {
            properties = PropertiesUtils.loadAsResource(this.getClass(), propFilePath);
            Iterator<Object> keyItr = properties.keySet().iterator();
            while (keyItr.hasNext()) {
                String key = (String)keyItr.next();
                String positionsString = properties.getProperty(key);
                String[] positionsStrings = positionsString.split(SEPARATOR);
                int[] positions = new int[positionsStrings.length];
                for (int i = 0; i < positions.length; ++i) {
                    positions[i] = Integer.parseInt(positionsStrings[i]);
                }
                this.argumentsMap.put(key, positions);
            }
        }
        catch (Exception err) {
            AdminComponentException e = new AdminComponentException("AdminMethodEncryptResolver.Invalid_properties_file: " + err.getMessage());
            e.setStackTrace(err.getStackTrace());
            throw e;
        }
    }

    public String toString() {
        return "AdminMethodEncryptor: argumentsMap= " + this.argumentsMap;
    }
}

