/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.db2;

import com.metamatrix.jdbc.base.BaseResultSetFilterDescriptor;
import com.metamatrix.jdbc.base.BaseResultSetSortDescriptor;
import com.metamatrix.jdbc.base.BaseTypeInfo;
import com.metamatrix.jdbc.base.BaseTypeInfos;
import com.metamatrix.jdbc.db2.DB2ImplConnection;
import com.metamatrix.util.UtilStringFunctions;

public class DB2MetaDataLibrary {
    private static String footprint = "$Revision:   3.71.1.5  $";
    public String catalogName = null;
    public static String UNION_ALL = " UNION ALL ";
    public static String UNION = " UNION ";
    public static boolean isUDBCompatible;
    private boolean useSort = false;
    private static DB2ImplConnection con;
    private String catalogSchema;
    private String catalogSchema2;
    private String restrictUser;

    DB2MetaDataLibrary(DB2ImplConnection dB2ImplConnection, String string, String string2) {
        con = dB2ImplConnection;
        isUDBCompatible = dB2ImplConnection.comm.serverOS != 3 && dB2ImplConnection.comm.serverOS != 8;
        this.catalogSchema = string;
        this.catalogSchema2 = string2;
        this.restrictUser = dB2ImplConnection.alternateID == null ? dB2ImplConnection.user.toUpperCase() : dB2ImplConnection.alternateID.toUpperCase();
    }

    /*
     * Opcode count of 14025 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    public static BaseTypeInfos buildTypeInfo() {
        int n;
        int n2;
        String[] stringArray;
        String[] stringArray2;
        String[][] stringArrayArray;
        boolean bl;
        BaseTypeInfos baseTypeInfos = new BaseTypeInfos();
        boolean bl2 = bl = DB2MetaDataLibrary.con.comm.supportsGraphic && DB2MetaDataLibrary.con.comm.isUnicodeDB;
        if (DB2MetaDataLibrary.con.comm.serverOS == 3) {
            if (DB2MetaDataLibrary.con.comm.serverMajorVersion < 9 || DB2MetaDataLibrary.con.comm.serverMajorVersion == 9 && DB2MetaDataLibrary.con.comm.serverMinorVersion < 1) {
                stringArrayArray = new String[][]{{"LONG VARCHAR FOR BIT DATA", "-4", "32698", "X'", "'", null, "1", "0", "1", null, "0", null, "LONG VARCHAR FOR BIT DATA", null, null, null}, {"VARCHAR() FOR BIT DATA", "-3", "32698", "X'", "'", "(Max length)", "1", "0", "3", null, "0", null, "VARCHAR() FOR BIT DATA", null, null, null}, {"CHAR() FOR BIT DATA", "-2", "254", "X'", "'", "(length)", "1", "0", "3", null, "0", null, "CHAR() FOR BIT DATA", null, null, null}, {"ROWID", "-2", "40", null, null, "not null generated always", "0", "0", "2", "1", "0", "0", "ROWID", null, null, null}, {"LONG VARCHAR", "-1", "32704", "'", "'", null, "1", "1", "1", null, "0", null, "LONG VARCHAR", null, null, null}, {"LONG VARGRAPHIC", "-1", "16352", "G'", "'", null, "1", "1", "3", null, "0", null, "LONG VARGRAPHIC", null, null, null}, {"CHAR", "1", "255", "'", "'", "(length)", "1", "1", "3", null, "0", null, "CHAR", null, null, null}, {"GRAPHIC", "1", "127", "G'", "'", "(length)", "1", "1", "3", null, "0", null, "GRAPHIC", null, null, null}, {"NUMERIC", "2", "31", null, null, "(Precision, scale)", "1", "0", "2", "0", "0", "0", "NUMERIC", "0", "31", "10"}, {"DECIMAL", "3", "31", null, null, "(Precision, scale)", "1", "0", "2", "0", "0", "0", "DECIMAL", "0", "31", "10"}, {"INTEGER", "4", "10", null, null, null, "1", "0", "2", "0", "0", "0", "INTEGER", "0", "0", "10"}, {"SMALLINT", "5", "5", null, null, null, "1", "0", "2", "0", "0", "0", "SMALLINT", "0", "0", "10"}, {"FLOAT", "6", "15", null, null, null, "1", "0", "2", "0", "0", "0", "FLOAT", null, null, "10"}, {"REAL", "7", "7", null, null, null, "1", "0", "2", "0", "0", "0", "FLOAT(4)", null, null, "10"}, {"DOUBLE", "8", "15", null, null, null, "1", "0", "2", "0", "0", "0", "DOUBLE", null, null, "10"}, {"VARCHAR", "12", "32698", "'", "'", "(Max length)", "1", "1", "1", null, "0", null, "VARCHAR", null, null, null}, {"VARGRAPHIC", "12", "16352", "G'", "'", "(length)", "1", "1", "3", null, "0", null, "VARGRAPHIC", null, null, null}, {"DATE", "91", "10", "{d '", "'}", null, "1", "0", "2", null, "0", null, "DATE", null, null, null}, {"TIME", "92", "8", "{t '", "'}", null, "1", "0", "2", null, "0", null, "TIME", null, null, null}, {"TIMESTAMP", "93", "26", "{ts '", "'}", null, "1", "0", "2", null, "0", null, "TIMESTAMP", "6", "6", null}, {"BLOB", "2004", "2147483647", null, null, "(length)", "1", "1", "1", null, "0", null, "BLOB", null, null, null}, {"CLOB", "2005", "2147483647", "'", "'", "(length)", "1", "1", "1", null, "0", null, "CLOB", null, null, null}, {"DBCLOB", "2005", "2147483647", "'", "'", "(length)", "1", "1", "1", null, "0", null, "DBCLOB", null, null, null}};
            } else {
                stringArrayArray = new String[][]{{"BIGINT", "-5", "19", null, null, null, "1", "0", "2", "0", "0", "0", "BIGINT", "0", "0", null}, {"LONG VARCHAR FOR BIT DATA", "-4", "32698", "X'", "'", null, "1", "0", "1", null, "0", null, "LONG VARCHAR FOR BIT DATA", null, null, null}, {"VARBINARY", "-3", "32704", "VARBINARY(X'", "')", "(Max length)", "1", "0", "3", null, "0", null, "VARBINARY", null, null, null}, {"VARCHAR() FOR BIT DATA", "-3", "32698", "X'", "'", "(Max length)", "1", "0", "3", null, "0", null, "VARCHAR() FOR BIT DATA", null, null, null}, {"BINARY", "-2", "255", "BINARY(X'", "')", "(length)", "1", "0", "3", null, "0", null, "BINARY", null, null, null}, {"CHAR() FOR BIT DATA", "-2", "254", "X'", "'", "(length)", "1", "0", "3", null, "0", null, "CHAR() FOR BIT DATA", null, null, null}, {"ROWID", "-2", "40", null, null, "not null generated always", "0", "0", "2", "1", "0", "0", "ROWID", null, null, null}, {"LONG VARCHAR", "-1", "32704", "'", "'", null, "1", "1", "1", null, "0", null, "LONG VARCHAR", null, null, null}, {"LONG VARGRAPHIC", "-1", "16352", "G'", "'", null, "1", "1", "3", null, "0", null, "LONG VARGRAPHIC", null, null, null}, {"CHAR", "1", "255", "'", "'", "(length)", "1", "1", "3", null, "0", null, "CHAR", null, null, null}, {"GRAPHIC", "1", "127", "G'", "'", "(length)", "1", "1", "3", null, "0", null, "GRAPHIC", null, null, null}, {"NUMERIC", "2", "31", null, null, "(Precision, scale)", "1", "0", "2", "0", "0", "0", "NUMERIC", "0", "31", "10"}, {"DECIMAL", "3", "31", null, null, "(Precision, scale)", "1", "0", "2", "0", "0", "0", "DECIMAL", "0", "31", "10"}, {"DECFLOAT", "3", "34", null, null, "(Precision)", "1", "0", "2", "0", "0", "0", "DECFLOAT", "0", "0", "10"}, {"INTEGER", "4", "10", null, null, null, "1", "0", "2", "0", "0", "0", "INTEGER", "0", "0", "10"}, {"SMALLINT", "5", "5", null, null, null, "1", "0", "2", "0", "0", "0", "SMALLINT", "0", "0", "10"}, {"FLOAT", "6", "15", null, null, null, "1", "0", "2", "0", "0", "0", "FLOAT", null, null, "10"}, {"REAL", "7", "7", null, null, null, "1", "0", "2", "0", "0", "0", "FLOAT(4)", null, null, "10"}, {"DOUBLE", "8", "15", null, null, null, "1", "0", "2", "0", "0", "0", "DOUBLE", null, null, "10"}, {"VARCHAR", "12", "32698", "'", "'", "(Max length)", "1", "1", "1", null, "0", null, "VARCHAR", null, null, null}, {"VARGRAPHIC", "12", "16352", "G'", "'", "(length)", "1", "1", "3", null, "0", null, "VARGRAPHIC", null, null, null}, {"DATE", "91", "10", "{d '", "'}", null, "1", "0", "2", null, "0", null, "DATE", null, null, null}, {"TIME", "92", "8", "{t '", "'}", null, "1", "0", "2", null, "0", null, "TIME", null, null, null}, {"TIMESTAMP", "93", "26", "{ts '", "'}", null, "1", "0", "2", null, "0", null, "TIMESTAMP", "6", "6", null}, {"BLOB", "2004", "2147483647", null, null, "(length)", "1", "1", "1", null, "0", null, "BLOB", null, null, null}, {"CLOB", "2005", "2147483647", "'", "'", "(length)", "1", "1", "1", null, "0", null, "CLOB", null, null, null}, {"DBCLOB", "2005", "2147483647", "'", "'", "(length)", "1", "1", "1", null, "0", null, "DBCLOB", null, null, null}};
                stringArray2 = new String[]{"XML", String.valueOf(DB2MetaDataLibrary.con.xmlDescribeType), "2147483647", null, null, null, "1", "1", "1", null, "0", null, "XML", null, null, null};
                stringArray = new String[stringArrayArray.length + 1][stringArrayArray[0].length];
                int n3 = 0;
                for (int i = 0; i < stringArrayArray.length; ++i) {
                    if (stringArrayArray[i][0].equalsIgnoreCase(DB2MetaDataLibrary.con.xmlDescribeTypeStr)) {
                        stringArray[n3++] = stringArrayArray[i];
                        stringArray[n3++] = stringArray2;
                        continue;
                    }
                    stringArray[n3++] = stringArrayArray[i];
                }
                stringArrayArray = stringArray;
            }
        } else if (DB2MetaDataLibrary.con.comm.serverOS == 8) {
            stringArrayArray = DB2MetaDataLibrary.con.comm.serverType <= 2 ? new String[][]{{"BIGINT", "-5", "19", null, null, null, "1", "0", "2", "0", "0", "0", "BIGINT", "0", "0", null}, {"LONG VARCHAR FOR BIT DATA", "-4", "32698", "X'", "'", null, "1", "0", "1", null, "0", null, "LONG VARCHAR FOR BIT DATA", null, null, null}, {"VARCHAR() FOR BIT DATA", "-3", "32698", "X'", "'", "(Max length)", "1", "0", "3", null, "0", null, "VARCHAR() FOR BIT DATA", null, null, null}, {"CHAR() FOR BIT DATA", "-2", "254", "X'", "'", "(length)", "1", "0", "3", null, "0", null, "CHAR() FOR BIT DATA", null, null, null}, {"LONG VARCHAR", "-1", "32698", "'", "'", null, "1", "1", "1", null, "0", null, "LONG VARCHAR", null, null, null}, {"LONG VARGRAPHIC", "-1", "16352", "G'", "'", null, "1", "1", "3", null, "0", null, "LONG VARGRAPHIC", null, null, null}, {"CHAR", "1", "254", "'", "'", "(length)", "1", "1", "3", null, "0", null, "CHAR", null, null, null}, {"GRAPHIC", "1", "16352", "G'", "'", "(length)", "1", "1", "3", null, "0", null, "GRAPHIC", null, null, null}, {"NUMERIC", "2", "31", null, null, "(Precision, scale)", "1", "0", "2", "0", "0", "0", "NUMERIC", "0", "31", "10"}, {"DECIMAL", "3", "31", null, null, "(Precision, scale)", "1", "0", "2", "0", "0", "0", "DECIMAL", "0", "31", "10"}, {"INTEGER", "4", "10", null, null, null, "1", "0", "2", "0", "0", "0", "INTEGER", "0", "0", "10"}, {"SMALLINT", "5", "5", null, null, null, "1", "0", "2", "0", "0", "0", "SMALLINT", "0", "0", "10"}, {"FLOAT", "6", "15", null, null, null, "1", "0", "2", "0", "0", "0", "FLOAT", null, null, "10"}, {"REAL", "7", "7", null, null, null, "1", "0", "2", "0", "0", "0", "FLOAT(4)", null, null, "10"}, {"DOUBLE", "8", "15", null, null, null, "1", "0", "2", "0", "0", "0", "DOUBLE", null, null, "10"}, {"VARCHAR", "12", "32698", "'", "'", "(Max length)", "1", "1", "1", null, "0", null, "VARCHAR", null, null, null}, {"VARGRAPHIC", "12", "16352", "G'", "'", "(length)", "1", "1", "3", null, "0", null, "VARGRAPHIC", null, null, null}, {"DATE", "91", "10", "{d '", "'}", null, "1", "0", "2", null, "0", null, "DATE", null, null, null}, {"TIME", "92", "8", "{t '", "'}", null, "1", "0", "2", null, "0", null, "TIME", null, null, null}, {"TIMESTAMP", "93", "26", "{ts '", "'}", null, "1", "0", "2", null, "0", null, "TIMESTAMP", "6", "6", null}, {"CLOB", "2005", "32700", "'", "'", "(length)", "1", "1", "1", null, "0", null, "CLOB", null, null, null}} : new String[][]{{"BIGINT", "-5", "19", null, null, null, "1", "0", "2", "0", "0", "0", "BIGINT", "0", "0", null}, {"LONG VARCHAR FOR BIT DATA", "-4", "32739", "X'", "'", null, "1", "0", "1", null, "0", null, "LONG VARCHAR FOR BIT DATA", null, null, null}, {"VARCHAR() FOR BIT DATA", "-3", "32739", "X'", "'", "(Max length)", "1", "0", "3", null, "0", null, "VARCHAR() FOR BIT DATA", null, null, null}, {"CHAR() FOR BIT DATA", "-2", "32765", "X'", "'", "(length)", "1", "0", "3", null, "0", null, "CHAR() FOR BIT DATA", null, null, null}, {"ROWID", "-2", "40", null, null, "not null generated always", "0", "0", "2", "1", "0", "0", "ROWID", null, null, null}, {"LONG VARCHAR", "-1", "32700", "'", "'", null, "1", "1", "1", null, "0", null, "LONG VARCHAR", null, null, null}, {"LONG VARGRAPHIC", "-1", "16352", "G'", "'", null, "1", "1", "3", null, "0", null, "LONG VARGRAPHIC", null, null, null}, {"CHAR", "1", "32765", "'", "'", "(length)", "1", "1", "3", null, "0", null, "CHAR", null, null, null}, {"GRAPHIC", "1", "16352", "G'", "'", "(length)", "1", "1", "3", null, "0", null, "GRAPHIC", null, null, null}, {"NUMERIC", "2", "31", null, null, "(Precision, scale)", "1", "0", "2", "0", "0", "0", "NUMERIC", "0", "31", "10"}, {"DECIMAL", "3", "31", null, null, "(Precision, scale)", "1", "0", "2", "0", "0", "0", "DECIMAL", "0", "31", "10"}, {"INTEGER", "4", "10", null, null, null, "1", "0", "2", "0", "0", "0", "INTEGER", "0", "0", "10"}, {"SMALLINT", "5", "5", null, null, null, "1", "0", "2", "0", "0", "0", "SMALLINT", "0", "0", "10"}, {"FLOAT", "6", "15", null, null, null, "1", "0", "2", "0", "0", "0", "FLOAT", null, null, "10"}, {"REAL", "7", "7", null, null, null, "1", "0", "2", "0", "0", "0", "FLOAT(4)", null, null, "10"}, {"DOUBLE", "8", "15", null, null, null, "1", "0", "2", "0", "0", "0", "DOUBLE", null, null, "10"}, {"VARCHAR", "12", "32739", "'", "'", "(Max length)", "1", "1", "1", null, "0", null, "VARCHAR", null, null, null}, {"VARGRAPHIC", "12", "16352", "G'", "'", "(length)", "1", "1", "3", null, "0", null, "VARGRAPHIC", null, null, null}, {"DATE", "91", "10", "{d '", "'}", null, "1", "0", "2", null, "0", null, "DATE", null, null, null}, {"TIME", "92", "8", "{t '", "'}", null, "1", "0", "2", null, "0", null, "TIME", null, null, null}, {"TIMESTAMP", "93", "26", "{ts '", "'}", null, "1", "0", "2", null, "0", null, "TIMESTAMP", "6", "6", null}, {"BLOB", "2004", "2147483647", null, null, "(length)", "1", "1", "1", null, "0", null, "BLOB", null, null, null}, {"CLOB", "2005", "2147483647", "'", "'", "(length)", "1", "1", "1", null, "0", null, "CLOB", null, null, null}, {"DBCLOB", "2005", "2147483647", "'", "'", "(length) CCSID 13488", "1", "1", "1", null, "0", null, "DBCLOB", null, null, null}};
        } else if (DB2MetaDataLibrary.con.comm.serverMajorVersion <= 7) {
            stringArrayArray = new String[][]{{"BIGINT", "-5", "19", null, null, null, "1", "0", "2", "0", "0", "0", "BIGINT", "0", "0", null}, {"LONG VARCHAR FOR BIT DATA", "-4", "32700", "X'", "'", null, "1", "0", "1", null, "0", null, "LONG VARCHAR FOR BIT DATA", null, null, null}, {"VARCHAR() FOR BIT DATA", "-3", "32704", "X'", "'", "(Max length)", "1", "0", "3", null, "0", null, "VARCHAR() FOR BIT DATA", null, null, null}, {"CHAR() FOR BIT DATA", "-2", "254", "X'", "'", "(length)", "1", "0", "3", null, "0", null, "CHAR() FOR BIT DATA", null, null, null}, {"LONG VARCHAR", "-1", "32700", "'", "'", null, "1", "1", "1", null, "0", null, "LONG VARCHAR", null, null, null}, {"CHAR", "1", "254", "'", "'", "(length)", "1", "1", "3", null, "0", null, "CHAR", null, null, null}, {"NUMERIC", "2", "31", null, null, "(Precision, scale)", "1", "0", "2", "0", "0", "0", "NUMERIC", "0", "31", "10"}, {"DECIMAL", "3", "31", null, null, "(Precision, scale)", "1", "0", "2", "0", "0", "0", "DECIMAL", "0", "31", "10"}, {"INTEGER", "4", "10", null, null, null, "1", "0", "2", "0", "0", "0", "INTEGER", "0", "0", "10"}, {"SMALLINT", "5", "5", null, null, null, "1", "0", "2", "0", "0", "0", "SMALLINT", "0", "0", "10"}, {"FLOAT", "6", "15", null, null, null, "1", "0", "2", "0", "0", "0", "FLOAT", null, null, "10"}, {"REAL", "7", "7", null, null, null, "1", "0", "2", "0", "0", "0", "FLOAT(4)", null, null, "10"}, {"DOUBLE", "8", "15", null, null, null, "1", "0", "2", "0", "0", "0", "DOUBLE", null, null, "10"}, {"VARCHAR", "12", "32704", "'", "'", "(Max length)", "1", "1", "3", null, "0", null, "VARCHAR", null, null, null}, {"DATE", "91", "10", "{d '", "'}", null, "1", "0", "2", null, "0", null, "DATE", null, null, null}, {"TIME", "92", "8", "{t '", "'}", null, "1", "0", "2", null, "0", null, "TIME", null, null, null}, {"TIMESTAMP", "93", "26", "{ts '", "'}", null, "1", "0", "2", null, "0", null, "TIMESTAMP", "6", "6", null}, {"CLOB", "2005", "32700", "'", "'", "(length)", "1", "1", "1", null, "0", null, "CLOB", null, null, null}};
            if (bl) {
                stringArray2 = new String[]{"LONG VARGRAPHIC", "-1", "16352", "G'", "'", null, "1", "1", "1", null, "0", null, "LONG VARGRAPHIC", null, null, null};
                stringArray = new String[]{"GRAPHIC", "1", "16352", "G'", "'", "(length)", "1", "1", "3", null, "0", null, "GRAPHIC", null, null, null};
                String[] stringArray3 = new String[]{"VARGRAPHIC", "12", "16352", "G'", "'", "(length)", "1", "1", "3", null, "0", null, "VARGRAPHIC", null, null, null};
                String[][] stringArray4 = new String[stringArrayArray.length + 3][stringArrayArray[0].length];
                n2 = 0;
                for (int i = 0; i < stringArrayArray.length; ++i) {
                    if (stringArrayArray[i][1].equalsIgnoreCase("-1")) {
                        stringArray4[n2++] = stringArrayArray[i];
                        stringArray4[n2++] = stringArray2;
                        continue;
                    }
                    if (stringArrayArray[i][1].equalsIgnoreCase("1")) {
                        stringArray4[n2++] = stringArrayArray[i];
                        stringArray4[n2++] = stringArray;
                        continue;
                    }
                    if (stringArrayArray[i][1].equalsIgnoreCase("12")) {
                        stringArray4[n2++] = stringArrayArray[i];
                        stringArray4[n2++] = stringArray3;
                        continue;
                    }
                    stringArray4[n2++] = stringArrayArray[i];
                }
                stringArrayArray = stringArray4;
            }
        } else if (DB2MetaDataLibrary.con.comm.serverMajorVersion == 8) {
            stringArrayArray = new String[][]{{"BIGINT", "-5", "19", null, null, null, "1", "0", "2", "0", "0", "0", "BIGINT", "0", "0", null}, {"LONG VARCHAR FOR BIT DATA", "-4", "32700", "X'", "'", null, "1", "0", "1", null, "0", null, "LONG VARCHAR FOR BIT DATA", null, null, null}, {"VARCHAR() FOR BIT DATA", "-3", "32762", "X'", "'", "(Max length)", "1", "0", "3", null, "0", null, "VARCHAR() FOR BIT DATA", null, null, null}, {"CHAR() FOR BIT DATA", "-2", "254", "X'", "'", "(length)", "1", "0", "3", null, "0", null, "CHAR() FOR BIT DATA", null, null, null}, {"LONG VARCHAR", "-1", "32700", "'", "'", null, "1", "1", "1", null, "0", null, "LONG VARCHAR", null, null, null}, {"CHAR", "1", "254", "'", "'", "(length)", "1", "1", "3", null, "0", null, "CHAR", null, null, null}, {"NUMERIC", "2", "31", null, null, "(Precision, scale)", "1", "0", "2", "0", "0", "0", "NUMERIC", "0", "31", "10"}, {"DECIMAL", "3", "31", null, null, "(Precision, scale)", "1", "0", "2", "0", "0", "0", "DECIMAL", "0", "31", "10"}, {"INTEGER", "4", "10", null, null, null, "1", "0", "2", "0", "0", "0", "INTEGER", "0", "0", "10"}, {"SMALLINT", "5", "5", null, null, null, "1", "0", "2", "0", "0", "0", "SMALLINT", "0", "0", "10"}, {"FLOAT", "6", "15", null, null, null, "1", "0", "2", "0", "0", "0", "FLOAT", null, null, "10"}, {"REAL", "7", "7", null, null, null, "1", "0", "2", "0", "0", "0", "FLOAT(4)", null, null, "10"}, {"DOUBLE", "8", "15", null, null, null, "1", "0", "2", "0", "0", "0", "DOUBLE", null, null, "10"}, {"VARCHAR", "12", "32762", "'", "'", "(Max length)", "1", "1", "3", null, "0", null, "VARCHAR", null, null, null}, {"DATE", "91", "10", "{d '", "'}", null, "1", "0", "2", null, "0", null, "DATE", null, null, null}, {"TIME", "92", "8", "{t '", "'}", null, "1", "0", "2", null, "0", null, "TIME", null, null, null}, {"TIMESTAMP", "93", "26", "{ts '", "'}", null, "1", "0", "2", null, "0", null, "TIMESTAMP", "6", "6", null}, {"BLOB", "2004", "2147483647", null, null, "(length)", "1", "1", "1", null, "0", null, "BLOB", null, null, null}, {"CLOB", "2005", "2147483647", "'", "'", "(length)", "1", "1", "1", null, "0", null, "CLOB", null, null, null}, {"DBCLOB", "2005", "2147483647", "'", "'", "(length)", "1", "1", "1", null, "0", null, "DBCLOB", null, null, null}};
            if (bl) {
                stringArray2 = new String[]{"LONG VARGRAPHIC", "-1", "16352", "G'", "'", null, "1", "1", "1", null, "0", null, "LONG VARGRAPHIC", null, null, null};
                stringArray = new String[]{"GRAPHIC", "1", "16352", "G'", "'", "(length)", "1", "1", "3", null, "0", null, "GRAPHIC", null, null, null};
                String[] stringArray5 = new String[]{"VARGRAPHIC", "12", "16352", "G'", "'", "(length)", "1", "1", "3", null, "0", null, "VARGRAPHIC", null, null, null};
                String[][] stringArray6 = new String[stringArrayArray.length + 3][stringArrayArray[0].length];
                n2 = 0;
                for (int i = 0; i < stringArrayArray.length; ++i) {
                    if (stringArrayArray[i][1].equalsIgnoreCase("-1")) {
                        stringArray6[n2++] = stringArrayArray[i];
                        stringArray6[n2++] = stringArray2;
                        continue;
                    }
                    if (stringArrayArray[i][1].equalsIgnoreCase("1")) {
                        stringArray6[n2++] = stringArrayArray[i];
                        stringArray6[n2++] = stringArray;
                        continue;
                    }
                    if (stringArrayArray[i][1].equalsIgnoreCase("12")) {
                        stringArray6[n2++] = stringArrayArray[i];
                        stringArray6[n2++] = stringArray5;
                        continue;
                    }
                    stringArray6[n2++] = stringArrayArray[i];
                }
                stringArrayArray = stringArray6;
            }
        } else if (DB2MetaDataLibrary.con.comm.serverMajorVersion < 9 || DB2MetaDataLibrary.con.comm.serverMajorVersion == 9 && DB2MetaDataLibrary.con.comm.serverMinorVersion < 1) {
            stringArrayArray = new String[][]{{"BIGINT", "-5", "19", null, null, null, "1", "0", "2", "0", "0", "0", "BIGINT", "0", "0", null}, {"LONG VARCHAR FOR BIT DATA", "-4", "32700", "X'", "'", null, "1", "0", "1", null, "0", null, "LONG VARCHAR FOR BIT DATA", null, null, null}, {"VARCHAR() FOR BIT DATA", "-3", "32762", "X'", "'", "(Max length)", "1", "0", "3", null, "0", null, "VARCHAR() FOR BIT DATA", null, null, null}, {"CHAR() FOR BIT DATA", "-2", "254", "X'", "'", "(length)", "1", "0", "3", null, "0", null, "CHAR() FOR BIT DATA", null, null, null}, {"LONG VARCHAR", "-1", "32700", "'", "'", null, "1", "1", "1", null, "0", null, "LONG VARCHAR", null, null, null}, {"LONG VARGRAPHIC", "-1", "16352", "G'", "'", null, "1", "1", "3", null, "0", null, "LONG VARGRAPHIC", null, null, null}, {"CHAR", "1", "254", "'", "'", "(length)", "1", "1", "3", null, "0", null, "CHAR", null, null, null}, {"GRAPHIC", "1", "16352", "G'", "'", "(length)", "1", "1", "3", null, "0", null, "GRAPHIC", null, null, null}, {"NUMERIC", "2", "31", null, null, "(Precision, scale)", "1", "0", "2", "0", "0", "0", "NUMERIC", "0", "31", "10"}, {"DECIMAL", "3", "31", null, null, "(Precision, scale)", "1", "0", "2", "0", "0", "0", "DECIMAL", "0", "31", "10"}, {"INTEGER", "4", "10", null, null, null, "1", "0", "2", "0", "0", "0", "INTEGER", "0", "0", "10"}, {"SMALLINT", "5", "5", null, null, null, "1", "0", "2", "0", "0", "0", "SMALLINT", "0", "0", "10"}, {"FLOAT", "6", "15", null, null, null, "1", "0", "2", "0", "0", "0", "FLOAT", null, null, "10"}, {"REAL", "7", "7", null, null, null, "1", "0", "2", "0", "0", "0", "FLOAT(4)", null, null, "10"}, {"DOUBLE", "8", "15", null, null, null, "1", "0", "2", "0", "0", "0", "DOUBLE", null, null, "10"}, {"VARCHAR", "12", "32762", "'", "'", "(Max length)", "1", "1", "3", null, "0", null, "VARCHAR", null, null, null}, {"VARGRAPHIC", "12", "16352", "G'", "'", "(length)", "1", "1", "3", null, "0", null, "VARGRAPHIC", null, null, null}, {"DATE", "91", "10", "{d '", "'}", null, "1", "0", "2", null, "0", null, "DATE", null, null, null}, {"TIME", "92", "8", "{t '", "'}", null, "1", "0", "2", null, "0", null, "TIME", null, null, null}, {"TIMESTAMP", "93", "26", "{ts '", "'}", null, "1", "0", "2", null, "0", null, "TIMESTAMP", "6", "6", null}, {"BLOB", "2004", "2147483647", null, null, "(length)", "1", "1", "1", null, "0", null, "BLOB", null, null, null}, {"CLOB", "2005", "2147483647", "'", "'", "(length)", "1", "1", "1", null, "0", null, "CLOB", null, null, null}, {"DBCLOB", "2005", "2147483647", "'", "'", "(length)", "1", "1", "1", null, "0", null, "DBCLOB", null, null, null}};
            stringArray2 = new String[]{"XML", String.valueOf(DB2MetaDataLibrary.con.xmlDescribeType), "2147483647", null, null, null, "1", "1", "1", null, "0", null, "XML", null, null, null};
            stringArray = new String[stringArrayArray.length + 1][stringArrayArray[0].length];
            int n4 = 0;
            for (int i = 0; i < stringArrayArray.length; ++i) {
                if (stringArrayArray[i][0].equalsIgnoreCase(DB2MetaDataLibrary.con.xmlDescribeTypeStr)) {
                    stringArray[n4++] = stringArrayArray[i];
                    stringArray[n4++] = stringArray2;
                    continue;
                }
                stringArray[n4++] = stringArrayArray[i];
            }
            stringArrayArray = stringArray;
            if (bl) {
                String[] stringArray7 = new String[]{"LONG VARGRAPHIC", "-1", "16352", "G'", "'", null, "1", "1", "1", null, "0", null, "LONG VARGRAPHIC", null, null, null};
                String[] stringArray8 = new String[]{"GRAPHIC", "1", "16352", "G'", "'", "(length)", "1", "1", "3", null, "0", null, "GRAPHIC", null, null, null};
                String[] stringArray9 = new String[]{"VARGRAPHIC", "12", "16352", "G'", "'", "(length)", "1", "1", "3", null, "0", null, "VARGRAPHIC", null, null, null};
                stringArray = new String[stringArrayArray.length + 3][stringArrayArray[0].length];
                n = 0;
                for (n2 = 0; n2 < stringArrayArray.length; ++n2) {
                    if (stringArrayArray[n2][1].equalsIgnoreCase("-1")) {
                        stringArray[n++] = stringArrayArray[n2];
                        stringArray[n++] = stringArray7;
                        continue;
                    }
                    if (stringArrayArray[n2][1].equalsIgnoreCase("1")) {
                        stringArray[n++] = stringArrayArray[n2];
                        stringArray[n++] = stringArray8;
                        continue;
                    }
                    if (stringArrayArray[n2][1].equalsIgnoreCase("12")) {
                        stringArray[n++] = stringArrayArray[n2];
                        stringArray[n++] = stringArray9;
                        continue;
                    }
                    stringArray[n++] = stringArrayArray[n2];
                }
                stringArrayArray = stringArray;
            }
        } else {
            stringArrayArray = new String[][]{{"BIGINT", "-5", "19", null, null, null, "1", "0", "2", "0", "0", "0", "BIGINT", "0", "0", null}, {"LONG VARCHAR FOR BIT DATA", "-4", "32700", "X'", "'", null, "1", "0", "1", null, "0", null, "LONG VARCHAR FOR BIT DATA", null, null, null}, {"VARCHAR() FOR BIT DATA", "-3", "32762", "X'", "'", "(Max length)", "1", "0", "3", null, "0", null, "VARCHAR() FOR BIT DATA", null, null, null}, {"CHAR() FOR BIT DATA", "-2", "254", "X'", "'", "(length)", "1", "0", "3", null, "0", null, "CHAR() FOR BIT DATA", null, null, null}, {"LONG VARCHAR", "-1", "32700", "'", "'", null, "1", "1", "1", null, "0", null, "LONG VARCHAR", null, null, null}, {"CHAR", "1", "254", "'", "'", "(length)", "1", "1", "3", null, "0", null, "CHAR", null, null, null}, {"NUMERIC", "2", "31", null, null, "(Precision, scale)", "1", "0", "2", "0", "0", "0", "NUMERIC", "0", "31", "10"}, {"DECIMAL", "3", "31", null, null, "(Precision, scale)", "1", "0", "2", "0", "0", "0", "DECIMAL", "0", "31", "10"}, {"INTEGER", "4", "10", null, null, null, "1", "0", "2", "0", "0", "0", "INTEGER", "0", "0", "10"}, {"SMALLINT", "5", "5", null, null, null, "1", "0", "2", "0", "0", "0", "SMALLINT", "0", "0", "10"}, {"FLOAT", "6", "15", null, null, null, "1", "0", "2", "0", "0", "0", "FLOAT", null, null, "10"}, {"REAL", "7", "7", null, null, null, "1", "0", "2", "0", "0", "0", "FLOAT(4)", null, null, "10"}, {"DOUBLE", "8", "15", null, null, null, "1", "0", "2", "0", "0", "0", "DOUBLE", null, null, "10"}, {"VARCHAR", "12", "32762", "'", "'", "(Max length)", "1", "1", "3", null, "0", null, "VARCHAR", null, null, null}, {"DATE", "91", "10", "{d '", "'}", null, "1", "0", "2", null, "0", null, "DATE", null, null, null}, {"TIME", "92", "8", "{t '", "'}", null, "1", "0", "2", null, "0", null, "TIME", null, null, null}, {"TIMESTAMP", "93", "26", "{ts '", "'}", null, "1", "0", "2", null, "0", null, "TIMESTAMP", "6", "6", null}, {"BLOB", "2004", "2147483647", null, null, "(length)", "1", "1", "1", null, "0", null, "BLOB", null, null, null}, {"CLOB", "2005", "2147483647", "'", "'", "(length)", "1", "1", "1", null, "0", null, "CLOB", null, null, null}, {"DBCLOB", "2005", "2147483647", "'", "'", "(length)", "1", "1", "1", null, "0", null, "DBCLOB", null, null, null}};
            stringArray2 = new String[]{"XML", String.valueOf(DB2MetaDataLibrary.con.xmlDescribeType), "2147483647", null, null, null, "1", "1", "1", null, "0", null, "XML", null, null, null};
            stringArray = new String[stringArrayArray.length + 1][stringArrayArray[0].length];
            int n5 = 0;
            for (int i = 0; i < stringArrayArray.length; ++i) {
                if (stringArrayArray[i][0].equalsIgnoreCase(DB2MetaDataLibrary.con.xmlDescribeTypeStr)) {
                    stringArray[n5++] = stringArrayArray[i];
                    stringArray[n5++] = stringArray2;
                    continue;
                }
                stringArray[n5++] = stringArrayArray[i];
            }
            stringArrayArray = stringArray;
            if (bl) {
                String[] stringArray10 = new String[]{"LONG VARGRAPHIC", "-1", "16352", "G'", "'", null, "1", "1", "1", null, "0", null, "LONG VARGRAPHIC", null, null, null};
                String[] stringArray11 = new String[]{"GRAPHIC", "1", "16352", "G'", "'", "(length)", "1", "1", "3", null, "0", null, "GRAPHIC", null, null, null};
                String[] stringArray12 = new String[]{"VARGRAPHIC", "12", "16352", "G'", "'", "(length)", "1", "1", "3", null, "0", null, "VARGRAPHIC", null, null, null};
                stringArray = new String[stringArrayArray.length + 3][stringArrayArray[0].length];
                n = 0;
                for (n2 = 0; n2 < stringArrayArray.length; ++n2) {
                    if (stringArrayArray[n2][1].equalsIgnoreCase("-1")) {
                        stringArray[n++] = stringArrayArray[n2];
                        stringArray[n++] = stringArray10;
                        continue;
                    }
                    if (stringArrayArray[n2][1].equalsIgnoreCase("1")) {
                        stringArray[n++] = stringArrayArray[n2];
                        stringArray[n++] = stringArray11;
                        continue;
                    }
                    if (stringArrayArray[n2][1].equalsIgnoreCase("12")) {
                        stringArray[n++] = stringArrayArray[n2];
                        stringArray[n++] = stringArray12;
                        continue;
                    }
                    stringArray[n++] = stringArrayArray[n2];
                }
                stringArrayArray = stringArray;
            }
        }
        for (int i = 0; i < stringArrayArray.length; ++i) {
            stringArray = new BaseTypeInfo();
            stringArray.typeName = stringArrayArray[i][0];
            stringArray.dataType = Short.valueOf(stringArrayArray[i][1]);
            stringArray.maxPrecision = Integer.valueOf(stringArrayArray[i][2]);
            stringArray.literalPrefix = stringArrayArray[i][3];
            stringArray.literalSuffix = stringArrayArray[i][4];
            stringArray.createParams = stringArrayArray[i][5];
            stringArray.nullable = Short.valueOf(stringArrayArray[i][6]);
            stringArray.caseSensitive = stringArrayArray[i][7] != null ? (stringArrayArray[i][7].equals("1") ? Boolean.TRUE : Boolean.FALSE) : null;
            stringArray.searchable = Short.valueOf(stringArrayArray[i][8]);
            stringArray.unsignedAttribute = stringArrayArray[i][9] != null ? (stringArrayArray[i][9].equals("1") ? Boolean.TRUE : Boolean.FALSE) : null;
            stringArray.fixedPrecScale = stringArrayArray[i][10] != null ? (stringArrayArray[i][10].equals("1") ? Boolean.TRUE : Boolean.FALSE) : null;
            stringArray.autoIncrement = stringArrayArray[i][11] != null ? (stringArrayArray[i][11].equals("1") ? Boolean.TRUE : Boolean.FALSE) : null;
            stringArray.localTypeName = stringArrayArray[i][12];
            stringArray.minimumScale = stringArrayArray[i][13] == null ? null : Short.valueOf(stringArrayArray[i][13]);
            stringArray.maximumScale = stringArrayArray[i][14] == null ? null : Short.valueOf(stringArrayArray[i][14]);
            stringArray.numPrecRadix = stringArrayArray[i][15] == null ? null : Integer.valueOf(stringArrayArray[i][15]);
            baseTypeInfos.add((BaseTypeInfo)stringArray);
        }
        return baseTypeInfos;
    }

    public String[] getTableTypeNames() {
        String[] stringArray = null;
        if (isUDBCompatible) {
            String[] stringArray2 = new String[]{"ALIAS", "HIERARCHY TABLE", "NICKNAME", "SUMMARY TABLE", "SYNONYMS", "SYSTEM TABLE", "TABLE", "VIEW"};
            stringArray = stringArray2;
        } else {
            String[] stringArray3;
            stringArray = stringArray3 = new String[]{"ALIAS", "SYNONYM", "SYSTEM TABLE", "TABLE", "TEMPORARY TABLE", "VIEW"};
        }
        return stringArray;
    }

    public String getTableString(BaseResultSetFilterDescriptor baseResultSetFilterDescriptor, BaseResultSetSortDescriptor baseResultSetSortDescriptor) {
        baseResultSetSortDescriptor.setSatisfied();
        String[] stringArray = new String[]{" AND TABSCHEMA ", " AND TABNAME "};
        String[] stringArray2 = new String[]{" AND CREATOR ", " AND NAME "};
        String[] stringArray3 = new String[]{" AND TABLE_SCHEMA ", " AND TABLE_NAME "};
        String string = (String)baseResultSetFilterDescriptor.getRestriction(1);
        if (string != null && !this.catalogNameMatches(string)) {
            baseResultSetFilterDescriptor.removeAllRestrictions();
            return null;
        }
        string = this.catalogName;
        String[] stringArray4 = DB2MetaDataLibrary.buildParameterSet(baseResultSetFilterDescriptor, 2, 3);
        int[] nArray = new int[]{2, 3};
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        if (isUDBCompatible) {
            string4 = "SELECT '" + string + "', TABSCHEMA, TABNAME,";
            string5 = DB2MetaDataLibrary.joinParameterSet(baseResultSetFilterDescriptor, stringArray, stringArray4, nArray);
        } else if (DB2MetaDataLibrary.con.comm.serverOS == 8) {
            string6 = "SELECT '" + string + "', TABLE_SCHEMA, TABLE_NAME,";
            string7 = DB2MetaDataLibrary.joinParameterSet(baseResultSetFilterDescriptor, stringArray3, stringArray4, nArray);
        } else {
            string2 = "SELECT '" + string + "', CREATOR, NAME,";
            string3 = DB2MetaDataLibrary.joinParameterSet(baseResultSetFilterDescriptor, stringArray2, stringArray4, nArray);
        }
        String string8 = " 'TABLE', REMARKS,nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1) FROM ? WHERE TYPE = 'T' AND NOT (CREATOR IN ('SYSIBM', 'SYSCAT', '" + this.catalogSchema + "'))";
        String string9 = " 'TABLE', REMARKS,nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1) FROM ? WHERE TYPE = 'T' AND TABSCHEMA <> 'SYSIBM' AND TABSCHEMA <> 'SYSCAT' AND TABSCHEMA <> '" + this.catalogSchema + "'";
        String string10 = " 'TABLE', REMARKS,nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1) FROM ? WHERE (TYPE = 'T' OR TYPE = 'P') AND TABLE_SCHEMA <> 'QSYS2' AND TABLE_SCHEMA <> 'QSYS2' AND TABLE_SCHEMA <> '" + this.catalogSchema + "'";
        String string11 = " 'VIEW', REMARKS,nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1) FROM ? WHERE TYPE = 'V'";
        String string12 = " 'VIEW', REMARKS,nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1) FROM ? WHERE (TYPE = 'V' OR TYPE = 'L') ";
        String string13 = " 'ALIAS', REMARKS,nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1) FROM ? WHERE TYPE = 'A'";
        String string14 = " 'SYNONYM', ' ',nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1) FROM ? WHERE 1=1";
        String string15 = " 'HIERARCHY', REMARKS,nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1) FROM ? WHERE TYPE = 'H'";
        String string16 = " 'NICKNAME', REMARKS,nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1) FROM ? WHERE TYPE = 'N'";
        String string17 = " 'SUMMARY', REMARKS,nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1) FROM ? WHERE TYPE = 'S'";
        String string18 = " 'SYSTEM TABLE', REMARKS,nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1) FROM ? WHERE CREATOR = '" + this.catalogSchema + "'";
        String string19 = " 'SYSTEM TABLE', REMARKS,nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1) FROM ? WHERE TABSCHEMA = '" + this.catalogSchema + "'";
        String string20 = " 'SYSTEM TABLE', REMARKS,nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1) FROM ? WHERE TABLE_SCHEMA = '" + this.catalogSchema + "'";
        String string21 = " ORDER BY 4, 2, 3 FOR FETCH ONLY";
        String[] stringArray5 = (String[])baseResultSetFilterDescriptor.getRestriction(4);
        baseResultSetFilterDescriptor.removeAllRestrictions();
        String string22 = this.catalogSchema + ".TABLES";
        String string23 = string4;
        String string24 = string5;
        if (!isUDBCompatible) {
            if (DB2MetaDataLibrary.con.comm.serverOS == 8) {
                string22 = this.catalogSchema + ".SYSTABLES";
                string23 = string6;
                string24 = string7;
            } else {
                string22 = this.catalogSchema + ".SYSTABLES";
                string23 = string2;
                string24 = string3;
            }
        }
        if (string24.indexOf(" LIKE ") > 0) {
            string24 = string24 + " ESCAPE '\\'";
        }
        String[] stringArray6 = new String[]{"?", string22};
        String[] stringArray7 = new String[]{"?", this.catalogSchema + ".SYSSYNONYMS"};
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        if (stringArray5 == null) {
            stringArray5 = this.getTableTypeNames();
        }
        for (int i = 0; i < stringArray5.length; ++i) {
            String string25 = null;
            if (stringArray5[i].equals("TABLE")) {
                string25 = isUDBCompatible ? string23 + string9 : (DB2MetaDataLibrary.con.comm.serverOS == 8 ? string23 + string10 : string23 + string8);
            }
            if (stringArray5[i].equals("VIEW")) {
                string25 = DB2MetaDataLibrary.con.comm.serverOS == 8 ? string23 + string12 : string23 + string11;
            }
            if (stringArray5[i].equals("ALIAS") && !bl) {
                string25 = string23 + string13;
                bl = true;
            }
            if (stringArray5[i].equals("SYNONYMS") || stringArray5[i].equals("SYNONYM")) {
                if (DB2MetaDataLibrary.con.comm.serverOS == 3) {
                    string25 = string23 + string14;
                } else if (!bl) {
                    string25 = string23 + string13;
                    bl = true;
                }
            }
            if (stringArray5[i].equals("NICKNAME")) {
                string25 = string23 + string16;
            }
            if (stringArray5[i].equals("SUMMARY TABLE")) {
                string25 = string23 + string17;
            }
            if (stringArray5[i].equals("HIERARCHY TABLE")) {
                string25 = string23 + string15;
            }
            if (stringArray5[i].equals("SYSTEM TABLE")) {
                string25 = isUDBCompatible ? string23 + string19 : (DB2MetaDataLibrary.con.comm.serverOS == 8 ? string23 + string20 : string23 + string18);
            }
            if (string25 == null) continue;
            StringBuffer stringBuffer2 = new StringBuffer();
            if ((stringArray5[i].equals("SYNONYMS") || stringArray5[i].equals("SYNONYM")) && DB2MetaDataLibrary.con.comm.serverOS == 3) {
                UtilStringFunctions.replaceStringDelimiters(string25, stringArray7, stringBuffer2, false);
            } else {
                UtilStringFunctions.replaceStringDelimiters(string25, stringArray6, stringBuffer2, false);
            }
            string25 = stringBuffer2.toString() + string24;
            if (stringBuffer.length() > 0) {
                stringBuffer.append(UNION);
            }
            stringBuffer.append(string25);
            stringBuffer2 = null;
        }
        String string26 = stringBuffer.toString();
        if (string26 != null && string26.trim().length() > 0) {
            string26 = string26 + string21;
        }
        return string26;
    }

    public String getUDBTableString(BaseResultSetFilterDescriptor baseResultSetFilterDescriptor, BaseResultSetSortDescriptor baseResultSetSortDescriptor, boolean bl) {
        baseResultSetSortDescriptor.setSatisfied();
        String[] stringArray = new String[]{" AND A.TABSCHEMA ", " AND A.TABNAME "};
        String string = (String)baseResultSetFilterDescriptor.getRestriction(1);
        if (string != null && !this.catalogNameMatches(string)) {
            baseResultSetFilterDescriptor.removeAllRestrictions();
            return null;
        }
        string = this.catalogName;
        String[] stringArray2 = DB2MetaDataLibrary.buildParameterSet(baseResultSetFilterDescriptor, 2, 3);
        int[] nArray = new int[]{2, 3};
        String string2 = null;
        String string3 = null;
        string2 = "SELECT DISTINCT '" + string + "', A.TABSCHEMA, A.TABNAME,";
        string3 = DB2MetaDataLibrary.joinParameterSet(baseResultSetFilterDescriptor, stringArray, stringArray2, nArray);
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        String string10 = null;
        if (bl) {
            string4 = " 'TABLE', A.REMARKS,nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1)  FROM " + this.catalogSchema + ".TABLES A, " + this.catalogSchema + ".TABAUTH B WHERE A.TYPE = 'T'" + " AND A.TABNAME = B.TABNAME AND B.GRANTEE IN ('" + this.restrictUser + "','PUBLIC','PUBLIC*') AND (B.SELECTAUTH = 'Y' OR B.SELECTAUTH = 'G')" + " AND A.TABSCHEMA <> 'SYSIBM' AND A.TABSCHEMA <> 'SYSCAT' AND A.TABSCHEMA <> '" + this.catalogSchema + "'";
            string5 = " 'VIEW', A.REMARKS,nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1)  FROM " + this.catalogSchema + ".TABLES A, " + this.catalogSchema + ".TABAUTH B WHERE A.TYPE = 'V' " + " AND A.TABNAME = B.TABNAME AND B.GRANTEE IN ('" + this.restrictUser + "','PUBLIC','PUBLIC*') AND (B.SELECTAUTH = 'Y' OR B.SELECTAUTH = 'G')";
            string6 = " 'ALIAS', A.REMARKS,nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1)  FROM " + this.catalogSchema + ".TABLES A, " + this.catalogSchema + ".TABAUTH B WHERE A.TYPE = 'A' " + " AND A.BASE_TABNAME = B.TABNAME AND B.GRANTEE IN ('" + this.restrictUser + "','PUBLIC','PUBLIC*') AND (B.SELECTAUTH = 'Y' OR B.SELECTAUTH = 'G')";
            string7 = " 'HIERARCHY', A.REMARKS,nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1)  FROM " + this.catalogSchema + ".TABLES A WHERE A.TYPE = 'H'";
            string8 = " 'NICKNAME', A.REMARKS,nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1)  FROM " + this.catalogSchema + ".TABLES A WHERE A.TYPE = 'N'";
            string9 = " 'SUMMARY', A.REMARKS,nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1)  FROM " + this.catalogSchema + ".TABLES A WHERE A.TYPE = 'S'";
            string10 = " 'SYSTEM TABLE', A.REMARKS,nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1)  FROM " + this.catalogSchema + ".TABLES A WHERE A.TABSCHEMA = '" + this.catalogSchema + "'";
        } else {
            string4 = " 'TABLE', A.REMARKS,nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1) FROM " + this.catalogSchema + ".TABLES A WHERE A.TYPE = 'T'" + " AND A.TABSCHEMA <> 'SYSIBM' AND A.TABSCHEMA <> 'SYSCAT' AND A.TABSCHEMA <> '" + this.catalogSchema + "'";
            string5 = " 'VIEW', A.REMARKS,nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1) FROM " + this.catalogSchema + ".TABLES A WHERE A.TYPE = 'V'";
            string6 = " 'ALIAS', A.REMARKS,nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1) FROM " + this.catalogSchema + ".TABLES A WHERE A.TYPE = 'A'";
            string7 = " 'HIERARCHY', A.REMARKS,nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1) FROM " + this.catalogSchema + ".TABLES A WHERE A.TYPE = 'H'";
            string8 = " 'NICKNAME', A.REMARKS,nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1) FROM " + this.catalogSchema + ".TABLES A WHERE A.TYPE = 'N'";
            string9 = " 'SUMMARY', A.REMARKS,nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1) FROM " + this.catalogSchema + ".TABLES A WHERE A.TYPE = 'S'";
            string10 = " 'SYSTEM TABLE', A.REMARKS,nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1) FROM " + this.catalogSchema + ".TABLES A WHERE A.TABSCHEMA = '" + this.catalogSchema + "'";
        }
        String string11 = " ORDER BY 4, 2, 3 FOR FETCH ONLY";
        String[] stringArray3 = (String[])baseResultSetFilterDescriptor.getRestriction(4);
        baseResultSetFilterDescriptor.removeAllRestrictions();
        String string12 = string2;
        String string13 = string3;
        if (string13.indexOf(" LIKE ") > 0) {
            string13 = string13 + " ESCAPE '\\'";
        }
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl2 = false;
        if (stringArray3 == null) {
            stringArray3 = this.getTableTypeNames();
        }
        String string14 = null;
        for (int i = 0; i < stringArray3.length; ++i) {
            string14 = null;
            if (stringArray3[i].equals("TABLE")) {
                string14 = string12 + string4;
            } else if (stringArray3[i].equals("VIEW")) {
                string14 = string12 + string5;
            } else if (stringArray3[i].equals("ALIAS")) {
                if (!bl2) {
                    string14 = string12 + string6;
                    bl2 = true;
                }
            } else if (stringArray3[i].equals("SYNONYMS") || stringArray3[i].equals("SYNONYM")) {
                if (!bl2) {
                    string14 = string12 + string6;
                }
                bl2 = true;
            } else if (stringArray3[i].equals("NICKNAME")) {
                string14 = string12 + string8;
            } else if (stringArray3[i].equals("SUMMARY TABLE")) {
                string14 = string12 + string9;
            } else if (stringArray3[i].equals("HIERARCHY TABLE")) {
                string14 = string12 + string7;
            } else if (stringArray3[i].equals("SYSTEM TABLE")) {
                string14 = string12 + string10;
            }
            if (string14 == null) continue;
            string14 = string14 + string13;
            if (stringBuffer.length() > 0) {
                stringBuffer.append(UNION);
            }
            stringBuffer.append(string14);
        }
        String string15 = stringBuffer.toString();
        if (string15 != null && string15.trim().length() > 0) {
            string15 = string15 + string11;
        }
        return string15;
    }

    public String getUDBColumnString(BaseResultSetFilterDescriptor baseResultSetFilterDescriptor, BaseResultSetSortDescriptor baseResultSetSortDescriptor) {
        baseResultSetSortDescriptor.setSatisfied();
        String string = (String)baseResultSetFilterDescriptor.getRestriction(1);
        if (string != null && !this.catalogNameMatches(string)) {
            baseResultSetFilterDescriptor.removeAllRestrictions();
            return null;
        }
        string = this.catalogName;
        String[] stringArray = new String[]{" AND TABSCHEMA ", " AND TABNAME ", " AND COLNAME "};
        String[] stringArray2 = DB2MetaDataLibrary.buildParameterSet(baseResultSetFilterDescriptor, 2, 4);
        int[] nArray = new int[]{2, 3, 4};
        String string2 = "SELECT '" + string + "', TABSCHEMA, TABNAME, COLNAME, 0, TYPENAME," + " LENGTH, 0, SCALE, 10, 1, REMARKS, DEFAULT, 0," + " 0, 0, COLNO+1, 'YES',nullif(1,1),nullif(1,1),nullif(1,1)" + ",nullif(1,1), CODEPAGE FROM " + this.catalogSchema + ".COLUMNS" + " WHERE NULLS LIKE '%Y%'";
        String string3 = "SELECT '" + string + "', TABSCHEMA, TABNAME, COLNAME, 0, TYPENAME," + " LENGTH, 0, SCALE, 10, 0, REMARKS, DEFAULT, 0," + " 0, 0, COLNO+1, 'NO',nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1), CODEPAGE" + " FROM " + this.catalogSchema + ".COLUMNS" + " WHERE NULLS LIKE '%N%'";
        String string4 = DB2MetaDataLibrary.joinParameterSet(baseResultSetFilterDescriptor, stringArray, stringArray2, nArray);
        String string5 = " ORDER BY 2, 3, 17 FOR FETCH ONLY";
        baseResultSetFilterDescriptor.removeAllRestrictions();
        if (string4.indexOf(" LIKE ") > 0) {
            string4 = string4 + " ESCAPE '\\'";
        }
        String string6 = null;
        if (DB2MetaDataLibrary.con.catalogIncludesSynonyms) {
            String[] stringArray3 = new String[]{" AND B.TABSCHEMA ", " AND B.TABNAME ", " AND A.COLNAME "};
            String string7 = "SELECT '" + string + "', B.TABSCHEMA, B.TABNAME, A.COLNAME, 0, A.TYPENAME," + " A.LENGTH, 0, A.SCALE, 10, 1, A.REMARKS, A.DEFAULT, 0," + " 0, 0, A.COLNO+1, 'YES',nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1), A.CODEPAGE" + " FROM " + this.catalogSchema + ".COLUMNS A, " + this.catalogSchema + ".TABLES B " + " WHERE NULLS LIKE '%Y%' AND B.BASE_TABNAME=A.TABNAME  AND A.TABSCHEMA=B.BASE_TABSCHEMA";
            String string8 = "SELECT '" + string + "', B.TABSCHEMA, B.TABNAME, A.COLNAME, 0, A.TYPENAME," + " A.LENGTH, 0, A.SCALE, 10, 0, A.REMARKS, A.DEFAULT, 0," + " 0, 0, A.COLNO+1, 'NO',nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1), A.CODEPAGE" + " FROM " + this.catalogSchema + ".COLUMNS A, " + this.catalogSchema + ".TABLES B " + " WHERE NULLS LIKE '%N%' AND B.BASE_TABNAME=A.TABNAME  AND A.TABSCHEMA=B.BASE_TABSCHEMA";
            String string9 = DB2MetaDataLibrary.joinParameterSet(baseResultSetFilterDescriptor, stringArray3, stringArray2, nArray);
            string6 = string2 + string4 + UNION + string7 + string9 + UNION_ALL + string3 + string4 + UNION + string8 + string9 + string5;
        } else {
            string6 = string2 + string4 + UNION_ALL + string3 + string4 + string5;
        }
        return string6;
    }

    public String getUDBProcedureString(BaseResultSetFilterDescriptor baseResultSetFilterDescriptor, BaseResultSetSortDescriptor baseResultSetSortDescriptor) {
        baseResultSetSortDescriptor.setSatisfied();
        String string = (String)baseResultSetFilterDescriptor.getRestriction(1);
        if (string != null && !this.catalogNameMatches(string)) {
            baseResultSetFilterDescriptor.removeAllRestrictions();
            return null;
        }
        string = this.catalogName;
        String[] stringArray = new String[]{" AND PROCSCHEMA ", " AND PROCNAME "};
        String[] stringArray2 = DB2MetaDataLibrary.buildParameterSet(baseResultSetFilterDescriptor, 2, 3);
        int[] nArray = new int[]{2, 3};
        String string2 = "SELECT '', PROCSCHEMA, PROCNAME, 0, 0, 0, REMARKS, 1 FROM " + this.catalogSchema + ".PROCEDURES WHERE RESULT_SETS = 0 ";
        String string3 = "SELECT '', PROCSCHEMA, PROCNAME, 0, 0, 0, REMARKS, 2 FROM " + this.catalogSchema + ".PROCEDURES WHERE RESULT_SETS > 0 ";
        String string4 = DB2MetaDataLibrary.joinParameterSet(baseResultSetFilterDescriptor, stringArray, stringArray2, nArray);
        String string5 = " ORDER BY 2, 3";
        baseResultSetFilterDescriptor.removeAllRestrictions();
        if (string4.indexOf(" LIKE ") > 0) {
            string4 = string4 + " ESCAPE '\\'";
        }
        String string6 = string2 + string4 + UNION_ALL + string3 + string4 + string5;
        return string6;
    }

    public String getUDBProcedureColumnsString(BaseResultSetFilterDescriptor baseResultSetFilterDescriptor, BaseResultSetSortDescriptor baseResultSetSortDescriptor) {
        Object object;
        String string = (String)baseResultSetFilterDescriptor.getRestriction(1);
        if (string != null && !this.catalogNameMatches(string)) {
            baseResultSetFilterDescriptor.removeAllRestrictions();
            return null;
        }
        string = this.catalogName;
        String string2 = null;
        if (this.useSort && baseResultSetSortDescriptor.getSortCount() > 0) {
            string2 = " ORDER BY ";
            for (int i = 0; i < baseResultSetSortDescriptor.getSortCount(); ++i) {
                int n = baseResultSetSortDescriptor.getSortColumnOrdinal(i);
                if (n <= 0) continue;
                object = String.valueOf(n);
                if (i > 0) {
                    string2 = string2 + ",";
                }
                string2 = string2 + (String)object;
            }
            string2 = string2 + " FOR FETCH ONLY";
        }
        baseResultSetSortDescriptor.setSatisfied();
        String[] stringArray = new String[]{" AND PROCSCHEMA ", " AND PROCNAME ", " AND PARMNAME "};
        String[] stringArray2 = DB2MetaDataLibrary.buildParameterSet(baseResultSetFilterDescriptor, 2, 4);
        object = new int[]{2, 3, 4};
        String string3 = DB2MetaDataLibrary.joinParameterSet(baseResultSetFilterDescriptor, stringArray, stringArray2, (int[])object);
        String string4 = "SELECT '', PROCSCHEMA, PROCNAME, PARMNAME, 1, ORDINAL, TYPENAME, LENGTH, LENGTH, SCALE, 10,0, ' ' FROM " + this.catalogSchema + ".PROCPARMS WHERE NULLS LIKE '%N%' AND PARM_MODE LIKE '%IN%' AND NOT (PARM_MODE IN ('INOUT'))";
        String string5 = "SELECT '', PROCSCHEMA, PROCNAME, PARMNAME, 1, ORDINAL, TYPENAME, LENGTH, LENGTH, SCALE, 10,1, ' ' FROM " + this.catalogSchema + ".PROCPARMS WHERE NULLS LIKE '%Y%' AND PARM_MODE LIKE '%IN%' AND NOT (PARM_MODE IN ('INOUT'))";
        String string6 = "SELECT '', PROCSCHEMA, PROCNAME, PARMNAME, 4, ORDINAL, TYPENAME, LENGTH, LENGTH, SCALE, 10,0, ' ' FROM " + this.catalogSchema + ".PROCPARMS WHERE NULLS LIKE '%N%' AND PARM_MODE LIKE 'OUT%'";
        String string7 = "SELECT '', PROCSCHEMA, PROCNAME, PARMNAME, 4, ORDINAL, TYPENAME, LENGTH, LENGTH, SCALE, 10,1, ' ' FROM " + this.catalogSchema + ".PROCPARMS WHERE NULLS LIKE '%Y%' AND PARM_MODE LIKE 'OUT%'";
        String string8 = "SELECT '', PROCSCHEMA, PROCNAME, PARMNAME, 2, ORDINAL, TYPENAME, LENGTH, LENGTH, SCALE, 10,0, ' ' FROM " + this.catalogSchema + ".PROCPARMS WHERE NULLS LIKE '%N%' AND PARM_MODE LIKE 'INOUT%'";
        String string9 = "SELECT '', PROCSCHEMA, PROCNAME, PARMNAME, 2, ORDINAL, TYPENAME, LENGTH, LENGTH, SCALE, 10,1, ' ' FROM " + this.catalogSchema + ".PROCPARMS WHERE NULLS LIKE '%Y%' AND PARM_MODE LIKE 'INOUT%'";
        if (string2 == null) {
            string2 = " ORDER BY 2, 3, 6 FOR FETCH ONLY";
        }
        if (string3.indexOf(" LIKE ") > 0) {
            string3 = string3 + " ESCAPE '\\'";
        }
        baseResultSetFilterDescriptor.removeAllRestrictions();
        String string10 = string4 + string3 + UNION_ALL + string5 + string3 + UNION_ALL + string8 + string3 + UNION_ALL + string9 + string3 + UNION_ALL + string6 + string3 + UNION_ALL + string7 + string3 + string2;
        return string10;
    }

    public String getUDBSchemaString(BaseResultSetFilterDescriptor baseResultSetFilterDescriptor, BaseResultSetSortDescriptor baseResultSetSortDescriptor) {
        baseResultSetSortDescriptor.setSatisfied();
        String string = "select rtrim(schemaname),nullif(1,1) from " + this.catalogSchema + ".schemata ORDER BY 1 FOR FETCH ONLY";
        return string;
    }

    public String getUDBCatalogString(BaseResultSetFilterDescriptor baseResultSetFilterDescriptor, BaseResultSetSortDescriptor baseResultSetSortDescriptor) {
        baseResultSetSortDescriptor.setSatisfied();
        String string = "SELECT DISTINCT '" + this.catalogName + "' FROM " + this.catalogSchema + ".TABLES ORDER BY 1 FOR FETCH ONLY";
        return string;
    }

    public String getUDBColumnPrivilegeString(BaseResultSetFilterDescriptor baseResultSetFilterDescriptor, BaseResultSetSortDescriptor baseResultSetSortDescriptor) {
        baseResultSetSortDescriptor.setSatisfied();
        String string = (String)baseResultSetFilterDescriptor.getRestriction(1);
        if (string != null && !this.catalogNameMatches(string)) {
            baseResultSetFilterDescriptor.removeAllRestrictions();
            return null;
        }
        string = this.catalogName;
        String[] stringArray = new String[]{" AND C.TABSCHEMA ", " AND C.TABNAME ", " AND T.COLNAME "};
        String[] stringArray2 = DB2MetaDataLibrary.buildParameterSet(baseResultSetFilterDescriptor, 2, 4);
        int[] nArray = new int[]{2, 3, 4};
        String string2 = "SELECT '" + string + "',C.TABSCHEMA, C.TABNAME, T.COLNAME, C.GRANTOR, C.GRANTEE, 'UPDATE', 'YES'" + " FROM " + this.catalogSchema + ".COLAUTH C, " + this.catalogSchema + ".COLUMNS T WHERE C.COLNAME = T.COLNAME AND C.TABNAME = T.TABNAME AND C.PRIVTYPE = 'U' AND C.GRANTABLE = 'G'";
        String string3 = "SELECT '" + string + "',C.TABSCHEMA, C.TABNAME, T.COLNAME, C.GRANTOR, C.GRANTEE, 'UPDATE', 'NO'" + " FROM " + this.catalogSchema + ".COLAUTH C, " + this.catalogSchema + ".COLUMNS T WHERE C.COLNAME = T.COLNAME AND C.TABNAME = T.TABNAME AND C.PRIVTYPE = 'U' AND C.GRANTABLE = 'N'";
        String string4 = "SELECT '" + string + "',C.TABSCHEMA, C.TABNAME, T.COLNAME, C.GRANTOR, C.GRANTEE, 'REFERENCE', 'YES'" + " FROM " + this.catalogSchema + ".COLAUTH C, " + this.catalogSchema + ".COLUMNS T WHERE C.COLNAME = T.COLNAME AND C.TABNAME = T.TABNAME AND C.PRIVTYPE = 'R' AND C.GRANTABLE = 'G'";
        String string5 = "SELECT '" + string + "',C.TABSCHEMA, C.TABNAME, T.COLNAME, C.GRANTOR, C.GRANTEE, 'REFERENCE', 'NO'" + " FROM " + this.catalogSchema + ".COLAUTH C, " + this.catalogSchema + ".COLUMNS T WHERE C.COLNAME = T.COLNAME AND C.TABNAME = T.TABNAME AND C.PRIVTYPE = 'R' AND C.GRANTABLE = 'N'";
        String string6 = "SELECT '" + string + "',C.TABSCHEMA, C.TABNAME, T.COLNAME, C.GRANTOR, C.GRANTEE, 'SELECT', 'YES'" + " FROM " + this.catalogSchema + ".TABAUTH C, " + this.catalogSchema + ".COLUMNS T WHERE C.TABSCHEMA = T.TABSCHEMA AND C.TABNAME = T.TABNAME AND C.SELECTAUTH = 'G'";
        String string7 = "SELECT '" + string + "',C.TABSCHEMA, C.TABNAME, T.COLNAME, C.GRANTOR, C.GRANTEE, 'SELECT', 'NO'" + " FROM " + this.catalogSchema + ".TABAUTH C, " + this.catalogSchema + ".COLUMNS T WHERE C.TABSCHEMA = T.TABSCHEMA AND C.TABNAME = T.TABNAME AND C.SELECTAUTH = 'Y'";
        String string8 = "SELECT '" + string + "',C.TABSCHEMA, C.TABNAME, T.COLNAME, C.GRANTOR, C.GRANTEE, 'INSERT', 'YES'" + " FROM " + this.catalogSchema + ".TABAUTH C, " + this.catalogSchema + ".COLUMNS T WHERE C.TABSCHEMA = T.TABSCHEMA AND C.TABNAME = T.TABNAME AND C.INSERTAUTH = 'G'";
        String string9 = "SELECT '" + string + "',C.TABSCHEMA, C.TABNAME, T.COLNAME, C.GRANTOR, C.GRANTEE, 'INSERT', 'NO'" + " FROM " + this.catalogSchema + ".TABAUTH C, " + this.catalogSchema + ".COLUMNS T WHERE C.TABSCHEMA = T.TABSCHEMA AND C.TABNAME = T.TABNAME AND C.INSERTAUTH = 'Y'";
        String string10 = "SELECT '" + string + "',C.TABSCHEMA, C.TABNAME, T.COLNAME, C.GRANTOR, C.GRANTEE, 'DELETE', 'YES'" + " FROM " + this.catalogSchema + ".TABAUTH C, " + this.catalogSchema + ".COLUMNS T WHERE C.TABSCHEMA = T.TABSCHEMA AND C.TABNAME = T.TABNAME AND C.DELETEAUTH = 'G'";
        String string11 = "SELECT '" + string + "',C.TABSCHEMA, C.TABNAME, T.COLNAME, C.GRANTOR, C.GRANTEE, 'DELETE', 'NO'" + " FROM " + this.catalogSchema + ".TABAUTH C, " + this.catalogSchema + ".COLUMNS T WHERE C.TABSCHEMA = T.TABSCHEMA AND C.TABNAME = T.TABNAME AND C.DELETEAUTH = 'Y'";
        String string12 = DB2MetaDataLibrary.joinParameterSet(baseResultSetFilterDescriptor, stringArray, stringArray2, nArray);
        String string13 = " ORDER BY 4, 7 FOR FETCH ONLY";
        baseResultSetFilterDescriptor.removeAllRestrictions();
        if (string12.indexOf(" LIKE ") > 0) {
            string12 = string12 + " ESCAPE '\\'";
        }
        String string14 = string2 + string12 + UNION_ALL + string3 + string12 + UNION_ALL + string4 + string12 + UNION_ALL + string5 + string12 + UNION_ALL + string6 + string12 + UNION_ALL + string7 + string12 + UNION_ALL + string8 + string12 + UNION_ALL + string9 + string12 + UNION_ALL + string10 + string12 + UNION_ALL + string11 + string12 + string13;
        return string14;
    }

    public String getUDBTablePrivilegeString(BaseResultSetFilterDescriptor baseResultSetFilterDescriptor, BaseResultSetSortDescriptor baseResultSetSortDescriptor) {
        baseResultSetSortDescriptor.setSatisfied();
        String string = (String)baseResultSetFilterDescriptor.getRestriction(1);
        if (string != null && !this.catalogNameMatches(string)) {
            baseResultSetFilterDescriptor.removeAllRestrictions();
            return null;
        }
        string = this.catalogName;
        String[] stringArray = new String[]{" AND TABSCHEMA ", " AND TABNAME "};
        String[] stringArray2 = DB2MetaDataLibrary.buildParameterSet(baseResultSetFilterDescriptor, 2, 3);
        int[] nArray = new int[]{2, 3};
        String string2 = DB2MetaDataLibrary.joinParameterSet(baseResultSetFilterDescriptor, stringArray, stringArray2, nArray);
        String string3 = " ORDER BY 2, 3, 6 FOR FETCH ONLY";
        String string4 = "SELECT '" + string + "',TABSCHEMA,TABNAME,GRANTOR,GRANTEE,' ',' ' FROM " + this.catalogSchema + ".TABAUTH" + " WHERE LENGTH(TABNAME) > 0";
        String string5 = "SELECT '" + string + "',TABSCHEMA,TABNAME,GRANTOR,GRANTEE,'ALTER','YES' FROM " + this.catalogSchema + ".TABAUTH" + " WHERE ALTERAUTH LIKE '%Y%' AND CONTROLAUTH LIKE '%Y%'";
        String string6 = "SELECT '" + string + "',TABSCHEMA,TABNAME,GRANTOR,GRANTEE,'ALTER','NO' FROM " + this.catalogSchema + ".TABAUTH" + " WHERE ALTERAUTH LIKE '%G%' AND CONTROLAUTH LIKE '%N%'";
        String string7 = "SELECT '" + string + "',TABSCHEMA,TABNAME,GRANTOR,GRANTEE,'DELETE','YES' FROM " + this.catalogSchema + ".TABAUTH" + " WHERE DELETEAUTH LIKE '%Y%' AND CONTROLAUTH LIKE '%Y%'";
        String string8 = "SELECT '" + string + "',TABSCHEMA,TABNAME,GRANTOR,GRANTEE,'DELETE','NO' FROM " + this.catalogSchema + ".TABAUTH" + " WHERE DELETEAUTH LIKE '%G%' AND CONTROLAUTH LIKE '%N%'";
        String string9 = "SELECT '" + string + "',TABSCHEMA,TABNAME,GRANTOR,GRANTEE,'INDEX','YES' FROM " + this.catalogSchema + ".TABAUTH" + " WHERE INDEXAUTH LIKE '%Y%' AND CONTROLAUTH LIKE '%Y%'";
        String string10 = "SELECT '" + string + "',TABSCHEMA,TABNAME,GRANTOR,GRANTEE,'INDEX','NO' FROM " + this.catalogSchema + ".TABAUTH" + " WHERE INDEXAUTH LIKE '%G%' AND CONTROLAUTH LIKE '%N%'";
        String string11 = "SELECT '" + string + "',TABSCHEMA,TABNAME,GRANTOR,GRANTEE,'INSERT','YES' FROM " + this.catalogSchema + ".TABAUTH" + " WHERE INSERTAUTH LIKE '%Y%' AND CONTROLAUTH LIKE '%Y%'";
        String string12 = "SELECT '" + string + "',TABSCHEMA,TABNAME,GRANTOR,GRANTEE,'INSERT','NO' FROM " + this.catalogSchema + ".TABAUTH" + " WHERE INSERTAUTH LIKE '%G%' AND CONTROLAUTH LIKE '%N%'";
        String string13 = "SELECT '" + string + "',TABSCHEMA,TABNAME,GRANTOR,GRANTEE,'REFERENCE','YES' FROM " + this.catalogSchema + ".TABAUTH" + " WHERE REFAUTH LIKE '%Y%' AND CONTROLAUTH LIKE '%Y%'";
        String string14 = "SELECT '" + string + "',TABSCHEMA,TABNAME,GRANTOR,GRANTEE,'REFERENCE','NO' FROM " + this.catalogSchema + ".TABAUTH" + " WHERE REFAUTH LIKE '%G%' AND CONTROLAUTH LIKE '%N%'";
        String string15 = "SELECT '" + string + "',TABSCHEMA,TABNAME,GRANTOR,GRANTEE,'SELECT','YES' FROM " + this.catalogSchema + ".TABAUTH" + " WHERE SELECTAUTH LIKE '%Y%' AND CONTROLAUTH LIKE '%Y%'";
        String string16 = "SELECT '" + string + "',TABSCHEMA,TABNAME,GRANTOR,GRANTEE,'SELECT','NO' FROM " + this.catalogSchema + ".TABAUTH" + " WHERE SELECTAUTH LIKE '%G%' AND CONTROLAUTH LIKE '%N%'";
        String string17 = "SELECT '" + string + "',TABSCHEMA,TABNAME,GRANTOR,GRANTEE,'UPDATE','YES' FROM " + this.catalogSchema + ".TABAUTH" + " WHERE UPDATEAUTH LIKE '%Y%' AND CONTROLAUTH LIKE '%Y%'";
        String string18 = "SELECT '" + string + "',TABSCHEMA,TABNAME,GRANTOR,GRANTEE,'UPDATE','NO' FROM " + this.catalogSchema + ".TABAUTH" + " WHERE UPDATEAUTH LIKE '%G%' AND CONTROLAUTH LIKE '%N%'";
        baseResultSetFilterDescriptor.removeAllRestrictions();
        if (string2.indexOf(" LIKE ") > 0) {
            string2 = string2 + " ESCAPE '\\'";
        }
        String string19 = string4 + string2 + " UNION " + string5 + string2 + UNION_ALL + string6 + string2 + UNION_ALL + string7 + string2 + UNION_ALL + string8 + string2 + UNION_ALL + string9 + string2 + UNION_ALL + string10 + string2 + UNION_ALL + string11 + string2 + UNION_ALL + string12 + string2 + UNION_ALL + string13 + string2 + UNION_ALL + string14 + string2 + UNION_ALL + string15 + string2 + UNION_ALL + string16 + string2 + UNION_ALL + string17 + string2 + UNION_ALL + string18 + string2 + string3;
        return string19;
    }

    public String getUDBBestRowIdentifierString(BaseResultSetFilterDescriptor baseResultSetFilterDescriptor, BaseResultSetSortDescriptor baseResultSetSortDescriptor) {
        baseResultSetSortDescriptor.setSatisfied();
        String[] stringArray = new String[]{" CT.TABSCHEMA ", " AND CT.TABNAME "};
        String[] stringArray2 = DB2MetaDataLibrary.buildParameterSet(baseResultSetFilterDescriptor, 10, 11);
        int[] nArray = new int[]{10, 11};
        int n = (Integer)baseResultSetFilterDescriptor.getRestriction(1);
        boolean bl = (Boolean)baseResultSetFilterDescriptor.getRestriction(12);
        String string = "";
        String string2 = "";
        String string3 = "SELECT 0, CT.COLNAME, 0, CT.TYPENAME, CT.LENGTH, 0, CT.SCALE, 0 FROM  " + this.catalogSchema + ".COLUMNS CT WHERE ";
        String string4 = "SELECT 1, CT.COLNAME, 0, CT.TYPENAME, CT.LENGTH, 0, CT.SCALE, 0 FROM  " + this.catalogSchema + ".COLUMNS CT WHERE CT.NULLS = 'N' AND ";
        String string5 = "SELECT 1, CT.COLNAME, 0, CT.TYPENAME, CT.LENGTH, 0, CT.SCALE,1 FROM " + this.catalogSchema + ".COLUMNS CT, " + this.catalogSchema + ".KEYCOLUSE CU WHERE CU.TABSCHEMA = CT.TABSCHEMA AND CU.TABNAME = CT.TABNAME AND CU.COLNAME = CT.COLNAME AND ";
        String string6 = "SELECT 2, CT.COLNAME, 0, CT.TYPENAME, CT.LENGTH, 0, CT.SCALE, 1 FROM " + this.catalogSchema + ".INDEXES IT, " + this.catalogSchema + ".COLUMNS CT WHERE IT.TABSCHEMA = CT.TABSCHEMA AND IT.TABNAME = CT.TABNAME AND AND (IT.UNIQUERULE = 'P' OR IT.UNIQUERULE = 'U') AND ";
        String string7 = DB2MetaDataLibrary.joinParameterSet(baseResultSetFilterDescriptor, stringArray, stringArray2, nArray);
        String string8 = " ORDER BY 1 FOR FETCH ONLY";
        baseResultSetFilterDescriptor.removeAllRestrictions();
        String string9 = null;
        string9 = bl && n == 0 ? string3 + string7 : string4 + string7;
        if (n == 1) {
            string9 = string9 + UNION_ALL + string5 + string7;
        }
        if (n == 2) {
            string9 = string9 + UNION_ALL + string6 + string7;
        }
        string9 = string9 + string8;
        return string9;
    }

    public String getUDBVersionColumnString(BaseResultSetFilterDescriptor baseResultSetFilterDescriptor, BaseResultSetSortDescriptor baseResultSetSortDescriptor) {
        baseResultSetSortDescriptor.setSatisfied();
        String[] stringArray = new String[]{" AND TABSCHEMA ", " AND TABNAME "};
        String string = (String)baseResultSetFilterDescriptor.getRestriction(1);
        if (string != null && !this.catalogNameMatches(string)) {
            baseResultSetFilterDescriptor.removeAllRestrictions();
            return null;
        }
        string = this.catalogName;
        String[] stringArray2 = DB2MetaDataLibrary.buildParameterSet(baseResultSetFilterDescriptor, 10, 11);
        int[] nArray = new int[]{10, 11};
        String string2 = DB2MetaDataLibrary.joinParameterSet(baseResultSetFilterDescriptor, stringArray, stringArray2, nArray);
        baseResultSetFilterDescriptor.removeAllRestrictions();
        String string3 = "SELECT 0, COLNAME, 0, TYPENAME, LENGTH, 0, SCALE, 0 FROM  " + this.catalogSchema + ".COLUMNS WHERE NULLS = 'N' AND GENERATED = 'A' ";
        String string4 = string3 + string2;
        return string4;
    }

    public String getUDBPrimaryKeysString(BaseResultSetFilterDescriptor baseResultSetFilterDescriptor, BaseResultSetSortDescriptor baseResultSetSortDescriptor) {
        baseResultSetSortDescriptor.setSatisfied();
        String string = (String)baseResultSetFilterDescriptor.getRestriction(1);
        if (string != null && !this.catalogNameMatches(string)) {
            baseResultSetFilterDescriptor.removeAllRestrictions();
            return null;
        }
        string = this.catalogName;
        String[] stringArray = new String[]{" AND IT.TABSCHEMA ", " AND IT.TABNAME "};
        String[] stringArray2 = DB2MetaDataLibrary.buildParameterSet(baseResultSetFilterDescriptor, 2, 3);
        int[] nArray = new int[]{2, 3};
        String string2 = "SELECT DISTINCT '" + string + "', IT.TABSCHEMA, IT.TABNAME, KT.COLNAME, KT.COLSEQ, IT.INDNAME" + " FROM " + this.catalogSchema + ".INDEXCOLUSE KT, " + this.catalogSchema + ".INDEXES IT" + " WHERE IT.UNIQUERULE = 'P' AND IT.INDSCHEMA = KT.INDSCHEMA AND KT.INDNAME = IT.INDNAME";
        String string3 = DB2MetaDataLibrary.joinParameterSet(baseResultSetFilterDescriptor, stringArray, stringArray2, nArray);
        String string4 = " ORDER BY 4 FOR FETCH ONLY";
        baseResultSetFilterDescriptor.removeAllRestrictions();
        String string5 = string2 + string3 + string4;
        return string5;
    }

    public String getUDBExportedKeysString(BaseResultSetFilterDescriptor baseResultSetFilterDescriptor, BaseResultSetSortDescriptor baseResultSetSortDescriptor) {
        baseResultSetSortDescriptor.setSatisfied();
        String string = (String)baseResultSetFilterDescriptor.getRestriction(1);
        if (string != null && !this.catalogNameMatches(string)) {
            baseResultSetFilterDescriptor.removeAllRestrictions();
            return null;
        }
        string = this.catalogName;
        String[] stringArray = new String[]{" AND IT.DEFINER ", " AND IT.TABNAME "};
        String[] stringArray2 = DB2MetaDataLibrary.buildParameterSet(baseResultSetFilterDescriptor, 2, 3);
        int[] nArray = new int[]{2, 3};
        String string2 = "SELECT '" + string + "', PT.TABSCHEMA, PT.TABNAME, PT.COLNAME," + " '" + string + "', FT.TABSCHEMA, FT.TABNAME, FT.COLNAME, PT.COLSEQ," + 3 + ", " + 3 + "," + " RT.CONSTNAME, IT.INDNAME, " + 7 + " FROM " + this.catalogSchema + ".REFERENCES RT, " + this.catalogSchema + ".KEYCOLUSE PT, " + this.catalogSchema + ".KEYCOLUSE FT, " + this.catalogSchema + ".INDEXES IT" + " WHERE IT.UNIQUERULE = 'P' AND IT.DEFINER = PT.TABSCHEMA AND IT.TABNAME = PT.TABNAME" + " AND PT.TABSCHEMA = RT.REFTABSCHEMA AND PT.TABNAME = RT.REFTABNAME" + " AND FT.TABSCHEMA = RT.TABSCHEMA AND FT.TABNAME = RT.TABNAME" + " AND PT.COLSEQ = FT.COLSEQ" + " AND RT.DELETERULE = 'A'";
        String string3 = "SELECT '" + string + "', PT.TABSCHEMA, PT.TABNAME, PT.COLNAME," + " '" + string + "', FT.TABSCHEMA, FT.TABNAME, FT.COLNAME, PT.COLSEQ," + 3 + ", " + 0 + "," + " RT.CONSTNAME, IT.INDNAME, " + 7 + " FROM " + this.catalogSchema + ".REFERENCES RT, " + this.catalogSchema + ".KEYCOLUSE PT, " + this.catalogSchema + ".KEYCOLUSE FT, " + this.catalogSchema + ".INDEXES IT" + " WHERE IT.UNIQUERULE = 'P' AND IT.DEFINER = PT.TABSCHEMA AND IT.TABNAME = PT.TABNAME" + " AND PT.TABSCHEMA = RT.REFTABSCHEMA AND PT.TABNAME = RT.REFTABNAME" + " AND FT.TABSCHEMA = RT.TABSCHEMA AND FT.TABNAME = RT.TABNAME" + " AND PT.COLSEQ = FT.COLSEQ" + " AND RT.DELETERULE = 'C'";
        String string4 = "SELECT '" + string + "', PT.TABSCHEMA, PT.TABNAME, PT.COLNAME," + " '" + string + "', FT.TABSCHEMA, FT.TABNAME, FT.COLNAME, PT.COLSEQ," + 3 + ", " + 2 + "," + " RT.CONSTNAME, IT.INDNAME, " + 7 + " FROM " + this.catalogSchema + ".REFERENCES RT, " + this.catalogSchema + ".KEYCOLUSE PT, " + this.catalogSchema + ".KEYCOLUSE FT, " + this.catalogSchema + ".INDEXES IT" + " WHERE IT.UNIQUERULE = 'P' AND IT.DEFINER = PT.TABSCHEMA AND IT.TABNAME = PT.TABNAME" + " AND PT.TABSCHEMA = RT.REFTABSCHEMA AND PT.TABNAME = RT.REFTABNAME" + " AND FT.TABSCHEMA = RT.TABSCHEMA AND FT.TABNAME = RT.TABNAME" + " AND PT.COLSEQ = FT.COLSEQ" + " AND RT.DELETERULE = 'N'";
        String string5 = "SELECT '" + string + "', PT.TABSCHEMA, PT.TABNAME, PT.COLNAME," + " '" + string + "', FT.TABSCHEMA, FT.TABNAME, FT.COLNAME, PT.COLSEQ," + 3 + ", " + 1 + "," + " RT.CONSTNAME, IT.INDNAME, " + 7 + " FROM " + this.catalogSchema + ".REFERENCES RT, " + this.catalogSchema + ".KEYCOLUSE PT, " + this.catalogSchema + ".KEYCOLUSE FT, " + this.catalogSchema + ".INDEXES IT" + " WHERE IT.UNIQUERULE = 'P' AND IT.DEFINER = PT.TABSCHEMA AND IT.TABNAME = PT.TABNAME" + " AND PT.TABSCHEMA = RT.REFTABSCHEMA AND PT.TABNAME = RT.REFTABNAME" + " AND FT.TABSCHEMA = RT.TABSCHEMA AND FT.TABNAME = RT.TABNAME" + " AND PT.COLSEQ = FT.COLSEQ" + " AND RT.DELETERULE = 'R'";
        String string6 = DB2MetaDataLibrary.joinParameterSet(baseResultSetFilterDescriptor, stringArray, stringArray2, nArray);
        String string7 = " ORDER BY 6, 7, 9 FOR FETCH ONLY";
        baseResultSetFilterDescriptor.removeAllRestrictions();
        String string8 = string2 + string6 + UNION_ALL + string3 + string6 + UNION_ALL + string4 + string6 + UNION_ALL + string5 + string6 + string7;
        return string8;
    }

    public String getUDBImportedKeysString(BaseResultSetFilterDescriptor baseResultSetFilterDescriptor, BaseResultSetSortDescriptor baseResultSetSortDescriptor) {
        baseResultSetSortDescriptor.setSatisfied();
        String string = (String)baseResultSetFilterDescriptor.getRestriction(5);
        if (string != null && !this.catalogNameMatches(string)) {
            baseResultSetFilterDescriptor.removeAllRestrictions();
            return null;
        }
        string = this.catalogName;
        String[] stringArray = new String[]{" AND IT.DEFINER ", " AND FT.TABNAME "};
        String[] stringArray2 = DB2MetaDataLibrary.buildParameterSet(baseResultSetFilterDescriptor, 6, 7);
        int[] nArray = new int[]{6, 7};
        String string2 = "SELECT '" + string + "', PT.TABSCHEMA, PT.TABNAME, PT.COLNAME," + " '" + string + "', FT.TABSCHEMA, FT.TABNAME, FT.COLNAME, PT.COLSEQ," + 3 + ", " + 3 + "," + " RT.CONSTNAME, IT.INDNAME, " + 7 + " FROM " + this.catalogSchema + ".REFERENCES RT, " + this.catalogSchema + ".KEYCOLUSE PT, " + this.catalogSchema + ".KEYCOLUSE FT, " + this.catalogSchema + ".INDEXES IT" + " WHERE IT.UNIQUERULE = 'P' AND IT.DEFINER = PT.TABSCHEMA AND IT.TABNAME = PT.TABNAME" + " AND PT.TABSCHEMA = RT.REFTABSCHEMA AND PT.TABNAME = RT.REFTABNAME" + " AND FT.TABSCHEMA = RT.TABSCHEMA AND FT.TABNAME = RT.TABNAME" + " AND PT.COLSEQ = FT.COLSEQ" + " AND RT.DELETERULE = 'A'";
        String string3 = "SELECT '" + string + "', PT.TABSCHEMA, PT.TABNAME, PT.COLNAME," + " '" + string + "', FT.TABSCHEMA, FT.TABNAME, FT.COLNAME, PT.COLSEQ," + 3 + ", " + 0 + "," + " RT.CONSTNAME, IT.INDNAME, " + 7 + " FROM " + this.catalogSchema + ".REFERENCES RT, " + this.catalogSchema + ".KEYCOLUSE PT, " + this.catalogSchema + ".KEYCOLUSE FT, " + this.catalogSchema + ".INDEXES IT" + " WHERE IT.UNIQUERULE = 'P' AND IT.DEFINER = PT.TABSCHEMA AND IT.TABNAME = PT.TABNAME" + " AND PT.TABSCHEMA = RT.REFTABSCHEMA AND PT.TABNAME = RT.REFTABNAME" + " AND FT.TABSCHEMA = RT.TABSCHEMA AND FT.TABNAME = RT.TABNAME" + " AND PT.COLSEQ = FT.COLSEQ" + " AND RT.DELETERULE = 'C'";
        String string4 = "SELECT '" + string + "', PT.TABSCHEMA, PT.TABNAME, PT.COLNAME," + " '" + string + "', FT.TABSCHEMA, FT.TABNAME, FT.COLNAME, PT.COLSEQ," + 3 + ", " + 2 + "," + " RT.CONSTNAME, IT.INDNAME, " + 7 + " FROM " + this.catalogSchema + ".REFERENCES RT, " + this.catalogSchema + ".KEYCOLUSE PT, " + this.catalogSchema + ".KEYCOLUSE FT, " + this.catalogSchema + ".INDEXES IT" + " WHERE IT.UNIQUERULE = 'P' AND IT.DEFINER = PT.TABSCHEMA AND IT.TABNAME = PT.TABNAME" + " AND PT.TABSCHEMA = RT.REFTABSCHEMA AND PT.TABNAME = RT.REFTABNAME" + " AND FT.TABSCHEMA = RT.TABSCHEMA AND FT.TABNAME = RT.TABNAME" + " AND PT.COLSEQ = FT.COLSEQ" + " AND RT.DELETERULE = 'N'";
        String string5 = "SELECT '" + string + "', PT.TABSCHEMA, PT.TABNAME, PT.COLNAME," + " '" + string + "', FT.TABSCHEMA, FT.TABNAME, FT.COLNAME, PT.COLSEQ," + 3 + ", " + 1 + "," + " RT.CONSTNAME, IT.INDNAME, " + 7 + " FROM " + this.catalogSchema + ".REFERENCES RT, " + this.catalogSchema + ".KEYCOLUSE PT, " + this.catalogSchema + ".KEYCOLUSE FT, " + this.catalogSchema + ".INDEXES IT" + " WHERE IT.UNIQUERULE = 'P' AND IT.DEFINER = PT.TABSCHEMA AND IT.TABNAME = PT.TABNAME" + " AND PT.TABSCHEMA = RT.REFTABSCHEMA AND PT.TABNAME = RT.REFTABNAME" + " AND FT.TABSCHEMA = RT.TABSCHEMA AND FT.TABNAME = RT.TABNAME" + " AND PT.COLSEQ = FT.COLSEQ" + " AND RT.DELETERULE = 'R'";
        String string6 = DB2MetaDataLibrary.joinParameterSet(baseResultSetFilterDescriptor, stringArray, stringArray2, nArray);
        String string7 = " ORDER BY 2, 3, 9 FOR FETCH ONLY";
        baseResultSetFilterDescriptor.removeAllRestrictions();
        String string8 = string2 + string6 + " UNION " + string3 + string6 + " UNION " + string4 + string6 + " UNION " + string5 + string6 + string7;
        return string8;
    }

    public String getUDBCrossReferenceString(BaseResultSetFilterDescriptor baseResultSetFilterDescriptor, BaseResultSetSortDescriptor baseResultSetSortDescriptor) {
        baseResultSetSortDescriptor.setSatisfied();
        String string = (String)baseResultSetFilterDescriptor.getRestriction(1);
        String string2 = (String)baseResultSetFilterDescriptor.getRestriction(5);
        if (string != null && !this.catalogNameMatches(string) || !this.catalogNameMatches(string2)) {
            baseResultSetFilterDescriptor.removeAllRestrictions();
            return null;
        }
        string = this.catalogName;
        String[] stringArray = new String[]{"", " AND RT.REFTABSCHEMA ", " AND RT.REFTABNAME ", "", " AND RT.TABSCHEMA ", " AND RT.TABNAME "};
        String[] stringArray2 = DB2MetaDataLibrary.buildParameterSet(baseResultSetFilterDescriptor, 0, 0);
        int[] nArray = new int[]{-1, 2, 3, -1, 6, 7};
        String string3 = "SELECT '" + string + "', RT.REFTABSCHEMA, RT.REFTABNAME, RT.PK_COLNAMES," + " '" + string + "', RT.TABSCHEMA, RT.TABNAME, RT.FK_COLNAMES, KT.COLSEQ," + 3 + ", " + 3 + "," + " RT.CONSTNAME, IT.INDNAME, " + 7 + " FROM " + this.catalogSchema + ".REFERENCES RT, " + this.catalogSchema + ".KEYCOLUSE KT, " + this.catalogSchema + ".INDEXES IT" + " WHERE IT.UNIQUERULE = 'P' AND IT.DEFINER = KT.TABSCHEMA AND IT.TABNAME = KT.TABNAME" + " AND KT.TABSCHEMA = RT.REFTABSCHEMA AND KT.TABNAME = RT.REFTABNAME" + " AND RT.DELETERULE = 'A'";
        String string4 = "SELECT '" + string + "', RT.REFTABSCHEMA, RT.REFTABNAME, RT.PK_COLNAMES," + " '" + string + "', RT.TABSCHEMA, RT.TABNAME, RT.FK_COLNAMES, KT.COLSEQ," + 3 + ", " + 0 + "," + " RT.CONSTNAME, IT.INDNAME, " + 7 + " FROM " + this.catalogSchema + ".REFERENCES RT, " + this.catalogSchema + ".KEYCOLUSE KT, " + this.catalogSchema + ".INDEXES IT" + " WHERE IT.UNIQUERULE = 'P' AND IT.DEFINER = KT.TABSCHEMA AND IT.TABNAME = KT.TABNAME" + " AND KT.TABSCHEMA = RT.REFTABSCHEMA AND KT.TABNAME = RT.REFTABNAME" + " AND RT.DELETERULE = 'C'";
        String string5 = "SELECT '" + string + "', RT.REFTABSCHEMA, RT.REFTABNAME, RT.PK_COLNAMES," + " '" + string + "', RT.TABSCHEMA, RT.TABNAME, RT.FK_COLNAMES, KT.COLSEQ," + 3 + ", " + 2 + "," + " RT.CONSTNAME, IT.INDNAME, " + 7 + " FROM " + this.catalogSchema + ".REFERENCES RT, " + this.catalogSchema + ".KEYCOLUSE KT, " + this.catalogSchema + ".INDEXES IT" + " WHERE IT.UNIQUERULE = 'P' AND IT.DEFINER = KT.TABSCHEMA AND IT.TABNAME = KT.TABNAME" + " AND KT.TABSCHEMA = RT.REFTABSCHEMA AND KT.TABNAME = RT.REFTABNAME" + " AND RT.DELETERULE = 'N'";
        String string6 = "SELECT '" + string + "', RT.REFTABSCHEMA, RT.REFTABNAME, RT.PK_COLNAMES," + " '" + string + "', RT.TABSCHEMA, RT.TABNAME, RT.FK_COLNAMES, KT.COLSEQ," + 3 + ", " + 1 + "," + " RT.CONSTNAME, IT.INDNAME, " + 7 + " FROM " + this.catalogSchema + ".REFERENCES RT, " + this.catalogSchema + ".KEYCOLUSE KT, " + this.catalogSchema + ".INDEXES IT" + " WHERE IT.UNIQUERULE = 'P' AND IT.DEFINER = KT.TABSCHEMA AND IT.TABNAME = KT.TABNAME" + " AND KT.TABSCHEMA = RT.REFTABSCHEMA AND KT.TABNAME = RT.REFTABNAME" + " AND RT.DELETERULE = 'R'";
        String string7 = DB2MetaDataLibrary.joinParameterSet(baseResultSetFilterDescriptor, stringArray, stringArray2, nArray);
        String string8 = " ORDER BY 6, 7, 9 FOR FETCH ONLY";
        baseResultSetFilterDescriptor.removeAllRestrictions();
        String string9 = string3 + string7 + UNION_ALL + string4 + string7 + UNION_ALL + string5 + string7 + UNION_ALL + string6 + string7 + string8;
        return string9;
    }

    public String getUDBIndexInfoString(BaseResultSetFilterDescriptor baseResultSetFilterDescriptor, BaseResultSetSortDescriptor baseResultSetSortDescriptor) {
        baseResultSetSortDescriptor.setSatisfied();
        String string = (String)baseResultSetFilterDescriptor.getRestriction(1);
        if (string != null && !this.catalogNameMatches(string)) {
            baseResultSetFilterDescriptor.removeAllRestrictions();
            return null;
        }
        string = this.catalogName;
        String[] stringArray = new String[]{" AND IT.DEFINER ", " AND IT.TABNAME "};
        String[] stringArray2 = new String[]{" AND TABSCHEMA ", " AND TABNAME "};
        String[] stringArray3 = DB2MetaDataLibrary.buildParameterSet(baseResultSetFilterDescriptor, 2, 3);
        int[] nArray = new int[]{2, 3};
        boolean bl = (Boolean)baseResultSetFilterDescriptor.getRestriction(4);
        String string2 = "SELECT '" + string + "', IT.TABSCHEMA, IT.TABNAME, CASE IT.UNIQUERULE WHEN 'D' THEN 1 WHEN '1' THEN 0 WHEN '0' THEN 0 ELSE 0 END CASE," + " ' ', IT.INDNAME, " + 1 + "," + " IU.COLSEQ, IU.COLNAME, IU.COLORDER, IT.UNIQUE_COLCOUNT, IT.SEQUENTIAL_PAGES, ' '" + " FROM " + this.catalogSchema + ".INDEXCOLUSE IU, " + this.catalogSchema + ".INDEXES IT WHERE IU.INDNAME = IT.INDNAME" + " AND IU.INDSCHEMA = IT.INDSCHEMA AND IT.INDEXTYPE = 'CLUS'";
        String string3 = "SELECT '" + string + "', IT.TABSCHEMA, IT.TABNAME, CASE IT.UNIQUERULE WHEN 'D' THEN 1 WHEN '1' THEN 0 WHEN '0' THEN 0 ELSE 0 END CASE," + " ' ', IT.INDNAME, " + 1 + "," + " IU.COLSEQ, IU.COLNAME, IU.COLORDER, IT.UNIQUE_COLCOUNT, IT.SEQUENTIAL_PAGES , ' '" + " FROM " + this.catalogSchema + ".INDEXCOLUSE IU, " + this.catalogSchema + ".INDEXES IT WHERE IU.INDNAME = IT.INDNAME" + " AND IU.INDSCHEMA = IT.INDSCHEMA AND IT.INDEXTYPE = 'CLUS' AND IT.UNIQUERULE = 'U'";
        String string4 = "SELECT '" + string + "', IT.TABSCHEMA, IT.TABNAME, CASE IT.UNIQUERULE WHEN 'D' THEN 1 WHEN '1' THEN 0 WHEN '0' THEN 0 ELSE 0 END CASE," + " ' ', IT.INDNAME, " + 3 + "," + " IU.COLSEQ, IU.COLNAME, IU.COLORDER, IT.UNIQUE_COLCOUNT, IT.SEQUENTIAL_PAGES , ' '" + " FROM " + this.catalogSchema + ".INDEXCOLUSE IU, " + this.catalogSchema + ".INDEXES IT WHERE IU.INDNAME = IT.INDNAME" + " AND IU.INDSCHEMA = IT.INDSCHEMA AND IT.INDEXTYPE = 'REG'";
        String string5 = "SELECT '" + string + "', IT.TABSCHEMA, IT.TABNAME, CASE IT.UNIQUERULE WHEN 'D' THEN 1 WHEN '1' THEN 0 WHEN '0' THEN 0 ELSE 0 END CASE," + " ' ', IT.INDNAME, " + 3 + "," + " IU.COLSEQ, IU.COLNAME, IU.COLORDER, IT.UNIQUE_COLCOUNT, IT.SEQUENTIAL_PAGES , ' '" + " FROM " + this.catalogSchema + ".INDEXCOLUSE IU, " + this.catalogSchema + ".INDEXES IT WHERE IU.INDNAME = IT.INDNAME" + " AND IU.INDSCHEMA = IT.INDSCHEMA AND IT.INDEXTYPE = 'REG' AND IT.UNIQUERULE = 'U'";
        String string6 = DB2MetaDataLibrary.joinParameterSet(baseResultSetFilterDescriptor, stringArray, stringArray3, nArray);
        String string7 = "SELECT '" + string + "', TABSCHEMA, TABNAME, 0," + " NULLIF('',''), NULLIF('',''), " + 0 + "," + " 0, NULLIF('',''), NULLIF('',''), 0, 0, NULLIF('','')" + " FROM " + this.catalogSchema + ".TABLES WHERE TABNAME <> ' '";
        String string8 = DB2MetaDataLibrary.joinParameterSet(baseResultSetFilterDescriptor, stringArray2, stringArray3, nArray);
        String string9 = " ORDER BY 4, 7, 6, 8 FOR FETCH ONLY";
        StringBuffer stringBuffer = new StringBuffer();
        baseResultSetFilterDescriptor.removeAllRestrictions();
        String string10 = null;
        if (bl) {
            string10 = string3 + string6 + UNION_ALL + string5 + string6 + UNION_ALL + string7 + string8;
        } else if (!bl) {
            string10 = string2 + string6 + UNION_ALL + string4 + string6 + UNION_ALL + string7 + string8;
        }
        string10 = string10 + string9;
        return string10;
    }

    public String getUDBsUDTsString(BaseResultSetFilterDescriptor baseResultSetFilterDescriptor, BaseResultSetSortDescriptor baseResultSetSortDescriptor) {
        baseResultSetSortDescriptor.setSatisfied();
        String string = (String)baseResultSetFilterDescriptor.getRestriction(1);
        if (string != null && !this.catalogNameMatches(string)) {
            baseResultSetFilterDescriptor.removeAllRestrictions();
            return null;
        }
        string = this.catalogName;
        String[] stringArray = DB2MetaDataLibrary.buildParameterSet(baseResultSetFilterDescriptor, 1, 3);
        int[] nArray = (int[])baseResultSetFilterDescriptor.getRestriction(4);
        baseResultSetFilterDescriptor.removeAllRestrictions();
        String string2 = "SELECT '" + string + "', TYPESCHEMA, TYPENAME, REMOTE_TYPNAME, 0, REMARKS FROM " + this.catalogSchema + ".TYPEMAPPINGS";
        String string3 = " WHERE TYPESCHEMA LIKE ? AND TYPENAME LIKE ? ";
        String string4 = " AND TYPEID = ? ";
        String string5 = " ORDER BY 2, 3 FOR FETCH ONLY";
        String[] stringArray2 = new String[]{"?", stringArray[2], stringArray[3]};
        String[] stringArray3 = new String[]{"?", "0"};
        StringBuffer stringBuffer = new StringBuffer();
        UtilStringFunctions.replaceStringDelimiters(string3, stringArray2, stringBuffer, true);
        String string6 = stringBuffer.toString();
        stringBuffer.delete(0, stringBuffer.length());
        for (int i = 0; i < nArray.length; ++i) {
            String string7 = string2 + string6 + string4;
            stringArray3[1] = String.valueOf(nArray[i]);
            UtilStringFunctions.replaceStringDelimiters(string7, stringArray3, stringBuffer, false);
            if (stringBuffer.length() <= 0) continue;
            UtilStringFunctions.replaceStringDelimiters(UNION_ALL, null, stringBuffer, true);
        }
        if (stringBuffer != null && stringBuffer.length() > 20) {
            stringBuffer.append(string5);
            return stringBuffer.toString();
        }
        return null;
    }

    public String getMVSTableString(BaseResultSetFilterDescriptor baseResultSetFilterDescriptor, BaseResultSetSortDescriptor baseResultSetSortDescriptor, boolean bl) {
        baseResultSetSortDescriptor.setSatisfied();
        String[] stringArray = new String[]{" AND A.CREATOR ", " AND A.NAME "};
        String string = (String)baseResultSetFilterDescriptor.getRestriction(1);
        if (string != null && !this.catalogNameMatches(string)) {
            baseResultSetFilterDescriptor.removeAllRestrictions();
            return null;
        }
        string = this.catalogName;
        String[] stringArray2 = DB2MetaDataLibrary.buildParameterSet(baseResultSetFilterDescriptor, 2, 3);
        int[] nArray = new int[]{2, 3};
        String string2 = null;
        String string3 = null;
        string2 = "SELECT DISTINCT '" + string + "', A.CREATOR, A.NAME,";
        string3 = DB2MetaDataLibrary.joinParameterSet(baseResultSetFilterDescriptor, stringArray, stringArray2, nArray);
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        String string10 = null;
        String string11 = null;
        if (bl) {
            string4 = " 'TABLE', A.REMARKS,nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1) FROM " + this.catalogSchema + ".SYSTABLES A," + this.catalogSchema + ".SYSTABAUTH B WHERE A.TYPE IN ('T', 'G', 'X') " + " AND A.NAME = B.TTNAME AND B.GRANTEE IN ('" + this.restrictUser + "','PUBLIC','PUBLIC*') AND (B.SELECTAUTH = 'Y' OR B.SELECTAUTH = 'G')" + " AND NOT (A.CREATOR IN ('SYSIBM', 'SYSCAT', '" + this.catalogSchema + "'))";
            string5 = " 'VIEW', REMARKS,nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1) FROM " + this.catalogSchema + ".SYSTABLES A," + this.catalogSchema + ".SYSTABAUTH B WHERE TYPE = 'V'" + " AND A.NAME = B.TTNAME AND B.GRANTEE IN ('" + this.restrictUser + "','PUBLIC','PUBLIC*') AND (B.SELECTAUTH = 'Y' OR B.SELECTAUTH = 'G')";
            string6 = " 'ALIAS', REMARKS,nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1) FROM " + this.catalogSchema + ".SYSTABLES A," + this.catalogSchema + ".SYSTABAUTH B WHERE TYPE = 'A'" + " AND A.TBNAME = B.TTNAME AND B.GRANTEE IN ('" + this.restrictUser + "','PUBLIC','PUBLIC*') AND (B.SELECTAUTH = 'Y' OR B.SELECTAUTH = 'G')";
            string7 = " 'SYNONYM', ' ',nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1) FROM " + this.catalogSchema + ".SYSSYNONYMS A," + this.catalogSchema + ".SYSTABAUTH B " + " WHERE A.TBNAME = B.TTNAME AND B.GRANTEE IN ('" + this.restrictUser + "','PUBLIC','PUBLIC*') AND (B.SELECTAUTH = 'Y' OR B.SELECTAUTH = 'G')";
            string8 = " 'HIERARCHY', REMARKS,nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1) FROM " + this.catalogSchema + ".SYSTABLES A WHERE TYPE = 'H'";
            string9 = " 'NICKNAME', REMARKS,nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1) FROM " + this.catalogSchema + ".SYSTABLES A WHERE TYPE = 'N'";
            string10 = " 'SUMMARY', REMARKS,nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1) FROM " + this.catalogSchema + ".SYSTABLES A WHERE TYPE = 'S'";
            string11 = " 'SYSTEM TABLE', REMARKS,nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1) FROM " + this.catalogSchema + ".SYSTABLES A WHERE CREATOR = '" + this.catalogSchema + "'";
        } else {
            string4 = " 'TABLE', A.REMARKS,nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1) FROM " + this.catalogSchema + ".SYSTABLES A WHERE A.TYPE  IN ('T', 'G', 'X') " + " AND NOT (A.CREATOR IN ('SYSIBM', 'SYSCAT', '" + this.catalogSchema + "'))";
            string5 = " 'VIEW', REMARKS,nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1) FROM " + this.catalogSchema + ".SYSTABLES A WHERE TYPE = 'V'";
            string6 = " 'ALIAS', REMARKS,nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1) FROM " + this.catalogSchema + ".SYSTABLES A WHERE TYPE = 'A'";
            string7 = " 'SYNONYM', ' ',nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1) FROM " + this.catalogSchema + ".SYSSYNONYMS A WHERE 1=1";
            string8 = " 'HIERARCHY', REMARKS,nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1) FROM " + this.catalogSchema + ".SYSTABLES A WHERE TYPE = 'H'";
            string9 = " 'NICKNAME', REMARKS,nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1) FROM " + this.catalogSchema + ".SYSTABLES A WHERE TYPE = 'N'";
            string10 = " 'SUMMARY', REMARKS,nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1) FROM " + this.catalogSchema + ".SYSTABLES A WHERE TYPE = 'S'";
            string11 = " 'SYSTEM TABLE', REMARKS,nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1) FROM " + this.catalogSchema + ".SYSTABLES A WHERE CREATOR = '" + this.catalogSchema + "'";
        }
        String string12 = " ORDER BY 4, 2, 3 FOR FETCH ONLY";
        String[] stringArray3 = (String[])baseResultSetFilterDescriptor.getRestriction(4);
        baseResultSetFilterDescriptor.removeAllRestrictions();
        String string13 = string2;
        String string14 = string3;
        StringBuffer stringBuffer = new StringBuffer();
        if (string14.indexOf(" LIKE ") > 0) {
            string14 = string14 + " ESCAPE '\\'";
        }
        boolean bl2 = false;
        if (stringArray3 == null) {
            stringArray3 = this.getTableTypeNames();
        }
        for (int i = 0; i < stringArray3.length; ++i) {
            String string15 = null;
            if (stringArray3[i].equals("TABLE")) {
                string15 = string13 + string4;
            }
            if (stringArray3[i].equals("VIEW")) {
                string15 = string13 + string5;
            }
            if (stringArray3[i].equals("ALIAS") && !bl2) {
                string15 = string13 + string6;
                bl2 = true;
            }
            if (stringArray3[i].equals("SYNONYMS") || stringArray3[i].equals("SYNONYM")) {
                if (DB2MetaDataLibrary.con.comm.serverOS == 3) {
                    string15 = string13 + string7;
                } else if (!bl2) {
                    string15 = string13 + string6;
                    bl2 = true;
                }
            }
            if (stringArray3[i].equals("NICKNAME")) {
                string15 = string13 + string9;
            }
            if (stringArray3[i].equals("SUMMARY TABLE")) {
                string15 = string13 + string10;
            }
            if (stringArray3[i].equals("HIERARCHY TABLE")) {
                string15 = string13 + string8;
            }
            if (stringArray3[i].equals("SYSTEM TABLE")) {
                string15 = string13 + string11;
            }
            if (string15 == null) continue;
            string15 = string15 + string14;
            if (stringBuffer.length() > 0) {
                stringBuffer.append(UNION);
            }
            stringBuffer.append(string15);
        }
        String string16 = stringBuffer.toString();
        if (string16 != null && string16.trim().length() > 0) {
            string16 = string16 + string12;
        }
        return string16;
    }

    public String getMVSColumnString(BaseResultSetFilterDescriptor baseResultSetFilterDescriptor, BaseResultSetSortDescriptor baseResultSetSortDescriptor) {
        baseResultSetSortDescriptor.setSatisfied();
        String string = (String)baseResultSetFilterDescriptor.getRestriction(1);
        if (string != null && !this.catalogNameMatches(string)) {
            baseResultSetFilterDescriptor.removeAllRestrictions();
            return null;
        }
        string = this.catalogName;
        String[] stringArray = new String[]{" AND TBCREATOR ", " AND TBNAME ", " AND NAME "};
        String[] stringArray2 = DB2MetaDataLibrary.buildParameterSet(baseResultSetFilterDescriptor, 2, 4);
        int[] nArray = new int[]{2, 3, 4};
        String string2 = "SELECT '" + string + "', TBCREATOR, TBNAME, NAME, 0, COLTYPE," + " LENGTH, 0, SCALE, 10, 1, REMARKS, DEFAULT, 0," + " 0, 0, COLNO, 'YES',nullif(1,1),nullif(1,1),nullif(1,1)" + " ,nullif(1,1), FOREIGNKEY FROM " + this.catalogSchema + ".SYSCOLUMNS" + " WHERE NULLS LIKE '%Y%'";
        String string3 = "SELECT '" + string + "', TBCREATOR, TBNAME, NAME, 0, COLTYPE," + " LENGTH, 0, SCALE, 10, 0, REMARKS, DEFAULT, 0," + " 0, 0, COLNO, 'NO',nullif(1,1),nullif(1,1),nullif(1,1)" + ",nullif(1,1), FOREIGNKEY FROM " + this.catalogSchema + ".SYSCOLUMNS" + " WHERE NULLS LIKE '%N%'";
        String string4 = " ORDER BY 2, 3, 17 FOR FETCH ONLY";
        String string5 = DB2MetaDataLibrary.joinParameterSet(baseResultSetFilterDescriptor, stringArray, stringArray2, nArray);
        String string6 = null;
        if (DB2MetaDataLibrary.con.catalogIncludesSynonyms) {
            String[] stringArray3 = new String[]{" AND B.CREATOR ", " AND B.NAME ", " AND A.NAME "};
            String string7 = "SELECT '" + string + "', B.CREATOR," + " B.NAME, A.NAME, 0, A.COLTYPE, A.LENGTH," + " 0, A.SCALE, 10, 1, A.REMARKS, A.DEFAULT, 0, 0, 0, A.COLNO," + " 'YES', nullif(1,1), nullif(1,1), nullif(1,1) ,nullif(1,1), FOREIGNKEY" + " FROM " + this.catalogSchema + ".SYSCOLUMNS A, " + this.catalogSchema + ".SYSSYNONYMS B" + " WHERE B.TBNAME=A.TBNAME  AND A.TBCREATOR=B.CREATOR" + " AND NULLS LIKE '%Y%'";
            String string8 = "SELECT '" + string + "', B.CREATOR," + " B.NAME, A.NAME, 0, A.COLTYPE, A.LENGTH," + " 0, A.SCALE, 10, 0, A.REMARKS, A.DEFAULT, 0, 0, 0, A.COLNO," + " 'NO', nullif(1,1), nullif(1,1), nullif(1,1) ,nullif(1,1), FOREIGNKEY" + " FROM " + this.catalogSchema + ".SYSCOLUMNS A, " + this.catalogSchema + ".SYSSYNONYMS B" + " WHERE B.TBNAME=A.TBNAME  AND A.TBCREATOR=B.CREATOR" + " AND NULLS LIKE '%N%'";
            String string9 = DB2MetaDataLibrary.joinParameterSet(baseResultSetFilterDescriptor, stringArray3, stringArray2, nArray);
            String[] stringArray4 = new String[]{" AND B.CREATOR ", " AND B.NAME ", " AND A.NAME "};
            String string10 = "SELECT '" + string + "', B.CREATOR," + " B.NAME, A.NAME, 0, A.COLTYPE, A.LENGTH," + " 0, A.SCALE, 10, 1, A.REMARKS, A.DEFAULT, 0, 0, 0, A.COLNO," + " 'YES', nullif(1,1), nullif(1,1), nullif(1,1) ,nullif(1,1), FOREIGNKEY" + " FROM " + this.catalogSchema + ".SYSCOLUMNS A, " + this.catalogSchema + ".SYSTABLES B" + " WHERE B.TBNAME=A.TBNAME  AND A.TBCREATOR=B.CREATOR" + " AND NULLS LIKE '%Y%'";
            String string11 = "SELECT '" + string + "', B.CREATOR," + " B.NAME, A.NAME, 0, A.COLTYPE, A.LENGTH," + " 0, A.SCALE, 10, 0, A.REMARKS, A.DEFAULT, 0, 0, 0, A.COLNO," + " 'NO', nullif(1,1), nullif(1,1), nullif(1,1) ,nullif(1,1), FOREIGNKEY" + " FROM " + this.catalogSchema + ".SYSCOLUMNS A, " + this.catalogSchema + ".SYSTABLES B" + " WHERE B.TBNAME=A.TBNAME  AND A.TBCREATOR=B.CREATOR" + " AND NULLS LIKE '%N%'";
            String string12 = DB2MetaDataLibrary.joinParameterSet(baseResultSetFilterDescriptor, stringArray4, stringArray2, nArray);
            baseResultSetFilterDescriptor.removeAllRestrictions();
            string6 = string2 + string5 + UNION + string3 + string5 + UNION + string7 + string9 + UNION + string8 + string9 + UNION + string10 + string12 + UNION + string11 + string12 + string4;
        } else {
            baseResultSetFilterDescriptor.removeAllRestrictions();
            string6 = string2 + string5 + UNION_ALL + string3 + string5 + string4;
        }
        return string6;
    }

    public String getMVS5ProcedureString(BaseResultSetFilterDescriptor baseResultSetFilterDescriptor, BaseResultSetSortDescriptor baseResultSetSortDescriptor) {
        baseResultSetSortDescriptor.setSatisfied();
        String string = (String)baseResultSetFilterDescriptor.getRestriction(1);
        if (string != null && !this.catalogNameMatches(string)) {
            baseResultSetFilterDescriptor.removeAllRestrictions();
            return null;
        }
        string = this.catalogName;
        String[] stringArray = new String[]{" AND AUTHID ", " AND PROCEDURE "};
        String[] stringArray2 = DB2MetaDataLibrary.buildParameterSet(baseResultSetFilterDescriptor, 2, 3);
        int[] nArray = new int[]{2, 3};
        String string2 = "SELECT '" + string + "', AUTHID, PROCEDURE, 0, 0, 0, ' ', " + 1 + " FROM " + this.catalogSchema + ".SYSPROCEDURES WHERE RESULT_SETS = 0 ";
        String string3 = "SELECT '" + string + "', AUTHID, PROCEDURE, 0, 0, 0, ' ', " + 2 + " FROM " + this.catalogSchema + ".SYSPROCEDURES WHERE RESULT_SETS > 0 ";
        String string4 = DB2MetaDataLibrary.joinParameterSet(baseResultSetFilterDescriptor, stringArray, stringArray2, nArray);
        String string5 = " ORDER BY 2, 3 FOR FETCH ONLY";
        baseResultSetFilterDescriptor.removeAllRestrictions();
        String string6 = string2 + string4 + UNION_ALL + string3 + string4 + string5;
        return string6;
    }

    public String getMVSProcedureString(BaseResultSetFilterDescriptor baseResultSetFilterDescriptor, BaseResultSetSortDescriptor baseResultSetSortDescriptor) {
        Object object;
        baseResultSetSortDescriptor.setSatisfied();
        String string = (String)baseResultSetFilterDescriptor.getRestriction(1);
        if (string != null && !this.catalogNameMatches(string)) {
            baseResultSetFilterDescriptor.removeAllRestrictions();
            return null;
        }
        string = this.catalogName;
        String[] stringArray = new String[]{" AND SCHEMA ", " AND NAME "};
        if (DB2MetaDataLibrary.con.comm.serverOS == 3 && (String)baseResultSetFilterDescriptor.getRestrictionByIndex(2) != null && ((String)baseResultSetFilterDescriptor.getRestrictionByIndex(2)).indexOf(95) != -1 && ((String)baseResultSetFilterDescriptor.getRestrictionByIndex(2)).length() < 18) {
            object = new StringBuffer((String)baseResultSetFilterDescriptor.getRestrictionByIndex(2));
            for (int i = ((String)baseResultSetFilterDescriptor.getRestriction(3)).length(); i < 18; ++i) {
                ((StringBuffer)object).append(" ");
            }
            if ((String)baseResultSetFilterDescriptor.getRestrictionByIndex(2) != null && ((String)baseResultSetFilterDescriptor.getRestrictionByIndex(2)).indexOf("\\_") != -1) {
                ((StringBuffer)object).deleteCharAt(((String)baseResultSetFilterDescriptor.getRestrictionByIndex(2)).indexOf("\\_"));
                ((StringBuffer)object).append(" ");
            }
            baseResultSetFilterDescriptor.setRestrictionByIndex(2, ((StringBuffer)object).toString());
        }
        object = DB2MetaDataLibrary.buildParameterSet(baseResultSetFilterDescriptor, 2, 3);
        int[] nArray = new int[]{2, 3};
        String string2 = "SELECT '" + string + "', SCHEMA, rtrim(NAME), 0, 0, 0, REMARKS, " + 1 + " FROM " + this.catalogSchema + ".SYSROUTINES WHERE RESULT_SETS = 0 ";
        String string3 = "SELECT '" + string + "', SCHEMA, rtrim(NAME), 0, 0, 0, REMARKS, " + 2 + " FROM " + this.catalogSchema + ".SYSROUTINES WHERE RESULT_SETS > 0 ";
        String string4 = DB2MetaDataLibrary.joinParameterSet(baseResultSetFilterDescriptor, stringArray, (String[])object, nArray);
        String string5 = " ORDER BY 2, 3 FOR FETCH ONLY";
        baseResultSetFilterDescriptor.removeAllRestrictions();
        String string6 = string2 + string4 + UNION_ALL + string3 + string4 + string5;
        return string6;
    }

    public String getMVS5ProcedureColumnsString(BaseResultSetFilterDescriptor baseResultSetFilterDescriptor, BaseResultSetSortDescriptor baseResultSetSortDescriptor) {
        baseResultSetSortDescriptor.setSatisfied();
        String string = (String)baseResultSetFilterDescriptor.getRestriction(1);
        if (string != null && !this.catalogNameMatches(string)) {
            baseResultSetFilterDescriptor.removeAllRestrictions();
            return null;
        }
        string = this.catalogName;
        String[] stringArray = new String[]{" AND AUTHID ", " AND PROCEDURE "};
        String[] stringArray2 = DB2MetaDataLibrary.buildParameterSet(baseResultSetFilterDescriptor, 2, 3);
        int[] nArray = new int[]{2, 3};
        String string2 = DB2MetaDataLibrary.joinParameterSet(baseResultSetFilterDescriptor, stringArray, stringArray2, nArray);
        String string3 = "SELECT '" + string + "', AUTHID, PROCEDURE, ' ', " + 0 + ", 0, PARMLIST, 0, 0, 0, 0," + 2 + ", ' '" + " FROM " + this.catalogSchema + ".SYSPROCEDURES WHERE ASUTIME >= 0";
        String string4 = " ORDER BY 2, 3 FOR FETCH ONLY";
        if (string2.indexOf(" LIKE ") > 0) {
            string2 = string2 + " ESCAPE '\\'";
        }
        baseResultSetFilterDescriptor.removeAllRestrictions();
        String string5 = string3 + string2 + string4;
        return string5;
    }

    public String getMVSProcedureColumnsString(BaseResultSetFilterDescriptor baseResultSetFilterDescriptor, BaseResultSetSortDescriptor baseResultSetSortDescriptor) {
        Object object;
        String string = (String)baseResultSetFilterDescriptor.getRestriction(1);
        if (string != null && !this.catalogNameMatches(string)) {
            baseResultSetFilterDescriptor.removeAllRestrictions();
            return null;
        }
        string = this.catalogName;
        String string2 = null;
        if (this.useSort && baseResultSetSortDescriptor.getSortCount() > 0) {
            string2 = " ORDER BY ";
            for (int i = 0; i < baseResultSetSortDescriptor.getSortCount(); ++i) {
                int n = baseResultSetSortDescriptor.getSortColumnOrdinal(i);
                if (n <= 0) continue;
                object = String.valueOf(n);
                if (i > 0) {
                    string2 = string2 + ",";
                }
                string2 = string2 + (String)object;
            }
            string2 = string2 + " FOR FETCH ONLY";
        }
        baseResultSetSortDescriptor.setSatisfied();
        String[] stringArray = new String[]{" AND P.SCHEMA ", " AND P.NAME ", " AND P.PARMNAME "};
        String[] stringArray2 = DB2MetaDataLibrary.buildParameterSet(baseResultSetFilterDescriptor, 2, 4);
        object = new int[]{2, 3, 4};
        String string3 = DB2MetaDataLibrary.joinParameterSet(baseResultSetFilterDescriptor, stringArray, stringArray2, (int[])object);
        String string4 = "SELECT '" + string + "', P.SCHEMA, P.NAME, P.PARMNAME, " + 1 + ", P.ORDINAL, P.TYPENAME, P.LENGTH, P.LENGTH, P.SCALE, 10," + 0 + ", NULLIF('','')" + " FROM " + this.catalogSchema + ".SYSROUTINES R, " + this.catalogSchema + ".SYSPARMS P WHERE R.SCHEMA = P.SCHEMA AND R.NAME = P.NAME" + " AND R.ROUTINETYPE = P.ROUTINETYPE AND R.NULL_CALL = 'N' AND P.ROWTYPE = 'P'" + " AND P.ROUTINETYPE = 'P'";
        String string5 = "SELECT '" + string + "', P.SCHEMA, P.NAME, P.PARMNAME, " + 1 + ", P.ORDINAL, P.TYPENAME, P.LENGTH, P.LENGTH, P.SCALE, 10," + 1 + ", NULLIF('','')" + " FROM " + this.catalogSchema + ".SYSROUTINES R, " + this.catalogSchema + ".SYSPARMS P WHERE R.SCHEMA = P.SCHEMA AND R.NAME = P.NAME" + " AND R.ROUTINETYPE = P.ROUTINETYPE AND R.NULL_CALL = 'Y' AND P.ROWTYPE = 'P'" + " AND P.ROUTINETYPE = 'P'";
        String string6 = "SELECT '" + string + "', P.SCHEMA, P.NAME, P.PARMNAME, " + 4 + ", P.ORDINAL, P.TYPENAME, P.LENGTH, P.LENGTH, P.SCALE, 10," + 0 + ", NULLIF('','')" + " FROM " + this.catalogSchema + ".SYSROUTINES R, " + this.catalogSchema + ".SYSPARMS P WHERE R.SCHEMA = P.SCHEMA AND R.NAME = P.NAME" + " AND R.ROUTINETYPE = P.ROUTINETYPE AND R.NULL_CALL = 'N' AND P.ROWTYPE = 'O'" + " AND P.ROUTINETYPE = 'P'";
        String string7 = "SELECT '" + string + "', P.SCHEMA, P.NAME, P.PARMNAME, " + 4 + ", P.ORDINAL, P.TYPENAME, P.LENGTH, P.LENGTH, P.SCALE, 10," + 1 + ", NULLIF('','')" + " FROM " + this.catalogSchema + ".SYSROUTINES R, " + this.catalogSchema + ".SYSPARMS P WHERE R.SCHEMA = P.SCHEMA AND R.NAME = P.NAME" + " AND R.ROUTINETYPE = P.ROUTINETYPE AND R.NULL_CALL = 'Y' AND P.ROWTYPE = 'O'" + " AND P.ROUTINETYPE = 'P'";
        String string8 = "SELECT '" + string + "', P.SCHEMA, P.NAME, P.PARMNAME, " + 2 + ", P.ORDINAL, P.TYPENAME, P.LENGTH, P.LENGTH, P.SCALE, 10," + 0 + ", NULLIF('','')" + " FROM " + this.catalogSchema + ".SYSROUTINES R, " + this.catalogSchema + ".SYSPARMS P WHERE R.SCHEMA = P.SCHEMA AND R.NAME = P.NAME" + " AND R.ROUTINETYPE = P.ROUTINETYPE AND R.NULL_CALL = 'N' AND P.ROWTYPE = 'B'" + " AND P.ROUTINETYPE = 'P'";
        String string9 = "SELECT '" + string + "', P.SCHEMA, P.NAME, P.PARMNAME, " + 2 + ", P.ORDINAL, P.TYPENAME, P.LENGTH, P.LENGTH, P.SCALE, 10," + 1 + ", NULLIF('','')" + " FROM " + this.catalogSchema + ".SYSROUTINES R, " + this.catalogSchema + ".SYSPARMS P WHERE R.SCHEMA = P.SCHEMA AND R.NAME = P.NAME" + " AND R.ROUTINETYPE = P.ROUTINETYPE AND R.NULL_CALL = 'Y' AND P.ROWTYPE = 'B'" + " AND P.ROUTINETYPE = 'P'";
        if (string2 == null) {
            string2 = " ORDER BY 2, 3, 6 FOR FETCH ONLY";
        }
        if (string3.indexOf(" LIKE ") > 0) {
            string3 = string3 + " ESCAPE '\\'";
        }
        baseResultSetFilterDescriptor.removeAllRestrictions();
        String string10 = string4 + string3 + UNION_ALL + string5 + string3 + UNION_ALL + string8 + string3 + UNION_ALL + string9 + string3 + UNION_ALL + string6 + string3 + UNION_ALL + string7 + string3 + string2;
        return string10;
    }

    public String getMVSSchemaString(BaseResultSetFilterDescriptor baseResultSetFilterDescriptor, BaseResultSetSortDescriptor baseResultSetSortDescriptor) {
        baseResultSetSortDescriptor.setSatisfied();
        String string = "select DISTINCT rtrim(schemaname),nullif(1,1) from " + this.catalogSchema + ".sysschemaauth" + UNION + "SELECT DISTINCT rtrim(CREATOR),nullif(1,1) FROM " + this.catalogSchema + ".SYSTABLES" + UNION + "SELECT DISTINCT rtrim(SCHEMA),nullif(1,1) FROM " + this.catalogSchema + ".SYSROUTINES";
        return string;
    }

    public String getMVSCatalogString(BaseResultSetFilterDescriptor baseResultSetFilterDescriptor, BaseResultSetSortDescriptor baseResultSetSortDescriptor) {
        baseResultSetSortDescriptor.setSatisfied();
        String string = "SELECT DISTINCT '" + this.catalogName + "' FROM SYSIBM.SYSDUMMY1 ORDER BY 1 FOR FETCH ONLY";
        return string;
    }

    public String getMVSColumnPrivilegeString(BaseResultSetFilterDescriptor baseResultSetFilterDescriptor, BaseResultSetSortDescriptor baseResultSetSortDescriptor) {
        baseResultSetSortDescriptor.setSatisfied();
        String string = (String)baseResultSetFilterDescriptor.getRestriction(1);
        if (string != null && !this.catalogNameMatches(string)) {
            baseResultSetFilterDescriptor.removeAllRestrictions();
            return null;
        }
        string = this.catalogName;
        String[] stringArray = new String[]{" AND CREATOR ", " AND TNAME ", " AND COLNAME "};
        String[] stringArray2 = DB2MetaDataLibrary.buildParameterSet(baseResultSetFilterDescriptor, 2, 4);
        int[] nArray = new int[]{2, 3, 4};
        String string2 = "SELECT '" + string + "', CREATOR, TNAME, COLNAME, GRANTOR, GRANTEE, 'UPDATE', 'YES'" + " FROM " + this.catalogSchema + ".SYSCOLAUTH WHERE PRIVILEGE = ' '";
        String string3 = "SELECT '" + string + "', CREATOR, TNAME, COLNAME, GRANTOR, GRANTEE, 'REFERENCE', 'YES'" + " FROM " + this.catalogSchema + ".SYSCOLAUTH WHERE PRIVILEGE = 'R'";
        String string4 = DB2MetaDataLibrary.joinParameterSet(baseResultSetFilterDescriptor, stringArray, stringArray2, nArray);
        String string5 = " ORDER BY 4, 7 FOR FETCH ONLY";
        baseResultSetFilterDescriptor.removeAllRestrictions();
        String string6 = string2 + string4 + UNION_ALL + string3 + string4 + string5;
        return string6;
    }

    public String getMVSTablePrivilegeString(BaseResultSetFilterDescriptor baseResultSetFilterDescriptor, BaseResultSetSortDescriptor baseResultSetSortDescriptor) {
        baseResultSetSortDescriptor.setSatisfied();
        String string = (String)baseResultSetFilterDescriptor.getRestriction(1);
        String string2 = this.catalogName;
        if (string != null && !string.equals(string2)) {
            baseResultSetFilterDescriptor.removeAllRestrictions();
            return null;
        }
        String[] stringArray = new String[]{" AND TCREATOR ", " AND TTNAME "};
        String[] stringArray2 = DB2MetaDataLibrary.buildParameterSet(baseResultSetFilterDescriptor, 2, 3);
        int[] nArray = new int[]{2, 3};
        String string3 = DB2MetaDataLibrary.joinParameterSet(baseResultSetFilterDescriptor, stringArray, stringArray2, nArray);
        String string4 = "SELECT '" + string + "',TCREATOR,TTNAME,GRANTOR,GRANTEE,'ALTER','YES' FROM " + this.catalogSchema + ".SYSTABAUTH" + " WHERE ALTERAUTH = 'G'";
        String string5 = "SELECT '" + string + "',TCREATOR,TTNAME,GRANTOR,GRANTEE,'ALTER', 'NO' FROM " + this.catalogSchema + ".SYSTABAUTH" + " WHERE ALTERAUTH = 'Y'";
        String string6 = "SELECT '" + string + "',TCREATOR,TTNAME,GRANTOR,GRANTEE,'DELETE','YES' FROM " + this.catalogSchema + ".SYSTABAUTH" + " WHERE DELETEAUTH = 'G'";
        String string7 = "SELECT '" + string + "',TCREATOR,TTNAME,GRANTOR,GRANTEE,'DELETE', 'NO' FROM " + this.catalogSchema + ".SYSTABAUTH" + " WHERE DELETEAUTH = 'Y'";
        String string8 = "SELECT '" + string + "',TCREATOR,TTNAME,GRANTOR,GRANTEE,'INDEX','YES' FROM " + this.catalogSchema + ".SYSTABAUTH" + " WHERE INDEXAUTH = 'G'";
        String string9 = "SELECT '" + string + "',TCREATOR,TTNAME,GRANTOR,GRANTEE,'INDEX', 'NO' FROM " + this.catalogSchema + ".SYSTABAUTH" + " WHERE INDEXAUTH = 'Y'";
        String string10 = "SELECT '" + string + "',TCREATOR,TTNAME,GRANTOR,GRANTEE,'INSERT','YES' FROM " + this.catalogSchema + ".SYSTABAUTH" + " WHERE INSERTAUTH = 'G'";
        String string11 = "SELECT '" + string + "',TCREATOR,TTNAME,GRANTOR,GRANTEE,'INSERT', 'NO' FROM " + this.catalogSchema + ".SYSTABAUTH" + " WHERE INSERTAUTH = 'Y'";
        String string12 = "SELECT '" + string + "',TCREATOR,TTNAME,GRANTOR,GRANTEE,'REFERENCES','YES' FROM " + this.catalogSchema + ".SYSTABAUTH" + " WHERE REFERENCESAUTH = 'G' AND REFCOLS <> '*'";
        String string13 = "SELECT '" + string + "',TCREATOR,TTNAME,GRANTOR,GRANTEE,'REFERENCES', 'NO' FROM " + this.catalogSchema + ".SYSTABAUTH" + " WHERE UPDATEAUTH = 'Y' AND REFCOLS <> '*'";
        String string14 = "SELECT '" + string + "',TCREATOR,TTNAME,GRANTOR,GRANTEE,'SELECT','YES' FROM " + this.catalogSchema + ".SYSTABAUTH" + " WHERE SELECTAUTH = 'G'";
        String string15 = "SELECT '" + string + "',TCREATOR,TTNAME,GRANTOR,GRANTEE,'SELECT', 'NO' FROM " + this.catalogSchema + ".SYSTABAUTH" + " WHERE SELECTAUTH = 'Y'";
        String string16 = "SELECT '" + string + "',TCREATOR,TTNAME,GRANTOR,GRANTEE,'UPDATE','YES' FROM " + this.catalogSchema + ".SYSTABAUTH" + " WHERE UPDATEAUTH = 'G' AND UPDATECOLS <> '*'";
        String string17 = "SELECT '" + string + "',TCREATOR,TTNAME,GRANTOR,GRANTEE,'UPDATE', 'NO' FROM " + this.catalogSchema + ".SYSTABAUTH" + " WHERE UPDATEAUTH = 'Y' AND UPDATECOLS <> '*'";
        String string18 = " ORDER BY 2, 3, 6 FOR FETCH ONLY";
        baseResultSetFilterDescriptor.removeAllRestrictions();
        String string19 = string4 + string3 + UNION_ALL + string5 + string3 + UNION_ALL + string6 + string3 + UNION_ALL + string7 + string3 + UNION_ALL + string8 + string3 + UNION_ALL + string9 + string3 + UNION_ALL + string10 + string3 + UNION_ALL + string11 + string3 + UNION_ALL + string12 + string3 + UNION_ALL + string13 + string3 + UNION_ALL + string14 + string3 + UNION_ALL + string15 + string3 + UNION_ALL + string16 + string3 + UNION_ALL + string17 + string3 + string18;
        return string19;
    }

    public String getMVSBestRowIdentifierString(BaseResultSetFilterDescriptor baseResultSetFilterDescriptor, BaseResultSetSortDescriptor baseResultSetSortDescriptor) {
        baseResultSetSortDescriptor.setSatisfied();
        String[] stringArray = new String[]{" CT.TBCREATOR ", " AND CT.TBNAME "};
        String[] stringArray2 = DB2MetaDataLibrary.buildParameterSet(baseResultSetFilterDescriptor, 10, 11);
        int[] nArray = new int[]{10, 11};
        int n = (Integer)baseResultSetFilterDescriptor.getRestriction(1);
        boolean bl = (Boolean)baseResultSetFilterDescriptor.getRestriction(12);
        String string = "";
        String string2 = "";
        String string3 = "SELECT 0, CT.NAME, 0, CT.COLTYPE, CT.LENGTH, 0, CT.SCALE, 0 FROM  " + this.catalogSchema + ".SYSCOLUMNS CT WHERE ";
        String string4 = "SELECT 1, CT.NAME, 0, CT.COLTYPE, CT.LENGTH, 0, CT.SCALE, 0 FROM  " + this.catalogSchema + ".SYSCOLUMNS CT WHERE CT.NULLS = 'N' AND ";
        String string5 = "SELECT 1, CT.NAME, 0, CT.COLTYPE, CT.LENGTH, 0, CT.SCALE,1 FROM " + this.catalogSchema + ".SYSCOLUMNS CT, " + this.catalogSchema + ".SYSKEYS KT, " + this.catalogSchema + ".SYSINDEXES IT WHERE KT.IXCREATOR = IT.CREATOR AND KT.IXNAME = IT.NAME AND KT.COLNAME = CT.NAME AND ";
        String string6 = "SELECT 2, CT.NAME, 0, CT.COLTYPE, CT.LENGTH, 0, CT.SCALE, 1 FROM " + this.catalogSchema + ".SYSINDEXES IT, " + this.catalogSchema + ".SYSCOLUMNS CT WHERE IT.TBCREATOR = CT.TBCREATOR AND IT.TBNAME = CT.TBNAME AND (IT.UNIQUERULE = 'P' OR IT.UNIQUERULE = 'U') AND";
        String string7 = DB2MetaDataLibrary.joinParameterSet(baseResultSetFilterDescriptor, stringArray, stringArray2, nArray);
        String string8 = " ORDER BY 1 FOR FETCH ONLY";
        baseResultSetFilterDescriptor.removeAllRestrictions();
        String string9 = null;
        string9 = bl && n == 0 ? string3 + string7 : string4 + string7;
        if (n == 1) {
            string9 = string9 + UNION_ALL + string5 + string7;
        }
        if (n == 2) {
            string9 = string9 + UNION_ALL + string6 + string7;
        }
        string9 = string9 + string8;
        return string9;
    }

    public String getMVSVersionColumnString(BaseResultSetFilterDescriptor baseResultSetFilterDescriptor, BaseResultSetSortDescriptor baseResultSetSortDescriptor) {
        baseResultSetSortDescriptor.setSatisfied();
        String[] stringArray = new String[]{" AND TBCREATOR ", " AND TBNAME "};
        String string = (String)baseResultSetFilterDescriptor.getRestriction(1);
        if (string != null && !this.catalogNameMatches(string)) {
            baseResultSetFilterDescriptor.removeAllRestrictions();
            return null;
        }
        string = this.catalogName;
        String[] stringArray2 = DB2MetaDataLibrary.buildParameterSet(baseResultSetFilterDescriptor, 10, 11);
        int[] nArray = new int[]{10, 11};
        String string2 = DB2MetaDataLibrary.joinParameterSet(baseResultSetFilterDescriptor, stringArray, stringArray2, nArray);
        baseResultSetFilterDescriptor.removeAllRestrictions();
        String string3 = "SELECT 0, NAME, 0, COLTYPE, LENGTH, 0, SCALE, 0 FROM " + this.catalogSchema + ".SYSCOLUMNS WHERE NULLS = 'N' AND DEFAULT IN ('S', 'U')";
        String string4 = string3 + string2;
        return string4;
    }

    public String getMVSPrimaryKeysString(BaseResultSetFilterDescriptor baseResultSetFilterDescriptor, BaseResultSetSortDescriptor baseResultSetSortDescriptor) {
        baseResultSetSortDescriptor.setSatisfied();
        String string = (String)baseResultSetFilterDescriptor.getRestriction(1);
        if (string != null && !this.catalogNameMatches(string)) {
            baseResultSetFilterDescriptor.removeAllRestrictions();
            return null;
        }
        string = this.catalogName;
        String[] stringArray = new String[]{" AND IT.TBCREATOR ", " AND IT.TBNAME "};
        String[] stringArray2 = DB2MetaDataLibrary.buildParameterSet(baseResultSetFilterDescriptor, 2, 3);
        int[] nArray = new int[]{2, 3};
        String string2 = "SELECT DISTINCT '" + string + "', IT.TBCREATOR, IT.TBNAME, KT.COLNAME, KT.COLSEQ, IT.NAME" + " FROM " + this.catalogSchema + ".SYSKEYS KT, " + this.catalogSchema + ".SYSINDEXES IT" + " WHERE IT.UNIQUERULE = 'P' AND IT.CREATOR = KT.IXCREATOR AND KT.IXNAME = IT.NAME";
        String string3 = DB2MetaDataLibrary.joinParameterSet(baseResultSetFilterDescriptor, stringArray, stringArray2, nArray);
        String string4 = " ORDER BY 4 FOR FETCH ONLY";
        baseResultSetFilterDescriptor.removeAllRestrictions();
        String string5 = string2 + string3 + string4;
        return string5;
    }

    public String getMVSExportedKeysString(BaseResultSetFilterDescriptor baseResultSetFilterDescriptor, BaseResultSetSortDescriptor baseResultSetSortDescriptor) {
        baseResultSetSortDescriptor.setSatisfied();
        String string = (String)baseResultSetFilterDescriptor.getRestriction(1);
        if (string != null && !this.catalogNameMatches(string)) {
            baseResultSetFilterDescriptor.removeAllRestrictions();
            return null;
        }
        string = this.catalogName;
        String[] stringArray = new String[]{" AND RT.REFTBCREATOR ", " AND RT.REFTBNAME "};
        String[] stringArray2 = DB2MetaDataLibrary.buildParameterSet(baseResultSetFilterDescriptor, 2, 3);
        int[] nArray = new int[]{2, 3};
        String string2 = "SELECT '" + string + "', IT.TBCREATOR, IT.TBNAME, PT.COLNAME," + " '" + string + "', FT.CREATOR, FT.TBNAME, FT.COLNAME, FT.COLSEQ," + 3 + ", " + 3 + "," + " RT.RELNAME, IT.NAME, " + 7 + " FROM " + this.catalogSchema + ".SYSINDEXES IT, " + this.catalogSchema + ".SYSKEYS PT, " + this.catalogSchema + ".SYSRELS RT, " + this.catalogSchema + ".SYSFOREIGNKEYS FT" + " WHERE IT.UNIQUERULE = 'P'" + " AND IT.CREATOR = PT.IXCREATOR AND IT.NAME = PT.IXNAME" + " AND IT.TBNAME = RT.REFTBNAME AND IT.TBCREATOR = RT.REFTBCREATOR" + " AND FT.RELNAME = RT.RELNAME AND FT.CREATOR = RT.CREATOR" + " AND PT.COLSEQ = FT.COLSEQ AND RT.DELETERULE = 'A'";
        String string3 = "SELECT '" + string + "', IT.TBCREATOR, IT.TBNAME, PT.COLNAME," + " '" + string + "', FT.CREATOR, FT.TBNAME, FT.COLNAME, FT.COLSEQ," + 3 + ", " + 0 + "," + " RT.RELNAME, IT.NAME, " + 7 + " FROM " + this.catalogSchema + ".SYSINDEXES IT, " + this.catalogSchema + ".SYSKEYS PT, " + this.catalogSchema + ".SYSRELS RT, " + this.catalogSchema + ".SYSFOREIGNKEYS FT" + " WHERE IT.UNIQUERULE = 'P'" + " AND IT.CREATOR = PT.IXCREATOR AND IT.NAME = PT.IXNAME" + " AND IT.TBNAME = RT.REFTBNAME AND IT.TBCREATOR = RT.REFTBCREATOR" + " AND FT.RELNAME = RT.RELNAME AND FT.CREATOR = RT.CREATOR" + " AND PT.COLSEQ = FT.COLSEQ AND RT.DELETERULE = 'C'";
        String string4 = "SELECT '" + string + "', IT.TBCREATOR, IT.TBNAME, PT.COLNAME," + " '" + string + "', FT.CREATOR, FT.TBNAME, FT.COLNAME, FT.COLSEQ," + 3 + ", " + 2 + "," + " RT.RELNAME, IT.NAME, " + 7 + " FROM " + this.catalogSchema + ".SYSINDEXES IT, " + this.catalogSchema + ".SYSKEYS PT, " + this.catalogSchema + ".SYSRELS RT, " + this.catalogSchema + ".SYSFOREIGNKEYS FT" + " WHERE IT.UNIQUERULE = 'P'" + " AND IT.CREATOR = PT.IXCREATOR AND IT.NAME = PT.IXNAME" + " AND IT.TBNAME = RT.REFTBNAME AND IT.TBCREATOR = RT.REFTBCREATOR" + " AND FT.RELNAME = RT.RELNAME AND FT.CREATOR = RT.CREATOR" + " AND PT.COLSEQ = FT.COLSEQ AND RT.DELETERULE = 'N'";
        String string5 = "SELECT '" + string + "', IT.TBCREATOR, IT.TBNAME, PT.COLNAME," + " '" + string + "', FT.CREATOR, FT.TBNAME, FT.COLNAME, FT.COLSEQ," + 3 + ", " + 1 + "," + " RT.RELNAME, IT.NAME, " + 7 + " FROM " + this.catalogSchema + ".SYSINDEXES IT, " + this.catalogSchema + ".SYSKEYS PT, " + this.catalogSchema + ".SYSRELS RT, " + this.catalogSchema + ".SYSFOREIGNKEYS FT" + " WHERE IT.UNIQUERULE = 'P'" + " AND IT.CREATOR = PT.IXCREATOR AND IT.NAME = PT.IXNAME" + " AND IT.TBNAME = RT.REFTBNAME AND IT.TBCREATOR = RT.REFTBCREATOR" + " AND FT.RELNAME = RT.RELNAME AND FT.CREATOR = RT.CREATOR" + " AND PT.COLSEQ = FT.COLSEQ AND RT.DELETERULE = 'R'";
        String string6 = DB2MetaDataLibrary.joinParameterSet(baseResultSetFilterDescriptor, stringArray, stringArray2, nArray);
        String string7 = " ORDER BY 6, 7, 9 FOR FETCH ONLY";
        baseResultSetFilterDescriptor.removeAllRestrictions();
        String string8 = string2 + string6 + UNION_ALL + string3 + string6 + UNION_ALL + string4 + string6 + UNION_ALL + string5 + string6 + string7;
        return string8;
    }

    public String getMVSImportedKeysString(BaseResultSetFilterDescriptor baseResultSetFilterDescriptor, BaseResultSetSortDescriptor baseResultSetSortDescriptor) {
        baseResultSetSortDescriptor.setSatisfied();
        String string = (String)baseResultSetFilterDescriptor.getRestriction(5);
        if (string != null && !this.catalogNameMatches(string)) {
            baseResultSetFilterDescriptor.removeAllRestrictions();
            return null;
        }
        string = this.catalogName;
        String[] stringArray = new String[]{" AND RT.CREATOR ", " AND RT.TBNAME "};
        String[] stringArray2 = DB2MetaDataLibrary.buildParameterSet(baseResultSetFilterDescriptor, 6, 7);
        int[] nArray = new int[]{6, 7};
        String string2 = "SELECT '" + string + "', IT.TBCREATOR, IT.TBNAME, PT.COLNAME," + " '" + string + "', FT.CREATOR, FT.TBNAME, FT.COLNAME, FT.COLSEQ," + 3 + ", " + 3 + "," + " RT.RELNAME, IT.NAME, " + 7 + " FROM " + this.catalogSchema + ".SYSINDEXES IT, " + this.catalogSchema + ".SYSKEYS PT, " + this.catalogSchema + ".SYSRELS RT, " + this.catalogSchema + ".SYSFOREIGNKEYS FT" + " WHERE IT.UNIQUERULE = 'P'" + " AND IT.CREATOR = PT.IXCREATOR AND IT.NAME = PT.IXNAME" + " AND IT.TBNAME = RT.REFTBNAME AND IT.TBCREATOR = RT.REFTBCREATOR" + " AND FT.RELNAME = RT.RELNAME AND FT.CREATOR = RT.CREATOR" + " AND PT.COLSEQ = FT.COLSEQ AND RT.DELETERULE = 'A'";
        String string3 = "SELECT '" + string + "', IT.TBCREATOR, IT.TBNAME, PT.COLNAME," + " '" + string + "', FT.CREATOR, FT.TBNAME, FT.COLNAME, FT.COLSEQ," + 3 + ", " + 0 + "," + " RT.RELNAME, IT.NAME, " + 7 + " FROM " + this.catalogSchema + ".SYSINDEXES IT, " + this.catalogSchema + ".SYSKEYS PT, " + this.catalogSchema + ".SYSRELS RT, " + this.catalogSchema + ".SYSFOREIGNKEYS FT" + " WHERE IT.UNIQUERULE = 'P'" + " AND IT.CREATOR = PT.IXCREATOR AND IT.NAME = PT.IXNAME" + " AND IT.TBNAME = RT.REFTBNAME AND IT.TBCREATOR = RT.REFTBCREATOR" + " AND FT.RELNAME = RT.RELNAME AND FT.CREATOR = RT.CREATOR" + " AND PT.COLSEQ = FT.COLSEQ AND RT.DELETERULE = 'C'";
        String string4 = "SELECT '" + string + "', IT.TBCREATOR, IT.TBNAME, PT.COLNAME," + " '" + string + "', FT.CREATOR, FT.TBNAME, FT.COLNAME, FT.COLSEQ," + 3 + ", " + 2 + "," + " RT.RELNAME, IT.NAME, " + 7 + " FROM " + this.catalogSchema + ".SYSINDEXES IT, " + this.catalogSchema + ".SYSKEYS PT, " + this.catalogSchema + ".SYSRELS RT, " + this.catalogSchema + ".SYSFOREIGNKEYS FT" + " WHERE IT.UNIQUERULE = 'P'" + " AND IT.CREATOR = PT.IXCREATOR AND IT.NAME = PT.IXNAME" + " AND IT.TBNAME = RT.REFTBNAME AND IT.TBCREATOR = RT.REFTBCREATOR" + " AND FT.RELNAME = RT.RELNAME AND FT.CREATOR = RT.CREATOR" + " AND PT.COLSEQ = FT.COLSEQ AND RT.DELETERULE = 'N'";
        String string5 = "SELECT '" + string + "', IT.TBCREATOR, IT.TBNAME, PT.COLNAME," + " '" + string + "', FT.CREATOR, FT.TBNAME, FT.COLNAME, FT.COLSEQ," + 3 + ", " + 1 + "," + " RT.RELNAME, IT.NAME, " + 7 + " FROM " + this.catalogSchema + ".SYSINDEXES IT, " + this.catalogSchema + ".SYSKEYS PT, " + this.catalogSchema + ".SYSRELS RT, " + this.catalogSchema + ".SYSFOREIGNKEYS FT" + " WHERE IT.UNIQUERULE = 'P'" + " AND IT.CREATOR = PT.IXCREATOR AND IT.NAME = PT.IXNAME" + " AND IT.TBNAME = RT.REFTBNAME AND IT.TBCREATOR = RT.REFTBCREATOR" + " AND FT.RELNAME = RT.RELNAME AND FT.CREATOR = RT.CREATOR" + " AND PT.COLSEQ = FT.COLSEQ AND RT.DELETERULE = 'R'";
        String string6 = DB2MetaDataLibrary.joinParameterSet(baseResultSetFilterDescriptor, stringArray, stringArray2, nArray);
        String string7 = " ORDER BY 2, 3, 9 FOR FETCH ONLY";
        baseResultSetFilterDescriptor.removeAllRestrictions();
        String string8 = string2 + string6 + UNION_ALL + string3 + string6 + UNION_ALL + string4 + string6 + UNION_ALL + string5 + string6 + string7;
        return string8;
    }

    public String getMVSCrossReferenceString(BaseResultSetFilterDescriptor baseResultSetFilterDescriptor, BaseResultSetSortDescriptor baseResultSetSortDescriptor) {
        baseResultSetSortDescriptor.setSatisfied();
        String string = (String)baseResultSetFilterDescriptor.getRestriction(1);
        String string2 = (String)baseResultSetFilterDescriptor.getRestriction(5);
        if (string != null && !this.catalogNameMatches(string) || !this.catalogNameMatches(string2)) {
            baseResultSetFilterDescriptor.removeAllRestrictions();
            return null;
        }
        string = this.catalogName;
        String[] stringArray = new String[]{"", " AND RT.REFTBCREATOR ", " AND RT.REFTBNAME ", "", " AND RT.CREATOR ", " AND RT.TBNAME "};
        String[] stringArray2 = DB2MetaDataLibrary.buildParameterSet(baseResultSetFilterDescriptor, 0, 0);
        int[] nArray = new int[]{-1, 2, 3, -1, 6, 7};
        String string3 = "SELECT '" + string + "', IT.TBCREATOR, IT.TBNAME, PT.COLNAME," + " '" + string + "', FT.CREATOR, FT.TBNAME, FT.COLNAME, FT.COLSEQ," + 3 + ", " + 3 + "," + " RT.RELNAME, IT.NAME, " + 7 + " FROM " + this.catalogSchema + ".SYSINDEXES IT, " + this.catalogSchema + ".SYSKEYS PT, " + this.catalogSchema + ".SYSRELS RT, " + this.catalogSchema + ".SYSFOREIGNKEYS FT" + " WHERE IT.UNIQUERULE = 'P'" + " AND IT.CREATOR = PT.IXCREATOR AND IT.NAME = PT.IXNAME" + " AND IT.TBNAME = RT.REFTBNAME AND IT.TBCREATOR = RT.REFTBCREATOR" + " AND FT.RELNAME = RT.RELNAME AND FT.CREATOR = RT.CREATOR AND FT.TBNAME = RT.TBNAME" + " AND PT.COLSEQ = FT.COLSEQ AND RT.DELETERULE = 'A'";
        String string4 = "SELECT '" + string + "', IT.TBCREATOR, IT.TBNAME, PT.COLNAME," + " '" + string + "', FT.CREATOR, FT.TBNAME, FT.COLNAME, FT.COLSEQ," + 3 + ", " + 0 + "," + " RT.RELNAME, IT.NAME, " + 7 + " FROM " + this.catalogSchema + ".SYSINDEXES IT, " + this.catalogSchema + ".SYSKEYS PT, " + this.catalogSchema + ".SYSRELS RT, " + this.catalogSchema + ".SYSFOREIGNKEYS FT" + " WHERE IT.UNIQUERULE = 'P'" + " AND IT.CREATOR = PT.IXCREATOR AND IT.NAME = PT.IXNAME" + " AND IT.TBNAME = RT.REFTBNAME AND IT.TBCREATOR = RT.REFTBCREATOR" + " AND FT.RELNAME = RT.RELNAME AND FT.CREATOR = RT.CREATOR AND FT.TBNAME = RT.TBNAME" + " AND PT.COLSEQ = FT.COLSEQ AND RT.DELETERULE = 'C'";
        String string5 = "SELECT '" + string + "', IT.TBCREATOR, IT.TBNAME, PT.COLNAME," + " '" + string + "', FT.CREATOR, FT.TBNAME, FT.COLNAME, FT.COLSEQ," + 3 + ", " + 2 + "," + " RT.RELNAME, IT.NAME, " + 7 + " FROM " + this.catalogSchema + ".SYSINDEXES IT, " + this.catalogSchema + ".SYSKEYS PT, " + this.catalogSchema + ".SYSRELS RT, " + this.catalogSchema + ".SYSFOREIGNKEYS FT" + " WHERE IT.UNIQUERULE = 'P'" + " AND IT.CREATOR = PT.IXCREATOR AND IT.NAME = PT.IXNAME" + " AND IT.TBNAME = RT.REFTBNAME AND IT.TBCREATOR = RT.REFTBCREATOR" + " AND FT.RELNAME = RT.RELNAME AND FT.CREATOR = RT.CREATOR AND FT.TBNAME = RT.TBNAME" + " AND PT.COLSEQ = FT.COLSEQ AND RT.DELETERULE = 'N'";
        String string6 = "SELECT '" + string + "', IT.TBCREATOR, IT.TBNAME, PT.COLNAME," + " '" + string + "', FT.CREATOR, FT.TBNAME, FT.COLNAME, FT.COLSEQ," + 3 + ", " + 1 + "," + " RT.RELNAME, IT.NAME, " + 7 + " FROM " + this.catalogSchema + ".SYSINDEXES IT, " + this.catalogSchema + ".SYSKEYS PT, " + this.catalogSchema + ".SYSRELS RT, " + this.catalogSchema + ".SYSFOREIGNKEYS FT" + " WHERE IT.UNIQUERULE = 'P'" + " AND IT.CREATOR = PT.IXCREATOR AND IT.NAME = PT.IXNAME" + " AND IT.TBNAME = RT.REFTBNAME AND IT.TBCREATOR = RT.REFTBCREATOR" + " AND FT.RELNAME = RT.RELNAME AND FT.CREATOR = RT.CREATOR AND FT.TBNAME = RT.TBNAME" + " AND PT.COLSEQ = FT.COLSEQ AND RT.DELETERULE = 'R'";
        String string7 = DB2MetaDataLibrary.joinParameterSet(baseResultSetFilterDescriptor, stringArray, stringArray2, nArray);
        String string8 = " ORDER BY 6, 7, 9 FOR FETCH ONLY";
        baseResultSetFilterDescriptor.removeAllRestrictions();
        String string9 = string3 + string7 + UNION_ALL + string4 + string7 + UNION_ALL + string5 + string7 + UNION_ALL + string6 + string7 + string8;
        return string9;
    }

    public String getMVSIndexInfoString(BaseResultSetFilterDescriptor baseResultSetFilterDescriptor, BaseResultSetSortDescriptor baseResultSetSortDescriptor) {
        baseResultSetSortDescriptor.setSatisfied();
        String string = (String)baseResultSetFilterDescriptor.getRestriction(1);
        if (string != null && !this.catalogNameMatches(string)) {
            baseResultSetFilterDescriptor.removeAllRestrictions();
            return null;
        }
        string = this.catalogName;
        String[] stringArray = new String[]{" AND IT.CREATOR ", " AND IT.TBNAME "};
        String[] stringArray2 = new String[]{" AND CREATOR ", " AND NAME "};
        String[] stringArray3 = DB2MetaDataLibrary.buildParameterSet(baseResultSetFilterDescriptor, 2, 3);
        int[] nArray = new int[]{2, 3};
        boolean bl = (Boolean)baseResultSetFilterDescriptor.getRestriction(4);
        String string2 = "SELECT '" + string + "', IT.TBCREATOR, IT.TBNAME, CASE IT.UNIQUERULE WHEN 'D' THEN 1 WHEN '1' THEN 0 WHEN '0' THEN 0 ELSE 0 END CASE," + " ' ', IT.NAME, " + 1 + "," + " KT.COLSEQ, KT.COLNAME, KT.ORDERING, IT.COLCOUNT, 0, ' '" + " FROM " + this.catalogSchema + ".SYSKEYS KT, " + this.catalogSchema + ".SYSINDEXES IT WHERE KT.IXNAME = IT.NAME" + " AND KT.IXCREATOR = IT.CREATOR AND IT.CLUSTERED = 'Y'";
        String string3 = "SELECT '" + string + "', IT.TBCREATOR, IT.TBNAME, CASE IT.UNIQUERULE WHEN 'D' THEN 1 WHEN '1' THEN 0 WHEN '0' THEN 0 ELSE 0 END CASE," + " ' ', IT.NAME, " + 1 + "," + " KT.COLSEQ, KT.COLNAME, KT.ORDERING, IT.COLCOUNT, 0, ' '" + " FROM " + this.catalogSchema + ".SYSKEYS KT, " + this.catalogSchema + ".SYSINDEXES IT WHERE KT.IXNAME = IT.NAME" + " AND KT.IXCREATOR = IT.CREATOR AND IT.CLUSTERED = 'Y' AND IT.UNIQUERULE <> 'D'";
        String string4 = "SELECT '" + string + "', IT.TBCREATOR, IT.TBNAME, CASE IT.UNIQUERULE WHEN 'D' THEN 1 WHEN '1' THEN 0 WHEN '0' THEN 0 ELSE 0 END CASE," + " ' ', IT.NAME, " + 3 + "," + " KT.COLSEQ, KT.COLNAME, KT.ORDERING, IT.COLCOUNT, 0, ' '" + " FROM " + this.catalogSchema + ".SYSKEYS KT, " + this.catalogSchema + ".SYSINDEXES IT WHERE KT.IXNAME = IT.NAME" + " AND KT.IXCREATOR = IT.CREATOR AND IT.CLUSTERED <> 'Y'";
        String string5 = "SELECT '" + string + "', IT.TBCREATOR, IT.TBNAME, CASE IT.UNIQUERULE WHEN 'D' THEN 1 WHEN '1' THEN 0 WHEN '0' THEN 0 ELSE 0 END CASE," + " ' ', IT.NAME, " + 3 + "," + " KT.COLSEQ, KT.COLNAME, KT.ORDERING, IT.COLCOUNT, 0, ' '" + " FROM " + this.catalogSchema + ".SYSKEYS KT, " + this.catalogSchema + ".SYSINDEXES IT WHERE KT.IXNAME = IT.NAME" + " AND KT.IXCREATOR = IT.CREATOR AND IT.CLUSTERED <> 'Y' AND IT.UNIQUERULE <> 'D'";
        String string6 = DB2MetaDataLibrary.joinParameterSet(baseResultSetFilterDescriptor, stringArray, stringArray3, nArray);
        String string7 = "SELECT '" + string + "', CREATOR, NAME, 0," + " NULLIF('',''), NULLIF('',''), " + 0 + "," + " 0, NULLIF('',''), NULLIF('',''), 0, 0, NULLIF('','')" + " FROM " + this.catalogSchema + ".SYSTABLES WHERE NAME <> ' '";
        String string8 = DB2MetaDataLibrary.joinParameterSet(baseResultSetFilterDescriptor, stringArray2, stringArray3, nArray);
        String string9 = " ORDER BY 4, 7, 6, 8 FOR FETCH ONLY";
        StringBuffer stringBuffer = new StringBuffer();
        baseResultSetFilterDescriptor.removeAllRestrictions();
        String string10 = null;
        if (bl) {
            string10 = string3 + string6 + UNION_ALL + string5 + string6 + UNION_ALL + string7 + string8;
        } else if (!bl) {
            string10 = string2 + string6 + UNION_ALL + string4 + string6 + UNION_ALL + string7 + string8;
        }
        string10 = string10 + string9;
        return string10;
    }

    public String getMVSsUDTsString(BaseResultSetFilterDescriptor baseResultSetFilterDescriptor, BaseResultSetSortDescriptor baseResultSetSortDescriptor) {
        return null;
    }

    public String getAS400ColumnString(BaseResultSetFilterDescriptor baseResultSetFilterDescriptor, BaseResultSetSortDescriptor baseResultSetSortDescriptor) {
        baseResultSetSortDescriptor.setSatisfied();
        String string = (String)baseResultSetFilterDescriptor.getRestriction(1);
        if (string != null && !this.catalogNameMatches(string)) {
            baseResultSetFilterDescriptor.removeAllRestrictions();
            return null;
        }
        string = this.catalogName;
        String[] stringArray = new String[]{" AND TABLE_SCHEMA ", " AND TABLE_NAME ", " AND COLUMN_NAME "};
        String[] stringArray2 = DB2MetaDataLibrary.buildParameterSet(baseResultSetFilterDescriptor, 2, 4);
        int[] nArray = new int[]{2, 3, 4};
        String string2 = "SELECT '" + string + "', TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, 0, DATA_TYPE," + " LENGTH, IFNULL(NUMERIC_PRECISION, CHARACTER_MAXIMUM_LENGTH)," + " NUMERIC_SCALE, NUMERIC_PRECISION_RADIX, IS_NULLABLE, LONG_COMMENT, COLUMN_DEFAULT, 0," + " 0, 0, ORDINAL_POSITION, 'YES',nullif(1,1),nullif(1,1),nullif(1,1)" + " ,nullif(1,1), CCSID FROM " + this.catalogSchema + ".SYSCOLUMNS" + " WHERE NULLS = 'Y'";
        String string3 = "SELECT '" + string + "', TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, 0, DATA_TYPE," + " LENGTH, IFNULL(NUMERIC_PRECISION, CHARACTER_MAXIMUM_LENGTH)," + " NUMERIC_SCALE, NUMERIC_PRECISION_RADIX, IS_NULLABLE, LONG_COMMENT, COLUMN_DEFAULT, 0," + " 0, 0, ORDINAL_POSITION, 'NO',nullif(1,1),nullif(1,1),nullif(1,1)" + " ,nullif(1,1), CCSID FROM " + this.catalogSchema + ".SYSCOLUMNS" + " WHERE NULLS = 'N'";
        String string4 = DB2MetaDataLibrary.joinParameterSet(baseResultSetFilterDescriptor, stringArray, stringArray2, nArray);
        String string5 = " ORDER BY 2, 3, 17 FOR FETCH ONLY";
        String string6 = null;
        if (DB2MetaDataLibrary.con.catalogIncludesSynonyms) {
            String[] stringArray3 = new String[]{" AND B.TABLE_SCHEMA ", " AND B.TABLE_NAME ", " AND A.COLUMN_NAME "};
            String string7 = "SELECT '" + string + "', B.TABLE_SCHEMA, B.TABLE_NAME, A.COLUMN_NAME, 0, A.DATA_TYPE," + " A.LENGTH, IFNULL(A.NUMERIC_PRECISION, A.CHARACTER_MAXIMUM_LENGTH)," + " A.NUMERIC_SCALE, A.NUMERIC_PRECISION_RADIX, A.IS_NULLABLE, A.LONG_COMMENT, A.COLUMN_DEFAULT, 0," + " 0, 0, A.ORDINAL_POSITION, 'YES',nullif(1,1),nullif(1,1),nullif(1,1)" + " ,nullif(1,1), CCSID FROM " + this.catalogSchema + ".SYSCOLUMNS A, " + this.catalogSchema + ".SYSTABLES B" + " WHERE NULLS = 'Y' AND B.BASE_TABLE_NAME=A.TABLE_NAME AND A.TABLE_SCHEMA=B.BASE_TABLE_SCHEMA";
            String string8 = "SELECT '" + string + "', B.TABLE_SCHEMA, B.TABLE_NAME, A.COLUMN_NAME, 0, A.DATA_TYPE," + " A.LENGTH, IFNULL(A.NUMERIC_PRECISION, A.CHARACTER_MAXIMUM_LENGTH)," + " A.NUMERIC_SCALE, A.NUMERIC_PRECISION_RADIX, A.IS_NULLABLE, A.LONG_COMMENT, A.COLUMN_DEFAULT, 0," + " 0, 0, A.ORDINAL_POSITION, 'NO',nullif(1,1),nullif(1,1),nullif(1,1)" + " ,nullif(1,1), CCSID FROM " + this.catalogSchema + ".SYSCOLUMNS A, " + this.catalogSchema + ".SYSTABLES B" + " WHERE NULLS = 'N' AND B.BASE_TABLE_NAME=A.TABLE_NAME AND A.TABLE_SCHEMA=B.BASE_TABLE_SCHEMA";
            String string9 = DB2MetaDataLibrary.joinParameterSet(baseResultSetFilterDescriptor, stringArray3, stringArray2, nArray);
            baseResultSetFilterDescriptor.removeAllRestrictions();
            string6 = string2 + string4 + UNION + string7 + string9 + UNION_ALL + string3 + string4 + UNION + string8 + string9 + string5;
        } else {
            baseResultSetFilterDescriptor.removeAllRestrictions();
            string6 = string2 + string4 + UNION_ALL + string3 + string4 + string5;
        }
        return string6;
    }

    public String getAS400ProcedureString(BaseResultSetFilterDescriptor baseResultSetFilterDescriptor, BaseResultSetSortDescriptor baseResultSetSortDescriptor) {
        baseResultSetSortDescriptor.setSatisfied();
        String string = (String)baseResultSetFilterDescriptor.getRestriction(1);
        if (string != null && !this.catalogNameMatches(string)) {
            baseResultSetFilterDescriptor.removeAllRestrictions();
            return null;
        }
        string = this.catalogName;
        String[] stringArray = new String[]{" AND SPECIFIC_SCHEMA ", " AND SPECIFIC_NAME "};
        String[] stringArray2 = DB2MetaDataLibrary.buildParameterSet(baseResultSetFilterDescriptor, 2, 3);
        int[] nArray = new int[]{2, 3};
        String string2 = "SELECT '" + string + "', SPECIFIC_SCHEMA, SPECIFIC_NAME, 0, 0, 0, LONG_COMMENT, " + 1 + " FROM " + this.catalogSchema + ".SYSPROCS WHERE RESULT_SETS = 0 ";
        String string3 = "SELECT '" + string + "', SPECIFIC_SCHEMA, SPECIFIC_NAME, 0, 0, 0, LONG_COMMENT, " + 2 + " FROM " + this.catalogSchema + ".SYSPROCS WHERE RESULT_SETS > 0 ";
        String string4 = DB2MetaDataLibrary.joinParameterSet(baseResultSetFilterDescriptor, stringArray, stringArray2, nArray);
        String string5 = " ORDER BY 2, 3 FOR FETCH ONLY";
        baseResultSetFilterDescriptor.removeAllRestrictions();
        String string6 = string2 + string4 + UNION_ALL + string3 + string4 + string5;
        return string6;
    }

    public String getAS400ProcedureColumnsString(BaseResultSetFilterDescriptor baseResultSetFilterDescriptor, BaseResultSetSortDescriptor baseResultSetSortDescriptor) {
        Object object;
        String string = (String)baseResultSetFilterDescriptor.getRestriction(1);
        if (string != null && !this.catalogNameMatches(string)) {
            baseResultSetFilterDescriptor.removeAllRestrictions();
            return null;
        }
        string = this.catalogName;
        String string2 = null;
        if (this.useSort && baseResultSetSortDescriptor.getSortCount() > 0) {
            string2 = " ORDER BY ";
            for (int i = 0; i < baseResultSetSortDescriptor.getSortCount(); ++i) {
                int n = baseResultSetSortDescriptor.getSortColumnOrdinal(i);
                if (n <= 0) continue;
                object = String.valueOf(n);
                if (i > 0) {
                    string2 = string2 + ",";
                }
                string2 = string2 + (String)object;
            }
            string2 = string2 + " FOR FETCH ONLY";
        }
        baseResultSetSortDescriptor.setSatisfied();
        String[] stringArray = new String[]{" WHERE SPECIFIC_SCHEMA ", " AND SPECIFIC_NAME ", " AND PARAMETER_NAME "};
        String[] stringArray2 = DB2MetaDataLibrary.buildParameterSet(baseResultSetFilterDescriptor, 2, 4);
        object = new int[]{2, 3, 4};
        String string3 = DB2MetaDataLibrary.joinParameterSet(baseResultSetFilterDescriptor, stringArray, stringArray2, (int[])object);
        String string4 = "SELECT '" + this.catalogName + "', SPECIFIC_SCHEMA, SPECIFIC_NAME, PARAMETER_NAME, " + " PARAMETER_MODE , ORDINAL_POSITION, DATA_TYPE, IFNULL(NUMERIC_PRECISION, CHARACTER_MAXIMUM_LENGTH)," + " IFNULL(NUMERIC_PRECISION, CHARACTER_MAXIMUM_LENGTH)," + " NUMERIC_SCALE, NUMERIC_PRECISION_RADIX, IS_NULLABLE, NULLIF('','')" + " FROM " + this.catalogSchema + ".SYSPARMS ";
        if (string2 == null) {
            string2 = " ORDER BY 2, 3, 6 FOR FETCH ONLY";
        }
        if (string3.indexOf(" LIKE ") > 0) {
            string3 = string3 + " ESCAPE '\\'";
        }
        baseResultSetFilterDescriptor.removeAllRestrictions();
        if (string3 == null || !string3.equals("")) {
            // empty if block
        }
        String string5 = string4 + string3 + string2;
        return string5;
    }

    public String getAS400SchemaString(BaseResultSetFilterDescriptor baseResultSetFilterDescriptor, BaseResultSetSortDescriptor baseResultSetSortDescriptor) {
        baseResultSetSortDescriptor.setSatisfied();
        String string = "SELECT DISTINCT CREATOR,nullif(1,1) FROM " + this.catalogSchema + ".SYSTABLES " + "UNION SELECT DISTINCT TABLE_SCHEMA,nullif(1,1) FROM " + this.catalogSchema + ".SYSTABLES " + "ORDER BY 1 FOR FETCH ONLY";
        return string;
    }

    public String getAS400CatalogString(BaseResultSetFilterDescriptor baseResultSetFilterDescriptor, BaseResultSetSortDescriptor baseResultSetSortDescriptor) {
        baseResultSetSortDescriptor.setSatisfied();
        String string = "SELECT DISTINCT '" + this.catalogName + "' FROM " + this.catalogSchema + ".SYSTABLES ORDER BY 1 FOR FETCH ONLY";
        return string;
    }

    public String getAS400ColumnPrivilegeString(BaseResultSetFilterDescriptor baseResultSetFilterDescriptor, BaseResultSetSortDescriptor baseResultSetSortDescriptor) {
        baseResultSetSortDescriptor.setSatisfied();
        baseResultSetFilterDescriptor.removeAllRestrictions();
        return null;
    }

    public String getAS400TableString(BaseResultSetFilterDescriptor baseResultSetFilterDescriptor, BaseResultSetSortDescriptor baseResultSetSortDescriptor) {
        baseResultSetSortDescriptor.setSatisfied();
        String[] stringArray = new String[]{" AND A.TABLE_SCHEMA ", " AND A.TABLE_NAME "};
        String string = (String)baseResultSetFilterDescriptor.getRestriction(1);
        if (string != null && !this.catalogNameMatches(string)) {
            baseResultSetFilterDescriptor.removeAllRestrictions();
            return null;
        }
        string = this.catalogName;
        String[] stringArray2 = DB2MetaDataLibrary.buildParameterSet(baseResultSetFilterDescriptor, 2, 3);
        int[] nArray = new int[]{2, 3};
        String string2 = null;
        String string3 = null;
        string2 = "SELECT '" + string + "', A.TABLE_SCHEMA, A.TABLE_NAME,";
        string3 = DB2MetaDataLibrary.joinParameterSet(baseResultSetFilterDescriptor, stringArray, stringArray2, nArray);
        String string4 = " 'TABLE', A.REMARKS,nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1) FROM " + this.catalogSchema + ".SYSTABLES A, " + this.catalogSchema2 + ".SQLTABLEPRIVILEGES B WHERE (A.TYPE = 'T' OR A.TYPE = 'P')" + " AND B.TABLE_NAME = A.TABLE_NAME AND B.GRANTEE = '" + this.restrictUser + "' AND B.PRIVILEGE = 'SELECT' " + " AND A.TABLE_SCHEMA <> 'QSYS2' AND A.TABLE_SCHEMA <> '" + this.catalogSchema + "' AND A.TABLE_SCHEMA <> '" + this.catalogSchema2 + "'";
        String string5 = " 'VIEW', A.REMARKS,nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1) FROM " + this.catalogSchema + ".SYSTABLES A, " + this.catalogSchema2 + ".SQLTABLEPRIVILEGES B WHERE (A.TYPE = 'V' OR A.TYPE = 'L') " + " AND B.TABLE_NAME = A.TABLE_NAME AND B.GRANTEE = '" + this.restrictUser + "' AND B.PRIVILEGE = 'SELECT' ";
        String string6 = " 'ALIAS', A.REMARKS,nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1) FROM " + this.catalogSchema + ".SYSTABLES A, " + this.catalogSchema2 + ".SQLTABLEPRIVILEGES B WHERE A.TYPE = 'A'" + " AND B.TABLE_NAME = A.TABLE_NAME AND B.GRANTEE = '" + this.restrictUser + "' AND B.PRIVILEGE = 'SELECT' ";
        String string7 = " 'HIERARCHY', A.REMARKS,nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1) FROM " + this.catalogSchema + ".SYSTABLES A WHERE A.TYPE = 'H'";
        String string8 = " 'NICKNAME', A.REMARKS,nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1) FROM " + this.catalogSchema + ".SYSTABLES A WHERE A.TYPE = 'N'";
        String string9 = " 'SUMMARY', A.REMARKS,nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1) FROM " + this.catalogSchema + ".SYSTABLES A WHERE A.TYPE = 'S'";
        String string10 = " 'SYSTEM TABLE', A.REMARKS,nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1) FROM " + this.catalogSchema + ".SYSTABLES A WHERE A.TABLE_SCHEMA = '" + this.catalogSchema + "'";
        String string11 = " ORDER BY 4, 2, 3 FOR FETCH ONLY";
        String[] stringArray3 = (String[])baseResultSetFilterDescriptor.getRestriction(4);
        baseResultSetFilterDescriptor.removeAllRestrictions();
        String string12 = string2;
        String string13 = string3;
        if (string13.indexOf(" LIKE ") > 0) {
            string13 = string13 + " ESCAPE '\\'";
        }
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        if (stringArray3 == null) {
            stringArray3 = this.getTableTypeNames();
        }
        for (int i = 0; i < stringArray3.length; ++i) {
            String string14 = null;
            if (stringArray3[i].equals("TABLE")) {
                string14 = string12 + string4;
            } else if (stringArray3[i].equals("VIEW")) {
                string14 = string12 + string5;
            } else if (stringArray3[i].equals("ALIAS")) {
                if (!bl) {
                    string14 = string12 + string6;
                    bl = true;
                }
            } else if (stringArray3[i].equals("SYNONYMS") || stringArray3[i].equals("SYNONYM")) {
                if (!bl) {
                    string14 = string12 + string6;
                    bl = true;
                }
            } else if (stringArray3[i].equals("NICKNAME")) {
                string14 = string12 + string8;
            } else if (stringArray3[i].equals("SUMMARY TABLE")) {
                string14 = string12 + string9;
            } else if (stringArray3[i].equals("HIERARCHY TABLE")) {
                string14 = string12 + string7;
            } else if (stringArray3[i].equals("SYSTEM TABLE")) {
                string14 = string12 + string10;
            }
            if (string14 == null) continue;
            string14 = string14 + string13;
            if (stringBuffer.length() > 0) {
                stringBuffer.append(UNION);
            }
            stringBuffer.append(string14);
        }
        String string15 = stringBuffer.toString();
        if (string15 != null && string15.trim().length() > 0) {
            string15 = string15 + string11;
        }
        return string15;
    }

    public String getAS400TablePrivilegeString(BaseResultSetFilterDescriptor baseResultSetFilterDescriptor, BaseResultSetSortDescriptor baseResultSetSortDescriptor) {
        String[] stringArray = new String[]{" AND TABLE_CAT ", " AND TABLE_SCHEM ", " AND TABLE_NAME "};
        String[] stringArray2 = DB2MetaDataLibrary.buildParameterSet(baseResultSetFilterDescriptor, 1, 3);
        int[] nArray = new int[]{1, 2, 3};
        String string = DB2MetaDataLibrary.joinParameterSet(baseResultSetFilterDescriptor, stringArray, stringArray2, nArray);
        baseResultSetFilterDescriptor.removeAllRestrictions();
        String string2 = "SELECT TABLE_CAT, TABLE_SCHEM, TABLE_NAME, GRANTOR, GRANTEE, PRIVILEGE, IS_GRANTABLE FROM " + this.catalogSchema + ".SQLTABLEPRIVILEGES " + "WHERE GRANTEE <> 'PUBLIC' " + string + "ORDER BY 1,2,3,6 FOR FETCH ONLY";
        return string2;
    }

    public String getAS400BestRowIdentifierString(BaseResultSetFilterDescriptor baseResultSetFilterDescriptor, BaseResultSetSortDescriptor baseResultSetSortDescriptor) {
        baseResultSetSortDescriptor.setSatisfied();
        String[] stringArray = new String[]{" TABLE_SCHEMA ", " TABLE_NAME "};
        String[] stringArray2 = new String[]{" CT.TABLE_SCHEMA ", " CT.TABLE_NAME "};
        String[] stringArray3 = DB2MetaDataLibrary.buildParameterSet(baseResultSetFilterDescriptor, 10, 11);
        int[] nArray = new int[]{10, 11};
        int n = (Integer)baseResultSetFilterDescriptor.getRestriction(1);
        boolean bl = (Boolean)baseResultSetFilterDescriptor.getRestriction(12);
        String string = "";
        String string2 = "";
        String string3 = "SELECT 0, COLUMN_NAME, 0, DATA_TYPE, LENGTH, 0, NUMERIC_SCALE, 0 FROM  " + this.catalogSchema + ".SYSCOLUMNS WHERE ";
        String string4 = "SELECT 1, COLUMN_NAME, 0, DATA_TYPE, LENGTH, 0, NUMERIC_SCALE, 0 FROM  " + this.catalogSchema + ".SYSCOLUMNS WHERE IS_NULLABLE = 'N' AND ";
        String string5 = "SELECT 1, CT.COLUMN_NAME, 0, CT.DATA_TYPE, CT.LENGTH, 0, CT.NUMERIC_SCALE, 1 FROM " + this.catalogSchema + ".SYSCOLUMNS CT, " + this.catalogSchema + ".SYSKEYS KT, " + this.catalogSchema + ".SYSINDEXES IT WHERE KT.INDEX_OWNER = IT.INDEX_OWNER AND KT.INDEX_NAME = IT.INDEX_NAME AND KT.COLUMN_NAME = CT.COLUMN_NAME AND ";
        String string6 = "SELECT 2, CT.COLUMN_NAME, 0, CT.DATA_TYPE, CT.LENGTH, 0, CT.NUMERIC_SCALE, 1 FROM " + this.catalogSchema + ".SYSINDEXES IT, " + this.catalogSchema + ".SYSCOLUMNS CT WHERE IT.TABLE_SCHEMA = CT.TABLE_SCHEMA AND IT.TABLE_NAME = CT.TABLE_NAME AND ";
        String string7 = DB2MetaDataLibrary.joinParameterSet(baseResultSetFilterDescriptor, stringArray, stringArray3, nArray);
        String string8 = DB2MetaDataLibrary.joinParameterSet(baseResultSetFilterDescriptor, stringArray2, stringArray3, nArray);
        String string9 = " ORDER BY 1 FOR FETCH ONLY";
        baseResultSetFilterDescriptor.removeAllRestrictions();
        String string10 = null;
        string10 = bl && n == 0 ? string3 + string7 : string4 + string7;
        if (n == 1) {
            string10 = string10 + UNION_ALL + string5 + string8;
        }
        if (n == 2) {
            string10 = string10 + UNION_ALL + string6 + string8;
        }
        string10 = string10 + string9;
        return string10;
    }

    public String getAS400VersionColumnString(BaseResultSetFilterDescriptor baseResultSetFilterDescriptor, BaseResultSetSortDescriptor baseResultSetSortDescriptor) {
        baseResultSetSortDescriptor.setSatisfied();
        String[] stringArray = new String[]{" AND TABLE_SCHEMA ", " AND TABLE_NAME "};
        String string = (String)baseResultSetFilterDescriptor.getRestriction(1);
        if (string != null && !this.catalogNameMatches(string)) {
            baseResultSetFilterDescriptor.removeAllRestrictions();
            return null;
        }
        string = this.catalogName;
        String[] stringArray2 = DB2MetaDataLibrary.buildParameterSet(baseResultSetFilterDescriptor, 10, 11);
        int[] nArray = new int[]{10, 11};
        String string2 = DB2MetaDataLibrary.joinParameterSet(baseResultSetFilterDescriptor, stringArray, stringArray2, nArray);
        baseResultSetFilterDescriptor.removeAllRestrictions();
        String string3 = "SELECT 0, COLUMN_NAME, 0, DATA_TYPE, LENGTH, 0, NUMERIC_SCALE, 0 FROM " + this.catalogSchema + ".SYSCOLUMNS WHERE IS_NULLABLE = 'N' AND COLUMN_DEFAULT IN ('S', 'U')";
        String string4 = string3 + string2;
        return string4;
    }

    public String getAS400PrimaryKeysString(BaseResultSetFilterDescriptor baseResultSetFilterDescriptor, BaseResultSetSortDescriptor baseResultSetSortDescriptor) {
        baseResultSetSortDescriptor.setSatisfied();
        String string = (String)baseResultSetFilterDescriptor.getRestriction(1);
        if (string != null && !this.catalogNameMatches(string)) {
            baseResultSetFilterDescriptor.removeAllRestrictions();
            return null;
        }
        string = this.catalogName;
        String[] stringArray = new String[]{" AND T1.TABLE_SCHEMA ", " AND T1.TABLE_NAME "};
        String[] stringArray2 = DB2MetaDataLibrary.buildParameterSet(baseResultSetFilterDescriptor, 2, 3);
        int[] nArray = new int[]{2, 3};
        String string2 = "SELECT DISTINCT '" + string + "', T1.TABLE_SCHEMA, T1.TABLE_NAME, T1.COLUMN_NAME, T1.ORDINAL_POSITION, " + " T1.CONSTRAINT_NAME FROM " + this.catalogSchema + ".SYSKEYCST T1, " + this.catalogSchema + ".SYSCST T2 WHERE " + " T1.CONSTRAINT_NAME = T2.CONSTRAINT_NAME AND T1.CONSTRAINT_SCHEMA = T2.CONSTRAINT_SCHEMA " + " AND T2.CONSTRAINT_TYPE = 'PRIMARY KEY' ";
        String string3 = DB2MetaDataLibrary.joinParameterSet(baseResultSetFilterDescriptor, stringArray, stringArray2, nArray);
        String string4 = " ORDER BY 2,3,5 FOR FETCH ONLY";
        baseResultSetFilterDescriptor.removeAllRestrictions();
        String string5 = string2 + string3 + string4;
        return string5;
    }

    public String getAS400ExportedKeysString(BaseResultSetFilterDescriptor baseResultSetFilterDescriptor, BaseResultSetSortDescriptor baseResultSetSortDescriptor) {
        baseResultSetSortDescriptor.setSatisfied();
        String string = (String)baseResultSetFilterDescriptor.getRestriction(1);
        if (string != null && !this.catalogNameMatches(string)) {
            baseResultSetFilterDescriptor.removeAllRestrictions();
            return null;
        }
        string = this.catalogName;
        String[] stringArray = new String[]{" AND PK.TABLE_SCHEMA ", " AND PK.TABLE_NAME "};
        String[] stringArray2 = DB2MetaDataLibrary.buildParameterSet(baseResultSetFilterDescriptor, 2, 3);
        int[] nArray = new int[]{2, 3};
        String string2 = "SELECT DISTINCT '" + string + "', PK.TABLE_SCHEMA, PK.TABLE_NAME, PK.COLUMN_NAME, '" + string + "', FK.TABLE_SCHEMA, FK.TABLE_NAME, FK.COLUMN_NAME, " + " PK.ORDINAL_POSITION," + 3 + " , R.DELETE_RULE, " + " FK.CONSTRAINT_NAME, PK.CONSTRAINT_NAME, " + 7 + " FROM " + this.catalogSchema + ".SYSCST C, " + this.catalogSchema + ".SYSKEYCST PK, " + this.catalogSchema + ".SYSREFCST R, " + this.catalogSchema + ".SYSKEYCST FK WHERE " + " C.CONSTRAINT_NAME = PK.CONSTRAINT_NAME AND C.CONSTRAINT_SCHEMA = PK.CONSTRAINT_SCHEMA AND " + " C.CONSTRAINT_NAME = R.UNIQUE_CONSTRAINT_NAME AND C.CONSTRAINT_SCHEMA = R.UNIQUE_CONSTRAINT_SCHEMA AND" + " R.CONSTRAINT_NAME = FK.CONSTRAINT_NAME AND R.CONSTRAINT_SCHEMA = FK.CONSTRAINT_SCHEMA AND " + " PK.ORDINAL_POSITION = FK.ORDINAL_POSITION ";
        String string3 = DB2MetaDataLibrary.joinParameterSet(baseResultSetFilterDescriptor, stringArray, stringArray2, nArray);
        String string4 = " ORDER BY 6, 7, 9 FOR FETCH ONLY";
        baseResultSetFilterDescriptor.removeAllRestrictions();
        String string5 = string2 + string3 + string4;
        return string5;
    }

    public String getAS400ImportedKeysString(BaseResultSetFilterDescriptor baseResultSetFilterDescriptor, BaseResultSetSortDescriptor baseResultSetSortDescriptor) {
        baseResultSetSortDescriptor.setSatisfied();
        String string = (String)baseResultSetFilterDescriptor.getRestriction(5);
        if (string != null && !this.catalogNameMatches(string)) {
            baseResultSetFilterDescriptor.removeAllRestrictions();
            return null;
        }
        string = this.catalogName;
        String[] stringArray = new String[]{" AND FK.TABLE_SCHEMA ", " AND FK.TABLE_NAME "};
        String[] stringArray2 = DB2MetaDataLibrary.buildParameterSet(baseResultSetFilterDescriptor, 6, 7);
        int[] nArray = new int[]{6, 7};
        String string2 = "SELECT DISTINCT '" + string + "', PK.TABLE_SCHEMA, PK.TABLE_NAME, PK.COLUMN_NAME, '" + string + "', FK.TABLE_SCHEMA, FK.TABLE_NAME, FK.COLUMN_NAME, " + " FK.ORDINAL_POSITION," + 3 + " , R.DELETE_RULE, " + " FK.CONSTRAINT_NAME, PK.CONSTRAINT_NAME, " + 7 + " FROM " + this.catalogSchema + ".SYSCST C, " + this.catalogSchema + ".SYSKEYCST PK, " + this.catalogSchema + ".SYSREFCST R, " + this.catalogSchema + ".SYSKEYCST FK WHERE " + " C.CONSTRAINT_NAME = PK.CONSTRAINT_NAME AND C.CONSTRAINT_SCHEMA = PK.CONSTRAINT_SCHEMA AND " + " C.CONSTRAINT_NAME = R.UNIQUE_CONSTRAINT_NAME AND C.CONSTRAINT_SCHEMA = R.UNIQUE_CONSTRAINT_SCHEMA AND" + " R.CONSTRAINT_NAME = FK.CONSTRAINT_NAME AND R.CONSTRAINT_SCHEMA = FK.CONSTRAINT_SCHEMA AND " + " PK.ORDINAL_POSITION = FK.ORDINAL_POSITION ";
        String string3 = DB2MetaDataLibrary.joinParameterSet(baseResultSetFilterDescriptor, stringArray, stringArray2, nArray);
        String string4 = " ORDER BY 6, 7, 9 FOR FETCH ONLY";
        baseResultSetFilterDescriptor.removeAllRestrictions();
        String string5 = string2 + string3 + string4;
        return string5;
    }

    public String getAS400CrossReferenceString(BaseResultSetFilterDescriptor baseResultSetFilterDescriptor, BaseResultSetSortDescriptor baseResultSetSortDescriptor) {
        baseResultSetSortDescriptor.setSatisfied();
        String string = (String)baseResultSetFilterDescriptor.getRestriction(1);
        String string2 = (String)baseResultSetFilterDescriptor.getRestriction(5);
        if (string != null && !this.catalogNameMatches(string) || !this.catalogNameMatches(string2)) {
            baseResultSetFilterDescriptor.removeAllRestrictions();
            return null;
        }
        string = this.catalogName;
        String[] stringArray = new String[]{"", " AND PK.TABLE_SCHEMA ", " AND PK.TABLE_NAME ", "", " AND FK.TABLE_SCHEMA ", " AND FK.TABLE_NAME "};
        String[] stringArray2 = DB2MetaDataLibrary.buildParameterSet(baseResultSetFilterDescriptor, 0, 0);
        int[] nArray = new int[]{-1, 2, 3, -1, 6, 7};
        String string3 = "SELECT DISTINCT '" + string + "', PK.TABLE_SCHEMA, PK.TABLE_NAME, PK.COLUMN_NAME, '" + string + "', FK.TABLE_SCHEMA, FK.TABLE_NAME, FK.COLUMN_NAME, " + " FK.ORDINAL_POSITION," + 3 + " , R.DELETE_RULE, " + " FK.CONSTRAINT_NAME, PK.CONSTRAINT_NAME, " + 7 + " FROM " + this.catalogSchema + ".SYSCST C, " + this.catalogSchema + ".SYSKEYCST PK, " + this.catalogSchema + ".SYSREFCST R, " + this.catalogSchema + ".SYSKEYCST FK WHERE " + " C.CONSTRAINT_NAME = PK.CONSTRAINT_NAME AND C.CONSTRAINT_SCHEMA = PK.CONSTRAINT_SCHEMA AND " + " C.CONSTRAINT_NAME = R.UNIQUE_CONSTRAINT_NAME AND C.CONSTRAINT_SCHEMA = R.UNIQUE_CONSTRAINT_SCHEMA AND" + " R.CONSTRAINT_NAME = FK.CONSTRAINT_NAME AND R.CONSTRAINT_SCHEMA = FK.CONSTRAINT_SCHEMA AND " + " PK.ORDINAL_POSITION = FK.ORDINAL_POSITION ";
        String string4 = DB2MetaDataLibrary.joinParameterSet(baseResultSetFilterDescriptor, stringArray, stringArray2, nArray);
        String string5 = " ORDER BY 6, 7, 9 FOR FETCH ONLY";
        baseResultSetFilterDescriptor.removeAllRestrictions();
        String string6 = string3 + string4 + string5;
        return string6;
    }

    public String getAS400IndexInfoString(BaseResultSetFilterDescriptor baseResultSetFilterDescriptor, BaseResultSetSortDescriptor baseResultSetSortDescriptor) {
        baseResultSetSortDescriptor.setSatisfied();
        String string = (String)baseResultSetFilterDescriptor.getRestriction(1);
        if (string != null && !this.catalogNameMatches(string)) {
            baseResultSetFilterDescriptor.removeAllRestrictions();
            return null;
        }
        string = this.catalogName;
        String[] stringArray = new String[]{" AND TABLE_SCHEMA ", " AND TBNAME "};
        String[] stringArray2 = new String[]{" AND TABLE_SCHEMA ", " AND TABLE_NAME "};
        String[] stringArray3 = DB2MetaDataLibrary.buildParameterSet(baseResultSetFilterDescriptor, 2, 3);
        int[] nArray = new int[]{2, 3};
        boolean bl = (Boolean)baseResultSetFilterDescriptor.getRestriction(4);
        String string2 = "SELECT '" + string + "', TABLE_SCHEMA, TBNAME, 1," + " ' ', NAME, " + 3 + "," + " COLSEQ, COLNAME, ORDERING, COLCOUNT, 0, ' '" + " FROM " + this.catalogSchema + ".SYSINDEXES, " + this.catalogSchema + ".SYSKEYS WHERE CREATOR = IXCREATOR" + " AND NAME = IXNAME ";
        String string3 = "SELECT '" + string + "', TABLE_SCHEMA, TBNAME, 1," + " ' ', NAME, " + 3 + "," + " COLSEQ, COLNAME, ORDERING, COLCOUNT, 0, ' '" + " FROM " + this.catalogSchema + ".SYSINDEXES, " + this.catalogSchema + ".SYSKEYS WHERE CREATOR = IXCREATOR" + " AND NAME = IXNAME AND UNIQUERULE IN('U', 'P') ";
        String string4 = DB2MetaDataLibrary.joinParameterSet(baseResultSetFilterDescriptor, stringArray, stringArray3, nArray);
        String string5 = "SELECT '" + string + "', TABLE_SCHEMA, NAME, 0," + " NULLIF('',''), NULLIF('',''), " + 0 + "," + " 0, NULLIF('',''), NULLIF('',''), 0, 0, NULLIF('','')" + " FROM " + this.catalogSchema + ".SYSTABLES WHERE NAME <> ' ' ";
        String string6 = DB2MetaDataLibrary.joinParameterSet(baseResultSetFilterDescriptor, stringArray2, stringArray3, nArray);
        String string7 = " ORDER BY 4, 7 , 6, 8 FOR FETCH ONLY";
        StringBuffer stringBuffer = new StringBuffer();
        baseResultSetFilterDescriptor.removeAllRestrictions();
        String string8 = null;
        if (bl) {
            string8 = string3 + string4 + UNION_ALL + string5 + string6;
        } else if (!bl) {
            string8 = string2 + string4 + UNION_ALL + string5 + string6;
        }
        string8 = string8 + string7;
        return string8;
    }

    public String getAS400sUDTsString(BaseResultSetFilterDescriptor baseResultSetFilterDescriptor, BaseResultSetSortDescriptor baseResultSetSortDescriptor) {
        return null;
    }

    public static String[] buildParameterSet(BaseResultSetFilterDescriptor baseResultSetFilterDescriptor, int n, int n2) {
        int n3 = baseResultSetFilterDescriptor.getRestrictionCount();
        boolean bl = false;
        String[] stringArray = null;
        if (n2 > 0) {
            n3 = n2 - n + 1;
            stringArray = new String[n3];
            n3 = n2 + 1;
        } else if (n3 > 0) {
            stringArray = new String[n3];
            n = 0;
            bl = true;
        }
        int n4 = 0;
        for (int i = n; i < n3; ++i) {
            Object object = bl ? baseResultSetFilterDescriptor.getRestrictionByIndex(i) : baseResultSetFilterDescriptor.getRestriction(i);
            if (object instanceof String) {
                stringArray[n4] = (String)object;
            } else if (object instanceof Integer) {
                stringArray[n4] = Integer.toString((Integer)object);
            } else if (object instanceof Boolean) {
                stringArray[n4] = ((Boolean)object).toString();
            }
            if (baseResultSetFilterDescriptor.isPattern(i) && stringArray[n4] != null) {
                String string = stringArray[n4].trim();
                int n5 = string.length();
                if (n5 <= 0) {
                    baseResultSetFilterDescriptor.setPattern(i, false);
                } else {
                    int n6 = -1;
                    n6 = stringArray[n4].indexOf("\\");
                    if (n6 < 0) {
                        n6 = string.lastIndexOf("_");
                        if (n6 > 0 && n6 < n5 - 1) {
                            n6 = -1;
                        }
                    } else if (n6 + 1 < stringArray[n4].length() && stringArray[n4].charAt(n6 + 1) != '_' && stringArray[n4].charAt(n6 + 1) != '%' && stringArray[n4].charAt(n6 + 1) != '\\') {
                        StringBuffer stringBuffer = new StringBuffer(stringArray[n4]).deleteCharAt(n6);
                        stringArray[n4] = stringBuffer.toString();
                        n6 = -1;
                    }
                    if (n6 < 0) {
                        n6 = stringArray[n4].indexOf("%");
                    }
                    if (n6 >= 0) {
                        baseResultSetFilterDescriptor.setPattern(i, true);
                    } else {
                        baseResultSetFilterDescriptor.setPattern(i, false);
                    }
                }
            }
            ++n4;
        }
        return stringArray;
    }

    public static String joinParameterSet(BaseResultSetFilterDescriptor baseResultSetFilterDescriptor, String[] stringArray, String[] stringArray2, int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            if (nArray[i] <= 0) continue;
            boolean bl = baseResultSetFilterDescriptor.isPattern(nArray[i]);
            if (stringArray2[i] == null) continue;
            stringArray2[i] = UtilStringFunctions.turnSingleQuotesIntoConsecutiveSingleQuotes(stringArray2[i]);
            String[] stringArray3 = new String[]{"?", stringArray2[i]};
            String string = null;
            string = bl ? stringArray[i] + " LIKE ? " : stringArray[i] + " = ? ";
            UtilStringFunctions.replaceStringDelimiters(string, stringArray3, stringBuffer, true);
        }
        return stringBuffer.toString();
    }

    boolean catalogNameMatches(String string) {
        boolean bl = false;
        if (string != null && this.catalogName != null) {
            if (string.equals(this.catalogName) || string.equals("")) {
                bl = true;
            }
        } else {
            bl = true;
        }
        return bl;
    }

    public void setUseSort(boolean bl) {
        this.useSort = bl;
    }
}

