/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.xml.base;

import com.metamatrix.data.api.ConnectorLogger;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class LoggingInputStreamFilter
extends FilterInputStream {
    ConnectorLogger logger;
    StringBuffer buff = new StringBuffer();
    boolean alreadyLogged = false;

    public LoggingInputStreamFilter(InputStream in, ConnectorLogger logger) {
        super(in);
        this.logger = logger;
    }

    public int read() throws IOException {
        int retval = this.in.read();
        if (retval != -1) {
            String aChar = new Character((char)retval).toString();
            this.buff.append(aChar);
        } else {
            this.logger.logTrace("InputStreamFilter: " + this.buff.toString());
            this.alreadyLogged = true;
        }
        return retval;
    }

    public int read(byte[] b) throws IOException {
        int retval = this.in.read(b);
        if (retval != -1) {
            this.buff.append(new String(b));
        } else {
            this.logger.logTrace("InputStreamFilter: " + this.buff.toString());
            this.alreadyLogged = true;
        }
        return retval;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int retval = this.in.read(b, off, len);
        if (retval != -1) {
            this.buff.append(new String(b));
        } else {
            this.logger.logTrace("InputStreamFilter: " + this.buff.toString());
            this.alreadyLogged = true;
        }
        return retval;
    }

    public void close() throws IOException {
        super.close();
        if (!this.alreadyLogged) {
            this.logger.logTrace("LoggingXMLStreamFilter: " + this.buff.toString());
            this.alreadyLogged = true;
        }
    }
}

