/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.xml.file;

import com.metamatrix.connector.xml.base.Executor;
import com.metamatrix.connector.xml.base.XMLConnectorState;
import com.metamatrix.connector.xml.base.XMLExecution;
import com.metamatrix.connector.xml.file.FileExecutor;
import com.metamatrix.data.exception.ConnectorException;
import java.util.Properties;

public class FileConnectorState
extends XMLConnectorState {
    private String m_fileName;
    private String m_directoryPath;
    public static final String FILE_NAME = "FileName";
    public static final String DIRECTORY_PATH = "FilePath";

    public FileConnectorState() {
        this.setFileName("");
        this.setDirectoryPath("");
        this.setErrorOnRecreateDoc(false);
    }

    public FileConnectorState(Properties props) {
        this();
        this.setState(props);
    }

    public Properties getState() {
        Properties props = super.getState();
        props.setProperty(FILE_NAME, this.getFileName());
        props.setProperty(DIRECTORY_PATH, this.getDirectoryPath());
        return props;
    }

    public void setState(Properties props) {
        try {
            super.setState(props);
        }
        catch (ConnectorException connectorException) {
            // empty catch block
        }
        this.setFileName(props.getProperty(FILE_NAME));
        this.setDirectoryPath(props.getProperty(DIRECTORY_PATH));
    }

    public final void setFileName(String fileName) {
        this.m_fileName = fileName != null ? fileName : "";
    }

    public final String getFileName() {
        return this.m_fileName;
    }

    public final void setDirectoryPath(String directoryPath) {
        this.m_directoryPath = directoryPath != null ? directoryPath : "";
    }

    public final String getDirectoryPath() {
        return this.m_directoryPath;
    }

    public Executor makeExecutor(XMLExecution execution) {
        return new FileExecutor(this, execution);
    }
}

