/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.xml.base;

import com.metamatrix.data.api.ConnectorLogger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.XMLFilterImpl;

class IDGeneratingXmlFilter
extends XMLFilterImpl {
    public static final String MM_ID_ATTR_NAME_BY_PATH = "com.metamatrix.xml.xpathpart";
    public static final String MM_ID_ATTR_NAME_BY_INDEX = "com.metamatrix.xml.xpathpart.byindex";
    public static final String MM_ID_ATTR_NAME = "com.metamatrix.xml.xpathpart";
    public static final String MM_ID_ATTR_VALUE_PREFIX = "";
    ConnectorLogger logger;
    String documentId;
    int index = 0;
    List path;

    IDGeneratingXmlFilter(String documentId, ConnectorLogger logger) {
        this.documentId = documentId;
        this.logger = logger;
    }

    public void startDocument() throws SAXException {
        this.path = new ArrayList();
        PathElement newPathElement = new PathElement(this.documentId, -1);
        this.path.add(newPathElement);
        super.startDocument();
    }

    private String getIdFromIndex() {
        String retval = MM_ID_ATTR_VALUE_PREFIX + this.documentId + "/" + this.index;
        ++this.index;
        return retval;
    }

    private String getIdFromPath(String qName) {
        StringBuffer retval = new StringBuffer();
        Object oParentPath = this.path.get(this.path.size() - 1);
        PathElement parentPath = (PathElement)oParentPath;
        Map predecessorCounts = parentPath.predecessorCounts;
        Object oCount = predecessorCounts.get(qName);
        Integer count = (Integer)oCount;
        int index = count == null ? 0 : count + 1;
        predecessorCounts.put(qName, new Integer(index));
        PathElement newPathElement = new PathElement(qName, index);
        this.path.add(newPathElement);
        boolean first = true;
        Iterator iter = this.path.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            PathElement pathElement = (PathElement)o;
            if (first) {
                first = false;
            } else {
                retval.append('/');
            }
            retval.append(pathElement.name);
            if (pathElement.index < 0) continue;
            retval.append('[');
            retval.append(pathElement.index);
            retval.append(']');
        }
        return retval.toString();
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        String indexValue = this.getIdFromIndex();
        String pathValue = this.getIdFromPath(qName);
        Attributes newAtts = this.addAttributes(atts, indexValue, pathValue);
        super.startElement(namespaceURI, localName, qName, newAtts);
    }

    protected Attributes addAttributes(Attributes atts, String indexValue, String pathValue) {
        AttributesImpl newAtts = new AttributesImpl(atts);
        newAtts.addAttribute(MM_ID_ATTR_VALUE_PREFIX, "com.metamatrix.xml.xpathpart", "com.metamatrix.xml.xpathpart", "CDATA", pathValue);
        newAtts.addAttribute(MM_ID_ATTR_VALUE_PREFIX, MM_ID_ATTR_NAME_BY_INDEX, MM_ID_ATTR_NAME_BY_INDEX, "CDATA", indexValue);
        return newAtts;
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        this.path.remove(this.path.size() - 1);
        super.endElement(namespaceURI, localName, qName);
    }

    protected static class PathElement {
        protected String name;
        protected int index;
        protected Map predecessorCounts;

        protected PathElement(String name, int index) {
            this.name = name;
            this.index = index;
            this.predecessorCounts = new HashMap();
        }
    }
}

