/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.sql.lang;

import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.LanguageVisitor;
import com.metamatrix.query.sql.visitor.SQLStringVisitor;

public class JoinType
implements LanguageObject {
    public static final JoinType JOIN_INNER = new JoinType(0);
    public static final JoinType JOIN_RIGHT_OUTER = new JoinType(1);
    public static final JoinType JOIN_LEFT_OUTER = new JoinType(2);
    public static final JoinType JOIN_FULL_OUTER = new JoinType(3);
    public static final JoinType JOIN_CROSS = new JoinType(4);
    private int type;

    private JoinType(int type) {
        this.type = type;
    }

    int getTypeCode() {
        return this.type;
    }

    public JoinType getReverseType() {
        if (this.equals(JOIN_RIGHT_OUTER)) {
            return JOIN_LEFT_OUTER;
        }
        if (this.equals(JOIN_LEFT_OUTER)) {
            return JOIN_RIGHT_OUTER;
        }
        return this;
    }

    public boolean isOuter() {
        return this.equals(JOIN_LEFT_OUTER) || this.equals(JOIN_FULL_OUTER) || this.equals(JOIN_RIGHT_OUTER);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!this.getClass().isInstance(other)) {
            return false;
        }
        return ((JoinType)other).getTypeCode() == this.type;
    }

    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    public int hashCode() {
        return this.type;
    }

    public Object clone() {
        return this;
    }

    public String toString() {
        return SQLStringVisitor.getSQLString(this);
    }
}

