/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.metadata;

import com.metamatrix.query.metadata.TempMetadataID;
import com.metamatrix.query.sql.symbol.AliasSymbol;
import com.metamatrix.query.sql.symbol.ElementSymbol;
import com.metamatrix.query.sql.symbol.SingleElementSymbol;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class TempMetadataStore
implements Serializable {
    private static final String SEPARATOR = ".";
    private Map tempGroups;

    public TempMetadataStore() {
        this(new HashMap());
    }

    public TempMetadataStore(Map data) {
        this.tempGroups = data == null ? new HashMap() : data;
    }

    public Map getData() {
        return this.tempGroups;
    }

    public void addTempGroup(String tempGroup, List tempSymbols) {
        this.addTempGroup(tempGroup, tempSymbols, true);
    }

    public void addTempGroup(String tempGroup, List tempSymbols, boolean isVirtual) {
        this.addTempGroup(tempGroup, tempGroup.toUpperCase(), null, tempSymbols, isVirtual);
    }

    public void addTempGroup(String tempGroup, String ucaseTempGroup, String tempGroupDefinition, List tempSymbols, boolean isVirtual) {
        String tempName = ucaseTempGroup;
        ArrayList<TempMetadataID> elementIDs = new ArrayList<TempMetadataID>(tempSymbols.size());
        Iterator symbolIter = tempSymbols.iterator();
        while (symbolIter.hasNext()) {
            SingleElementSymbol symbol = (SingleElementSymbol)symbolIter.next();
            String elementName = tempName + SEPARATOR + symbol.getShortCanonicalName();
            Object metadataID = null;
            if (symbol instanceof AliasSymbol) {
                AliasSymbol as = (AliasSymbol)symbol;
                symbol = as.getSymbol();
            }
            if (symbol instanceof ElementSymbol) {
                metadataID = ((ElementSymbol)symbol).getMetadataID();
            }
            while (metadataID != null && metadataID instanceof TempMetadataID) {
                metadataID = ((TempMetadataID)metadataID).getOriginalMetadataID();
            }
            TempMetadataID elementID = new TempMetadataID(elementName, symbol.getType(), metadataID);
            elementIDs.add(elementID);
        }
        TempMetadataID groupID = new TempMetadataID(tempName, tempGroupDefinition, tempGroup, elementIDs, isVirtual);
        this.tempGroups.put(tempName, groupID);
    }

    public void addTempGroups(Map tempGroupMap) {
        if (tempGroupMap != null && tempGroupMap.size() > 0) {
            Iterator keyIter = tempGroupMap.keySet().iterator();
            while (keyIter.hasNext()) {
                String tempGroupName = (String)keyIter.next();
                TempMetadataID groupID = (TempMetadataID)tempGroupMap.get(tempGroupName);
                this.tempGroups.put(tempGroupName, groupID);
            }
        }
    }

    public TempMetadataID getTempGroupID(String tempGroup) {
        return (TempMetadataID)this.tempGroups.get(tempGroup.toUpperCase());
    }

    public TempMetadataID getTempElementID(String tempElement) {
        int index = tempElement.lastIndexOf(SEPARATOR);
        if (index < 0) {
            return null;
        }
        String groupName = tempElement.substring(0, index);
        TempMetadataID groupID = (TempMetadataID)this.tempGroups.get(groupName.toUpperCase());
        if (groupID != null) {
            Iterator elementIter = groupID.getElements().iterator();
            while (elementIter.hasNext()) {
                TempMetadataID elementID = (TempMetadataID)elementIter.next();
                if (!elementID.getID().equalsIgnoreCase(tempElement)) continue;
                return elementID;
            }
        }
        return null;
    }

    public List getTempElementElementIDs(String tempGroup) {
        TempMetadataID groupID = (TempMetadataID)this.tempGroups.get(tempGroup.toUpperCase());
        if (groupID != null) {
            return groupID.getElements();
        }
        return null;
    }
}

