/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.comm.platform.socket.server;

import com.metamatrix.common.comm.api.Message;
import com.metamatrix.common.comm.api.MessageHolder;
import com.metamatrix.common.comm.api.ServerListener;
import com.metamatrix.common.comm.exception.CommunicationException;
import com.metamatrix.common.comm.platform.socket.ObjectSocket;
import com.metamatrix.common.comm.platform.socket.SocketClientInstanceStats;
import com.metamatrix.common.comm.platform.socket.SocketConnectionProtocol;
import com.metamatrix.common.comm.platform.socket.SocketLog;
import com.metamatrix.common.comm.platform.socket.packet.AsynchronousPacket;
import com.metamatrix.common.comm.platform.socket.packet.ClosingPacket;
import com.metamatrix.common.comm.platform.socket.packet.ConnectionPacket;
import com.metamatrix.common.comm.platform.socket.packet.Packet;
import com.metamatrix.common.comm.platform.socket.packet.SynchronousPacket;
import com.metamatrix.common.comm.platform.socket.server.ServerAsynchronousWorkItem;
import com.metamatrix.common.comm.platform.socket.server.ServerSynchronousWorkItem;
import com.metamatrix.common.comm.platform.socket.server.SocketClientConnection;
import com.metamatrix.common.comm.service.ExceptionHolder;
import com.metamatrix.common.queue.QueueSuspendedException;
import com.metamatrix.common.queue.WorkerPool;
import com.metamatrix.common.util.ApplicationInfo;
import com.metamatrix.core.MetaMatrixRuntimeException;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;

public class SocketClientInstance
implements SocketConnectionProtocol {
    private ObjectSocket objectSocket;
    private ServerListener serverListener;
    private SocketLog log;
    private WorkerPool workerPool;
    private static String releaseNumber;
    private SocketClientInstanceStats stats = new SocketClientInstanceStats();
    private Map clientConnections = new HashMap();

    public SocketClientInstance(ObjectSocket objectSocket, ServerListener serverListener, WorkerPool workerPool, SocketLog log, int inputBufferSize, int outputBufferSize) throws CommunicationException, IOException {
        this.objectSocket = objectSocket;
        objectSocket.initialize(this);
        this.serverListener = serverListener;
        this.log = log;
        this.workerPool = workerPool;
    }

    void send(int virtualSocketId, Message message, String messageKey) throws CommunicationException {
        this.objectSocket.write(new AsynchronousPacket(virtualSocketId, messageKey, message));
        ++this.stats.objectsWritten;
    }

    void sendSynchronousResponse(int virtualSocketId, Integer synchRequestId, Message message) throws CommunicationException {
        this.objectSocket.write(new SynchronousPacket(virtualSocketId, synchRequestId, message));
        ++this.stats.objectsWritten;
    }

    private String getVersionInfo() {
        if (releaseNumber == null) {
            releaseNumber = "Unknown Release";
            try {
                ApplicationInfo info = ApplicationInfo.getInstance();
                info.setMainComponent("metamatrix-server.jar");
                ApplicationInfo.Component component = info.getMainComponent();
                releaseNumber = component.getReleaseNumber();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return releaseNumber;
    }

    public void handshake(Socket socket, ObjectInputStream is, ObjectOutputStream os) throws CommunicationException, IOException {
        try {
            int timeout = socket.getSoTimeout();
            socket.setSoTimeout(2000);
            is.readObject();
            socket.setSoTimeout(timeout);
            os.writeObject(this.getVersionInfo());
            os.flush();
        }
        catch (ClassNotFoundException e) {
            throw new CommunicationException((Throwable)e, "Handshake Error");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read() {
        try {
            try {
                while (true) {
                    this.readDirect();
                }
            }
            catch (EOFException e) {
                this.log.logDetail("SocketClientConnection.read", e, "Unable to read: socket was already closed.");
                Object var3_4 = null;
                if (this.objectSocket != null) {
                    try {
                        this.objectSocket.close();
                    }
                    catch (CommunicationException err) {}
                }
            }
            catch (CommunicationException e) {
                this.log.logDetail("SocketClientConnection.read", e, "Unable to read: socket was already closed.");
                Object var3_5 = null;
                if (this.objectSocket != null) {
                    try {
                        this.objectSocket.close();
                    }
                    catch (CommunicationException err) {}
                }
            }
            catch (Throwable e) {
                this.log.logError("SocketClientConnection.read", e, e.getMessage());
                Object var3_6 = null;
                if (this.objectSocket != null) {
                    try {
                        this.objectSocket.close();
                    }
                    catch (CommunicationException err) {}
                }
            }
        }
        catch (Throwable throwable) {
            Object var3_7 = null;
            if (this.objectSocket != null) {
                try {
                    this.objectSocket.close();
                }
                catch (CommunicationException err) {
                    // empty catch block
                }
            }
            throw throwable;
        }
    }

    protected void readDirect() throws EOFException, CommunicationException {
        Packet rawData = this.objectSocket.read();
        ++this.stats.objectsRead;
        if (rawData instanceof ConnectionPacket) {
            this.processConnectionPacket((ConnectionPacket)rawData);
        } else if (rawData instanceof AsynchronousPacket) {
            this.processAsynchronousPacket((AsynchronousPacket)rawData);
        } else if (rawData instanceof SynchronousPacket) {
            this.processSynchronousPacket((SynchronousPacket)rawData);
        } else if (rawData instanceof ClosingPacket) {
            this.processClosingPacket((ClosingPacket)rawData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processConnectionPacket(ConnectionPacket packet) {
        SocketClientConnection clientConnection = null;
        Map map = this.clientConnections;
        synchronized (map) {
            clientConnection = (SocketClientConnection)this.clientConnections.get(new Integer(packet.virtualSocketID));
            if (clientConnection != null) {
                this.serverListener.connectionRemoved(clientConnection);
            }
            clientConnection = new SocketClientConnection(this, packet.virtualSocketID, packet.properties);
            this.clientConnections.put(new Integer(packet.virtualSocketID), clientConnection);
            this.stats.virtualSockets.add(new Integer(packet.virtualSocketID));
            this.serverListener.connectionAdded(clientConnection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SocketClientConnection lookup(int virtualSocketId) {
        Map map = this.clientConnections;
        synchronized (map) {
            return (SocketClientConnection)this.clientConnections.get(new Integer(virtualSocketId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SocketClientConnection removeFromConnectionMap(int virtualSocketId) {
        Map map = this.clientConnections;
        synchronized (map) {
            this.stats.virtualSockets.remove(new Integer(virtualSocketId));
            return (SocketClientConnection)this.clientConnections.remove(new Integer(virtualSocketId));
        }
    }

    private void processAsynchronousPacket(AsynchronousPacket packet) {
        if (this.log.isLogged("SocketClientConnection.read", 5)) {
            this.log.logDetail("SocketClientConnection.read", "processing asynch message:" + packet.message);
        }
        SocketClientConnection clientConnection = this.lookup(packet.virtualSocketID);
        if (this.deserializationFailed(packet.message)) {
            if (this.log.isLogged("SocketClientConnection.read", 2)) {
                this.log.logError("SocketClientConnection.read", ((ExceptionHolder)((MessageHolder)packet.message).contents).exception, "Exception while deserializing an asynchronous message packet.");
            }
            try {
                clientConnection.send(packet.message, packet.messageKey);
            }
            catch (Throwable t) {
                this.log.logError("SocketClientConnection.read", t, "Exception when sending an asynchronous error packet.");
            }
        } else {
            this.addAsynchWork(clientConnection, this.serverListener, packet.message, packet.messageKey, this.log);
        }
    }

    private void processSynchronousPacket(SynchronousPacket packet) {
        if (this.log.isLogged("SocketClientConnection.read", 5)) {
            this.log.logDetail("SocketClientConnection.read", "processing synch message:" + packet.message + " virtualSocketId:" + packet.virtualSocketID);
        }
        SocketClientConnection clientConnection = this.lookup(packet.virtualSocketID);
        if (this.deserializationFailed(packet.message)) {
            if (this.log.isLogged("SocketClientConnection.read", 2)) {
                this.log.logError("SocketClientConnection.read", ((ExceptionHolder)((MessageHolder)packet.message).contents).exception, "Exception while deserializing a synchronous message packet.");
            }
            try {
                clientConnection.sendSynchronousResponse(packet.synchRequestID, packet.message);
            }
            catch (Throwable t) {
                this.log.logError("SocketClientConnection.read", t, "Exception when sending a synchronous error packet.");
            }
        } else {
            this.addSynchWork(clientConnection, this.objectSocket, packet.synchRequestID, packet.message, this.log, this.serverListener);
        }
    }

    private void processClosingPacket(ClosingPacket data) {
        SocketClientConnection clientConnection = this.removeFromConnectionMap(data.virtualSocketID);
        this.serverListener.connectionRemoved(clientConnection);
    }

    private void addAsynchWork(SocketClientConnection clientConnection, ServerListener serverListener, Message message, String messageKey, SocketLog log) {
        try {
            this.workerPool.addWork(new ServerAsynchronousWorkItem(clientConnection, serverListener, message, messageKey, log));
        }
        catch (QueueSuspendedException e) {
            throw new MetaMatrixRuntimeException(e);
        }
    }

    private void addSynchWork(SocketClientConnection clientConnection, ObjectSocket objectSocket, Integer synchRequestId, Message message, SocketLog log, ServerListener serverListener) {
        try {
            this.workerPool.addWork(new ServerSynchronousWorkItem(clientConnection, synchRequestId, message, log, serverListener));
        }
        catch (QueueSuspendedException e) {
            throw new MetaMatrixRuntimeException(e);
        }
    }

    private boolean deserializationFailed(Message message) {
        return message instanceof MessageHolder && ((MessageHolder)message).contents instanceof ExceptionHolder;
    }

    public SocketClientInstanceStats getStats() {
        return this.stats;
    }
}

