/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbcx.oracle;

import com.metamatrix.jdbc.base.BaseConnection;
import com.metamatrix.jdbcx.base.BaseImplXAResource;
import com.metamatrix.jdbcx.base.BaseXADataSource;
import com.metamatrix.jdbcx.oracle.OracleImplXAResource;
import java.sql.SQLException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;

public class OracleDataSource
extends BaseXADataSource {
    private static String footprint = "$Revision:   3.22.1.0  $";
    String SID;
    String serviceName;
    String refCursorSupportString;
    String FetchTSWTZasTimestampString;
    String serverType;
    String codePageOverride = "";
    String tnsNamesFile;
    String tnsServerName;
    String sendFloatParametersAsString;
    String supportLinks;
    boolean enableCancelTimeout;
    String authenticationMethod = "auto";
    String sysLoginRole = "";
    int wireProtocolMode = 1;
    int catalogOptions = 2;
    boolean ignoreCatalogIncludesSynonymsSetting = false;
    String commitBehavior = "serverDefault";
    String encryptionMethod = "noEncryption";
    String keyPassword = "";
    String keyStore = "";
    String keyStorePassword = "";
    String trustStore = "";
    String trustStorePassword = "";
    boolean validateServerCertificate = true;
    String hostNameInCertificate = "";

    public final boolean getEnableCancelTimeout() {
        return this.enableCancelTimeout;
    }

    public int getPortNumber() {
        int n = super.getPortNumber();
        if (n == 0) {
            return 1521;
        }
        return n;
    }

    public String getSID() {
        return this.SID;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getServerType() {
        return this.serverType;
    }

    public String getTNSServerName() {
        return this.tnsServerName;
    }

    public String getTNSNamesFile() {
        return this.tnsNamesFile;
    }

    public String getFetchTSWTZasTimestamp() {
        return this.FetchTSWTZasTimestampString;
    }

    public String getrefCursorSupport() {
        return this.refCursorSupportString;
    }

    public boolean getCatalogIncludesSynonyms() {
        return (this.catalogOptions & 2) > 0;
    }

    public int getCatalogOptions() {
        return this.catalogOptions;
    }

    public int getWireProtocolMode() {
        return this.wireProtocolMode;
    }

    public String getSendFloatParametersAsString() {
        return this.sendFloatParametersAsString;
    }

    public String getSupportLinks() {
        return this.supportLinks;
    }

    public void setSendFloatParametersAsString(String string) {
        this.sendFloatParametersAsString = string;
    }

    public void setSupportLinks(String string) {
        this.supportLinks = string;
    }

    public void setFetchTSWTZasTimestamp(String string) {
        this.FetchTSWTZasTimestampString = string;
    }

    public void setrefCursorSupport(String string) {
        this.refCursorSupportString = string;
    }

    public void setCatalogOptions(int n) {
        this.catalogOptions = n;
        this.ignoreCatalogIncludesSynonymsSetting = true;
    }

    public void setWireProtocolMode(int n) {
        this.wireProtocolMode = n;
    }

    public void setCatalogIncludesSynonyms(boolean bl) {
        if (!this.ignoreCatalogIncludesSynonymsSetting) {
            this.catalogOptions = bl ? 2 : 0;
        }
    }

    public String getCodePageOverride() {
        return this.codePageOverride;
    }

    public void setCodePageOverride(String string) {
        this.codePageOverride = string == null ? "" : string;
    }

    public final void setEnableCancelTimeout(boolean bl) {
        this.enableCancelTimeout = bl;
    }

    public void setSID(String string) {
        this.SID = string;
    }

    public void setServiceName(String string) {
        this.serviceName = string;
    }

    public void setServerType(String string) {
        this.serverType = string;
    }

    public void setTNSServerName(String string) {
        this.tnsServerName = string;
    }

    public void setTNSNamesFile(String string) {
        this.tnsNamesFile = string;
    }

    public String getAuthenticationMethod() {
        return this.authenticationMethod;
    }

    public void setAuthenticationMethod(String string) {
        this.authenticationMethod = string == null ? "auto" : string;
    }

    public String getSysLoginRole() {
        return this.sysLoginRole;
    }

    public void setSysLoginRole(String string) {
        this.sysLoginRole = string == null ? "" : string;
    }

    public String getCommitBehavior() {
        return this.commitBehavior;
    }

    public void setCommitBehavior(String string) {
        this.commitBehavior = string == null ? "serverDefault" : string;
    }

    public String getEncryptionMethod() {
        return this.encryptionMethod;
    }

    public void setEncryptionMethod(String string) {
        this.encryptionMethod = string == null ? "noEncryption" : string;
    }

    public final boolean getValidateServerCertificate() {
        return this.validateServerCertificate;
    }

    public final void setValidateServerCertificate(boolean bl) {
        this.validateServerCertificate = bl;
    }

    public String getHostNameInCertificate() {
        return this.hostNameInCertificate;
    }

    public void setHostNameInCertificate(String string) {
        this.hostNameInCertificate = string;
    }

    public String getKeyPassword() {
        return this.keyPassword;
    }

    public void setKeyPassword(String string) {
        this.keyPassword = string;
    }

    public String getKeyStore() {
        return this.keyStore;
    }

    public void setKeyStore(String string) {
        this.keyStore = string;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public void setKeyStorePassword(String string) {
        this.keyStorePassword = string;
    }

    public String getTrustStore() {
        return this.trustStore;
    }

    public void setTrustStore(String string) {
        this.trustStore = string;
    }

    public String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    public void setTrustStorePassword(String string) {
        this.trustStorePassword = string;
    }

    protected void implAddProperties(Reference reference) {
        if (this.SID != null) {
            reference.add(new StringRefAddr("SID", this.SID));
        }
        if (this.serviceName != null) {
            reference.add(new StringRefAddr("serviceName", this.serviceName));
        }
        if (this.serverType != null) {
            reference.add(new StringRefAddr("serverType", this.serverType));
        }
        if (this.refCursorSupportString != null) {
            reference.add(new StringRefAddr("refCursorSupport", this.refCursorSupportString));
        }
        if (this.FetchTSWTZasTimestampString != null) {
            reference.add(new StringRefAddr("FetchTSWTZasTimestamp", this.FetchTSWTZasTimestampString));
        }
        if (this.tnsNamesFile != null) {
            reference.add(new StringRefAddr("TNSNamesFile", this.tnsNamesFile));
        }
        if (this.tnsServerName != null) {
            reference.add(new StringRefAddr("TNSServerName", this.tnsServerName));
        }
        if (this.codePageOverride != null) {
            reference.add(new StringRefAddr("codePageOverride", this.codePageOverride));
        }
        if (this.sendFloatParametersAsString != null) {
            reference.add(new StringRefAddr("sendFloatParametersAsString", this.sendFloatParametersAsString));
        }
        if (this.supportLinks != null) {
            reference.add(new StringRefAddr("supportLinks", this.supportLinks));
        }
        reference.add(new StringRefAddr("authenticationMethod", this.authenticationMethod));
        reference.add(new StringRefAddr("enableCancelTimeout", new Boolean(this.enableCancelTimeout).toString()));
        if (this.wireProtocolMode != 1) {
            reference.add(new StringRefAddr("wireProtocolMode", Integer.toString(this.wireProtocolMode)));
        }
        if (this.catalogOptions != 2) {
            reference.add(new StringRefAddr("catalogOptions", Integer.toString(this.catalogOptions)));
            reference.add(new StringRefAddr("CatalogIncludesSynonyms", "false"));
        }
        reference.add(new StringRefAddr("encryptionMethod", this.encryptionMethod));
        if (this.sysLoginRole != null) {
            reference.add(new StringRefAddr("sysLoginRole", this.sysLoginRole));
        }
        reference.add(new StringRefAddr("commitBehavior", this.commitBehavior));
        if (this.keyPassword != null) {
            reference.add(new StringRefAddr("keyPassword", this.keyPassword));
        }
        if (this.keyStore != null) {
            reference.add(new StringRefAddr("keyStore", this.keyStore));
        }
        if (this.keyStorePassword != null) {
            reference.add(new StringRefAddr("keyStorePassword", this.keyStorePassword));
        }
        if (this.trustStore != null) {
            reference.add(new StringRefAddr("trustStore", this.trustStore));
        }
        if (this.trustStorePassword != null) {
            reference.add(new StringRefAddr("trustStorePassword", this.trustStorePassword));
        }
        try {
            reference.add(new StringRefAddr("validateServerCertificate", new Boolean(this.validateServerCertificate).toString()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.hostNameInCertificate != null) {
            reference.add(new StringRefAddr("hostNameInCertificate", this.hostNameInCertificate));
        }
    }

    protected String implGetPropertyNameValuePairs() throws SQLException {
        String string = null;
        if (this.SID != null) {
            string = "SID=" + this.SID;
        }
        if (this.serviceName != null) {
            string = string == null ? "serviceName=" + this.serviceName : string + ";serviceName=" + this.serviceName;
        }
        if (this.serverType != null) {
            string = string == null ? "serverType=" + this.serverType : string + ";serverType=" + this.serverType;
        }
        if (this.refCursorSupportString != null) {
            string = string == null ? "refCursorSupport=" + this.refCursorSupportString : string + ";refCursorSupport=" + this.refCursorSupportString;
        }
        if (this.FetchTSWTZasTimestampString != null) {
            string = string == null ? "FetchTSWTZasTimestamp=" + this.FetchTSWTZasTimestampString : string + ";FetchTSWTZasTimestamp=" + this.FetchTSWTZasTimestampString;
        }
        if (this.tnsServerName != null) {
            string = string == null ? "TNSServerName=" + this.tnsServerName : string + ";TNSServerName=" + this.tnsServerName;
        }
        if (this.tnsNamesFile != null) {
            string = string == null ? "TNSNamesFile=" + this.tnsNamesFile : string + ";TNSNamesFile=" + this.tnsNamesFile;
        }
        if (this.catalogOptions != 2) {
            string = string == null ? "CatalogIncludesSynonyms=" + ((this.catalogOptions & 2) > 0 ? "TRUE" : "FALSE") + ";catalogOptions=" + this.catalogOptions : string + ";CatalogIncludesSynonyms=" + ((this.catalogOptions & 2) > 0 ? "TRUE" : "FALSE") + ";catalogOptions=" + this.catalogOptions;
        }
        if (this.codePageOverride != null) {
            string = string == null ? "codePageOverride=" + this.codePageOverride : string + ";codePageOverride=" + this.codePageOverride;
        }
        string = string == null ? "enableCancelTimeout=" + this.enableCancelTimeout : string + ";enableCancelTimeout=" + this.enableCancelTimeout;
        string = string == null ? "authenticationMethod=" + this.authenticationMethod : string + ";authenticationMethod=" + this.authenticationMethod;
        if (this.sendFloatParametersAsString != null) {
            string = string == null ? "sendFloatParametersAsString=" + this.sendFloatParametersAsString : string + ";sendFloatParametersAsString=" + this.sendFloatParametersAsString;
        }
        if (this.supportLinks != null) {
            string = string == null ? "supportLinks=" + this.supportLinks : string + ";supportLinks=" + this.supportLinks;
        }
        if (this.wireProtocolMode != 1) {
            string = string == null ? "wireProtocolMode=" + this.wireProtocolMode : string + ";wireProtocolMode=" + this.wireProtocolMode;
        }
        string = string == null ? "encryptionMethod=" + this.encryptionMethod : string + ";encryptionMethod=" + this.encryptionMethod;
        if (this.sysLoginRole != null) {
            string = string == null ? "sysLoginRole=" + this.sysLoginRole : string + ";sysLoginRole=" + this.sysLoginRole;
        }
        string = string == null ? "commitBehavior=" + this.commitBehavior : string + ";commitBehavior=" + this.commitBehavior;
        if (this.keyPassword != null) {
            string = string + ";keyPassword=" + this.keyPassword + ";";
        }
        if (this.keyStore != null) {
            string = string + ";keyStore=" + this.keyStore + ";";
        }
        if (this.keyStorePassword != null) {
            string = string + ";keyStorePassword=" + this.keyStorePassword + ";";
        }
        if (this.trustStore != null) {
            string = string + ";trustStore=" + this.trustStore + ";";
        }
        if (this.trustStorePassword != null) {
            string = string + ";trustStorePassword=" + this.trustStorePassword + ";";
        }
        if (this.hostNameInCertificate != null) {
            string = string + ";hostNameInCertificate=" + this.hostNameInCertificate + ";";
        }
        string = string == null ? "validateServerCertificate=" + this.validateServerCertificate : string + ";validateServerCertificate=" + this.validateServerCertificate;
        return string;
    }

    protected BaseImplXAResource createImplXAResource(BaseConnection baseConnection) {
        return new OracleImplXAResource(baseConnection);
    }

    public String getAuthenticatedUser(String string) {
        if (this.authenticationMethod.equalsIgnoreCase("client")) {
            return System.getProperty("user.name");
        }
        return "";
    }
}

