/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.sqlserver;

import com.metamatrix.jdbc.base.BaseData;
import com.metamatrix.jdbc.base.BaseExceptions;
import com.metamatrix.jdbc.sqlserver.SQLServerByteOrderedDataReader;
import com.metamatrix.jdbc.sqlserver.SQLServerConnection;
import com.metamatrix.util.UtilException;
import com.metamatrix.util.UtilPagedTempBuffer;
import com.metamatrix.util.UtilTransliterator;
import java.io.InputStream;
import java.sql.SQLException;

public final class SQLServerColumn {
    private static String footprint = "$Revision:   3.10.1.0  $";
    public byte TDSType = 0;
    public BaseData data;
    public UtilPagedTempBuffer longData;
    public boolean longDataCached = false;
    private long writePositionOfLongData = 0L;
    public boolean releaseLongDataAtNextFetch = false;
    public UtilTransliterator nonUnicodeCharTransliterator = null;
    public boolean isPartLenDataType = false;

    public SQLServerColumn(SQLServerConnection sQLServerConnection) {
        this.data = new BaseData(sQLServerConnection);
        this.longData = null;
    }

    public boolean isLongColumn() {
        return this.TDSType == 35 || this.TDSType == 99 || this.TDSType == 34 || this.TDSType == -15;
    }

    public void cacheLongData(int n, SQLServerByteOrderedDataReader sQLServerByteOrderedDataReader, int n2, UtilTransliterator utilTransliterator, boolean bl, boolean bl2, BaseExceptions baseExceptions) throws SQLException {
        try {
            if (this.longData == null) {
                this.longData = new UtilPagedTempBuffer(n);
            } else if (bl) {
                this.longData.truncate();
            }
            if (bl) {
                this.writePositionOfLongData = 0L;
            }
            if (utilTransliterator == null) {
                int n3 = 0;
                byte[] byArray = new byte[16384];
                while (n2 > 0) {
                    n3 = sQLServerByteOrderedDataReader.getArrayOfBytes(byArray, 0, Math.min(16384, n2));
                    this.writePositionOfLongData += (long)this.longData.write(this.writePositionOfLongData, byArray, 0, n3);
                    n2 -= n3;
                }
            } else {
                boolean bl3 = false;
                UtilException utilException = null;
                int n4 = 0;
                byte[] byArray = new byte[8192];
                InputStream inputStream = utilTransliterator.decodeAsUCS2ByteStream(sQLServerByteOrderedDataReader.getInputStream(n2, bl2), n2);
                while (n4 != -1) {
                    n4 = inputStream.read(byArray, 0, 8192);
                    try {
                        if (n4 == -1 || bl3) continue;
                        this.writePositionOfLongData += (long)this.longData.write(this.writePositionOfLongData, byArray, 0, n4);
                    }
                    catch (UtilException utilException2) {
                        inputStream.skip(n2);
                        utilException = utilException2;
                        bl3 = true;
                    }
                }
                if (utilException != null) {
                    throw utilException;
                }
            }
        }
        catch (Exception exception) {
            throw baseExceptions.getException(exception);
        }
        this.longDataCached = true;
    }
}

