/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.oracle;

import com.metamatrix.jdbc.base.BaseColumn;
import com.metamatrix.jdbc.base.BaseExceptions;
import com.metamatrix.jdbc.base.BaseParameter;
import com.metamatrix.jdbc.oracle.net8.OracleDataConsumer;
import com.metamatrix.jdbc.oracle.net8.OracleDataProvider;
import com.metamatrix.util.UtilDebug;
import com.metamatrix.util.UtilException;
import com.metamatrix.util.UtilTransliterator;
import java.io.InputStream;
import java.io.Reader;
import java.sql.SQLException;

public class OracleInternalParameter {
    private static String footprint = "$Revision:   1.9.1.1  $";
    public int m_nativeBindType;
    public int m_precision;
    public int m_scale;
    public long m_maxlen;
    public int m_direction = 32;
    public int m_charSetId;
    public int m_charSetForm;
    public UtilTransliterator m_transliterator;
    public byte[] m_nativeDataIn;
    public int m_nativeDataInLength;
    public int m_nativeDataInOffset;
    private byte[][] m_nativeDataOut;
    private int[] m_nativeDataOutLength;
    private int m_numOutputValues = 0;
    public BaseParameter m_baseParameter;
    public BaseColumn[] m_columnDescriptions;
    public static final byte IN = 32;
    public static final byte OUT = 16;

    public void setInfo(int n, int n2, int n3, int n4, int n5, int n6, UtilTransliterator utilTransliterator) {
        this.m_nativeBindType = n;
        this.m_precision = n2;
        this.m_scale = n3;
        this.m_maxlen = n4;
        this.m_charSetId = n5;
        this.m_charSetForm = n6;
        this.m_transliterator = utilTransliterator;
        this.m_baseParameter = null;
    }

    public void copy(OracleInternalParameter oracleInternalParameter) {
        this.m_nativeBindType = oracleInternalParameter.m_nativeBindType;
        this.m_precision = oracleInternalParameter.m_precision;
        this.m_scale = oracleInternalParameter.m_scale;
        this.m_maxlen = oracleInternalParameter.m_maxlen;
        this.m_charSetId = oracleInternalParameter.m_charSetId;
        this.m_charSetForm = oracleInternalParameter.m_charSetForm;
        this.m_transliterator = oracleInternalParameter.m_transliterator;
        this.m_direction = oracleInternalParameter.m_direction;
        this.m_baseParameter = oracleInternalParameter.m_baseParameter;
    }

    public byte[] getSingleOutputValue(BaseExceptions baseExceptions) throws SQLException {
        if (this.m_numOutputValues > 1) {
            throw baseExceptions.getException(7049);
        }
        return this.m_nativeDataOut[0];
    }

    public int getSingleOutputValueLength(BaseExceptions baseExceptions) throws SQLException {
        if (this.m_numOutputValues > 1) {
            throw baseExceptions.getException(7049);
        }
        return this.m_nativeDataOutLength[0];
    }

    public byte[] getOutputValue(int n, BaseExceptions baseExceptions) throws SQLException {
        if (n >= this.m_numOutputValues) {
            throw baseExceptions.getException(7049);
        }
        return this.m_nativeDataOut[n];
    }

    public int getOutputValueLength(int n, BaseExceptions baseExceptions) throws SQLException {
        if (n >= this.m_numOutputValues) {
            throw baseExceptions.getException(7049);
        }
        return this.m_nativeDataOutLength[n];
    }

    public byte[][] getAllOutputValues() {
        return this.m_nativeDataOut;
    }

    public int getNumOutputValues() {
        if (this.m_numOutputValues == 1) {
            return this.m_nativeDataOut[0] == null ? 0 : 1;
        }
        return this.m_numOutputValues;
    }

    public void setupNativeDataInBuffer(int n) {
        if (this.m_nativeDataIn == null || n > this.m_nativeDataIn.length) {
            this.m_nativeDataIn = new byte[n];
        }
    }

    public void readData(int n, OracleDataProvider oracleDataProvider) throws UtilException, SQLException {
        Object object = null;
        this.m_nativeDataOut = new byte[n][];
        this.m_nativeDataOutLength = new int[n];
        this.m_numOutputValues = n;
        switch (this.m_nativeBindType) {
            case 1: 
            case 2: 
            case 6: 
            case 8: 
            case 11: 
            case 12: 
            case 23: 
            case 24: 
            case 96: 
            case 100: 
            case 101: 
            case 102: 
            case 104: 
            case 180: 
            case 181: 
            case 208: 
            case 231: {
                for (int i = 0; i < n; ++i) {
                    object = oracleDataProvider.readCLR(4000);
                    short s = oracleDataProvider.readB2();
                    if (s == 0) {
                        this.m_nativeDataOut[i] = object;
                        this.m_nativeDataOutLength[i] = ((byte[])object).length;
                        continue;
                    }
                    this.m_nativeDataOut[i] = null;
                }
                break;
            }
            case 112: 
            case 113: 
            case 114: {
                for (int i = 0; i < n; ++i) {
                    object = oracleDataProvider.readB4() != 0 ? oracleDataProvider.readCLR((int)this.m_maxlen) : null;
                    short s = oracleDataProvider.readB2();
                    if (s == 0) {
                        this.m_nativeDataOut[i] = object;
                        this.m_nativeDataOutLength[i] = ((byte[])object).length;
                        continue;
                    }
                    this.m_nativeDataOut[i] = null;
                }
                break;
            }
            default: {
                UtilDebug.assert("Unexpected output parameter type", false);
            }
        }
    }

    public void writeData(OracleDataConsumer oracleDataConsumer) throws UtilException {
        try {
            switch (this.m_nativeBindType) {
                case 23: 
                case 24: {
                    if (this.m_baseParameter != null) {
                        InputStream inputStream = this.m_baseParameter.getBinaryStream(-1, this.m_baseParameter.connection, this.m_baseParameter.connection.getExceptions());
                        oracleDataConsumer.writeCLR(inputStream);
                        break;
                    }
                    if (this.m_nativeDataIn == null) {
                        oracleDataConsumer.writeByte((byte)0);
                        break;
                    }
                    oracleDataConsumer.writeCLR(this.m_nativeDataIn, this.m_nativeDataInOffset, this.m_nativeDataInLength);
                    break;
                }
                case 1: 
                case 8: {
                    if (this.m_baseParameter != null) {
                        Reader reader = this.m_baseParameter.getCharacterStreamReader(-1, this.m_baseParameter.connection, this.m_baseParameter.connection.getExceptions());
                        oracleDataConsumer.writeCLR(reader, this.m_transliterator);
                        break;
                    }
                    if (this.m_nativeDataIn == null) {
                        oracleDataConsumer.writeByte((byte)0);
                        break;
                    }
                    oracleDataConsumer.writeCLR(this.m_nativeDataIn, this.m_nativeDataInOffset, this.m_nativeDataInLength);
                    break;
                }
                case 112: 
                case 113: {
                    oracleDataConsumer.writeB4(this.m_maxlen);
                }
                case 6: 
                case 12: 
                case 96: 
                case 100: 
                case 101: 
                case 102: 
                case 180: 
                case 181: 
                case 231: {
                    if (this.m_nativeDataIn == null) {
                        oracleDataConsumer.writeByte((byte)0);
                        break;
                    }
                    oracleDataConsumer.writeCLR(this.m_nativeDataIn, this.m_nativeDataInOffset, this.m_nativeDataInLength);
                    break;
                }
                default: {
                    UtilDebug.assert("Unexpected data type", false);
                    break;
                }
            }
        }
        catch (Exception exception) {
            throw new UtilException(1030);
        }
    }
}

