/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jgroups.Channel;
import org.jgroups.ExtendedReceiverAdapter;
import org.jgroups.JChannelFactory;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.util.Util;

public class MultiplexerTest
extends TestCase {
    private Cache c1;
    private Cache c2;
    private Cache c1_repl;
    private Cache c2_repl;
    private Channel ch1;
    private Channel ch2;
    private Channel ch1_repl;
    private Channel ch2_repl;
    static final String CFG = "stacks.xml";
    static final String STACK_NAME = "fc-fast-minimalthreads";
    JChannelFactory factory;
    JChannelFactory factory2;

    public MultiplexerTest(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        super.setUp();
        this.factory = new JChannelFactory();
        this.factory.setMultiplexerConfig(CFG);
        this.factory2 = new JChannelFactory();
        this.factory2.setMultiplexerConfig(CFG);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        if (this.ch1_repl != null) {
            this.ch1_repl.close();
        }
        if (this.ch2_repl != null) {
            this.ch2_repl.close();
        }
        if (this.ch1 != null) {
            this.ch1.close();
        }
        if (this.ch2 != null) {
            this.ch2.close();
        }
        if (this.c1 != null) {
            this.c1.clear();
        }
        if (this.c2 != null) {
            this.c2.clear();
        }
        if (this.c1_repl != null) {
            this.c1_repl.clear();
        }
        if (this.c2_repl != null) {
            this.c2_repl.clear();
        }
    }

    public void testReplicationWithOneChannel() throws Exception {
        this.ch1 = this.factory.createMultiplexerChannel(STACK_NAME, "c1");
        this.ch1.connect("bla");
        this.c1 = new Cache(this.ch1, "cache-1");
        MultiplexerTest.assertEquals((String)"cache has to be empty initially", (int)0, (int)this.c1.size());
        this.c1.put("name", "Bela");
        Util.sleep(300L);
        MultiplexerTest.assertEquals((int)1, (int)this.c1.size());
        MultiplexerTest.assertEquals((Object)"Bela", (Object)this.c1.get("name"));
    }

    public void testReplicationWithTwoChannels() throws Exception {
        this.ch1 = this.factory.createMultiplexerChannel(STACK_NAME, "c1");
        this.ch1.connect("bla");
        this.c1 = new Cache(this.ch1, "cache-1");
        MultiplexerTest.assertEquals((String)"cache has to be empty initially", (int)0, (int)this.c1.size());
        this.ch1_repl = this.factory2.createMultiplexerChannel(STACK_NAME, "c1");
        this.ch1_repl.connect("bla");
        this.c1_repl = new Cache(this.ch1_repl, "cache-1-repl");
        MultiplexerTest.assertEquals((String)"cache has to be empty initially", (int)0, (int)this.c1_repl.size());
        this.c1.put("name", "Bela");
        Util.sleep(500L);
        System.out.println("c1: " + this.c1 + ", c1_repl: " + this.c1_repl);
        MultiplexerTest.assertEquals((int)1, (int)this.c1.size());
        MultiplexerTest.assertEquals((Object)"Bela", (Object)this.c1.get("name"));
        MultiplexerTest.assertEquals((int)1, (int)this.c1_repl.size());
        MultiplexerTest.assertEquals((Object)"Bela", (Object)this.c1_repl.get("name"));
        this.c1.put("id", new Long(322649L));
        this.c1_repl.put("hobbies", "biking");
        this.c1_repl.put("bike", "Centurion");
        Util.sleep(500L);
        System.out.println("c1: " + this.c1 + ", c1_repl: " + this.c1_repl);
        MultiplexerTest.assertEquals((int)4, (int)this.c1.size());
        MultiplexerTest.assertEquals((int)4, (int)this.c1_repl.size());
        MultiplexerTest.assertEquals((Object)new Long(322649L), (Object)this.c1.get("id"));
        MultiplexerTest.assertEquals((Object)new Long(322649L), (Object)this.c1_repl.get("id"));
        MultiplexerTest.assertEquals((Object)"biking", (Object)this.c1.get("hobbies"));
        MultiplexerTest.assertEquals((Object)"biking", (Object)this.c1_repl.get("hobbies"));
        MultiplexerTest.assertEquals((Object)"Centurion", (Object)this.c1.get("bike"));
        MultiplexerTest.assertEquals((Object)"Centurion", (Object)this.c1_repl.get("bike"));
    }

    public void testStateTransfer() throws Exception {
        this.ch1 = this.factory.createMultiplexerChannel(STACK_NAME, "c1");
        this.ch1.connect("bla");
        this.c1 = new Cache(this.ch1, "cache-1");
        MultiplexerTest.assertEquals((String)"cache has to be empty initially", (int)0, (int)this.c1.size());
        this.ch1_repl = this.factory2.createMultiplexerChannel(STACK_NAME, "c1");
        this.c1.put("name", "Bela");
        this.c1.put("id", new Long(322649L));
        this.c1.put("hobbies", "biking");
        this.c1.put("bike", "Centurion");
        this.ch1_repl.connect("bla");
        this.c1_repl = new Cache(this.ch1_repl, "cache-1-repl");
        boolean rc = this.ch1_repl.getState(null, 5000L);
        System.out.println("state transfer: " + rc);
        Util.sleep(500L);
        System.out.println("c1_repl: " + this.c1_repl);
        MultiplexerTest.assertEquals((String)"initial state should have been transferred", (int)4, (int)this.c1_repl.size());
        MultiplexerTest.assertEquals((Object)new Long(322649L), (Object)this.c1.get("id"));
        MultiplexerTest.assertEquals((Object)new Long(322649L), (Object)this.c1_repl.get("id"));
        MultiplexerTest.assertEquals((Object)"biking", (Object)this.c1.get("hobbies"));
        MultiplexerTest.assertEquals((Object)"biking", (Object)this.c1_repl.get("hobbies"));
        MultiplexerTest.assertEquals((Object)"Centurion", (Object)this.c1.get("bike"));
        MultiplexerTest.assertEquals((Object)"Centurion", (Object)this.c1_repl.get("bike"));
    }

    public void testStateTransferWithTwoApplications() throws Exception {
        this.ch1 = this.factory.createMultiplexerChannel(STACK_NAME, "c1");
        this.ch1.connect("bla");
        this.c1 = new Cache(this.ch1, "cache-1");
        MultiplexerTest.assertEquals((String)"cache has to be empty initially", (int)0, (int)this.c1.size());
        this.ch2 = this.factory.createMultiplexerChannel(STACK_NAME, "c2");
        this.ch2.connect("bla");
        this.c2 = new Cache(this.ch2, "cache-2");
        MultiplexerTest.assertEquals((String)"cache has to be empty initially", (int)0, (int)this.c2.size());
        this.ch1_repl = this.factory2.createMultiplexerChannel(STACK_NAME, "c1");
        this.ch2_repl = this.factory2.createMultiplexerChannel(STACK_NAME, "c2");
        this.c1.put("name", "cache-1");
        this.c2.put("name", "cache-2");
        this.ch1_repl.connect("bla");
        this.c1_repl = new Cache(this.ch1_repl, "cache-1-repl");
        boolean rc = this.ch1_repl.getState(null, 5000L);
        System.out.println("state transfer: " + rc);
        this.ch2_repl.connect("bla");
        this.c2_repl = new Cache(this.ch2_repl, "cache-2-repl");
        rc = this.ch2_repl.getState(null, 5000L);
        System.out.println("state transfer: " + rc);
        Util.sleep(500L);
        System.out.println("Caches after state transfers:");
        System.out.println("c1: " + this.c1);
        System.out.println("c1_repl: " + this.c1_repl);
        System.out.println("c2: " + this.c2);
        System.out.println("c2_repl: " + this.c2_repl);
        MultiplexerTest.assertEquals((int)1, (int)this.c1.size());
        MultiplexerTest.assertEquals((int)1, (int)this.c1_repl.size());
        MultiplexerTest.assertEquals((int)1, (int)this.c2.size());
        MultiplexerTest.assertEquals((int)1, (int)this.c2_repl.size());
        MultiplexerTest.assertEquals((Object)"cache-1", (Object)this.c1.get("name"));
        MultiplexerTest.assertEquals((Object)"cache-1", (Object)this.c1_repl.get("name"));
        MultiplexerTest.assertEquals((Object)"cache-2", (Object)this.c2.get("name"));
        MultiplexerTest.assertEquals((Object)"cache-2", (Object)this.c2_repl.get("name"));
    }

    public void testStateTransferWithRegistration() throws Exception {
        this.ch1 = this.factory.createMultiplexerChannel(STACK_NAME, "c1");
        this.ch1.connect("bla");
        this.c1 = new Cache(this.ch1, "cache-1");
        MultiplexerTest.assertEquals((String)"cache has to be empty initially", (int)0, (int)this.c1.size());
        this.ch2 = this.factory.createMultiplexerChannel(STACK_NAME, "c2");
        this.ch2.connect("bla");
        this.c2 = new Cache(this.ch2, "cache-2");
        MultiplexerTest.assertEquals((String)"cache has to be empty initially", (int)0, (int)this.c2.size());
        this.c1.put("name", "cache-1");
        this.c2.put("name", "cache-2");
        this.ch1_repl = this.factory2.createMultiplexerChannel(STACK_NAME, "c1", true, null);
        this.ch2_repl = this.factory2.createMultiplexerChannel(STACK_NAME, "c2", true, null);
        this.ch1_repl.connect("bla");
        this.c1_repl = new Cache(this.ch1_repl, "cache-1-repl");
        boolean rc = this.ch1_repl.getState(null, 5000L);
        System.out.println("state transfer: " + rc);
        this.ch2_repl.connect("bla");
        this.c2_repl = new Cache(this.ch2_repl, "cache-2-repl");
        rc = this.ch2_repl.getState(null, 5000L);
        System.out.println("state transfer: " + rc);
        Util.sleep(500L);
        System.out.println("Caches after state transfers:");
        System.out.println("c1: " + this.c1);
        System.out.println("c1_repl: " + this.c1_repl);
        System.out.println("c2: " + this.c2);
        System.out.println("c2_repl: " + this.c2_repl);
        MultiplexerTest.assertEquals((int)1, (int)this.c1.size());
        MultiplexerTest.assertEquals((int)1, (int)this.c1_repl.size());
        MultiplexerTest.assertEquals((int)1, (int)this.c2.size());
        MultiplexerTest.assertEquals((int)1, (int)this.c2_repl.size());
        MultiplexerTest.assertEquals((Object)"cache-1", (Object)this.c1.get("name"));
        MultiplexerTest.assertEquals((Object)"cache-1", (Object)this.c1_repl.get("name"));
        MultiplexerTest.assertEquals((Object)"cache-2", (Object)this.c2.get("name"));
        MultiplexerTest.assertEquals((Object)"cache-2", (Object)this.c2_repl.get("name"));
        this.c1.clear();
        this.c1_repl.clear();
        this.c2.clear();
        this.c2_repl.clear();
    }

    public void testGetSubstates() throws Exception {
        this.ch1 = this.factory.createMultiplexerChannel(STACK_NAME, "c1");
        this.ch1.connect("bla");
        this.c1 = new ExtendedCache(this.ch1, "cache-1");
        MultiplexerTest.assertEquals((String)"cache has to be empty initially", (int)0, (int)this.c1.size());
        this.ch2 = this.factory.createMultiplexerChannel(STACK_NAME, "c2");
        this.ch2.connect("bla");
        this.c2 = new ExtendedCache(this.ch2, "cache-2");
        MultiplexerTest.assertEquals((String)"cache has to be empty initially", (int)0, (int)this.c2.size());
        for (int i = 0; i < 10; ++i) {
            this.c1.put(new Integer(i), new Integer(i));
            this.c2.put(new Integer(i), new Integer(i));
        }
        this.ch1_repl = this.factory2.createMultiplexerChannel(STACK_NAME, "c1");
        this.ch2_repl = this.factory2.createMultiplexerChannel(STACK_NAME, "c2");
        this.ch1_repl.connect("bla");
        this.c1_repl = new ExtendedCache(this.ch1_repl, "cache-1-repl");
        boolean rc = this.ch1_repl.getState(null, "odd", 5000L);
        System.out.println("state transfer: " + rc);
        this.ch2_repl.connect("bla");
        this.c2_repl = new ExtendedCache(this.ch2_repl, "cache-2-repl");
        rc = this.ch2_repl.getState(null, "even", 5000L);
        System.out.println("state transfer: " + rc);
        Util.sleep(500L);
        System.out.println("Caches after state transfers:");
        System.out.println("c1: " + this.c1);
        System.out.println("c2: " + this.c2);
        System.out.println("c1_repl (removed odd substate): " + this.c1_repl);
        System.out.println("c2_repl (removed even substate): " + this.c2_repl);
        MultiplexerTest.assertEquals((int)5, (int)this.c1_repl.size());
        MultiplexerTest.assertEquals((int)5, (int)this.c2_repl.size());
        this._testEvenNumbersPresent(this.c1_repl);
        this._testOddNumbersPresent(this.c2_repl);
    }

    private void _testEvenNumbersPresent(Cache c) {
        Integer[] evens = new Integer[]{new Integer(0), new Integer(2), new Integer(4), new Integer(6), new Integer(8)};
        this._testNumbersPresent(c, evens);
    }

    private void _testOddNumbersPresent(Cache c) {
        Integer[] odds = new Integer[]{new Integer(1), new Integer(3), new Integer(5), new Integer(7), new Integer(9)};
        this._testNumbersPresent(c, odds);
    }

    private void _testNumbersPresent(Cache c, Integer[] numbers) {
        int len = numbers.length;
        MultiplexerTest.assertEquals((int)len, (int)c.size());
        for (int i = 0; i < numbers.length; ++i) {
            Integer number = numbers[i];
            MultiplexerTest.assertEquals((Object)number, (Object)c.get(number));
        }
    }

    public void testGetSubstatesMultipleTimes() throws Exception {
        this.ch1 = this.factory.createMultiplexerChannel(STACK_NAME, "c1");
        this.ch1.connect("bla");
        this.c1 = new ExtendedCache(this.ch1, "cache-1");
        MultiplexerTest.assertEquals((String)"cache has to be empty initially", (int)0, (int)this.c1.size());
        this.ch2 = this.factory.createMultiplexerChannel(STACK_NAME, "c2");
        this.ch2.connect("bla");
        this.c2 = new ExtendedCache(this.ch2, "cache-2");
        MultiplexerTest.assertEquals((String)"cache has to be empty initially", (int)0, (int)this.c2.size());
        for (int i = 0; i < 10; ++i) {
            this.c1.put(new Integer(i), new Integer(i));
            this.c2.put(new Integer(i), new Integer(i));
        }
        this.ch1_repl = this.factory2.createMultiplexerChannel(STACK_NAME, "c1");
        this.ch2_repl = this.factory2.createMultiplexerChannel(STACK_NAME, "c2");
        this.ch1_repl.connect("bla");
        this.c1_repl = new ExtendedCache(this.ch1_repl, "cache-1-repl");
        boolean rc = this.ch1_repl.getState(null, "odd", 5000L);
        System.out.println("state transfer: " + rc);
        this.ch2_repl.connect("bla");
        this.c2_repl = new ExtendedCache(this.ch2_repl, "cache-2-repl");
        rc = this.ch2_repl.getState(null, "even", 5000L);
        System.out.println("state transfer: " + rc);
        Util.sleep(500L);
        this._testOddNumbersPresent(this.c2_repl);
        System.out.println("Caches after state transfers:");
        System.out.println("c1: " + this.c1);
        System.out.println("c2: " + this.c2);
        System.out.println("c1_repl (removed odd substate): " + this.c1_repl);
        System.out.println("c2_repl (removed even substate): " + this.c2_repl);
        MultiplexerTest.assertEquals((int)5, (int)this.c2_repl.size());
        rc = this.ch2_repl.getState(null, "odd", 5000L);
        Util.sleep(500L);
        System.out.println("c2_repl (removed odd substate): " + this.c2_repl);
        this._testEvenNumbersPresent(this.c2_repl);
        MultiplexerTest.assertEquals((int)5, (int)this.c2_repl.size());
        rc = this.ch2_repl.getState(null, "even", 5000L);
        Util.sleep(500L);
        System.out.println("c2_repl (removed even substate): " + this.c2_repl);
        this._testOddNumbersPresent(this.c2_repl);
        MultiplexerTest.assertEquals((int)5, (int)this.c2_repl.size());
        rc = this.ch2_repl.getState(null, "odd", 5000L);
        Util.sleep(500L);
        System.out.println("c2_repl (removed odd substate): " + this.c2_repl);
        this._testEvenNumbersPresent(this.c2_repl);
    }

    public static Test suite() {
        return new TestSuite(MultiplexerTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)MultiplexerTest.suite());
    }

    static class ExtendedCache
    extends Cache {
        public ExtendedCache(Channel ch, String name) {
            super(ch, name);
        }

        public byte[] getState(String state_id) {
            HashMap copy = new HashMap(this.data);
            Iterator it = copy.keySet().iterator();
            while (it.hasNext()) {
                Integer key = (Integer)it.next();
                if (state_id.equals("odd") && key % 2 != 0) {
                    it.remove();
                    continue;
                }
                if (!state_id.equals("even") || key % 2 != 0) continue;
                it.remove();
            }
            try {
                return Util.objectToByteBuffer(copy);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        public void setState(String state_id, byte[] state) {
            this.setState(state);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            Map map = this.data;
            synchronized (map) {
                TreeSet keys = new TreeSet(this.data.keySet());
                StringBuffer sb = new StringBuffer();
                Iterator it = keys.iterator();
                while (it.hasNext()) {
                    Object o = it.next();
                    sb.append(o).append("=").append(this.data.get(o)).append(" ");
                }
                return sb.toString();
            }
        }
    }

    private static class Cache
    extends ExtendedReceiverAdapter {
        final Map data = new HashMap();
        Channel ch;
        String name;

        public Cache(Channel ch, String name) {
            this.ch = ch;
            this.name = name;
            this.ch.setReceiver(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Object get(Object key) {
            Map map = this.data;
            synchronized (map) {
                return this.data.get(key);
            }
        }

        protected void put(Object key, Object val) throws Exception {
            Object[] buf = new Object[]{key, val};
            Message msg = new Message(null, null, (Serializable)buf);
            this.ch.send(msg);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected int size() {
            Map map = this.data;
            synchronized (map) {
                return this.data.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void receive(Message msg) {
            Object[] modification = (Object[])msg.getObject();
            Object key = modification[0];
            Object val = modification[1];
            Map map = this.data;
            synchronized (map) {
                this.data.put(key, val);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public byte[] getState() {
            byte[] state = null;
            Map map = this.data;
            synchronized (map) {
                try {
                    state = Util.objectToByteBuffer(this.data);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }
            return state;
        }

        public byte[] getState(String state_id) {
            return this.getState();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setState(byte[] state) {
            try {
                Map m = (Map)Util.objectFromByteBuffer(state);
                Map map = this.data;
                synchronized (map) {
                    this.data.clear();
                    this.data.putAll(m);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void setState(String state_id, byte[] state) {
            this.setState(state);
        }

        public void clear() {
            this.data.clear();
        }

        public void viewAccepted(View new_view) {
            this.log("view is " + new_view);
        }

        public String toString() {
            return this.data.toString();
        }

        private void log(String msg) {
            System.out.println("-- [" + this.name + "] " + msg);
        }
    }
}

