/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jgroups.ChannelException;
import org.jgroups.JChannel;
import org.jgroups.ReceiverAdapter;
import org.jgroups.util.Promise;

public class LargeStateTransferTest
extends TestCase {
    JChannel provider;
    JChannel requester;
    Promise p = new Promise();
    final String props = "fc-fast-minimalthreads.xml";
    long start;
    long stop;
    static final int SIZE_1 = 100000;
    static final int SIZE_2 = 1000000;
    static final int SIZE_3 = 5000000;
    static final int SIZE_4 = 10000000;

    public LargeStateTransferTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.provider = new JChannel("fc-fast-minimalthreads.xml");
        this.requester = new JChannel("fc-fast-minimalthreads.xml");
    }

    protected void tearDown() throws Exception {
        if (this.provider != null) {
            this.provider.close();
        }
        if (this.requester != null) {
            this.requester.close();
        }
        super.tearDown();
    }

    public void testStateTransfer1() throws ChannelException {
        this._testStateTransfer(100000);
    }

    public void testStateTransfer2() throws ChannelException {
        this._testStateTransfer(1000000);
    }

    public void testStateTransfer3() throws ChannelException {
        this._testStateTransfer(5000000);
    }

    public void testStateTransfer4() throws ChannelException {
        this._testStateTransfer(10000000);
    }

    public void _testStateTransfer(int size) throws ChannelException {
        this.provider.setReceiver(new Provider(size));
        this.provider.connect("X");
        this.p.reset();
        this.requester.setReceiver(new Requester(this.p));
        this.requester.connect("X");
        LargeStateTransferTest.log("requesting state of " + size + " bytes");
        this.start = System.currentTimeMillis();
        this.requester.getState(null, 20000L);
        Object result = this.p.getResult(10000L);
        this.stop = System.currentTimeMillis();
        LargeStateTransferTest.log("result=" + result + " bytes (in " + (this.stop - this.start) + "ms)");
        LargeStateTransferTest.assertNotNull((Object)result);
        LargeStateTransferTest.assertEquals((Object)result, (Object)new Integer(size));
    }

    static void log(String msg) {
        System.out.println(Thread.currentThread() + " -- " + msg);
    }

    public static Test suite() {
        return new TestSuite(LargeStateTransferTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)LargeStateTransferTest.suite());
    }

    private static class Requester
    extends ReceiverAdapter {
        Promise p;

        public Requester(Promise p) {
            this.p = p;
        }

        public byte[] getState() {
            throw new UnsupportedOperationException("not implemented by requester");
        }

        public void setState(byte[] state) {
            this.p.setResult(new Integer(state.length));
        }
    }

    private static class Provider
    extends ReceiverAdapter {
        byte[] state;

        public Provider(int size) {
            this.state = new byte[size];
        }

        public byte[] getState() {
            return this.state;
        }

        public void setState(byte[] state) {
            throw new UnsupportedOperationException("not implemented by provider");
        }
    }
}

