/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.jmx;

import java.io.Serializable;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.Address;
import org.jgroups.ChannelClosedException;
import org.jgroups.ChannelException;
import org.jgroups.ChannelListener;
import org.jgroups.ChannelNotConnectedException;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.TimeoutException;
import org.jgroups.Version;
import org.jgroups.View;
import org.jgroups.jmx.JChannelMBean;
import org.jgroups.jmx.JmxConfigurator;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JChannel
implements JChannelMBean {
    org.jgroups.JChannel channel;
    String props = null;
    String group_name = "TestGroup";
    String object_name = null;
    Log log = LogFactory.getLog(this.getClass());
    private boolean receive_blocks = false;
    private boolean receive_local_msgs = true;
    private boolean auto_reconnect = false;
    private boolean auto_getstate = false;
    private String mbean_server_name = null;

    public JChannel() {
    }

    public JChannel(org.jgroups.JChannel channel) {
        this.channel = channel;
    }

    public org.jgroups.JChannel getChannel() {
        return this.channel;
    }

    public String getVersion() {
        return Version.printDescription();
    }

    public String getMBeanServerName() {
        return this.mbean_server_name;
    }

    public void setMBeanServerName(String n) {
        this.mbean_server_name = n;
    }

    public String getProperties() {
        return this.props;
    }

    public void setProperties(String props) {
        this.props = props;
    }

    public String getObjectName() {
        return this.object_name;
    }

    public void setObjectName(String name) {
        this.object_name = name;
    }

    public int getNumberOfTasksInTimer() {
        return this.channel.getNumberOfTasksInTimer();
    }

    public String dumpTimerQueue() {
        return this.channel.dumpTimerQueue();
    }

    public void setClusterConfig(Element config) {
        StringBuffer buffer = new StringBuffer();
        NodeList stack = config.getChildNodes();
        int length = stack.getLength();
        for (int s = 0; s < length; ++s) {
            Node node = stack.item(s);
            if (node.getNodeType() != 1) continue;
            Element tag = (Element)node;
            String protocol = tag.getTagName();
            buffer.append(protocol);
            NamedNodeMap attrs = tag.getAttributes();
            int attrLength = attrs.getLength();
            if (attrLength > 0) {
                buffer.append('(');
            }
            for (int a = 0; a < attrLength; ++a) {
                Attr attr = (Attr)attrs.item(a);
                String name = attr.getName();
                String value = attr.getValue();
                buffer.append(name);
                buffer.append('=');
                buffer.append(value);
                if (a >= attrLength - 1) continue;
                buffer.append(';');
            }
            if (attrLength > 0) {
                buffer.append(')');
            }
            buffer.append(':');
        }
        buffer.setLength(buffer.length() - 1);
        this.setProperties(buffer.toString());
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)("setting cluster properties from xml to: " + this.props));
        }
    }

    public String getGroupName() {
        return this.group_name;
    }

    public void setGroupName(String group_name) {
        this.group_name = group_name;
    }

    public String getClusterName() {
        return this.getGroupName();
    }

    public void setClusterName(String cluster_name) {
        this.setGroupName(cluster_name);
    }

    public boolean getReceiveBlockEvents() {
        return this.receive_blocks;
    }

    public void setReceiveBlockEvents(boolean flag) {
        this.receive_blocks = flag;
        if (this.channel != null) {
            this.channel.setOpt(0, new Boolean(flag));
        }
    }

    public boolean getReceiveLocalMessages() {
        return this.receive_local_msgs;
    }

    public void setReceiveLocalMessages(boolean flag) {
        this.receive_local_msgs = flag;
        if (this.channel != null) {
            this.channel.setOpt(3, new Boolean(flag));
        }
    }

    public boolean getAutoReconnect() {
        return this.auto_reconnect;
    }

    public void setAutoReconnect(boolean flag) {
        this.auto_reconnect = flag;
        if (this.channel != null) {
            this.channel.setOpt(5, new Boolean(flag));
        }
    }

    public boolean getAutoGetState() {
        return this.auto_getstate;
    }

    public void setAutoGetState(boolean flag) {
        this.auto_getstate = flag;
        if (this.channel != null) {
            this.channel.setOpt(6, new Boolean(flag));
        }
    }

    public boolean getStatsEnabled() {
        return this.channel.statsEnabled();
    }

    public void setStatsEnabled(boolean flag) {
        this.channel.enableStats(flag);
    }

    public Map dumpStats() {
        return this.channel.dumpStats();
    }

    public void resetStats() {
        this.channel.resetStats();
    }

    public long getSentMessages() {
        return this.channel.getSentMessages();
    }

    public long getSentBytes() {
        return this.channel.getSentBytes();
    }

    public long getReceivedMessages() {
        return this.channel.getReceivedMessages();
    }

    public long getReceivedBytes() {
        return this.channel.getReceivedBytes();
    }

    public void create() throws Exception {
        if (this.channel != null) {
            this.channel.close();
        }
        this.channel = new org.jgroups.JChannel(this.props);
        this.setOptions();
        MBeanServer server = MBeanServerFactory.findMBeanServer(this.mbean_server_name).get(0);
        JmxConfigurator.registerProtocols(server, this.channel, this.getObjectName());
    }

    public void start() throws Exception {
        this.channel.connect(this.group_name);
    }

    public void stop() {
        if (this.channel != null) {
            this.channel.disconnect();
        }
    }

    public void destroy() {
        MBeanServer server = MBeanServerFactory.findMBeanServer(this.mbean_server_name).get(0);
        JmxConfigurator.unregisterProtocols(server, this.channel, this.getObjectName());
        if (this.channel != null) {
            this.channel.close();
            this.channel = null;
        }
    }

    public View getView() {
        return this.channel.getView();
    }

    public String getViewAsString() {
        View v = this.channel.getView();
        return v != null ? v.toString() : "n/a";
    }

    public Address getLocalAddress() {
        return this.channel.getLocalAddress();
    }

    public String getLocalAddressAsString() {
        Address addr = this.getLocalAddress();
        return addr != null ? addr.toString() : "n/a";
    }

    public void setChannelListener(ChannelListener channel_listener) {
        if (this.channel != null) {
            this.channel.addChannelListener(channel_listener);
        }
    }

    public void addChannelListener(ChannelListener listener) {
        if (this.channel != null) {
            this.channel.addChannelListener(listener);
        }
    }

    public void removeChannelListener(ChannelListener l) {
        if (this.channel != null) {
            this.channel.removeChannelListener(l);
        }
    }

    public boolean isOpen() {
        return this.channel.isOpen();
    }

    public boolean isConnected() {
        return this.channel.isConnected();
    }

    public int getNumMessages() {
        return this.channel.getNumMessages();
    }

    public String dumpQueue() {
        return this.channel.dumpQueue();
    }

    public String printProtocolSpec(boolean include_properties) {
        return this.channel.printProtocolSpec(include_properties);
    }

    public String toString(boolean print_details) {
        return this.channel.toString(print_details);
    }

    public void connect(String channel_name) throws ChannelException, ChannelClosedException {
        this.channel.connect(channel_name);
    }

    public void disconnect() {
        this.channel.disconnect();
    }

    public void close() {
        this.channel.close();
    }

    public void shutdown() {
        this.channel.shutdown();
    }

    public void send(Message msg) throws ChannelNotConnectedException, ChannelClosedException {
        this.channel.send(msg);
    }

    public void send(Address dst, Address src, Serializable obj) throws ChannelNotConnectedException, ChannelClosedException {
        this.channel.send(dst, src, obj);
    }

    public void sendToAll(String msg) throws ChannelNotConnectedException, ChannelClosedException {
        this.send(null, null, (Serializable)((Object)msg));
    }

    public void down(Event evt) {
        this.channel.down(evt);
    }

    public Object receive(long timeout) throws ChannelNotConnectedException, ChannelClosedException, TimeoutException {
        return this.channel.receive(timeout);
    }

    public Object peek(long timeout) throws ChannelNotConnectedException, ChannelClosedException, TimeoutException {
        return this.channel.peek(timeout);
    }

    public void blockOk() {
        this.channel.blockOk();
    }

    public boolean getState(Address target, long timeout) throws ChannelNotConnectedException, ChannelClosedException {
        return this.channel.getState(target, timeout);
    }

    public void returnState(byte[] state) {
        this.channel.returnState(state);
    }

    public void returnState(byte[] state, String state_id) {
        this.channel.returnState(state, state_id);
    }

    private void setOptions() {
        this.channel.setOpt(0, new Boolean(this.receive_blocks));
        this.channel.setOpt(3, new Boolean(this.receive_local_msgs));
        this.channel.setOpt(5, new Boolean(this.auto_reconnect));
        this.channel.setOpt(6, new Boolean(this.auto_getstate));
    }
}

