/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests.stack;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.ObjectOutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.stack.GossipRouter;
import org.jgroups.stack.GossipServer;

public class Utilities {
    static Log log = LogFactory.getLog((Class)Utilities.class);
    private static GossipRouter gossipRouter = null;

    public static int startGossipRouter() throws Exception {
        return Utilities.startGossipRouter(30000L, 1000L, 120000L);
    }

    public static int startGossipRouter(long expiryTime) throws Exception {
        return Utilities.startGossipRouter(expiryTime, 1000L, 120000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int startGossipRouter(final long expiryTime, final long gossipRequestTimeout, final long routingClientReplyTimeout) throws Exception {
        Object[] lock;
        if (gossipRouter != null) {
            throw new Exception("GossipRouter already started");
        }
        final int routerPort = Utilities.getFreePort();
        Thread routerThread = new Thread(new Runnable(){

            public void run() {
                try {
                    gossipRouter = new GossipRouter(routerPort, null, expiryTime, gossipRequestTimeout, routingClientReplyTimeout);
                    gossipRouter.start();
                }
                catch (Exception e) {
                    String msg = "Failed to start the router on port " + routerPort;
                    log.error((Object)msg);
                    gossipRouter = null;
                }
            }
        });
        routerThread.start();
        long startms = System.currentTimeMillis();
        Throwable lastConnectException = null;
        long crtms = startms;
        Socket s = null;
        while (crtms - startms < 10000L) {
            try {
                s = new Socket("localhost", routerPort);
                lastConnectException = null;
                break;
            }
            catch (Exception e) {
                lastConnectException = e;
                Thread.sleep(1000L);
                crtms = System.currentTimeMillis();
            }
        }
        if (lastConnectException != null) {
            lastConnectException.printStackTrace();
            throw new Exception("Cannot connect to the router");
        }
        final DataInputStream dis = new DataInputStream(s.getInputStream());
        final DataOutputStream dos = new DataOutputStream(s.getOutputStream());
        Object[] objectArray = lock = new Object[1];
        synchronized (lock) {
            new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Object result = null;
                    try {
                        int len = dis.readInt();
                        byte[] buffer = new byte[len];
                        dis.read(buffer, 0, len);
                        dos.writeInt(-10);
                        dos.writeUTF("nogroup_setup");
                        dis.readInt();
                        result = new Object();
                    }
                    catch (Exception e) {
                        result = e;
                    }
                    finally {
                        Object[] objectArray = lock;
                        synchronized (lock) {
                            lock[0] = result;
                            lock.notify();
                            // ** MonitorExit[var2_5] (shouldn't be in output)
                        }
                    }
                }
            }).start();
            try {
                lock.wait(10000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (lock[0] == null) {
                String msg = "Cannot send/receive to/from the router: timeout";
                throw new Exception(msg);
            }
            if (lock[0] instanceof Exception) {
                String msg = "Cannot send/receive to/from the router: " + ((Exception)lock[0]).getMessage();
                throw new Exception(msg);
            }
            // ** MonitorExit[var17_13] (shouldn't be in output)
            s.close();
            System.out.println("router ok");
            return routerPort;
        }
    }

    public static void stopGossipRouter() throws Exception {
        if (gossipRouter == null) {
            throw new Exception("There's no GossipRouter running");
        }
        gossipRouter.stop();
        System.out.println("router stopped");
        gossipRouter = null;
    }

    public static int startGossipServer(final long expiryTime) throws Exception {
        final int port = Utilities.getFreePort();
        Thread gossipThread = new Thread(new Runnable(){

            public void run() {
                try {
                    new GossipServer(port, expiryTime).run();
                }
                catch (Exception e) {
                    String msg = "Failed to start the gossip server on port " + port;
                    log.error((Object)msg);
                    e.printStackTrace();
                }
            }
        });
        gossipThread.start();
        long startms = System.currentTimeMillis();
        Throwable lastConnectException = null;
        long crtms = startms;
        Socket s = null;
        while (crtms - startms < 10000L) {
            try {
                s = new Socket("localhost", port);
                lastConnectException = null;
                break;
            }
            catch (Exception e) {
                lastConnectException = e;
                Thread.sleep(1000L);
                crtms = System.currentTimeMillis();
            }
        }
        if (lastConnectException != null) {
            lastConnectException.printStackTrace();
            throw new Exception("Cannot connect to the gossip server");
        }
        ObjectOutputStream oos = new ObjectOutputStream(s.getOutputStream());
        oos.writeObject(null);
        oos.close();
        s.close();
        System.out.println("gossip server ok");
        return port;
    }

    public static void stopGossipServer(int port) throws Exception {
    }

    public static int getFreePort() throws Exception {
        ServerSocket ss = new ServerSocket(0);
        int port = ss.getLocalPort();
        ss.close();
        return port;
    }
}

