/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.protocols.Discovery;
import org.jgroups.protocols.PingHeader;
import org.jgroups.stack.IpAddress;

public class TCPPING
extends Discovery {
    int port_range = 1;
    ArrayList initial_hosts = null;
    static final String name = "TCPPING";

    public String getName() {
        return name;
    }

    public boolean setProperties(Properties props) {
        String str = props.getProperty("port_range");
        if (str != null) {
            this.port_range = Integer.parseInt(str);
            if (this.port_range < 1) {
                this.port_range = 1;
            }
            props.remove("port_range");
        }
        if ((str = props.getProperty("initial_hosts")) != null) {
            props.remove("initial_hosts");
            try {
                this.initial_hosts = this.createInitialHosts(str);
            }
            catch (UnknownHostException e) {
                this.log.error((Object)"failed creating initial list of hosts", (Throwable)e);
                return false;
            }
        }
        return super.setProperties(props);
    }

    public void localAddressSet(Address addr) {
        if (this.initial_hosts != null && addr != null && this.initial_hosts.contains(addr)) {
            this.initial_hosts.remove(addr);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("[SET_LOCAL_ADDRESS]: removing my own address (" + addr + ") from initial_hosts; initial_hosts=" + this.initial_hosts));
            }
        }
    }

    public void sendGetMembersRequest() {
        Iterator it = this.initial_hosts.iterator();
        while (it.hasNext()) {
            Address addr = (Address)it.next();
            Message msg = new Message(addr, null, null);
            msg.putHeader(name, new PingHeader(1, null));
            if (this.trace) {
                this.log.trace((Object)("[FIND_INITIAL_MBRS] sending PING request to " + msg.getDest()));
            }
            this.passDown(new Event(1, msg));
        }
    }

    private ArrayList createInitialHosts(String l) throws UnknownHostException {
        StringTokenizer tok = new StringTokenizer(l, ",");
        ArrayList<IpAddress> retval = new ArrayList<IpAddress>();
        while (tok.hasMoreTokens()) {
            try {
                int port;
                String t = tok.nextToken();
                String host = t.substring(0, t.indexOf(91));
                for (int i = port = Integer.parseInt(t.substring(t.indexOf(91) + 1, t.indexOf(93))); i < port + this.port_range; ++i) {
                    IpAddress addr = new IpAddress(host, i);
                    retval.add(addr);
                }
            }
            catch (NumberFormatException e) {
                if (!this.log.isErrorEnabled()) continue;
                this.log.error((Object)("exeption is " + e));
            }
        }
        return retval;
    }
}

