/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentReaderHashMap;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.stack.Protocol;
import org.jgroups.util.BoundedList;
import org.jgroups.util.Streamable;

public class FC
extends Protocol {
    final Map sent = new HashMap(11);
    final Map received = new ConcurrentReaderHashMap(11);
    final List creditors = new ArrayList(11);
    private long max_credits = 50000L;
    private Long max_credits_constant;
    private long max_block_time = 5000L;
    private double min_threshold = 0.25;
    private long min_credits = 0L;
    private boolean running = true;
    private boolean insufficient_credit = false;
    private long lowest_credit = this.max_credits;
    final Object mutex = new Object();
    static final String name = "FC";
    private long start_blocking = 0L;
    private long stop_blocking = 0L;
    private int num_blockings = 0;
    private int num_credit_requests_received = 0;
    private int num_credit_requests_sent = 0;
    private int num_credit_responses_sent = 0;
    private int num_credit_responses_received = 0;
    private long total_time_blocking = 0L;
    final BoundedList last_blockings = new BoundedList(50);
    static final FcHeader REPLENISH_HDR = new FcHeader(1);
    static final FcHeader CREDIT_REQUEST_HDR = new FcHeader(2);

    public final String getName() {
        return name;
    }

    public void resetStats() {
        super.resetStats();
        this.num_blockings = 0;
        this.num_credit_requests_sent = 0;
        this.num_credit_requests_received = 0;
        this.num_credit_responses_received = 0;
        this.num_credit_responses_sent = 0;
        this.total_time_blocking = 0L;
        this.last_blockings.removeAll();
    }

    public long getMaxCredits() {
        return this.max_credits;
    }

    public void setMaxCredits(long max_credits) {
        this.max_credits = max_credits;
        this.max_credits_constant = new Long(this.max_credits);
    }

    public double getMinThreshold() {
        return this.min_threshold;
    }

    public void setMinThreshold(double min_threshold) {
        this.min_threshold = min_threshold;
    }

    public long getMinCredits() {
        return this.min_credits;
    }

    public void setMinCredits(long min_credits) {
        this.min_credits = min_credits;
    }

    public boolean isBlocked() {
        return this.insufficient_credit;
    }

    public int getNumberOfBlockings() {
        return this.num_blockings;
    }

    public long getMaxBlockTime() {
        return this.max_block_time;
    }

    public void setMaxBlockTime(long t) {
        this.max_block_time = t;
    }

    public long getTotalTimeBlocked() {
        return this.total_time_blocking;
    }

    public double getAverageTimeBlocked() {
        return this.num_blockings == 0 ? 0.0 : (double)this.total_time_blocking / (double)this.num_blockings;
    }

    public int getNumberOfCreditRequestsReceived() {
        return this.num_credit_requests_received;
    }

    public int getNumberOfCreditRequestsSent() {
        return this.num_credit_requests_sent;
    }

    public int getNumberOfCreditResponsesReceived() {
        return this.num_credit_responses_received;
    }

    public int getNumberOfCreditResponsesSent() {
        return this.num_credit_responses_sent;
    }

    public String printSenderCredits() {
        return FC.printMap(this.sent);
    }

    public String printReceiverCredits() {
        return FC.printMap(this.received);
    }

    public String printCredits() {
        StringBuffer sb = new StringBuffer();
        sb.append("senders:\n").append(FC.printMap(this.sent)).append("\n\nreceivers:\n").append(FC.printMap(this.received));
        return sb.toString();
    }

    public Map dumpStats() {
        HashMap<String, String> retval = super.dumpStats();
        if (retval == null) {
            retval = new HashMap<String, String>();
        }
        retval.put("senders", FC.printMap(this.sent));
        retval.put("receivers", FC.printMap(this.received));
        retval.put("num_blockings", (String)((Object)new Integer(this.num_blockings)));
        retval.put("avg_time_blocked", (String)((Object)new Double(this.getAverageTimeBlocked())));
        retval.put("num_replenishments", (String)((Object)new Integer(this.num_credit_responses_received)));
        retval.put("total_time_blocked", (String)((Object)new Long(this.total_time_blocking)));
        return retval;
    }

    public String showLastBlockingTimes() {
        return this.last_blockings.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unblock() {
        Object object = this.mutex;
        synchronized (object) {
            if (this.trace) {
                this.log.trace((Object)("unblocking the sender and replenishing all members, creditors are " + this.creditors));
            }
            Iterator it = this.sent.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                entry.setValue(this.max_credits_constant);
            }
            this.lowest_credit = FC.computeLowestCredit(this.sent);
            this.creditors.clear();
            this.insufficient_credit = false;
            this.mutex.notifyAll();
        }
    }

    public boolean setProperties(Properties props) {
        boolean min_credits_set = false;
        super.setProperties(props);
        String str = props.getProperty("max_credits");
        if (str != null) {
            this.max_credits = Long.parseLong(str);
            props.remove("max_credits");
        }
        if ((str = props.getProperty("min_threshold")) != null) {
            this.min_threshold = Double.parseDouble(str);
            props.remove("min_threshold");
        }
        if ((str = props.getProperty("min_credits")) != null) {
            this.min_credits = Long.parseLong(str);
            props.remove("min_credits");
            min_credits_set = true;
        }
        if (!min_credits_set) {
            this.min_credits = (long)((double)this.max_credits * this.min_threshold);
        }
        if ((str = props.getProperty("max_block_time")) != null) {
            this.max_block_time = Long.parseLong(str);
            props.remove("max_block_time");
        }
        if (props.size() > 0) {
            this.log.error((Object)("FC.setProperties(): the following properties are not recognized: " + props));
            return false;
        }
        this.max_credits_constant = new Long(this.max_credits);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws Exception {
        super.start();
        Object object = this.mutex;
        synchronized (object) {
            this.running = true;
            this.insufficient_credit = false;
            this.lowest_credit = this.max_credits;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        super.stop();
        Object object = this.mutex;
        synchronized (object) {
            this.running = false;
            this.mutex.notifyAll();
        }
    }

    protected void receiveDownEvent(Event evt) {
        if (evt.getType() == 6) {
            View v = (View)evt.getArg();
            Vector mbrs = v.getMembers();
            this.handleViewChange(mbrs);
        }
        super.receiveDownEvent(evt);
    }

    public void down(Event evt) {
        switch (evt.getType()) {
            case 1: {
                this.handleDownMessage(evt);
                return;
            }
        }
        this.passDown(evt);
    }

    public void up(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                FcHeader hdr = (FcHeader)msg.removeHeader(name);
                if (hdr != null) {
                    switch (hdr.type) {
                        case 1: {
                            ++this.num_credit_responses_received;
                            this.handleCredit(msg.getSrc());
                            break;
                        }
                        case 2: {
                            ++this.num_credit_requests_received;
                            Address sender = msg.getSrc();
                            if (this.trace) {
                                this.log.trace((Object)("received credit request from " + sender + ": sending credits"));
                            }
                            this.received.put(sender, this.max_credits_constant);
                            this.sendCredit(sender);
                            break;
                        }
                        default: {
                            this.log.error((Object)("header type " + hdr.type + " not known"));
                        }
                    }
                    return;
                }
                this.adjustCredit(msg);
                break;
            }
            case 6: {
                this.handleViewChange(((View)evt.getArg()).getMembers());
            }
        }
        this.passUp(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDownMessage(Event evt) {
        Message msg = (Message)evt.getArg();
        int length = msg.getLength();
        Address dest = msg.getDest();
        Object object = this.mutex;
        synchronized (object) {
            if (this.lowest_credit <= (long)length) {
                this.determineCreditors(dest, length);
                this.insufficient_credit = true;
                ++this.num_blockings;
                this.start_blocking = System.currentTimeMillis();
                while (this.insufficient_credit && this.running) {
                    try {
                        this.mutex.wait(this.max_block_time);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    if (!this.insufficient_credit || !this.running) continue;
                    if (this.trace) {
                        this.log.trace((Object)("timeout occurred waiting for credits; sending credit request to " + this.creditors));
                    }
                    for (int i = 0; i < this.creditors.size(); ++i) {
                        this.sendCreditRequest((Address)this.creditors.get(i));
                    }
                }
                this.stop_blocking = System.currentTimeMillis();
                long block_time = this.stop_blocking - this.start_blocking;
                if (this.trace) {
                    this.log.trace((Object)("total time blocked: " + block_time + " ms"));
                }
                this.total_time_blocking += block_time;
                this.last_blockings.add(new Long(block_time));
            } else {
                long tmp = this.decrementCredit(this.sent, dest, length);
                if (tmp != -1L) {
                    this.lowest_credit = Math.min(tmp, this.lowest_credit);
                }
            }
        }
        this.passDown(evt);
    }

    private void determineCreditors(Address dest, int length) {
        boolean multicast;
        boolean bl = multicast = dest == null || dest.isMulticastAddress();
        if (multicast) {
            Iterator it = this.sent.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                Address mbr = (Address)entry.getKey();
                Long credits = (Long)entry.getValue();
                if (credits > (long)length || this.creditors.contains(mbr)) continue;
                this.creditors.add(mbr);
            }
        } else {
            Long credits = (Long)this.sent.get(dest);
            if (credits != null && credits <= (long)length && !this.creditors.contains(dest)) {
                this.creditors.add(dest);
            }
        }
    }

    private long decrementCredit(Map m, Address dest, long credits) {
        boolean multicast = dest == null || dest.isMulticastAddress();
        long lowest = this.max_credits;
        if (multicast) {
            if (m.size() == 0) {
                return -1L;
            }
            Iterator it = m.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                Long val = (Long)entry.getValue();
                long tmp = val;
                entry.setValue(new Long(tmp -= credits));
                lowest = Math.min(tmp, lowest);
            }
            return lowest;
        }
        Long val = (Long)m.get(dest);
        if (val != null) {
            lowest = val;
            m.put(dest, new Long(lowest -= credits));
            return lowest;
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleCredit(Address sender) {
        if (sender == null) {
            return;
        }
        StringBuffer sb = null;
        Object object = this.mutex;
        synchronized (object) {
            if (this.trace) {
                Long old_credit = (Long)this.sent.get(sender);
                sb = new StringBuffer();
                sb.append("received credit from ").append(sender).append(", old credit was ").append(old_credit).append(", new credits are ").append(this.max_credits).append(".\nCreditors before are: ").append(this.creditors);
            }
            this.sent.put(sender, this.max_credits_constant);
            this.lowest_credit = FC.computeLowestCredit(this.sent);
            if (this.creditors.size() > 0) {
                this.creditors.remove(sender);
                if (this.trace) {
                    sb.append("\nCreditors after removal of ").append(sender).append(" are: ").append(this.creditors);
                    this.log.trace((Object)sb.toString());
                }
            }
            if (this.insufficient_credit && this.lowest_credit > 0L && this.creditors.size() == 0) {
                this.insufficient_credit = false;
                this.mutex.notifyAll();
            }
        }
    }

    private static long computeLowestCredit(Map m) {
        Collection credits = m.values();
        Long retval = (Long)Collections.min(credits);
        return retval;
    }

    private void adjustCredit(Message msg) {
        Address src = msg.getSrc();
        long length = msg.getLength();
        if (src == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"src is null");
            }
            return;
        }
        if (length == 0L) {
            return;
        }
        if (this.decrementCredit(this.received, src, length) <= this.min_credits) {
            this.received.put(src, this.max_credits_constant);
            if (this.trace) {
                this.log.trace((Object)("sending replenishment message to " + src));
            }
            this.sendCredit(src);
        }
    }

    private void sendCredit(Address dest) {
        Message msg = new Message(dest, null, null);
        msg.putHeader(name, REPLENISH_HDR);
        this.passDown(new Event(1, msg));
        ++this.num_credit_responses_sent;
    }

    private void sendCreditRequest(Address dest) {
        Message msg = new Message(dest, null, null);
        msg.putHeader(name, CREDIT_REQUEST_HDR);
        this.passDown(new Event(1, msg));
        ++this.num_credit_requests_sent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleViewChange(Vector mbrs) {
        if (mbrs == null) {
            return;
        }
        if (this.trace) {
            this.log.trace((Object)("new membership: " + mbrs));
        }
        Object object = this.mutex;
        synchronized (object) {
            Address addr;
            for (int i = 0; i < mbrs.size(); ++i) {
                addr = (Address)mbrs.elementAt(i);
                if (!this.received.containsKey(addr)) {
                    this.received.put(addr, this.max_credits_constant);
                }
                if (this.sent.containsKey(addr)) continue;
                this.sent.put(addr, this.max_credits_constant);
            }
            Iterator it = this.received.keySet().iterator();
            while (it.hasNext()) {
                addr = (Address)it.next();
                if (mbrs.contains(addr)) continue;
                it.remove();
            }
            it = this.sent.keySet().iterator();
            while (it.hasNext()) {
                addr = (Address)it.next();
                if (mbrs.contains(addr)) continue;
                it.remove();
            }
            for (int i = 0; i < this.creditors.size(); ++i) {
                Address creditor = (Address)this.creditors.get(i);
                if (mbrs.contains(creditor)) continue;
                this.creditors.remove(creditor);
            }
            if (this.trace) {
                this.log.trace((Object)("creditors are " + this.creditors));
            }
            if (this.insufficient_credit && this.creditors.size() == 0) {
                this.lowest_credit = FC.computeLowestCredit(this.sent);
                this.insufficient_credit = false;
                this.mutex.notifyAll();
            }
        }
    }

    private static String printMap(Map m) {
        StringBuffer sb = new StringBuffer();
        Iterator it = m.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            sb.append(entry.getKey()).append(": ").append(entry.getValue()).append("\n");
        }
        return sb.toString();
    }

    public static class FcHeader
    extends Header
    implements Streamable {
        public static final byte REPLENISH = 1;
        public static final byte CREDIT_REQUEST = 2;
        byte type = 1;

        public FcHeader() {
        }

        public FcHeader(byte type) {
            this.type = type;
        }

        public long size() {
            return 1L;
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeByte(this.type);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.type = in.readByte();
        }

        public void writeTo(DataOutputStream out) throws IOException {
            out.writeByte(this.type);
        }

        public void readFrom(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
            this.type = in.readByte();
        }

        public String toString() {
            switch (this.type) {
                case 1: {
                    return "REPLENISH";
                }
                case 2: {
                    return "CREDIT_REQUEST";
                }
            }
            return "<invalid type>";
        }
    }
}

