/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.mux;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.ChannelClosedException;
import org.jgroups.ChannelNotConnectedException;
import org.jgroups.Event;
import org.jgroups.JChannel;
import org.jgroups.JChannelFactory;
import org.jgroups.Message;
import org.jgroups.UpHandler;
import org.jgroups.mux.MuxChannel;
import org.jgroups.mux.MuxHeader;
import org.jgroups.stack.StateTransferInfo;
import org.jgroups.util.Util;

public class Multiplexer
implements UpHandler {
    private final Map apps = new HashMap();
    private final JChannel channel;
    static final Log log = LogFactory.getLog((Class)Multiplexer.class);
    static final String SEPARATOR = "::";
    static final short SEPARATOR_LEN = (short)"::".length();
    static final String LIST_SEPARATOR = ";";
    private final Map state_transfer_listeners = new HashMap();

    public Multiplexer() {
        this.channel = null;
    }

    public Multiplexer(JChannel channel) {
        this.channel = channel;
        this.channel.setUpHandler(this);
    }

    public Set getApplicationIds() {
        return this.apps != null ? this.apps.keySet() : null;
    }

    public boolean stateTransferListenersPresent() {
        return this.state_transfer_listeners != null && this.state_transfer_listeners.size() > 0;
    }

    public synchronized void registerForStateTransfer(String appl_id, String substate_id) {
        String key = appl_id;
        if (substate_id != null && substate_id.length() > 0) {
            key = key + SEPARATOR + substate_id;
        }
        this.state_transfer_listeners.put(key, Boolean.FALSE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean getState(Address target, String id, long timeout) throws ChannelNotConnectedException, ChannelClosedException {
        Collection values;
        boolean all_true;
        if (this.state_transfer_listeners == null) {
            return false;
        }
        Iterator it = this.state_transfer_listeners.entrySet().iterator();
        while (it.hasNext()) {
            boolean match;
            Map.Entry entry = it.next();
            String key = (String)entry.getKey();
            int index = key.indexOf(SEPARATOR);
            if (index > -1) {
                String tmp = key.substring(0, index);
                match = id.equals(tmp);
            } else {
                match = id.equals(key);
            }
            if (!match) continue;
            entry.setValue(Boolean.TRUE);
            break;
        }
        if (!(all_true = Util.all(values = this.state_transfer_listeners.values(), Boolean.TRUE))) {
            return true;
        }
        boolean rc = false;
        try {
            this.startFlush();
            HashSet keys = new HashSet(this.state_transfer_listeners.keySet());
            rc = this.fetchApplicationStates(target, keys, timeout);
            this.state_transfer_listeners.clear();
        }
        finally {
            this.stopFlush();
        }
        return rc;
    }

    private boolean fetchApplicationStates(Address target, Set keys, long timeout) throws ChannelClosedException, ChannelNotConnectedException {
        boolean all_rcs = true;
        Iterator it = keys.iterator();
        while (it.hasNext()) {
            String appl_id = (String)it.next();
            boolean rc = this.channel.getState(target, appl_id, timeout);
            if (rc) continue;
            all_rcs = false;
        }
        return all_rcs;
    }

    public void up(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                MuxHeader hdr = (MuxHeader)msg.getHeader("MUX");
                if (hdr == null) {
                    log.error((Object)("MuxHeader not present - discarding message " + msg));
                    return;
                }
                MuxChannel mux_ch = (MuxChannel)this.apps.get(hdr.id);
                if (mux_ch == null) {
                    log.error((Object)("didn't find an application for id=" + hdr.id + " discarding messgage " + msg));
                    return;
                }
                if (log.isTraceEnabled()) {
                    log.trace((Object)("dispatching message to " + hdr.id));
                }
                mux_ch.up(evt);
                break;
            }
            case 6: {
                this.passToAllMuxChannels(evt);
                break;
            }
            case 9: {
                this.passToAllMuxChannels(evt);
                break;
            }
            case 17: {
                this.handleStateRequest(evt);
                break;
            }
            case 20: {
                this.handleStateResponse(evt);
                break;
            }
            default: {
                this.passToAllMuxChannels(evt);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Channel createMuxChannel(JChannelFactory f, String id, String stack_name) throws Exception {
        Map map = this.apps;
        synchronized (map) {
            if (this.apps.containsKey(id)) {
                throw new Exception("application ID \"" + id + "\" is already registered, cannot register duplicate ID");
            }
            MuxChannel ch = new MuxChannel(f, this.channel, id, stack_name, this);
            this.apps.put(id, ch);
            return ch;
        }
    }

    private void passToAllMuxChannels(Event evt) {
        Iterator it = this.apps.values().iterator();
        while (it.hasNext()) {
            MuxChannel ch = (MuxChannel)it.next();
            ch.up(evt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MuxChannel remove(String id) {
        Map map = this.apps;
        synchronized (map) {
            return (MuxChannel)this.apps.remove(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        boolean all_disconnected = true;
        Map map = this.apps;
        synchronized (map) {
            Iterator it = this.apps.values().iterator();
            while (it.hasNext()) {
                MuxChannel mux_ch = (MuxChannel)it.next();
                if (!mux_ch.isConnected()) continue;
                all_disconnected = false;
                break;
            }
            if (all_disconnected) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)"disconnecting underlying JChannel as all MuxChannels are disconnected");
                }
                this.channel.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean close() {
        boolean all_closed = true;
        Map map = this.apps;
        synchronized (map) {
            Iterator it = this.apps.values().iterator();
            while (it.hasNext()) {
                MuxChannel mux_ch = (MuxChannel)it.next();
                if (!mux_ch.isOpen()) continue;
                all_closed = false;
                break;
            }
            if (all_closed) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)"closing underlying JChannel as all MuxChannels are closed");
                }
                this.channel.close();
                this.apps.clear();
            }
            return all_closed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAll() {
        Map map = this.apps;
        synchronized (map) {
            Iterator it = this.apps.values().iterator();
            while (it.hasNext()) {
                MuxChannel mux_ch = (MuxChannel)it.next();
                mux_ch.setConnected(false);
                mux_ch.setClosed(true);
                mux_ch.closeMessageQueue(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shutdown() {
        boolean all_closed = true;
        Map map = this.apps;
        synchronized (map) {
            Iterator it = this.apps.values().iterator();
            while (it.hasNext()) {
                MuxChannel mux_ch = (MuxChannel)it.next();
                if (!mux_ch.isOpen()) continue;
                all_closed = false;
                break;
            }
            if (all_closed) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)"shutting down underlying JChannel as all MuxChannels are closed");
                }
                this.channel.shutdown();
                this.apps.clear();
            }
            return all_closed;
        }
    }

    private void handleStateRequest(Event evt) {
        StateTransferInfo info = (StateTransferInfo)evt.getArg();
        String id = info.state_id;
        MuxChannel mux_ch = null;
        try {
            int index = id.indexOf(SEPARATOR);
            if (index > -1) {
                info.state_id = id.substring(index + SEPARATOR_LEN);
                id = id.substring(0, index);
            } else {
                info.state_id = null;
            }
            mux_ch = (MuxChannel)this.apps.get(id);
            if (mux_ch == null) {
                throw new IllegalArgumentException("didn't find application with ID=" + id + " to fetch state from");
            }
            mux_ch.up(evt);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            mux_ch.returnState(null, id);
        }
    }

    private void handleStateResponse(Event evt) {
        String substate_id;
        String appl_id;
        StateTransferInfo info = (StateTransferInfo)evt.getArg();
        String tmp = info.state_id;
        if (tmp == null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("state is null, not passing up: " + info));
            }
            return;
        }
        int index = tmp.indexOf(SEPARATOR);
        if (index > -1) {
            appl_id = tmp.substring(0, index);
            substate_id = tmp.substring(index + SEPARATOR_LEN);
        } else {
            appl_id = tmp;
            substate_id = null;
        }
        MuxChannel mux_ch = (MuxChannel)this.apps.get(appl_id);
        if (mux_ch == null) {
            log.error((Object)("didn't find application with ID=" + appl_id + " to fetch state from"));
        } else {
            StateTransferInfo tmp_info = info.copy();
            tmp_info.state_id = substate_id;
            evt.setArg(tmp_info);
            mux_ch.up(evt);
        }
    }

    void startFlush() {
    }

    void stopFlush() {
    }
}

