/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks;

import java.io.NotSerializableException;
import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jgroups.Channel;
import org.jgroups.JChannel;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.util.Rsp;
import org.jgroups.util.RspList;

public class RpcDispatcherSerializationTest
extends TestCase {
    private JChannel channel;
    private JChannel channel2;
    private RpcDispatcher disp;
    private RpcDispatcher disp2;
    private String props = null;

    public RpcDispatcherSerializationTest(String testName) {
        super(testName);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.channel = new JChannel(this.props);
        this.channel.setOpt(5, Boolean.TRUE);
        this.disp = new RpcDispatcher((Channel)this.channel, null, null, (Object)this);
        this.channel.connect("RpcDispatcherSerializationTestGroup");
        this.channel2 = new JChannel(this.props);
        this.disp2 = new RpcDispatcher((Channel)this.channel2, null, null, (Object)this);
        this.channel2.connect("RpcDispatcherSerializationTestGroup");
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.channel2.close();
        this.disp2.stop();
        this.disp.stop();
        this.channel.close();
    }

    public void testNonSerializableArgument() {
        try {
            this.disp.callRemoteMethods(null, "foo", new Object[]{new NonSerializable()}, new Class[]{NonSerializable.class}, 2, 5000L);
            RpcDispatcherSerializationTest.fail((String)"should throw NotSerializableException");
        }
        catch (Throwable t) {
            Throwable cause = t.getCause();
            if (cause != null && cause instanceof NotSerializableException) {
                System.out.println("received RuntimeException with NotSerializableException as cause - this is expected");
            }
            RpcDispatcherSerializationTest.fail((String)("received " + t));
        }
    }

    public void testTargetMethodNotFound() {
        Vector members = this.channel.getView().getMembers();
        System.out.println("members are: " + members);
        RspList rsps = this.disp.callRemoteMethods(members, "foo", new Object[]{"one", "two"}, new Class[]{String.class, String.class}, 2, 8000L);
        System.out.println("responses:\n" + rsps + ", channel.view: " + this.channel.getView() + ", channel2.view: " + this.channel2.getView());
        RpcDispatcherSerializationTest.assertEquals((int)members.size(), (int)rsps.size());
        for (int i = 0; i < rsps.size(); ++i) {
            Rsp rsp = (Rsp)rsps.elementAt(i);
            RpcDispatcherSerializationTest.assertTrue((boolean)(rsp.getValue() instanceof NoSuchMethodException));
        }
    }

    public static Test suite() {
        return new TestSuite(RpcDispatcherSerializationTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)RpcDispatcherSerializationTest.suite());
    }

    static class NonSerializable {
        int i;

        NonSerializable() {
        }
    }
}

