/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.launcher;

import java.lang.reflect.Constructor;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.osgi.framework.adaptor.FrameworkAdaptor;
import org.eclipse.osgi.framework.internal.core.Msg;
import org.eclipse.osgi.framework.internal.core.OSGi;
import org.eclipse.osgi.framework.internal.core.Tokenizer;
import org.eclipse.osgi.util.NLS;

public class Launcher {
    protected String consolePort = "";
    protected boolean console = false;
    protected String adaptorClassName = "org.eclipse.osgi.framework.internal.defaultadaptor.DefaultAdaptor";
    protected final String osgiConsoleClazz = "org.eclipse.osgi.framework.internal.core.FrameworkConsole";
    protected String[] adaptorArgs = null;
    private static final String OSGI_CONSOLE_COMPONENT_NAME = "OSGi Console";
    private static final String OSGI_CONSOLE_COMPONENT = "console.jar";
    static /* synthetic */ Class array$Ljava$lang$String;
    static /* synthetic */ Class class$org$eclipse$osgi$framework$internal$core$OSGi;

    public static void main(String[] args) {
        new Launcher().doIt(args);
    }

    protected void doIt(String[] args) {
        String[] consoleArgs = this.parseArgs(args);
        FrameworkAdaptor adaptor = null;
        try {
            adaptor = this.doAdaptor();
        }
        catch (Exception e) {
            System.out.println(Msg.LAUNCHER_ADAPTOR_ERROR);
            e.printStackTrace();
            return;
        }
        OSGi osgi = this.doOSGi(adaptor);
        if (osgi != null) {
            if (this.console) {
                this.doConsole(osgi, consoleArgs);
            } else {
                osgi.launch();
            }
        }
    }

    protected String[] parseArgs(String[] args) {
        Vector<String> consoleArgsVector = new Vector<String>();
        for (int i = 0; i < args.length; ++i) {
            Tokenizer tok;
            boolean match = false;
            String fullarg = args[i];
            int quoteidx = fullarg.indexOf("\"");
            if (quoteidx > 0) {
                if (quoteidx == fullarg.lastIndexOf("\"")) {
                    boolean stillparsing = true;
                    ++i;
                    while (i < args.length && stillparsing) {
                        fullarg = fullarg + " " + args[i];
                        ++i;
                        if (quoteidx >= fullarg.lastIndexOf("\"")) continue;
                        stillparsing = false;
                    }
                }
            } else {
                quoteidx = fullarg.indexOf("'");
                if (quoteidx > 0) {
                    if (quoteidx == fullarg.lastIndexOf("'")) {
                        boolean stillparsing = true;
                        ++i;
                        while (i < args.length && stillparsing) {
                            fullarg = fullarg + " " + args[i];
                            ++i;
                            if (quoteidx >= fullarg.lastIndexOf("'")) continue;
                            stillparsing = false;
                        }
                    }
                    fullarg = fullarg.replace('\'', '\"');
                }
            }
            if (!(tok = new Tokenizer(fullarg)).hasMoreTokens()) continue;
            String command = tok.getString(" ");
            StringTokenizer subtok = new StringTokenizer(command, ":");
            String subcommand = subtok.nextToken().toLowerCase();
            if (Launcher.matchCommand("-console", subcommand, 4)) {
                this._console(command);
                match = true;
            }
            if (Launcher.matchCommand("-adaptor", subcommand, 2)) {
                this._adaptor(command);
                match = true;
            }
            if (match) continue;
            consoleArgsVector.addElement(fullarg);
        }
        String[] consoleArgsArray = new String[consoleArgsVector.size()];
        Enumeration e = consoleArgsVector.elements();
        for (int i = 0; i < consoleArgsArray.length; ++i) {
            consoleArgsArray[i] = (String)e.nextElement();
        }
        return consoleArgsArray;
    }

    public static boolean matchCommand(String command, String input, int minLength) {
        int length;
        if (minLength <= 0) {
            minLength = command.length();
        }
        if (minLength > (length = input.length())) {
            length = minLength;
        }
        return command.regionMatches(0, input, 0, length);
    }

    protected void _console(String command) {
        this.console = true;
        StringTokenizer tok = new StringTokenizer(command, ":");
        String cmd = tok.nextToken();
        if (tok.hasMoreTokens()) {
            this.consolePort = tok.nextToken();
        }
    }

    protected void _adaptor(String command) {
        Tokenizer tok = new Tokenizer(command);
        String cmd = tok.getToken(":");
        tok.getChar();
        String adp = tok.getToken(":");
        if (adp.length() > 0) {
            this.adaptorClassName = adp;
        }
        Vector<String> v = new Vector<String>();
        while (true) {
            tok.getChar();
            String arg = tok.getString(":");
            if (arg == null) break;
            v.addElement(arg);
        }
        if (v != null) {
            int numArgs = v.size();
            this.adaptorArgs = new String[numArgs];
            Enumeration e = v.elements();
            for (int i = 0; i < numArgs; ++i) {
                this.adaptorArgs[i] = (String)e.nextElement();
            }
        }
    }

    protected FrameworkAdaptor doAdaptor() throws Exception {
        Class<?> adaptorClass = Class.forName(this.adaptorClassName);
        Class[] constructorArgs = new Class[]{array$Ljava$lang$String == null ? (array$Ljava$lang$String = Launcher.class$("[Ljava.lang.String;")) : array$Ljava$lang$String};
        Constructor<?> constructor = adaptorClass.getConstructor(constructorArgs);
        return (FrameworkAdaptor)constructor.newInstance(new Object[]{this.adaptorArgs});
    }

    private OSGi doOSGi(FrameworkAdaptor adaptor) {
        return new OSGi(adaptor);
    }

    private void doConsole(OSGi osgi, String[] consoleArgs) {
        try {
            Object[] parameters;
            Class[] parameterTypes;
            Class<?> osgiconsoleClass = Class.forName("org.eclipse.osgi.framework.internal.core.FrameworkConsole");
            if (this.consolePort.length() == 0) {
                parameterTypes = new Class[]{class$org$eclipse$osgi$framework$internal$core$OSGi == null ? (class$org$eclipse$osgi$framework$internal$core$OSGi = Launcher.class$("org.eclipse.osgi.framework.internal.core.OSGi")) : class$org$eclipse$osgi$framework$internal$core$OSGi, array$Ljava$lang$String == null ? (array$Ljava$lang$String = Launcher.class$("[Ljava.lang.String;")) : array$Ljava$lang$String};
                parameters = new Object[]{osgi, consoleArgs};
            } else {
                parameterTypes = new Class[]{class$org$eclipse$osgi$framework$internal$core$OSGi == null ? (class$org$eclipse$osgi$framework$internal$core$OSGi = Launcher.class$("org.eclipse.osgi.framework.internal.core.OSGi")) : class$org$eclipse$osgi$framework$internal$core$OSGi, Integer.TYPE, array$Ljava$lang$String == null ? (array$Ljava$lang$String = Launcher.class$("[Ljava.lang.String;")) : array$Ljava$lang$String};
                parameters = new Object[]{osgi, new Integer(this.consolePort), consoleArgs};
            }
            Constructor<?> consoleConstructor = osgiconsoleClass.getConstructor(parameterTypes);
            Object osgiconsole = consoleConstructor.newInstance(parameters);
            Thread t = new Thread((Runnable)osgiconsole, OSGI_CONSOLE_COMPONENT_NAME);
            t.start();
        }
        catch (NumberFormatException nfe) {
            System.err.println(NLS.bind(Msg.LAUNCHER_INVALID_PORT, this.consolePort));
        }
        catch (Exception ex) {
            this.informAboutMissingComponent(OSGI_CONSOLE_COMPONENT_NAME, OSGI_CONSOLE_COMPONENT);
        }
    }

    void informAboutMissingComponent(String component, String jar) {
        System.out.println();
        System.out.print(NLS.bind(Msg.LAUNCHER_COMPONENT_MISSING, component));
        System.out.println(NLS.bind(Msg.LAUNCHER_COMPONENT_JAR, jar));
        System.out.println();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

