/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.server.query.service;

import com.metamatrix.api.exception.ComponentNotFoundException;
import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.server.InvalidRequestIDException;
import com.metamatrix.common.util.RemoteUtil;
import com.metamatrix.dqp.message.RequestID;
import com.metamatrix.platform.security.api.SessionToken;
import com.metamatrix.platform.service.api.exception.ServiceClosedException;
import com.metamatrix.platform.service.api.exception.ServiceException;
import com.metamatrix.platform.service.api.exception.ServiceNotInitializedException;
import com.metamatrix.platform.service.api.exception.ServiceStateException;
import com.metamatrix.platform.service.proxy.ServiceProxy;
import com.metamatrix.server.ServerPlugin;
import com.metamatrix.server.query.service.IQueryServiceProxy;
import com.metamatrix.server.query.service.QueryServiceInterface;
import java.rmi.ConnectException;
import java.rmi.ConnectIOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class QueryServiceProxy
extends ServiceProxy
implements IQueryServiceProxy {
    static /* synthetic */ Class class$com$metamatrix$server$query$service$QueryServiceInterface;

    public void clearCache(SessionToken sessionToken) throws ComponentNotFoundException, ServiceException {
        this.checkConnection();
        Iterator services = this.getInstances().iterator();
        if (!services.hasNext()) {
            ComponentNotFoundException cnfe = new ComponentNotFoundException("ERR.018.005.0072", ServerPlugin.Util.getString("ERR.018.005.0072", sessionToken));
            this.logException(cnfe);
            throw cnfe;
        }
        QueryServiceInterface service = null;
        int retryLimit = this.getRetryLimit();
        RemoteException re = null;
        while (services.hasNext()) {
            service = (QueryServiceInterface)RemoteUtil.narrow(services.next(), class$com$metamatrix$server$query$service$QueryServiceInterface == null ? QueryServiceProxy.class$("com.metamatrix.server.query.service.QueryServiceInterface") : class$com$metamatrix$server$query$service$QueryServiceInterface);
            try {
                boolean called = false;
                for (int i = 0; i != retryLimit; ++i) {
                    try {
                        service.clearCache(sessionToken);
                        called = true;
                    }
                    catch (RemoteException e) {
                        re = e;
                        if (!(e instanceof ConnectException) && !(e instanceof ConnectIOException)) break;
                        try {
                            Thread.sleep(250L);
                            continue;
                        }
                        catch (InterruptedException ie) {
                        }
                    }
                }
                if (re != null) {
                    ServerPlugin.Util.log(4, re, ServerPlugin.Util.getString("QueryServiceProxy.RMI_error_with_QueryServiceProxy_communications_with_service"));
                }
                if (called) continue;
                this.markInstanceAsBad(service);
            }
            catch (ComponentNotFoundException e) {
            }
            catch (ServiceNotInitializedException snie) {
                ServerPlugin.Util.log(2, snie, ServerPlugin.Util.getString("QueryServiceProxy.Error__Could_not_clear_cache_in_Query_Service,_service_is_not_initialized"));
            }
            catch (ServiceClosedException sce) {
                this.markInstanceAsBad(service);
                ServerPlugin.Util.log(2, sce, ServerPlugin.Util.getString("QueryServiceProxy.Error__Could_not_clear_cache__in_Query_Service,_service_is_closed."));
            }
        }
    }

    public void cancelQueries(SessionToken sessionToken, boolean isClient, boolean shouldRollback) throws InvalidRequestIDException, MetaMatrixComponentException, ServiceStateException {
        this.checkConnection();
        Iterator services = this.getInstances().iterator();
        if (!services.hasNext()) {
            ComponentNotFoundException cnfe = new ComponentNotFoundException("ERR.018.005.0065", ServerPlugin.Util.getString("ERR.018.005.0065", sessionToken));
            this.logException(cnfe);
            throw cnfe;
        }
        QueryServiceInterface service = null;
        int retryLimit = this.getRetryLimit();
        RemoteException re = null;
        while (services.hasNext()) {
            service = (QueryServiceInterface)RemoteUtil.narrow(services.next(), class$com$metamatrix$server$query$service$QueryServiceInterface == null ? QueryServiceProxy.class$("com.metamatrix.server.query.service.QueryServiceInterface") : class$com$metamatrix$server$query$service$QueryServiceInterface);
            try {
                boolean called = false;
                for (int i = 0; i != retryLimit; ++i) {
                    try {
                        service.cancelQueries(sessionToken, shouldRollback);
                        called = true;
                    }
                    catch (RemoteException e) {
                        re = e;
                        if (!(e instanceof ConnectException) && !(e instanceof ConnectIOException)) break;
                        try {
                            Thread.sleep(250L);
                            continue;
                        }
                        catch (InterruptedException ie) {
                        }
                    }
                }
                if (re != null) {
                    ServerPlugin.Util.log(4, re, ServerPlugin.Util.getString("QueryServiceProxy.RMI_error_with_QueryServiceProxy_communications_with_service"));
                }
                if (called) continue;
                this.markInstanceAsBad(service);
            }
            catch (ComponentNotFoundException e) {
            }
            catch (ServiceNotInitializedException snie) {
                ServerPlugin.Util.log(2, snie, ServerPlugin.Util.getString("QueryServiceProxy.Error__Could_not_cancel_queries_with_Query_Service,_service_is_not_initialized."));
            }
            catch (ServiceClosedException sce) {
                this.markInstanceAsBad(service);
                ServerPlugin.Util.log(2, sce, ServerPlugin.Util.getString("QueryServiceProxy.Error__Could_not_cancel_queries_with_Query_Service,_service_is_closed."));
            }
        }
    }

    public void cancelQuery(RequestID requestID, boolean isClient, boolean shouldRollback) throws InvalidRequestIDException, MetaMatrixComponentException, ServiceException {
        this.checkConnection();
        Iterator services = this.getInstances().iterator();
        if (!services.hasNext()) {
            ComponentNotFoundException cnfe = new ComponentNotFoundException("ERR.018.005.0061", ServerPlugin.Util.getString("ERR.018.005.0061", requestID));
            this.logException(cnfe);
            throw cnfe;
        }
        QueryServiceInterface service = null;
        int retryLimit = this.getRetryLimit();
        RemoteException re = null;
        while (services.hasNext()) {
            service = (QueryServiceInterface)RemoteUtil.narrow(services.next(), class$com$metamatrix$server$query$service$QueryServiceInterface == null ? QueryServiceProxy.class$("com.metamatrix.server.query.service.QueryServiceInterface") : class$com$metamatrix$server$query$service$QueryServiceInterface);
            try {
                boolean called = false;
                for (int i = 0; i != retryLimit; ++i) {
                    try {
                        service.cancelQuery(requestID, shouldRollback);
                        called = true;
                    }
                    catch (RemoteException e) {
                        re = e;
                        if (!(e instanceof ConnectException) && !(e instanceof ConnectIOException)) break;
                        try {
                            Thread.sleep(250L);
                            continue;
                        }
                        catch (InterruptedException ie) {
                        }
                    }
                }
                if (re != null) {
                    ServerPlugin.Util.log(4, re, ServerPlugin.Util.getString("QueryServiceProxy.RMI_error_with_QueryServiceProxy_communications_with_service."));
                }
                if (called) continue;
                this.markInstanceAsBad(service);
            }
            catch (InvalidRequestIDException e) {
            }
            catch (ServiceNotInitializedException snie) {
                ServerPlugin.Util.log(2, snie, ServerPlugin.Util.getString("QueryServiceProxy.Error__Could_not_cancel_query_with_Query_Service,_service_is_not_initialized."));
            }
            catch (ServiceClosedException sce) {
                this.markInstanceAsBad(service);
                ServerPlugin.Util.log(2, sce, ServerPlugin.Util.getString("QueryServiceProxy.Error__Could_not_cancel_query_with_Query_Service,_service_is_closed."));
            }
            catch (MetaMatrixComponentException e) {}
        }
    }

    public void cancelQuery(RequestID requestID, int nodeID) throws InvalidRequestIDException, MetaMatrixComponentException, ServiceException {
        this.checkConnection();
        Iterator services = this.getInstances().iterator();
        if (!services.hasNext()) {
            ComponentNotFoundException cnfe = new ComponentNotFoundException("ERR.018.005.0061", ServerPlugin.Util.getString("ERR.018.005.0061", requestID));
            this.logException(cnfe);
            throw cnfe;
        }
        QueryServiceInterface service = null;
        int retryLimit = this.getRetryLimit();
        RemoteException re = null;
        while (services.hasNext()) {
            service = (QueryServiceInterface)RemoteUtil.narrow(services.next(), class$com$metamatrix$server$query$service$QueryServiceInterface == null ? QueryServiceProxy.class$("com.metamatrix.server.query.service.QueryServiceInterface") : class$com$metamatrix$server$query$service$QueryServiceInterface);
            try {
                boolean called = false;
                for (int i = 0; i != retryLimit; ++i) {
                    try {
                        service.cancelQuery(requestID, nodeID);
                        called = true;
                    }
                    catch (RemoteException e) {
                        re = e;
                        if (!(e instanceof ConnectException) && !(e instanceof ConnectIOException)) break;
                        try {
                            Thread.sleep(250L);
                            continue;
                        }
                        catch (InterruptedException ie) {
                        }
                    }
                }
                if (re != null) {
                    ServerPlugin.Util.log(4, re, ServerPlugin.Util.getString("QueryServiceProxy.RMI_error_with_QueryServiceProxy_communications_with_service."));
                }
                if (called) continue;
                this.markInstanceAsBad(service);
            }
            catch (InvalidRequestIDException e) {
            }
            catch (ServiceNotInitializedException snie) {
                ServerPlugin.Util.log(2, snie, ServerPlugin.Util.getString("QueryServiceProxy.Error__Could_not_cancel_query_with_Query_Service,_service_is_not_initialized."));
            }
            catch (ServiceClosedException sce) {
                this.markInstanceAsBad(service);
                ServerPlugin.Util.log(2, sce, ServerPlugin.Util.getString("QueryServiceProxy.Error__Could_not_cancel_query_with_Query_Service,_service_is_closed."));
            }
            catch (MetaMatrixComponentException e) {}
        }
    }

    public List getQueriesForSession(SessionToken userToken) throws ServiceException {
        this.checkConnection();
        Iterator services = this.getInstances().iterator();
        ArrayList requests = new ArrayList();
        if (!services.hasNext()) {
            return requests;
        }
        QueryServiceInterface service = null;
        int retryLimit = this.getRetryLimit();
        RemoteException re = null;
        while (services.hasNext()) {
            service = (QueryServiceInterface)RemoteUtil.narrow(services.next(), class$com$metamatrix$server$query$service$QueryServiceInterface == null ? QueryServiceProxy.class$("com.metamatrix.server.query.service.QueryServiceInterface") : class$com$metamatrix$server$query$service$QueryServiceInterface);
            boolean called = false;
            try {
                for (int i = 0; i != retryLimit; ++i) {
                    try {
                        requests.addAll(service.getQueriesForSession(userToken));
                        called = true;
                    }
                    catch (RemoteException e) {
                        re = e;
                        if (!(e instanceof ConnectException) && !(e instanceof ConnectIOException)) break;
                        try {
                            Thread.sleep(250L);
                            continue;
                        }
                        catch (InterruptedException ie) {
                        }
                    }
                }
                if (re != null) {
                    ServerPlugin.Util.log(4, re, ServerPlugin.Util.getString("QueryServiceProxy.RMI_error_with_QueryServiceProxy_communications_with_service."));
                }
                if (called) continue;
                this.markInstanceAsBad(service);
            }
            catch (ServiceNotInitializedException snie) {
                ServerPlugin.Util.log(2, snie, ServerPlugin.Util.getString("QueryServiceProxy.Error__Could_not_get_queries_for_session_from_Query_Service,_service_is_not_initialized."));
            }
            catch (ServiceClosedException sce) {
                this.markInstanceAsBad(service);
                ServerPlugin.Util.log(2, sce, ServerPlugin.Util.getString("QueryServiceProxy.Error__Could_not_get_queries_for_session_from_Query_Service,_service_is_closed."));
            }
        }
        return requests;
    }

    public List getAllQueries() throws ServiceException {
        this.checkConnection();
        Iterator services = this.getInstances().iterator();
        ArrayList requests = new ArrayList();
        if (!services.hasNext()) {
            return requests;
        }
        QueryServiceInterface service = null;
        int retryLimit = this.getRetryLimit();
        RemoteException re = null;
        while (services.hasNext()) {
            service = (QueryServiceInterface)RemoteUtil.narrow(services.next(), class$com$metamatrix$server$query$service$QueryServiceInterface == null ? QueryServiceProxy.class$("com.metamatrix.server.query.service.QueryServiceInterface") : class$com$metamatrix$server$query$service$QueryServiceInterface);
            boolean called = false;
            try {
                for (int i = 0; i != retryLimit; ++i) {
                    try {
                        requests.addAll(service.getAllQueries());
                        called = true;
                    }
                    catch (RemoteException e) {
                        re = e;
                        if (!(e instanceof ConnectException) && !(e instanceof ConnectIOException)) break;
                        try {
                            Thread.sleep(250L);
                            continue;
                        }
                        catch (InterruptedException ie) {
                        }
                    }
                }
                if (re != null) {
                    ServerPlugin.Util.log(4, re, ServerPlugin.Util.getString("QueryServiceProxy.RMI_error_with_QueryServiceProxy_communications_with_service."));
                }
                if (called) continue;
                this.markInstanceAsBad(service);
            }
            catch (ServiceNotInitializedException snie) {
                ServerPlugin.Util.log(2, snie, ServerPlugin.Util.getString("QueryServiceProxy.Error__Could_not_get_all_queries_from_Query_Service,_service_is_not_initialized."));
            }
            catch (ServiceClosedException sce) {
                this.markInstanceAsBad(service);
                ServerPlugin.Util.log(2, sce, ServerPlugin.Util.getString("QueryServiceProxy.Error__Could_not_get_all_queries_from_Query_Service,_service_is_closed."));
            }
        }
        return requests;
    }

    public String getServiceType() {
        return "QueryService";
    }

    protected String getServiceNameForProxy() {
        return "QueryService";
    }

    protected QueryServiceInterface getCurrentService() throws ServiceException {
        return (QueryServiceInterface)RemoteUtil.narrow(this.getNextInstance(), class$com$metamatrix$server$query$service$QueryServiceInterface == null ? (class$com$metamatrix$server$query$service$QueryServiceInterface = QueryServiceProxy.class$("com.metamatrix.server.query.service.QueryServiceInterface")) : class$com$metamatrix$server$query$service$QueryServiceInterface);
    }

    protected String getLoggingContext() {
        return "QUERY_SERVICE";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

