/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.sql.visitor;

import com.metamatrix.api.exception.query.QueryResolverException;
import com.metamatrix.api.exception.query.UnresolvedSymbolDescription;
import com.metamatrix.query.QueryPlugin;
import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.LanguageVisitor;
import com.metamatrix.query.sql.navigator.PreOrderNavigator;
import com.metamatrix.query.sql.proc.Block;
import com.metamatrix.query.sql.proc.DeclareStatement;
import com.metamatrix.query.sql.proc.Statement;
import com.metamatrix.query.sql.symbol.ElementSymbol;
import com.metamatrix.query.sql.util.VariableContext;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DeclaredVariableCollector
extends LanguageVisitor {
    private static final String SEPARATOR = ".";
    private List multiVarDeclarations;
    private VariableContext varContext;

    public DeclaredVariableCollector(VariableContext varContext) {
        if (varContext == null) {
            throw new IllegalArgumentException(QueryPlugin.Util.getString("ERR.015.010.0020"));
        }
        this.varContext = varContext;
        this.addUpdateCountVariable();
    }

    public void collectDeclareVariables(DeclareStatement obj) {
        ElementSymbol variable = obj.getVariable();
        String typeName = obj.getVariableType();
        String varName = variable.getCanonicalName();
        int sepIndex = varName.indexOf(SEPARATOR);
        if (sepIndex < 0) {
            varName = "VARIABLES." + varName.substring(sepIndex + 1);
        } else {
            sepIndex = varName.lastIndexOf(SEPARATOR);
            String groupName = varName.substring(0, sepIndex);
            if (!groupName.equals("VARIABLES")) {
                this.handleMultiDeclaredVarible(variable, QueryPlugin.Util.getString("ERR.015.010.0031", new Object[]{"VARIABLES", variable}));
            }
        }
        variable.setName(varName);
        if (this.varContext.containsLocalVariable(variable) && !varName.equals("VARIABLES.ROWS_UPDATED")) {
            this.handleMultiDeclaredVarible(variable, QueryPlugin.Util.getString("ERR.015.010.0032", variable));
        }
        this.varContext.setValue(variable, typeName);
    }

    public void visit(Block obj) {
        Iterator stmtIter = obj.getStatements().iterator();
        while (stmtIter.hasNext()) {
            Statement stmt = (Statement)stmtIter.next();
            if (stmt.getType() != 3) continue;
            this.collectDeclareVariables((DeclareStatement)stmt);
        }
        this.setAbort(true);
    }

    private void addUpdateCountVariable() {
        String countVar = "VARIABLES.ROWS_UPDATED";
        ElementSymbol updateCount = new ElementSymbol(countVar.toString());
        this.varContext.setValue(updateCount, "integer");
    }

    public VariableContext getVariableContext() {
        return this.varContext;
    }

    private List getMultiVariableDeclarations() {
        return this.multiVarDeclarations;
    }

    private void handleMultiDeclaredVarible(ElementSymbol symbol, String description) {
        if (this.multiVarDeclarations == null) {
            this.multiVarDeclarations = new ArrayList();
        }
        this.multiVarDeclarations.add(new UnresolvedSymbolDescription(symbol, description));
    }

    public static final VariableContext getVariableContext(LanguageObject obj) throws QueryResolverException {
        VariableContext varContext = new VariableContext();
        DeclaredVariableCollector declareVisitor = new DeclaredVariableCollector(varContext);
        PreOrderNavigator.doVisit(obj, declareVisitor);
        List multiVars = declareVisitor.getMultiVariableDeclarations();
        if (multiVars != null && multiVars.size() > 0) {
            UnresolvedSymbolDescription symbol = (UnresolvedSymbolDescription)multiVars.get(0);
            QueryResolverException e = new QueryResolverException(symbol.getDescription());
            e.setUnresolvedSymbols(multiVars);
            throw e;
        }
        return varContext;
    }
}

