/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.sql.visitor;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.QueryResolverException;
import com.metamatrix.api.exception.query.UnresolvedSymbolDescription;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.metadata.TempMetadataID;
import com.metamatrix.query.resolver.util.ResolveElementsVisitor;
import com.metamatrix.query.resolver.util.ResolveGroupsVisitor;
import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.LanguageVisitor;
import com.metamatrix.query.sql.lang.BetweenCriteria;
import com.metamatrix.query.sql.lang.CompareCriteria;
import com.metamatrix.query.sql.lang.IsNullCriteria;
import com.metamatrix.query.sql.lang.MatchCriteria;
import com.metamatrix.query.sql.lang.Select;
import com.metamatrix.query.sql.lang.SetCriteria;
import com.metamatrix.query.sql.navigator.CorrelatedSubqueryPreOrderNavigator;
import com.metamatrix.query.sql.navigator.PreOrderNavigator;
import com.metamatrix.query.sql.symbol.AliasSymbol;
import com.metamatrix.query.sql.symbol.CaseExpression;
import com.metamatrix.query.sql.symbol.ElementSymbol;
import com.metamatrix.query.sql.symbol.Expression;
import com.metamatrix.query.sql.symbol.ExpressionSymbol;
import com.metamatrix.query.sql.symbol.Function;
import com.metamatrix.query.sql.symbol.GroupSymbol;
import com.metamatrix.query.sql.symbol.Reference;
import com.metamatrix.query.sql.symbol.SearchedCaseExpression;
import com.metamatrix.query.sql.symbol.SelectSymbol;
import com.metamatrix.query.sql.symbol.Symbol;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CorrelatedVariableSubstitutionVisitor
extends LanguageVisitor {
    private int refCounter = 0;
    private List references = new ArrayList();
    private QueryMetadataInterface metadata;
    private MetaMatrixComponentException componentException;
    private List unresolvedLanguageObjects;

    public CorrelatedVariableSubstitutionVisitor(QueryMetadataInterface metadata) {
        this.metadata = metadata;
    }

    public List getReferences() {
        return this.references;
    }

    public List getUnresolvedSymbols() {
        return this.unresolvedLanguageObjects;
    }

    public MetaMatrixComponentException getComponentException() {
        return this.componentException;
    }

    public void visit(Select obj) {
        List selectSymbols = obj.getSymbols();
        ArrayList<SelectSymbol> newSelectSymbols = new ArrayList<SelectSymbol>(selectSymbols.size());
        Iterator sybIter = selectSymbols.iterator();
        while (sybIter.hasNext()) {
            SelectSymbol ss = (SelectSymbol)sybIter.next();
            newSelectSymbols.add(this.getVariableValue(ss));
        }
        obj.setSymbols(newSelectSymbols);
    }

    public void visit(BetweenCriteria obj) {
        obj.setExpression(this.getVariableValue(obj.getExpression()));
        obj.setLowerExpression(this.getVariableValue(obj.getLowerExpression()));
        obj.setUpperExpression(this.getVariableValue(obj.getUpperExpression()));
    }

    public void visit(CaseExpression obj) {
        obj.setExpression(this.getVariableValue(obj.getExpression()));
        int whenCount = obj.getWhenCount();
        ArrayList<Expression> whens = new ArrayList<Expression>(whenCount);
        ArrayList<Expression> thens = new ArrayList<Expression>(whenCount);
        for (int i = 0; i < whenCount; ++i) {
            whens.add(this.getVariableValue(obj.getWhenExpression(i)));
            thens.add(this.getVariableValue(obj.getThenExpression(i)));
        }
        obj.setWhen(whens, thens);
        obj.setElseExpression(this.getVariableValue(obj.getElseExpression()));
    }

    public void visit(CompareCriteria obj) {
        obj.setLeftExpression(this.getVariableValue(obj.getLeftExpression()));
        obj.setRightExpression(this.getVariableValue(obj.getRightExpression()));
    }

    public void visit(IsNullCriteria obj) {
        obj.setExpression(this.getVariableValue(obj.getExpression()));
    }

    public void visit(MatchCriteria obj) {
        obj.setLeftExpression(this.getVariableValue(obj.getLeftExpression()));
        obj.setRightExpression(this.getVariableValue(obj.getRightExpression()));
    }

    public void visit(SearchedCaseExpression obj) {
        int whenCount = obj.getWhenCount();
        ArrayList<Expression> thens = new ArrayList<Expression>(whenCount);
        for (int i = 0; i < whenCount; ++i) {
            thens.add(this.getVariableValue(obj.getThenExpression(i)));
        }
        obj.setWhen(obj.getWhen(), thens);
        obj.setElseExpression(this.getVariableValue(obj.getElseExpression()));
    }

    public void visit(SetCriteria obj) {
        obj.setExpression(this.getVariableValue(obj.getExpression()));
    }

    public void visit(Function obj) {
        int argLength = obj.getArgs().length;
        Expression[] args = new Expression[argLength];
        for (int i = 0; i < argLength; ++i) {
            args[i] = this.getVariableValue(obj.getArg(i));
        }
        obj.setArgs(args);
    }

    private Expression getVariableValue(Expression expression) {
        ElementSymbol variable;
        Expression expr = expression;
        if (expr instanceof AliasSymbol) {
            expr = ((AliasSymbol)expr).getSymbol();
        }
        if (expr instanceof ElementSymbol && (variable = (ElementSymbol)expr).isExternalReference()) {
            this.resolveElementSymbol(variable);
            Reference ref = new Reference(this.refCounter++, variable);
            this.references.add(ref);
            return ref;
        }
        return expression;
    }

    private SelectSymbol getVariableValue(SelectSymbol selectSymbol) {
        String name = "Ref";
        boolean aliased = false;
        SelectSymbol ss = selectSymbol;
        if (ss instanceof AliasSymbol) {
            name = ss.getName();
            ss = ((AliasSymbol)ss).getSymbol();
            aliased = true;
        }
        if (ss instanceof ElementSymbol) {
            ElementSymbol variable = (ElementSymbol)ss;
            if (variable.isExternalReference()) {
                if (!aliased) {
                    name = variable.getName();
                }
                this.resolveElementSymbol(variable);
                Reference ref = new Reference(this.refCounter++, variable);
                this.references.add(ref);
                return new ExpressionSymbol(name, ref);
            }
        } else if (ss instanceof ExpressionSymbol) {
            ExpressionSymbol variable = (ExpressionSymbol)ss;
            Expression newExpr = this.getVariableValue(variable.getExpression());
            variable.setExpression(newExpr);
        }
        return selectSymbol;
    }

    private void resolveElementSymbol(ElementSymbol variable) {
        List unresolvedElements;
        GroupSymbol group = variable.getGroupSymbol();
        if (group.getMetadataID() instanceof TempMetadataID) {
            TempMetadataID tempID = (TempMetadataID)group.getMetadataID();
            String originalName = tempID.getOriginalName();
            group.setName(originalName);
        }
        group.setMetadataIDToNull();
        try {
            ResolveGroupsVisitor.resolveGroups((LanguageObject)group, (QueryMetadataInterface)this.metadata);
        }
        catch (QueryResolverException e) {
            this.handleUnresolvedSymbol(group, e.getMessage());
        }
        catch (MetaMatrixComponentException e) {
            this.handleException(e);
        }
        ArrayList<GroupSymbol> groups = new ArrayList<GroupSymbol>(1);
        groups.add(group);
        variable.setMetadataID(null);
        ResolveElementsVisitor visitor = new ResolveElementsVisitor(this.metadata, groups);
        PreOrderNavigator.doVisit(variable, (LanguageVisitor)visitor);
        if (visitor.getComponentException() != null) {
            this.handleException(visitor.getComponentException());
        }
        if ((unresolvedElements = visitor.getUnresolvedElements()) != null && unresolvedElements.size() > 0) {
            if (this.unresolvedLanguageObjects == null) {
                this.unresolvedLanguageObjects = unresolvedElements;
            } else {
                this.unresolvedLanguageObjects.addAll(unresolvedElements);
            }
        }
    }

    private void handleException(MetaMatrixComponentException e) {
        this.componentException = e;
        this.setAbort(true);
    }

    private void handleUnresolvedSymbol(Symbol symbol, String description) {
        if (this.unresolvedLanguageObjects == null) {
            this.unresolvedLanguageObjects = new ArrayList();
        }
        this.unresolvedLanguageObjects.add(new UnresolvedSymbolDescription(symbol, description));
    }

    public static final List substituteVariables(LanguageObject obj, QueryMetadataInterface metadata) throws MetaMatrixComponentException, QueryResolverException {
        CorrelatedVariableSubstitutionVisitor visitor = new CorrelatedVariableSubstitutionVisitor(metadata);
        CorrelatedSubqueryPreOrderNavigator.doVisit(obj, visitor);
        if (visitor.getComponentException() != null) {
            throw visitor.getComponentException();
        }
        List unresolvedSymbols = visitor.getUnresolvedSymbols();
        if (unresolvedSymbols != null && unresolvedSymbols.size() > 0) {
            UnresolvedSymbolDescription symbol = (UnresolvedSymbolDescription)unresolvedSymbols.get(0);
            QueryResolverException e = new QueryResolverException(symbol.getDescription());
            e.setUnresolvedSymbols(unresolvedSymbols);
            throw e;
        }
        return visitor.getReferences();
    }
}

