/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.sql.visitor;

import com.metamatrix.query.sql.LanguageVisitor;
import com.metamatrix.query.sql.lang.BetweenCriteria;
import com.metamatrix.query.sql.lang.CompareCriteria;
import com.metamatrix.query.sql.lang.Delete;
import com.metamatrix.query.sql.lang.GroupBy;
import com.metamatrix.query.sql.lang.Insert;
import com.metamatrix.query.sql.lang.IsNullCriteria;
import com.metamatrix.query.sql.lang.MatchCriteria;
import com.metamatrix.query.sql.lang.OrderBy;
import com.metamatrix.query.sql.lang.SPParameter;
import com.metamatrix.query.sql.lang.Select;
import com.metamatrix.query.sql.lang.SetCriteria;
import com.metamatrix.query.sql.lang.StoredProcedure;
import com.metamatrix.query.sql.lang.SubqueryCompareCriteria;
import com.metamatrix.query.sql.lang.SubquerySetCriteria;
import com.metamatrix.query.sql.lang.UnaryFromClause;
import com.metamatrix.query.sql.lang.Update;
import com.metamatrix.query.sql.proc.CriteriaSelector;
import com.metamatrix.query.sql.symbol.AggregateSymbol;
import com.metamatrix.query.sql.symbol.AliasSymbol;
import com.metamatrix.query.sql.symbol.AllInGroupSymbol;
import com.metamatrix.query.sql.symbol.AllSymbol;
import com.metamatrix.query.sql.symbol.CaseExpression;
import com.metamatrix.query.sql.symbol.ElementSymbol;
import com.metamatrix.query.sql.symbol.Expression;
import com.metamatrix.query.sql.symbol.Function;
import com.metamatrix.query.sql.symbol.GroupSymbol;
import com.metamatrix.query.sql.symbol.SearchedCaseExpression;
import com.metamatrix.query.sql.symbol.SingleElementSymbol;
import com.metamatrix.query.sql.symbol.Symbol;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractSymbolMappingVisitor
extends LanguageVisitor {
    private List unmappedSymbols;

    protected AbstractSymbolMappingVisitor() {
    }

    protected abstract Symbol getMappedSymbol(Symbol var1);

    public void visit(CaseExpression obj) {
        if (obj.getExpression() instanceof ElementSymbol) {
            obj.setExpression(this.getMappedElement((ElementSymbol)obj.getExpression()));
        }
        int whenCount = obj.getWhenCount();
        ArrayList<Expression> whens = new ArrayList<Expression>(whenCount);
        ArrayList<Expression> thens = new ArrayList<Expression>(whenCount);
        Expression when = null;
        Expression then = null;
        for (int i = 0; i < whenCount; ++i) {
            when = obj.getWhenExpression(i);
            then = obj.getThenExpression(i);
            if (when instanceof ElementSymbol) {
                when = this.getMappedElement((ElementSymbol)when);
            }
            if (then instanceof ElementSymbol) {
                then = this.getMappedElement((ElementSymbol)then);
            }
            whens.add(when);
            thens.add(then);
        }
        obj.setWhen(whens, thens);
        if (obj.getElseExpression() instanceof ElementSymbol) {
            obj.setElseExpression(this.getMappedElement((ElementSymbol)obj.getElseExpression()));
        }
    }

    public void visit(Insert obj) {
        ArrayList<ElementSymbol> physicalElements = new ArrayList<ElementSymbol>();
        GroupSymbol virtualGroup = obj.getGroup();
        obj.setGroup(this.getMappedGroup(virtualGroup));
        if (obj.getVariables() != null) {
            Iterator elementIter = obj.getVariables().iterator();
            while (elementIter.hasNext()) {
                ElementSymbol virtualElement = (ElementSymbol)elementIter.next();
                physicalElements.add(this.getMappedElement(virtualElement));
            }
            obj.setVariables(physicalElements);
        }
    }

    public void visit(Delete obj) {
        GroupSymbol virtualGroup = obj.getGroup();
        obj.setGroup(this.getMappedGroup(virtualGroup));
    }

    public void visit(Update obj) {
        GroupSymbol virtualGroup = obj.getGroup();
        obj.setGroup(this.getMappedGroup(virtualGroup));
    }

    public void visit(BetweenCriteria obj) {
        Expression exp = obj.getExpression();
        Expression lowerExp = obj.getLowerExpression();
        Expression upperExp = obj.getUpperExpression();
        if (exp instanceof ElementSymbol) {
            exp = this.getMappedElement((ElementSymbol)exp);
            obj.setExpression(exp);
        }
        if (lowerExp instanceof ElementSymbol) {
            lowerExp = this.getMappedElement((ElementSymbol)lowerExp);
            obj.setLowerExpression(lowerExp);
        }
        if (upperExp instanceof ElementSymbol) {
            upperExp = this.getMappedElement((ElementSymbol)upperExp);
            obj.setUpperExpression(upperExp);
        }
    }

    public void visit(CompareCriteria obj) {
        Expression leftExp = obj.getLeftExpression();
        Expression rightExp = obj.getRightExpression();
        if (leftExp instanceof ElementSymbol) {
            leftExp = this.getMappedElement((ElementSymbol)leftExp);
            obj.setLeftExpression(leftExp);
        }
        if (rightExp instanceof ElementSymbol) {
            rightExp = this.getMappedElement((ElementSymbol)rightExp);
            obj.setRightExpression(rightExp);
        }
    }

    public void visit(IsNullCriteria obj) {
        Expression expr = obj.getExpression();
        if (expr instanceof ElementSymbol) {
            expr = this.getMappedElement((ElementSymbol)expr);
            obj.setExpression(expr);
        }
    }

    public void visit(MatchCriteria obj) {
        Expression leftExp = obj.getLeftExpression();
        Expression rightExp = obj.getRightExpression();
        if (leftExp instanceof ElementSymbol) {
            leftExp = this.getMappedElement((ElementSymbol)leftExp);
            obj.setLeftExpression(leftExp);
        }
        if (rightExp instanceof ElementSymbol) {
            rightExp = this.getMappedElement((ElementSymbol)rightExp);
            obj.setRightExpression(rightExp);
        }
    }

    public void visit(SetCriteria obj) {
        Expression expr = obj.getExpression();
        if (expr instanceof ElementSymbol) {
            expr = this.getMappedElement((ElementSymbol)expr);
            obj.setExpression(expr);
        }
        ArrayList<ElementSymbol> valuesList = new ArrayList<ElementSymbol>(obj.getNumberOfValues());
        Iterator valuesIter = obj.getValues().iterator();
        while (valuesIter.hasNext()) {
            Object exp = valuesIter.next();
            if (exp instanceof ElementSymbol) {
                valuesList.add(this.getMappedElement((ElementSymbol)exp));
                continue;
            }
            if (exp instanceof AliasSymbol) {
                SingleElementSymbol elementSyb = ((AliasSymbol)exp).getSymbol();
                if (!(elementSyb instanceof ElementSymbol)) continue;
                valuesList.add(this.getMappedElement((ElementSymbol)elementSyb));
                continue;
            }
            valuesList.add((ElementSymbol)exp);
        }
    }

    public void visit(Function obj) {
        int argLength = obj.getArgs().length;
        Expression[] args = new Expression[argLength];
        for (int i = 0; i < argLength; ++i) {
            Expression exp = obj.getArg(i);
            args[i] = exp instanceof ElementSymbol ? this.getMappedElement((ElementSymbol)exp) : exp;
        }
        obj.setArgs(args);
    }

    public void visit(AggregateSymbol obj) {
        Expression e = obj.getExpression();
        if (e instanceof ElementSymbol) {
            obj.setExpression(this.getMappedElement((ElementSymbol)e));
        }
    }

    public void visit(AliasSymbol obj) {
        SingleElementSymbol oldSymbol = obj.getSymbol();
        if (oldSymbol != null && oldSymbol instanceof ElementSymbol) {
            obj.setSymbol(this.getMappedElement((ElementSymbol)oldSymbol));
        }
    }

    public void visit(AllInGroupSymbol obj) {
        Symbol mappedSymbol;
        String newGroupName = null;
        List oldSymbols = obj.getElementSymbols();
        if (oldSymbols != null && oldSymbols.size() > 0) {
            ArrayList<Symbol> newSymbols = new ArrayList<Symbol>(oldSymbols.size());
            Iterator iter = oldSymbols.iterator();
            while (iter.hasNext()) {
                GroupSymbol newGroup;
                ElementSymbol es = (ElementSymbol)iter.next();
                mappedSymbol = this.getMappedElement(es);
                if (newGroupName == null && mappedSymbol != null && (newGroup = ((ElementSymbol)mappedSymbol).getGroupSymbol()) != null) {
                    newGroupName = newGroup.getName();
                }
                newSymbols.add(mappedSymbol);
            }
            obj.setElementSymbols(newSymbols);
        }
        if (newGroupName == null) {
            String symbolName = obj.getName();
            String oldGroupName = symbolName.substring(0, symbolName.length() - 2);
            GroupSymbol fakeSymbol = new GroupSymbol(oldGroupName);
            mappedSymbol = this.getMappedGroup(fakeSymbol);
            newGroupName = mappedSymbol.getName();
        }
        obj.setName(newGroupName + ".*");
    }

    public void visit(AllSymbol obj) {
        List oldSymbols = obj.getElementSymbols();
        if (oldSymbols != null && oldSymbols.size() > 0) {
            ArrayList<ElementSymbol> newSymbols = new ArrayList<ElementSymbol>(oldSymbols.size());
            Iterator iter = oldSymbols.iterator();
            while (iter.hasNext()) {
                ElementSymbol es = (ElementSymbol)iter.next();
                newSymbols.add(this.getMappedElement(es));
            }
            obj.setElementSymbols(newSymbols);
        }
    }

    public void visit(GroupBy obj) {
        List oldSymbols = obj.getSymbols();
        ArrayList<ElementSymbol> newSymbols = new ArrayList<ElementSymbol>(oldSymbols.size());
        Iterator symbolIter = oldSymbols.iterator();
        while (symbolIter.hasNext()) {
            Object symbol = symbolIter.next();
            if (symbol instanceof ElementSymbol) {
                newSymbols.add(this.getMappedElement((ElementSymbol)symbol));
                continue;
            }
            newSymbols.add((ElementSymbol)symbol);
        }
        obj.replaceSymbols(newSymbols);
    }

    public void visit(OrderBy obj) {
        List oldSymbols = obj.getVariables();
        ArrayList<ElementSymbol> newSymbols = new ArrayList<ElementSymbol>(oldSymbols.size());
        Iterator symbolIter = oldSymbols.iterator();
        while (symbolIter.hasNext()) {
            Object symbol = symbolIter.next();
            if (symbol instanceof ElementSymbol) {
                newSymbols.add(this.getMappedElement((ElementSymbol)symbol));
                continue;
            }
            newSymbols.add((ElementSymbol)symbol);
        }
        obj.replaceVariables(newSymbols);
    }

    public void visit(SearchedCaseExpression obj) {
        int whenCount = obj.getWhenCount();
        ArrayList<Expression> thens = new ArrayList<Expression>(whenCount);
        Expression then = null;
        for (int i = 0; i < whenCount; ++i) {
            then = obj.getThenExpression(i);
            if (then instanceof ElementSymbol) {
                then = this.getMappedElement((ElementSymbol)then);
            }
            thens.add(then);
        }
        obj.setWhen(obj.getWhen(), thens);
        if (obj.getElseExpression() instanceof ElementSymbol) {
            obj.setElseExpression(this.getMappedElement((ElementSymbol)obj.getElseExpression()));
        }
    }

    public void visit(Select obj) {
        List oldSymbols = obj.getSymbols();
        ArrayList<ElementSymbol> newSymbols = new ArrayList<ElementSymbol>(oldSymbols.size());
        Iterator symbolIter = oldSymbols.iterator();
        while (symbolIter.hasNext()) {
            Object symbol = symbolIter.next();
            if (symbol instanceof ElementSymbol) {
                newSymbols.add(this.getMappedElement((ElementSymbol)symbol));
                continue;
            }
            newSymbols.add((ElementSymbol)symbol);
        }
        obj.clearSymbols();
        obj.addSymbols(newSymbols);
    }

    public void visit(UnaryFromClause obj) {
        GroupSymbol srcGroup = obj.getGroup();
        obj.setGroup(this.getMappedGroup(srcGroup));
    }

    public void visit(StoredProcedure obj) {
        String execName = obj.getProcedureName();
        GroupSymbol fakeGroup = new GroupSymbol(execName);
        Object procedureID = obj.getProcedureID();
        if (procedureID != null) {
            fakeGroup.setMetadataID(procedureID);
        }
        GroupSymbol mappedGroup = this.getMappedGroup(fakeGroup);
        obj.setProcedureName(mappedGroup.getName());
        List params = obj.getParameters();
        Iterator paramIter = params.iterator();
        while (paramIter.hasNext()) {
            SPParameter param = (SPParameter)paramIter.next();
            Expression expr = param.getExpression();
            if (expr == null || !(expr instanceof ElementSymbol)) continue;
            expr = this.getMappedElement((ElementSymbol)expr);
            param.setExpression(expr);
        }
    }

    public void visit(SubqueryCompareCriteria obj) {
        Expression leftExp = obj.getLeftExpression();
        if (leftExp instanceof ElementSymbol) {
            leftExp = this.getMappedElement((ElementSymbol)leftExp);
            obj.setLeftExpression(leftExp);
        }
    }

    public void visit(SubquerySetCriteria obj) {
        Expression expr = obj.getExpression();
        if (expr instanceof ElementSymbol) {
            expr = this.getMappedElement((ElementSymbol)expr);
            obj.setExpression(expr);
        }
    }

    public void visit(CriteriaSelector obj) {
        CriteriaSelector selector = obj;
        if (selector.hasElements()) {
            List elements = selector.getElements();
            ArrayList<ElementSymbol> mappedElements = new ArrayList<ElementSymbol>(elements.size());
            Iterator elemIter = elements.iterator();
            while (elemIter.hasNext()) {
                ElementSymbol elem = (ElementSymbol)elemIter.next();
                mappedElements.add(this.getMappedElement(elem));
            }
            selector.setElements(mappedElements);
        }
    }

    private ElementSymbol getMappedElement(ElementSymbol obj) {
        ElementSymbol element = (ElementSymbol)this.getMappedSymbol(obj);
        if (element != null) {
            return element;
        }
        this.markUnmapped(obj);
        return obj;
    }

    private GroupSymbol getMappedGroup(GroupSymbol obj) {
        GroupSymbol group = (GroupSymbol)this.getMappedSymbol(obj);
        if (group != null) {
            return group;
        }
        this.markUnmapped(obj);
        return obj;
    }

    private void markUnmapped(Symbol symbol) {
        if (this.unmappedSymbols == null) {
            this.unmappedSymbols = new ArrayList();
        }
        this.unmappedSymbols.add(symbol);
    }

    public List getUnmappedSymbols() {
        return this.unmappedSymbols;
    }
}

