/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.util;

public class SqlUtil {
    private SqlUtil() {
    }

    public static boolean isUpdateSql(String sql) throws IllegalArgumentException {
        if (sql != null && sql.length() > 0) {
            int length = sql.length();
            for (int i = 0; i < length; ++i) {
                char c = sql.charAt(i);
                if (Character.isWhitespace(c)) continue;
                if (c == 'i' || c == 'I' || c == 'u' || c == 'U' || c == 'd' || c == 'D') {
                    if (i + 6 > length) {
                        return false;
                    }
                    String word = sql.substring(i, i + 6);
                    return word.equalsIgnoreCase("insert") || word.equalsIgnoreCase("update") || word.equalsIgnoreCase("delete");
                }
                if (c == 's' || c == 'S') {
                    if (i + 6 > length) {
                        return false;
                    }
                    String word = sql.substring(i, i + 6);
                    if (word.equalsIgnoreCase("select")) {
                        String upperCaseSql = sql.toUpperCase();
                        int intoIndex = upperCaseSql.indexOf(" INTO ", i);
                        if (intoIndex == -1) {
                            return false;
                        }
                        int fromIndex = upperCaseSql.indexOf(" FROM ", intoIndex);
                        if (fromIndex == -1 || fromIndex > intoIndex) {
                            return true;
                        }
                    }
                    return false;
                }
                return false;
            }
        }
        throw new IllegalArgumentException();
    }
}

