/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.internal.datamgr;

import com.metamatrix.data.api.ConnectorCapabilities;
import com.metamatrix.query.optimizer.capabilities.BasicSourceCapabilities;
import com.metamatrix.query.optimizer.capabilities.SourceCapabilities;
import java.util.List;

public class CapabilitiesConverter {
    private CapabilitiesConverter() {
    }

    public static SourceCapabilities convertCapabilities(ConnectorCapabilities srcCaps) {
        return CapabilitiesConverter.convertCapabilities(srcCaps, null);
    }

    public static SourceCapabilities convertCapabilities(ConnectorCapabilities srcCaps, String connectorID) {
        BasicSourceCapabilities tgtCaps = new BasicSourceCapabilities();
        int scopeValue = srcCaps.getCapabilitiesScope();
        switch (scopeValue) {
            case 0: {
                tgtCaps.setScope("GLOBAL");
                break;
            }
            case 1: {
                tgtCaps.setScope("PERUSER");
            }
        }
        tgtCaps.setCapabilitySupport("QUERY.SELECT.DISTINCT", srcCaps.supportsSelectDistinct());
        tgtCaps.setCapabilitySupport("QUERY.SELECT.LITERALS", srcCaps.supportsSelectLiterals());
        tgtCaps.setCapabilitySupport("QUERY.FROM.JOIN.ALIAS", srcCaps.supportsAliasedGroup());
        tgtCaps.setCapabilitySupport("QUERY.FROM.JOIN", srcCaps.supportsJoins());
        tgtCaps.setCapabilitySupport("QUERY.FROM.JOIN.SELFJOIN", srcCaps.supportsSelfJoins());
        tgtCaps.setCapabilitySupport("QUERY.FROM.JOIN.OUTER", srcCaps.supportsOuterJoins());
        tgtCaps.setCapabilitySupport("QUERY.FROM.JOIN.OUTER.FULL", srcCaps.supportsFullOuterJoins());
        tgtCaps.setCapabilitySupport("QUERY.FROM.INLINE.VIEWS", srcCaps.supportsInlineViews());
        tgtCaps.setCapabilitySupport("QUERY.FROM.INLINE.VIEWS.ORDERBY", srcCaps.supportsOrderByInInlineViews());
        tgtCaps.setCapabilitySupport("QUERY.WHERE", srcCaps.supportsCriteria());
        tgtCaps.setCapabilitySupport("QUERY.WHERE.BETWEEN", srcCaps.supportsBetweenCriteria());
        tgtCaps.setCapabilitySupport("QUERY.WHERE.COMPARE", srcCaps.supportsCompareCriteria());
        tgtCaps.setCapabilitySupport("QUERY.WHERE.COMPARE.EQ", srcCaps.supportsCompareCriteriaEquals());
        tgtCaps.setCapabilitySupport("QUERY.WHERE.COMPARE.NE", srcCaps.supportsCompareCriteriaNotEquals());
        tgtCaps.setCapabilitySupport("QUERY.WHERE.COMPARE.LT", srcCaps.supportsCompareCriteriaLessThan());
        tgtCaps.setCapabilitySupport("QUERY.WHERE.COMPARE.LE", srcCaps.supportsCompareCriteriaLessThanOrEqual());
        tgtCaps.setCapabilitySupport("QUERY.WHERE.COMPARE.GT", srcCaps.supportsCompareCriteriaGreaterThan());
        tgtCaps.setCapabilitySupport("QUERY.WHERE.COMPARE.GE", srcCaps.supportsCompareCriteriaGreaterThanOrEqual());
        tgtCaps.setCapabilitySupport("QUERY.WHERE.LIKE", srcCaps.supportsLikeCriteria());
        tgtCaps.setCapabilitySupport("QUERY.WHERE.LIKE.ESCAPE", srcCaps.supportsLikeCriteriaEscapeCharacter());
        tgtCaps.setCapabilitySupport("QUERY.WHERE.IN", srcCaps.supportsInCriteria());
        tgtCaps.setCapabilitySupport("QUERY.WHERE.IN.SUBQUERY", srcCaps.supportsInCriteriaSubquery());
        tgtCaps.setCapabilitySupport("QUERY.WHERE.ISNULL", srcCaps.supportsIsNullCriteria());
        tgtCaps.setCapabilitySupport("QUERY.WHERE.AND", srcCaps.supportsAndCriteria());
        tgtCaps.setCapabilitySupport("QUERY.WHERE.OR", srcCaps.supportsOrCriteria());
        tgtCaps.setCapabilitySupport("QUERY.WHERE.NOT", srcCaps.supportsNotCriteria());
        tgtCaps.setCapabilitySupport("QUERY.WHERE.QUANT.EXISTS", srcCaps.supportsExistsCriteria());
        tgtCaps.setCapabilitySupport("QUERY.WHERE.QUANT.COMPARE", srcCaps.supportsQuantifiedCompareCriteria());
        tgtCaps.setCapabilitySupport("QUERY.WHERE.QUANT.SOME", srcCaps.supportsQuantifiedCompareCriteriaSome());
        tgtCaps.setCapabilitySupport("QUERY.WHERE.QUANT.ALL", srcCaps.supportsQuantifiedCompareCriteriaAll());
        tgtCaps.setCapabilitySupport("QUERY.ORDERBY", srcCaps.supportsOrderBy());
        tgtCaps.setCapabilitySupport("QUERY.AGGREGATES", srcCaps.supportsAggregates());
        tgtCaps.setCapabilitySupport("QUERY.AGGREGATES.SUM", srcCaps.supportsAggregatesSum());
        tgtCaps.setCapabilitySupport("QUERY.AGGREGATES.AVG", srcCaps.supportsAggregatesAvg());
        tgtCaps.setCapabilitySupport("QUERY.AGGREGATES.MIN", srcCaps.supportsAggregatesMin());
        tgtCaps.setCapabilitySupport("QUERY.AGGREGATES.MAX", srcCaps.supportsAggregatesMax());
        tgtCaps.setCapabilitySupport("QUERY.AGGREGATES.COUNT", srcCaps.supportsAggregatesCount());
        tgtCaps.setCapabilitySupport("QUERY.AGGREGATES.COUNT.STAR", srcCaps.supportsAggregatesCountStar());
        tgtCaps.setCapabilitySupport("QUERY.AGGREGATES.DISTINCT", srcCaps.supportsAggregatesDistinct());
        tgtCaps.setCapabilitySupport("QUERY.SUBQUERIES.SCALAR", srcCaps.supportsScalarSubqueries());
        tgtCaps.setCapabilitySupport("QUERY.SUBQUERIES.CORRELATED", srcCaps.supportsCorrelatedSubqueries());
        tgtCaps.setCapabilitySupport("QUERY.CASE", srcCaps.supportsCaseExpressions());
        tgtCaps.setCapabilitySupport("QUERY.SEARCHED.CASE", srcCaps.supportsSearchedCaseExpressions());
        tgtCaps.setCapabilitySupport("QUERY.UNION", srcCaps.supportsUnions());
        tgtCaps.setCapabilitySupport("QUERY.UNION.ORDERBY", srcCaps.supportsUnionOrderBy());
        tgtCaps.setCapabilitySupport("BULK.INSERT", srcCaps.supportsExecutionMode(4));
        tgtCaps.setCapabilitySupport("UPDATE.BATCHED", srcCaps.supportsExecutionMode(3));
        tgtCaps.setCapabilitySupport("FUNCTION", srcCaps.supportsScalarFunctions());
        tgtCaps.setCapabilitySupport("QUERY.GROUPBY.FUNCTIONS", srcCaps.supportsFunctionsInGroupBy());
        tgtCaps.setCapabilitySupport("ROWLIMIT", srcCaps.supportsRowLimit());
        tgtCaps.setCapabilitySupport("ROWOFFSET", srcCaps.supportsRowOffset());
        tgtCaps.setCapabilitySupport("SUPPORTXATRANSACTION", srcCaps.supportsXATransactions());
        List functions = srcCaps.getSupportedFunctions();
        if (functions != null && functions.size() > 0) {
            for (String func : functions) {
                tgtCaps.setFunctionSupport(func.toLowerCase(), true);
            }
        }
        tgtCaps.setSourceProperty("MAX.IN.CRITERIA.SIZE", (Object)new Integer(srcCaps.getMaxInCriteriaSize()));
        tgtCaps.setSourceProperty("CONNECTOR_ID", (Object)connectorID);
        if (!srcCaps.supportsInCriteria() && srcCaps.supportsCompareCriteria() && srcCaps.supportsCompareCriteriaEquals()) {
            tgtCaps.setCapabilitySupport("QUERY.WHERE.IN", true);
            tgtCaps.setSourceProperty("MAX.IN.CRITERIA.SIZE", (Object)new Integer(1));
        }
        return tgtCaps;
    }
}

