/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;

public class UtilDataConversions {
    private static String footprint = "$Revision:   3.1.1.0  $";
    private static final char[] Digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static byte[] CharsToBytes(String string, char[] cArray) throws UnsupportedEncodingException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)byteArrayOutputStream, string);
        BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
        byte[] byArray = null;
        try {
            bufferedWriter.write(cArray, 0, cArray.length);
            bufferedWriter.flush();
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new UnsupportedEncodingException(iOException.getMessage());
        }
        return byArray;
    }

    public static String BytesToChars(String string, byte[] byArray) throws UnsupportedEncodingException {
        Object object;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)byteArrayInputStream, string);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        while (bl) {
            object = new char[300];
            try {
                int n = bufferedReader.read((char[])object, 0, ((char[])object).length);
                if (n > 0) {
                    stringBuffer.append((char[])object, 0, n);
                    continue;
                }
                bl = false;
            }
            catch (IOException iOException) {
                throw new UnsupportedEncodingException(iOException.getMessage());
            }
        }
        object = stringBuffer.toString();
        return object;
    }

    public static String ASCIIBytesToString(byte[] byArray, int n) {
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            cArray[i] = (char)(byArray[i] & 0xFF);
        }
        return new String(cArray);
    }

    public static String UCS2BytesToString(byte[] byArray, int n) {
        char[] cArray = new char[n / 2];
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            cArray[n3] = (char)((byArray[n2] & 0xFF) << 8 | byArray[n2 + 1] & 0xFF);
            n2 += 2;
            ++n3;
        }
        return new String(cArray);
    }

    public static String bytesToString(byte[] byArray, int n) {
        StringBuffer stringBuffer = new StringBuffer(n * 2);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(Digits[byArray[i] >> 4 & 0xF]);
            stringBuffer.append(Digits[byArray[i] & 0xF]);
        }
        return stringBuffer.toString();
    }

    public static final String byteToHex(byte by) {
        char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        char[] cArray2 = new char[]{cArray[by >> 4 & 0xF], cArray[by & 0xF]};
        return new String(cArray2);
    }

    public static final InputStream stringToASCIIInputStream(String string) {
        ByteArrayInputStream byteArrayInputStream = null;
        if (string != null) {
            char[] cArray = string.toCharArray();
            byte[] byArray = new byte[cArray.length];
            for (int i = 0; i < cArray.length; ++i) {
                byArray[i] = (byte)cArray[i];
            }
            byteArrayInputStream = new ByteArrayInputStream(byArray);
        }
        return byteArrayInputStream;
    }

    public static char[] AsciiByteArrayToUCS2CharArray(byte[] byArray, int n, int n2) {
        char[] cArray = new char[n2];
        for (int i = 0; i < n2; ++i) {
            cArray[i] = (char)(byArray[n++] & 0xFF);
        }
        return cArray;
    }

    public static void AsciiByteArrayToUCS2CharArray(byte[] byArray, int n, char[] cArray, int n2, int n3) {
        while (n3-- > 0) {
            cArray[n2++] = (char)(byArray[n++] & 0xFF);
        }
    }

    public static byte[] UCS2CharArrayToByteArray(char[] cArray, int n, int n2) {
        byte[] byArray = new byte[n2 * 2];
        int n3 = 0;
        while (n2-- > 0) {
            byArray[n3++] = (byte)(cArray[n] >> 8);
            byArray[n3++] = (byte)cArray[n];
            ++n;
        }
        return byArray;
    }

    public static byte[] UCS2CharArrayToLittleEndianByteArray(char[] cArray, int n, int n2) {
        byte[] byArray = new byte[n2 * 2];
        int n3 = 0;
        while (n2-- > 0) {
            byArray[n3++] = (byte)cArray[n];
            byArray[n3++] = (byte)(cArray[n] >> 8);
            ++n;
        }
        return byArray;
    }

    public static void UCS2CharArrayToAsciiByteArray(char[] cArray, int n, byte[] byArray, int n2, int n3) {
        while (n3-- > 0) {
            byArray[n2++] = (byte)cArray[n++];
        }
    }

    public static void ByteArrayToUCS2CharArray(byte[] byArray, int n, char[] cArray, int n2, int n3) {
        int n4 = n3 / 2;
        while (n4-- > 0) {
            cArray[n2++] = (char)((byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF);
        }
    }

    public static void LittleEndianByteArrayToUCS2CharArray(byte[] byArray, int n, char[] cArray, int n2, int n3) {
        int n4 = n3 / 2;
        while (n4-- > 0) {
            cArray[n2++] = (char)((byArray[n + 1] & 0xFF) << 8 | byArray[n] & 0xFF);
            n += 2;
        }
    }
}

