/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.oracle;

import com.metamatrix.jdbc.base.BaseData;
import com.metamatrix.jdbc.base.BaseImplBlob;
import com.metamatrix.jdbc.base.BaseImplClob;
import com.metamatrix.jdbc.base.BaseImplResultSet;
import com.metamatrix.jdbc.oracle.OracleColumn;
import com.metamatrix.jdbc.oracle.OracleConnection;
import com.metamatrix.jdbc.oracle.OracleImplBlob;
import com.metamatrix.jdbc.oracle.OracleImplClob;
import com.metamatrix.jdbc.oracle.OracleImplConnection;
import com.metamatrix.jdbc.oracle.OracleImplStatement;
import com.metamatrix.jdbc.oracle.OracleVNU;
import com.metamatrix.util.UtilException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.math.BigDecimal;
import java.sql.SQLException;

public class OracleImplResultset
extends BaseImplResultSet {
    private static String footprint = "$Revision:   3.56.1.2  $";
    private static int[] powersOfTen = new int[]{0, 0, 1, 10, 100, 1000, 10000, 100000, 1000000, 10000000, 100000000, 100000000, 1000000000};
    private short ResultSetsOraCid = 0;
    private int RSIndex;
    private BaseData reusablebasedata;
    private char[] valueAsString = null;
    private long NUM_NANOSECONDS_IN_SECOND = 1000000000L;
    private double NUM_NANOSECONDS_IN_DAY = 86400L * this.NUM_NANOSECONDS_IN_SECOND;
    public OracleConnection connection;
    private boolean isJavaDoubleToString;
    private boolean codepageOverrideNoConvert;
    private char[] valueAsChars = null;
    public int m_fetchSizeSetting = 0;
    static final byte[] urowid_indbyte_char = new byte[]{65, 42, 45, 40, 41};
    static final byte[] urowid_basis_64 = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
    static final byte[] urowid_index_64 = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, -1, -1, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, -1, -1, -1, -1, -1};

    public int getColumnAccess() {
        return 2;
    }

    public OracleImplResultset(OracleConnection oracleConnection) {
        this.reusablebasedata = new BaseData(oracleConnection);
        this.isJavaDoubleToString = oracleConnection.getIsJavaDoubleToString();
        this.codepageOverrideNoConvert = oracleConnection.oic.codepageOverrideNoConvert;
    }

    public void reset() {
        super.reset();
    }

    public void initialize(short s, int n) {
        this.RSIndex = n;
        this.ResultSetsOraCid = s;
    }

    protected boolean setupForNextResultSetInMultipleResult(int n) throws SQLException {
        return true;
    }

    public void writeBlob(RandomAccessFile randomAccessFile, BaseImplBlob baseImplBlob) throws SQLException, IOException {
        randomAccessFile.writeInt(((OracleImplBlob)baseImplBlob).bloblocator.length);
        randomAccessFile.write(((OracleImplBlob)baseImplBlob).bloblocator);
        randomAccessFile.writeBoolean(((OracleImplBlob)baseImplBlob).CheckIsBFILE());
    }

    public BaseImplBlob readBlob(RandomAccessFile randomAccessFile) throws SQLException, IOException {
        int n = randomAccessFile.readInt();
        byte[] byArray = new byte[n];
        randomAccessFile.read(byArray);
        return new OracleImplBlob(byArray, (OracleImplStatement)this.implStatement, randomAccessFile.readBoolean());
    }

    public void writeClob(RandomAccessFile randomAccessFile, BaseImplClob baseImplClob) throws SQLException, IOException {
        randomAccessFile.writeInt(((OracleImplClob)baseImplClob).cloblocator.length);
        randomAccessFile.write(((OracleImplClob)baseImplClob).cloblocator);
    }

    public BaseImplClob readClob(RandomAccessFile randomAccessFile) throws SQLException, IOException {
        int n = randomAccessFile.readInt();
        byte[] byArray = new byte[n];
        randomAccessFile.read(byArray);
        int n2 = ((byArray[32] & 0xFF) << 8) + (byArray[33] & 0xFF);
        return new OracleImplClob(byArray, (OracleImplStatement)this.implStatement, n2);
    }

    public BaseData getData(int n, int n2) throws SQLException {
        OracleImplStatement oracleImplStatement = (OracleImplStatement)this.implStatement;
        OracleColumn oracleColumn = (OracleColumn)oracleImplStatement.CurrentRSDescriptions[this.RSIndex][n - 1];
        if (!oracleColumn.isSupportedColumnType) {
            throw ((OracleImplStatement)this.implStatement).comm.exceptions.getException(7051);
        }
        if (oracleColumn.indicator != 0) {
            if (oracleImplStatement.databaseMetaDataResultSet != 0) {
                if (n == 1 && (oracleImplStatement.databaseMetaDataResultSet == 1 || oracleImplStatement.databaseMetaDataResultSet == 2 || oracleImplStatement.databaseMetaDataResultSet == 5 || oracleImplStatement.databaseMetaDataResultSet == 6 || oracleImplStatement.databaseMetaDataResultSet == 16 || oracleImplStatement.databaseMetaDataResultSet == 9 || oracleImplStatement.databaseMetaDataResultSet == 14 || oracleImplStatement.databaseMetaDataResultSet == 12 || oracleImplStatement.databaseMetaDataResultSet == 11 || oracleImplStatement.databaseMetaDataResultSet == 10 || oracleImplStatement.databaseMetaDataResultSet == 8 || oracleImplStatement.databaseMetaDataResultSet == 13)) {
                    this.reusablebasedata.setString("");
                    return this.reusablebasedata;
                }
                if (n == 5 && (oracleImplStatement.databaseMetaDataResultSet == 12 || oracleImplStatement.databaseMetaDataResultSet == 11 || oracleImplStatement.databaseMetaDataResultSet == 10)) {
                    this.reusablebasedata.setString("");
                    return this.reusablebasedata;
                }
            }
            switch (oracleColumn.OCINativeType) {
                case 12: {
                    this.reusablebasedata.setNull(108);
                    break;
                }
                case 180: {
                    this.reusablebasedata.setNull(109);
                    break;
                }
                case 181: {
                    this.reusablebasedata.setNull(110);
                    break;
                }
                case 231: {
                    this.reusablebasedata.setNull(111);
                    break;
                }
                default: {
                    this.reusablebasedata.setNull(n2);
                }
            }
            return this.reusablebasedata;
        }
        if (n == 5 && oracleImplStatement.databaseMetaDataResultSet == 2) {
            long l = OracleVNU.convertVNUToLong(oracleColumn.data, oracleColumn.len, this.exceptions);
            if (l == 1111L) {
                OracleColumn oracleColumn2 = (OracleColumn)oracleImplStatement.CurrentRSDescriptions[this.RSIndex][5];
                String string = null;
                try {
                    string = oracleColumn2.transliterator.decode(oracleColumn2.data, 0, oracleColumn2.len);
                }
                catch (UtilException utilException) {
                    throw ((OracleImplStatement)this.implStatement).comm.exceptions.getException(utilException);
                }
                if (string.indexOf("TIMESTAMP") != -1) {
                    if (string.indexOf("TIME ZONE") != -1 && string.indexOf("LOCAL") == -1) {
                        boolean bl = ((OracleImplConnection)this.implStatement.implConnection).FetchTSWTZasTimestamp;
                        if (bl) {
                            this.reusablebasedata.setLong(93L);
                        } else {
                            this.reusablebasedata.setLong(12L);
                        }
                    } else {
                        this.reusablebasedata.setLong(93L);
                    }
                } else {
                    this.reusablebasedata.setLong(l);
                }
            } else {
                this.reusablebasedata.setLong(l);
            }
            return this.reusablebasedata;
        }
        if (n == 6 && oracleImplStatement.databaseMetaDataResultSet == 2) {
            OracleColumn oracleColumn3 = (OracleColumn)oracleImplStatement.CurrentRSDescriptions[this.RSIndex][5];
            String string = null;
            try {
                string = oracleColumn3.transliterator.decode(oracleColumn3.data, 0, oracleColumn3.len);
            }
            catch (UtilException utilException) {
                throw ((OracleImplStatement)this.implStatement).comm.exceptions.getException(utilException);
            }
            if (string.indexOf("TIMESTAMP") != -1) {
                int n3 = string.indexOf("(");
                if (n3 != -1) {
                    StringBuffer stringBuffer = new StringBuffer(string);
                    int n4 = string.indexOf(")");
                    stringBuffer.delete(n3, n4 + 1);
                    this.reusablebasedata.setString(stringBuffer.toString());
                } else {
                    this.reusablebasedata.setString(string);
                }
            } else {
                this.reusablebasedata.setString(string);
            }
            return this.reusablebasedata;
        }
        int n5 = 0;
        block10 : switch (oracleColumn.OCINativeType) {
            case 2: 
            case 6: {
                switch (n2) {
                    case 8: {
                        n5 = oracleColumn.scale;
                        if (oracleColumn.type == 8) {
                            n5 = -1;
                        } else if (oracleColumn.precision == 38 && oracleColumn.scale == 127 && ((OracleImplConnection)this.implStatement.implConnection).getNumberPrecisionScaleOption() == 1) {
                            n5 = 0;
                        }
                        this.reusablebasedata.setBigDecimal(OracleVNU.convertVNUToBigDecimal(oracleColumn.data, 0, oracleColumn.len, n5, (OracleImplConnection)this.implStatement.implConnection));
                        break block10;
                    }
                    case 1: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 9: {
                        this.reusablebasedata.setLong(OracleVNU.convertVNUToLong(oracleColumn.data, oracleColumn.len, this.exceptions));
                        break block10;
                    }
                    case 6: 
                    case 7: {
                        this.reusablebasedata.setDouble(OracleVNU.convertVNUToDouble(oracleColumn.data, oracleColumn.len));
                        break block10;
                    }
                }
                if (oracleColumn.type == 8 || oracleColumn.type == 6) {
                    if (this.isJavaDoubleToString) {
                        this.reusablebasedata.setString(Double.toString(OracleVNU.convertVNUToDouble(oracleColumn.data, oracleColumn.len)));
                        break;
                    }
                    this.reusablebasedata.setString(OracleVNU.convertVNUToIEEEString(oracleColumn.data, 0, oracleColumn.len, (OracleImplConnection)this.implStatement.implConnection));
                    break;
                }
                n5 = oracleColumn.scale;
                if (oracleColumn.precision == 38 && oracleColumn.scale == 127 && ((OracleImplConnection)this.implStatement.implConnection).getNumberPrecisionScaleOption() == 1) {
                    n5 = 0;
                }
                this.reusablebasedata.setString(OracleVNU.convertVNUToString(oracleColumn.data, 0, oracleColumn.len, n5, (OracleImplConnection)this.implStatement.implConnection));
                break;
            }
            case 208: {
                this.reusablebasedata.setString(OracleImplResultset.uRowidToString(oracleColumn.data, oracleColumn.len));
                break;
            }
            case 1: 
            case 11: 
            case 96: 
            case 104: {
                try {
                    this.reusablebasedata.setString(oracleColumn.transliterator.decode(oracleColumn.data, 0, oracleColumn.len));
                    break;
                }
                catch (UtilException utilException) {
                    throw ((OracleImplStatement)this.implStatement).comm.exceptions.getException(utilException);
                }
            }
            case 8: {
                try {
                    this.reusablebasedata.setCharacterStreamReader(oracleColumn.transliterator.decodeAsReader(new ByteArrayInputStream(oracleColumn.data, 0, oracleColumn.len)));
                    break;
                }
                catch (UtilException utilException) {
                    throw ((OracleImplStatement)this.implStatement).comm.exceptions.getException(utilException);
                }
            }
            case 12: {
                this.reusablebasedata.setNativeBytes(oracleColumn.data, oracleColumn.len, 108);
                break;
            }
            case 180: {
                this.reusablebasedata.setNativeBytes(oracleColumn.data, oracleColumn.len, 109);
                break;
            }
            case 231: {
                this.reusablebasedata.setNativeOracleTimestampWithLocalTimeZone(oracleColumn.data, oracleColumn.len, ((OracleImplConnection)this.implStatement.implConnection).getTimeZoneHours(), ((OracleImplConnection)this.implStatement.implConnection).getTimeZoneMinutes());
                break;
            }
            case 181: {
                boolean bl = ((OracleImplConnection)this.implStatement.implConnection).FetchTSWTZasTimestamp;
                n5 = oracleColumn.precision - 20 - (bl ? 0 : 7);
                if (n5 < 0) {
                    n5 = 0;
                }
                this.reusablebasedata.setNativeOracleTimestampWithTimeZone(oracleColumn.data, oracleColumn.len, n5, bl);
                break;
            }
            case 23: {
                byte[] byArray = new byte[oracleColumn.len];
                System.arraycopy(oracleColumn.data, 0, byArray, 0, oracleColumn.len);
                this.reusablebasedata.setBytes(byArray);
                break;
            }
            case 24: {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(oracleColumn.data, 0, oracleColumn.len);
                this.reusablebasedata.setBinaryStream(byteArrayInputStream);
                break;
            }
            case 112: {
                if (oracleColumn.charSetId == 0) {
                    oracleColumn.charSetId = oracleColumn.charSetForm == 1 ? (int)((OracleImplConnection)this.implStatement.implConnection).originalReportedOraCharset : (int)((OracleImplConnection)this.implStatement.implConnection).originalReportedOraNCharset;
                }
                OracleImplClob oracleImplClob = new OracleImplClob(oracleColumn.data, oracleImplStatement, oracleColumn.charSetId);
                if (this.codepageOverrideNoConvert) {
                    int n6 = (int)oracleImplClob.getLength() * oracleColumn.transliterator.getMaxBytesPerChar();
                    if (this.valueAsChars == null || this.valueAsChars.length < n6) {
                        this.valueAsChars = new char[n6];
                    }
                    int n7 = oracleImplClob.readData(this.valueAsChars, 0, 1L, (int)oracleImplClob.getLength());
                    this.reusablebasedata.setString(new String(this.valueAsChars, 0, n7));
                    break;
                }
                this.reusablebasedata.setClob(oracleImplClob);
                break;
            }
            case 109: {
                if (oracleColumn.charSetId == 0) {
                    oracleColumn.charSetId = oracleColumn.charSetForm == 1 ? (int)((OracleImplConnection)this.implStatement.implConnection).originalReportedOraCharset : (int)((OracleImplConnection)this.implStatement.implConnection).originalReportedOraNCharset;
                }
                this.reusablebasedata.setClob(new OracleImplClob(oracleColumn.data, oracleImplStatement, ((OracleImplConnection)this.implStatement.implConnection).currentOraCharset));
                break;
            }
            case 113: {
                this.reusablebasedata.setBlob(new OracleImplBlob(oracleColumn.data, oracleImplStatement));
                break;
            }
            case 114: {
                this.reusablebasedata.setBlob(new OracleImplBlob(oracleColumn.data, oracleImplStatement, true));
                break;
            }
            case 100: {
                int n8 = oracleColumn.data[0];
                int n9 = oracleColumn.data[1];
                int n10 = oracleColumn.data[2];
                int n11 = oracleColumn.data[3];
                if ((n8 & 0x80) != 0) {
                    n8 &= 0x7F;
                    n9 &= 0xFF;
                    n10 &= 0xFF;
                    n11 &= 0xFF;
                } else {
                    n8 = ~n8 & 0xFF;
                    n9 = ~n9 & 0xFF;
                    n10 = ~n10 & 0xFF;
                    n11 = ~n11 & 0xFF;
                }
                int n12 = n8 << 24 | n9 << 16 | n10 << 8 | n11;
                this.reusablebasedata.setFloat(Float.intBitsToFloat(n12));
                break;
            }
            case 101: {
                int n13 = oracleColumn.data[0];
                int n14 = oracleColumn.data[1];
                int n15 = oracleColumn.data[2];
                int n16 = oracleColumn.data[3];
                int n17 = oracleColumn.data[4];
                int n18 = oracleColumn.data[5];
                int n19 = oracleColumn.data[6];
                int n20 = oracleColumn.data[7];
                if ((n13 & 0x80) != 0) {
                    n13 &= 0x7F;
                    n14 &= 0xFF;
                    n15 &= 0xFF;
                    n16 &= 0xFF;
                    n17 &= 0xFF;
                    n18 &= 0xFF;
                    n19 &= 0xFF;
                    n20 &= 0xFF;
                } else {
                    n13 = ~n13 & 0xFF;
                    n14 = ~n14 & 0xFF;
                    n15 = ~n15 & 0xFF;
                    n16 = ~n16 & 0xFF;
                    n17 = ~n17 & 0xFF;
                    n18 = ~n18 & 0xFF;
                    n19 = ~n19 & 0xFF;
                    n20 = ~n20 & 0xFF;
                }
                int n21 = n13 << 24 | n14 << 16 | n15 << 8 | n16;
                int n22 = n17 << 24 | n18 << 16 | n19 << 8 | n20;
                long l = (long)n21 << 32 | (long)n22 & 0xFFFFFFFFL;
                this.reusablebasedata.setDouble(Double.longBitsToDouble(l));
                break;
            }
            case 183: {
                int n23 = oracleColumn.data[0] & 0xFF;
                int n24 = oracleColumn.data[1] & 0xFF;
                int n25 = oracleColumn.data[2] & 0xFF;
                int n26 = oracleColumn.data[3] & 0xFF;
                int n27 = n23 << 24 | n24 << 16 | n25 << 8 | n26;
                n27 -= Integer.MIN_VALUE;
                int n28 = oracleColumn.data[4] - 60;
                int n29 = oracleColumn.data[5] - 60;
                int n30 = oracleColumn.data[6] - 60;
                int n31 = oracleColumn.data[7] & 0xFF;
                int n32 = oracleColumn.data[8] & 0xFF;
                int n33 = oracleColumn.data[9] & 0xFF;
                int n34 = oracleColumn.data[10] & 0xFF;
                int n35 = n31 << 24 | n32 << 16 | n33 << 8 | n34;
                long l = (long)(n28 * 60 * 60) * this.NUM_NANOSECONDS_IN_SECOND + (long)(n29 * 60) * this.NUM_NANOSECONDS_IN_SECOND + (long)n30 * this.NUM_NANOSECONDS_IN_SECOND + (long)(n35 -= Integer.MIN_VALUE);
                double d = (double)l / this.NUM_NANOSECONDS_IN_DAY;
                this.reusablebasedata.setBigDecimal(new BigDecimal((double)n27 + d));
                break;
            }
            case 182: {
                throw ((OracleImplStatement)this.implStatement).comm.exceptions.getException(7042);
            }
        }
        return this.reusablebasedata;
    }

    public int getCurrentCursorPosition() {
        return this.cursorPosition;
    }

    public boolean fetchAtPosition(int n) throws SQLException {
        OracleImplStatement oracleImplStatement = (OracleImplStatement)this.implStatement;
        return oracleImplStatement.fetchNext2(false, this.RSIndex, null);
    }

    public void close() throws SQLException {
        OracleImplStatement oracleImplStatement = (OracleImplStatement)this.implStatement;
        if (this.ResultSetsOraCid != 0) {
            oracleImplStatement.closeResultset(this.ResultSetsOraCid, this.RSIndex);
            this.ResultSetsOraCid = 0;
        }
        super.close();
    }

    public void setFetchSize(int n) {
        this.m_fetchSizeSetting = n;
    }

    static final String uRowidToString(byte[] byArray, int n) throws SQLException {
        char[] cArray = new char[512];
        int n2 = 0;
        int n3 = n - 1;
        int n4 = 4 * (n / 3) + (n % 3 != 0 ? 0 : n % 3 + 1);
        if (n4 != 0) {
            cArray[n2++] = (char)urowid_indbyte_char[byArray[0] - 1];
            int n5 = 1;
            while (n3 > 0) {
                cArray[n2++] = (char)urowid_basis_64[(byArray[n5] & 0xFF) >> 2];
                if (n3 == 1) {
                    cArray[n2++] = (char)urowid_basis_64[(byArray[n5] & 3) << 4];
                    break;
                }
                byte by = (byte)(byArray[n5 + 1] & 0xFF);
                cArray[n2++] = (char)urowid_basis_64[(byArray[n5] & 3) << 4 | (by & 0xF0) >> 4];
                if (n3 == 2) {
                    cArray[n2++] = (char)urowid_basis_64[(by & 0xF) << 2];
                    break;
                }
                cArray[n2++] = (char)urowid_basis_64[(by & 0xF) << 2 | (byArray[n5 += 2] & 0xC0) >> 6];
                cArray[n2] = (char)urowid_basis_64[byArray[n5] & 0x3F];
                n3 -= 3;
                ++n5;
                ++n2;
            }
        }
        return new String(cArray, 0, n2);
    }
}

