package jboss.test;

import java.util.Set;

import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.OneToMany;

import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

/**
 * Company customer
 * 
 * @author Emmanuel Bernard
 * @author Kabir Khan
 */
@Entity
@Cache(region = "Customer", usage = CacheConcurrencyStrategy.TRANSACTIONAL)
public class Customer implements java.io.Serializable {
	Integer id;
	String name;

	private transient Set<Contact> contacts;

	public Customer() {
	}

	@Id
	public Integer getId() {
		return id;
	}

	public void setId(Integer id) {
		this.id = id;
	}

	public String getName() {
		return name;
	}

	public void setName(String string) {
		name = string;
	}

	@Cache(usage = CacheConcurrencyStrategy.TRANSACTIONAL)
	@OneToMany(mappedBy = "customer", fetch = FetchType.EAGER, cascade = CascadeType.ALL)
	public Set<Contact> getContacts() {
		return contacts;
	}

	public void setContacts(Set<Contact> contacts) {
		this.contacts = contacts;
	}
}
