/*
* JBoss, Home of Professional Open Source.
* Copyright 2012, Red Hat Middleware LLC, and individual contributors
* as indicated by the @author tags. See the copyright.txt file in the
* distribution for a full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.as.test.integration.domain.mixed;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 *
 * @author <a href="kabir.khan@jboss.com">Kabir Khan</a>
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(value=ElementType.TYPE)
public @interface Version {

    AsVersion value();

    final String AS = "jboss-as-";
    final String WILDFLY = "wildfly";
    final String EAP = "jboss-eap-";

    enum AsVersion {
        //Here we only test EAP versions
        EAP_6_0_0(EAP, "6.0.0"),
        EAP_6_0_1(EAP, "6.0.1"),
        EAP_6_1_0(EAP, "6.1.0"),
        EAP_6_1_1(EAP, "6.1.1");

        final String basename;
        final String version;

        AsVersion(String basename, String version){
            this.basename = basename;
            this.version = version;
        }

        public String getBaseName() {
            return basename;
        }

        public String getVersion() {
            return version;
        }

        public String getExpandedDirectoryName() {
            return basename + version;
        }

        public String getZipFileName() {
            return getExpandedDirectoryName() + ".zip";
        }
    }


}
