/*
* JBoss, Home of Professional Open Source
*
* Distributable under LGPL license.
* See terms of license at gnu.org.
*/
package org.jboss.seam.annotations;

import static java.lang.annotation.ElementType.METHOD;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

/**
 * Marks a method as causing a jBPM transition after 
 * the method returns a non-null result without exception.
 */
@Target(METHOD)
@Retention(RUNTIME)
@Documented
public @interface Transition {
   
   /**
    * The transition name, defaults to the name
    * of the method.
    * 
    * @return the transition name
    */
   String value() default "";
   
   //TODO: String[] ifOutcome() default {};
   
}
