Tree.Selection = Class.create();
Tree.Selection.prototype = {
	initialize: function() {
		this.indexes = [];
		this.ranges = [];
	},

	addRange: function(range) {
		this.ranges.push(range);
	},

	addIndex: function(index) {
		this.indexes.push(index);
	},

	getRanges: function() {
		var ranges = [];
		if (this.indexes.length == 0) return ranges;
		ranges.push(new DataGrid.Range(this.indexes[0], this.indexes[0]));
		var current = ranges[ranges.length - 1];
		for (var i = 1; i < this.indexes.length; i++) {
			if (this.indexes[i] - current.indexes[1] > 1) {
				ranges.push(new DataGrid.Range(this.indexes[i], this.indexes[i]));
				current = ranges[ranges.length - 1];
			} else {
				current.indexes[1] = this.indexes[i];
			}
		}
		return ranges;
	}
}

Tree.SelectionManager = Class.create();
Tree.SelectionManager.prototype = {
	initialize: function(tree) {
		this.tree = tree;

		this.eventKeyPress = this.processKeyDown.bindAsEventListener(this);
		Event.observe(document, "keypress", this.eventKeyPress);

		this.eventLostFocus = this.processLostFocus.bindAsEventListener(this);
		Event.observe(document, "click", this.eventLostFocus);

		this.eventPreventLostFocus = this.processPreventLostFocus.bindAsEventListener(this);
		Event.observe(this.tree.element, "click", this.eventPreventLostFocus);
	},

	restoreSelection: function() {
		if (this.tree.input.value && $(this.tree.input.value)) {
			this.setSelection(($(this.tree.input.value)).object);
		}		
	},
	
	processPreventLostFocus: function() {
		this.inFocus = true;
		this.preventLostFocus = true;
	},

	processLostFocus: function() {
		if (!this.preventLostFocus) {
			this.lostFocus();
		} else {
			this.preventLostFocus = false;
		}
	},

	lostFocus: function() {
		this.inFocus = false;
	},

	setSelection: function(item) {
		item.toggleSelection();
		this.activeItem = item;
	},

	processKeyDown: function(event) {
		if (!this.activeItem) return;
		if (!($(this.activeItem.id))) { 
			this.activeItem = null;
			this.tree.input.value = "";
			return;
		}
		var noDefault = false;
		var key = event.keyCode || event.charCode;
		switch (key) {
			case Event.KEY_UP:
				if (this.inFocus) {
					if (!event.ctrlKey && !event.shiftKey && !event.altKey) {
						
						var item = this.activeItem;
						do {
							var newItem = this.getPreviousItemForSelection(item);
							
							if (newItem && newItem != item) {
								item = newItem;
							
								if (item.toggleSelection(event)) {
									this.activeItem = item;
									item = null;
								}
							} else {
								item = null;
							}
						} while (item);
						 
					}
					noDefault = true;
				}
				break;
			case Event.KEY_DOWN:
				if (this.inFocus) {
					if (!event.ctrlKey && !event.shiftKey && !event.altKey) {

						var item = this.activeItem;
						do {
							var newItem = this.getNextItemForSelection(item);
							
							if (newItem && newItem != item) {
								item = newItem;
							
								if (item.toggleSelection(event)) {
									this.activeItem = item;
									item = null;
								}

							} else {
								item = null;
							}
						} while (item);

					}
					noDefault = true;
				}
				break;
			case Event.KEY_LEFT:
				if (this.inFocus) {
					if (!event.ctrlKey && !event.shiftKey && !event.altKey) {
						this.activeItem.collapse();
					}
					noDefault = true;
				}
				break;
			case Event.KEY_RIGHT:
				if (this.inFocus) {
					if (!event.ctrlKey && !event.shiftKey && !event.altKey) {
						this.activeItem.expand();
					}
					noDefault = true;
				}
				break;
			case Event.KEY_TAB:
				this.lostFocus();
		}
		if (noDefault) {
			if (event.preventBubble) event.preventBubble();
			Event.stop(event);
		}
	},

	getNextItemForSelection: function(item) {
		if (!item.isCollapsed() && item.hasChilds()) {
			return item.childs.first();
		} else {
			var next = item.next();
			if (next != item) {
				return next;
			} else {
				var next = item.parent.next();
				if (next != item.parent) {
					return next;
				} else {
					return item;
				}
			}
		}
	},

	getPreviousItemForSelection: function(item) {
		var prev = item.previous();
		if (prev == item) {
			if (prev.parent == this.tree) {
				prev = item;
			} else {
				prev = item.parent;
			}
		} else if (!prev.isCollapsed() && prev.hasChilds()) {
			prev = prev.childs.last();
			while (!prev.isCollapsed() && prev.hasChilds()) {
				prev = prev.childs.last();
			}
		}
		return prev;
	}
}
